/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsWatcher;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogPanel;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @Nullable
    private final Runnable myRecreateMainLogHandler;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogColorManagerImpl myColorManager;
    @NotNull
    private final VcsLogTabsWatcher myTabsLogRefresher;
    @NotNull
    private final PostponableLogRefresher myPostponableRefresher;
    private boolean myInitialized;

    public VcsLogManager(@NotNull Project project2, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<VcsRoot> roots) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        this(project2, uiProperties, roots, true, null);
    }

    public VcsLogManager(@NotNull Project project2, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<VcsRoot> roots, boolean scheduleRefreshImmediately, @Nullable Runnable recreateHandler) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogManager", "<init>"));
        }
        this.myInitialized = false;
        this.myProject = project2;
        this.myUiProperties = uiProperties;
        this.myRecreateMainLogHandler = recreateHandler;
        Map<VirtualFile, VcsLogProvider> logProviders = VcsLogManager.findLogProviders(roots, this.myProject);
        this.myLogData = new VcsLogData(this.myProject, logProviders, new MyFatalErrorsHandler());
        this.myPostponableRefresher = new PostponableLogRefresher(this.myLogData);
        this.myTabsLogRefresher = new VcsLogTabsWatcher(this.myProject, this.myPostponableRefresher, this.myLogData);
        VcsLogManager.refreshLogOnVcsEvents(logProviders, this.myPostponableRefresher, this.myLogData);
        this.myColorManager = new VcsLogColorManagerImpl(logProviders.keySet());
        if (scheduleRefreshImmediately) {
            this.scheduleInitialization();
        }
        Disposer.register((Disposable)project2, (Disposable)this);
    }

    public void scheduleInitialization() {
        if (!this.myInitialized) {
            this.myInitialized = true;
            this.myLogData.initialize();
        }
    }

    public boolean isLogVisible() {
        return this.myPostponableRefresher.isLogVisible();
    }

    @NotNull
    public VcsLogData getDataManager() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager", "getDataManager"));
        }
        return vcsLogData;
    }

    @NotNull
    public JComponent createLogPanel(@NotNull String logId, @Nullable String contentTabName) {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/impl/VcsLogManager", "createLogPanel"));
        }
        VcsLogUiImpl ui = this.createLogUi(logId, contentTabName);
        VcsLogPanel vcsLogPanel = new VcsLogPanel(this, ui);
        if (vcsLogPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager", "createLogPanel"));
        }
        return vcsLogPanel;
    }

    @NotNull
    public VcsLogUiImpl createLogUi(@NotNull String logId, @Nullable String contentTabName) {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/impl/VcsLogManager", "createLogUi"));
        }
        VcsLogUiImpl vcsLogUiImpl = this.createLogUi(contentTabName, this.getMainLogUiFactory(logId));
        if (vcsLogUiImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager", "createLogUi"));
        }
        return vcsLogUiImpl;
    }

    @NotNull
    public VcsLogUiFactory<? extends VcsLogUiImpl> getMainLogUiFactory(@NotNull String logId) {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/impl/VcsLogManager", "getMainLogUiFactory"));
        }
        MainVcsLogUiFactory mainVcsLogUiFactory = new MainVcsLogUiFactory(logId);
        if (mainVcsLogUiFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager", "getMainLogUiFactory"));
        }
        return mainVcsLogUiFactory;
    }

    @NotNull
    public <U extends AbstractVcsLogUi> U createLogUi(@Nullable String contentTabName, @NotNull VcsLogUiFactory<U> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/vcs/log/impl/VcsLogManager", "createLogUi"));
        }
        U ui = factory.createLogUi(this.myProject, this.myLogData, this.myColorManager);
        Disposable disposable = contentTabName != null ? this.myTabsLogRefresher.addTabToWatch(contentTabName, ((AbstractVcsLogUi)ui).getRefresher()) : this.myPostponableRefresher.addLogWindow(((AbstractVcsLogUi)ui).getRefresher());
        Disposer.register(ui, (Disposable)disposable);
        ((AbstractVcsLogUi)ui).requestFocus();
        U u = ui;
        if (u == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager", "createLogUi"));
        }
        return u;
    }

    private static void refreshLogOnVcsEvents(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogRefresher refresher, @NotNull Disposable disposableParent) {
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/impl/VcsLogManager", "refreshLogOnVcsEvents"));
        }
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "com/intellij/vcs/log/impl/VcsLogManager", "refreshLogOnVcsEvents"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/impl/VcsLogManager", "refreshLogOnVcsEvents"));
        }
        MultiMap providers2roots = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : logProviders.entrySet()) {
            providers2roots.putValue((Object)entry.getValue(), (Object)entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : providers2roots.entrySet()) {
            Disposable disposable = ((VcsLogProvider)entry.getKey()).subscribeToRootRefreshEvents((Collection)entry.getValue(), refresher);
            Disposer.register((Disposable)disposableParent, (Disposable)disposable);
        }
    }

    @NotNull
    public static Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<VcsRoot> roots, @NotNull Project project2) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/vcs/log/impl/VcsLogManager", "findLogProviders"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogManager", "findLogProviders"));
        }
        HashMap logProviders = ContainerUtil.newHashMap();
        VcsLogProvider[] allLogProviders = (VcsLogProvider[])Extensions.getExtensions((ExtensionPointName)VcsLogProvider.LOG_PROVIDER_EP, (AreaInstance)project2);
        block0: for (VcsRoot root : roots) {
            AbstractVcs vcs = root.getVcs();
            VirtualFile path = root.getPath();
            if (vcs == null || path == null) {
                LOG.error("Skipping invalid VCS root: " + root);
                continue;
            }
            for (VcsLogProvider provider : allLogProviders) {
                if (!provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
                logProviders.put(path, provider);
                continue block0;
            }
        }
        HashMap hashMap = logProviders;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsLogManager", "findLogProviders"));
        }
        return hashMap;
    }

    public void disposeLog() {
        Disposer.dispose((Disposable)this.myLogData);
    }

    @Deprecated
    @Nullable
    public static VcsLogManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogManager", "getInstance"));
        }
        return ((VcsProjectLog)ServiceManager.getService((Project)project2, VcsProjectLog.class)).getLogManager();
    }

    @Deprecated
    @Nullable
    public VcsLogUiImpl getMainLogUi() {
        return ((VcsProjectLog)ServiceManager.getService((Project)this.myProject, VcsProjectLog.class)).getMainLogUi();
    }

    public void dispose() {
        this.disposeLog();
    }

    private class MainVcsLogUiFactory
    implements VcsLogUiFactory<VcsLogUiImpl> {
        private final String myLogId;

        public MainVcsLogUiFactory(String logId) {
            if (logId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/impl/VcsLogManager$MainVcsLogUiFactory", "<init>"));
            }
            this.myLogId = logId;
        }

        @Override
        public VcsLogUiImpl createLogUi(@NotNull Project project2, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/impl/VcsLogManager$MainVcsLogUiFactory", "createLogUi"));
            }
            if (logData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/impl/VcsLogManager$MainVcsLogUiFactory", "createLogUi"));
            }
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/impl/VcsLogManager$MainVcsLogUiFactory", "createLogUi"));
            }
            MainVcsLogUiProperties properties = VcsLogManager.this.myUiProperties.createProperties(this.myLogId);
            VisiblePackRefresherImpl refresher = new VisiblePackRefresherImpl(project2, logData, properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE), new VcsLogFilterer(logData.getLogProviders(), logData.getStorage(), logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), logData.getIndex()));
            return new VcsLogUiImpl(logData, project2, manager, properties, refresher);
        }
    }

    @FunctionalInterface
    public static interface VcsLogUiFactory<T extends AbstractVcsLogUi> {
        public T createLogUi(@NotNull Project var1, @NotNull VcsLogData var2, @NotNull VcsLogColorManager var3);
    }

    private class MyFatalErrorsHandler
    implements FatalErrorHandler {
        private final AtomicBoolean myIsBroken = new AtomicBoolean(false);

        private MyFatalErrorsHandler() {
        }

        @Override
        public void consume(@Nullable Object source, @NotNull Exception e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/impl/VcsLogManager$MyFatalErrorsHandler", "consume"));
            }
            if (this.myIsBroken.compareAndSet(false, true)) {
                this.processError(source, e);
            } else {
                LOG.debug((Throwable)e);
            }
        }

        protected void processError(@Nullable Object source, @NotNull Exception e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/impl/VcsLogManager$MyFatalErrorsHandler", "processError"));
            }
            if (VcsLogManager.this.myRecreateMainLogHandler != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/impl/VcsLogManager$MyFatalErrorsHandler", "lambda$processError$0"));
                    }
                    String message = "Fatal error, VCS Log re-created: " + e.getMessage();
                    if (VcsLogManager.this.isLogVisible()) {
                        LOG.info((Throwable)e);
                        this.displayFatalErrorMessage(message);
                    } else {
                        LOG.error(message, (Throwable)e);
                    }
                    VcsLogManager.this.myRecreateMainLogHandler.run();
                });
            } else {
                LOG.error((Throwable)e);
            }
            if (source instanceof VcsLogStorage) {
                VcsLogManager.this.myLogData.getIndex().markCorrupted();
            }
        }

        @Override
        public void displayFatalErrorMessage(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/impl/VcsLogManager$MyFatalErrorsHandler", "displayFatalErrorMessage"));
            }
            VcsBalloonProblemNotifier.showOverChangesView(VcsLogManager.this.myProject, message, MessageType.ERROR, new NamedRunnable[0]);
        }
    }
}

