/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.StatisticsUtilKt;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogFeaturesCollector
extends AbstractApplicationUsagesCollector {
    public static final GroupDescriptor ID = GroupDescriptor.create("VCS Log Ui Settings");

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) throws CollectUsagesException {
        VcsLogUiImpl ui;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector", "getProjectUsages"));
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project2);
        if (projectLog != null && (ui = projectLog.getMainLogUi()) != null) {
            MainVcsLogUiProperties properties = ui.getProperties();
            HashSet usages = ContainerUtil.newHashSet();
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.details", properties.get(MainVcsLogUiProperties.SHOW_DETAILS)));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.long.edges", properties.get(MainVcsLogUiProperties.SHOW_LONG_EDGES)));
            PermanentGraph.SortType sortType = properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE);
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.sort.linear.bek", sortType.equals((Object)PermanentGraph.SortType.LinearBek)));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.sort.bek", sortType.equals((Object)PermanentGraph.SortType.Bek)));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.sort.normal", sortType.equals((Object)PermanentGraph.SortType.Normal)));
            if (ui.isMultipleRoots()) {
                usages.add(StatisticsUtilKt.getBooleanUsage("ui.roots", properties.get(MainVcsLogUiProperties.SHOW_ROOT_NAMES)));
            }
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.labels.compact", properties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW)));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.labels.showTagNames", properties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES)));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.textFilter.regex", properties.get(MainVcsLogUiProperties.TEXT_FILTER_REGEX)));
            usages.add(StatisticsUtilKt.getBooleanUsage("ui.textFilter.matchCase", properties.get(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE)));
            for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])Extensions.getExtensions((ExtensionPointName)VcsLogUiImpl.LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)project2)) {
                if (!factory.showMenuItem()) continue;
                MainVcsLogUiProperties.VcsLogHighlighterProperty property = MainVcsLogUiProperties.VcsLogHighlighterProperty.get(factory.getId());
                usages.add(StatisticsUtilKt.getBooleanUsage("ui.highlighter." + ConvertUsagesUtil.ensureProperKey(factory.getId()), properties.exists(property) && properties.get(property) != false));
            }
            HashSet hashSet = usages;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector", "getProjectUsages"));
            }
            return hashSet;
        }
        Set<UsageDescriptor> set2 = Collections.emptySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector", "getProjectUsages"));
        }
        return set2;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = ID;
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

