/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPanel
extends JBPanel
implements DataProvider {
    @NotNull
    private final VcsLogManager myManager;
    @NotNull
    private final AbstractVcsLogUi myUi;

    public VcsLogPanel(@NotNull VcsLogManager manager, @NotNull AbstractVcsLogUi logUi) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/ui/VcsLogPanel", "<init>"));
        }
        if (logUi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logUi", "com/intellij/vcs/log/ui/VcsLogPanel", "<init>"));
        }
        super((LayoutManager)new BorderLayout());
        this.myManager = manager;
        this.myUi = logUi;
        this.add(this.myUi.getMainComponent(), "Center");
    }

    @NotNull
    public AbstractVcsLogUi getUi() {
        AbstractVcsLogUi abstractVcsLogUi = this.myUi;
        if (abstractVcsLogUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogPanel", "getUi"));
        }
        return abstractVcsLogUi;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (VcsLogInternalDataKeys.LOG_MANAGER.is(dataId)) {
            return this.myManager;
        }
        if (VcsLogDataKeys.VCS_LOG.is(dataId)) {
            return this.myUi.getVcsLog();
        }
        if (VcsLogDataKeys.VCS_LOG_UI.is(dataId)) {
            return this.myUi;
        }
        if (VcsLogDataKeys.VCS_LOG_DATA_PROVIDER.is(dataId)) {
            return this.myManager.getDataManager();
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(dataId)) {
            List hashes = this.myUi.getVcsLog().getSelectedCommits();
            if (hashes.size() > 1000) {
                return null;
            }
            return ArrayUtil.toObjectArray((Collection)ContainerUtil.map((Collection)hashes, commitId -> VcsLogUtil.convertToRevisionNumber(commitId.getHash())), VcsRevisionNumber.class);
        }
        return null;
    }
}

