/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class ShowGraphHistoryAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project2 = e.getProject();
        assert (project2 != null);
        VirtualFile file2 = (VirtualFile)e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        VcsLogManager logManager = VcsProjectLog.getInstance(project2).getLogManager();
        assert (logManager != null);
        VcsLogContentProvider.openLogTab(project2, logManager, "Log", file2.getName(), new VcsLogUiWithFileFilterFactory(logManager, file2));
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        if (!Registry.is((String)"vcs.log.graph.history")) {
            presentation.setEnabledAndVisible(false);
        } else {
            VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            Project project2 = e.getProject();
            if (file2 == null || project2 == null) {
                presentation.setEnabledAndVisible(false);
            } else {
                VirtualFile root = ProjectLevelVcsManager.getInstance((Project)project2).getVcsRootFor(file2);
                VcsLogData dataManager = VcsProjectLog.getInstance(project2).getDataManager();
                if (root == null || dataManager == null) {
                    presentation.setEnabledAndVisible(false);
                } else {
                    presentation.setVisible(dataManager.getRoots().contains(root));
                    presentation.setEnabled(dataManager.getIndex().isIndexed(root));
                }
            }
        }
    }

    private static class VcsLogUiWithFileFilterFactory
    implements VcsLogManager.VcsLogUiFactory<AbstractVcsLogUi> {
        private final VcsLogManager myLogManager;
        private final VirtualFile myFile;

        public VcsLogUiWithFileFilterFactory(@NotNull VcsLogManager logManager, @NotNull VirtualFile file2) {
            if (logManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/vcs/log/ui/actions/ShowGraphHistoryAction$VcsLogUiWithFileFilterFactory", "<init>"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/vcs/log/ui/actions/ShowGraphHistoryAction$VcsLogUiWithFileFilterFactory", "<init>"));
            }
            this.myLogManager = logManager;
            this.myFile = file2;
        }

        @Override
        public AbstractVcsLogUi createLogUi(@NotNull Project project2, @NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/actions/ShowGraphHistoryAction$VcsLogUiWithFileFilterFactory", "createLogUi"));
            }
            if (logData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/actions/ShowGraphHistoryAction$VcsLogUiWithFileFilterFactory", "createLogUi"));
            }
            if (colorManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/actions/ShowGraphHistoryAction$VcsLogUiWithFileFilterFactory", "createLogUi"));
            }
            VcsLogUiImpl ui = this.myLogManager.getMainLogUiFactory(this.myFile.getName()).createLogUi(project2, logData, colorManager);
            ui.getFilterUi().setFilter((VcsLogFilter)new VcsLogStructureFilterImpl((Collection<FilePath>)Collections.singleton(VcsUtil.getFilePath((VirtualFile)this.myFile))));
            return ui;
        }
    }
}

