/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.UI;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.HtmlPanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.HtmlTableBuilder;
import com.intellij.vcs.log.ui.frame.ReferencesPanel;
import com.intellij.vcs.log.ui.render.RectanglePainter;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitPanel
extends JBPanel {
    public static final int BOTTOM_BORDER = 2;
    private static final int REFERENCES_BORDER = 12;
    private static final int TOP_BORDER = 4;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final ReferencesPanel myBranchesPanel;
    @NotNull
    private final ReferencesPanel myTagsPanel;
    @NotNull
    private final DataPanel myDataPanel;
    @NotNull
    private final BranchesPanel myContainingBranchesPanel;
    @NotNull
    private final RootPanel myRootPanel;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @Nullable
    private VcsFullCommitDetails myCommit;

    public CommitPanel(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/frame/CommitPanel", "<init>"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/frame/CommitPanel", "<init>"));
        }
        this.myLogData = logData;
        this.myColorManager = colorManager;
        this.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.setOpaque(false);
        this.myRootPanel = new RootPanel();
        this.myBranchesPanel = new ReferencesPanel();
        this.myBranchesPanel.setBorder((Border)JBUI.Borders.empty((int)12, (int)0, (int)0, (int)0));
        this.myTagsPanel = new ReferencesPanel();
        this.myTagsPanel.setBorder((Border)JBUI.Borders.empty((int)12, (int)0, (int)0, (int)0));
        this.myDataPanel = new DataPanel(this.myLogData.getProject());
        this.myContainingBranchesPanel = new BranchesPanel();
        this.add(this.myRootPanel);
        this.add(this.myDataPanel);
        this.add(this.myBranchesPanel);
        this.add(this.myTagsPanel);
        this.add(this.myContainingBranchesPanel);
        this.setBorder((Border)CommitPanel.getDetailsBorder());
    }

    public void setCommit(@NotNull VcsFullCommitDetails commitData) {
        if (commitData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitData", "com/intellij/vcs/log/ui/frame/CommitPanel", "setCommit"));
        }
        if (!Comparing.equal((Object)this.myCommit, (Object)commitData)) {
            if (commitData instanceof LoadingDetails) {
                this.myDataPanel.setData(null);
                this.myRootPanel.setRoot("", null);
            } else {
                this.myDataPanel.setData(commitData);
                VirtualFile root = commitData.getRoot();
                if (this.myColorManager.isMultipleRoots()) {
                    this.myRootPanel.setRoot(root.getName(), (Color)VcsLogGraphTable.getRootBackgroundColor(root, this.myColorManager));
                } else {
                    this.myRootPanel.setRoot("", null);
                }
            }
            this.myCommit = commitData;
        }
        List<String> branches = null;
        if (!(commitData instanceof LoadingDetails)) {
            branches = this.myLogData.getContainingBranchesGetter().requestContainingBranches(commitData.getRoot(), (Hash)commitData.getId());
        }
        this.myContainingBranchesPanel.setBranches(branches);
        this.myDataPanel.update();
        this.myContainingBranchesPanel.update();
        this.revalidate();
    }

    public void setRefs(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/frame/CommitPanel", "setRefs"));
        }
        List<VcsRef> references = this.sortRefs(refs);
        this.myBranchesPanel.setReferences(references.stream().filter(ref -> ref.getType().isBranch()).collect(Collectors.toList()));
        this.myTagsPanel.setReferences(references.stream().filter(ref -> !ref.getType().isBranch()).collect(Collectors.toList()));
    }

    public void update() {
        this.myDataPanel.update();
        this.myRootPanel.update();
        this.myBranchesPanel.update();
        this.myTagsPanel.update();
        this.myContainingBranchesPanel.update();
    }

    public void updateBranches() {
        if (this.myCommit != null) {
            this.myContainingBranchesPanel.setBranches(this.myLogData.getContainingBranchesGetter().getContainingBranchesFromCache(this.myCommit.getRoot(), (Hash)this.myCommit.getId()));
        } else {
            this.myContainingBranchesPanel.setBranches(null);
        }
        this.myContainingBranchesPanel.update();
    }

    @NotNull
    private List<VcsRef> sortRefs(@NotNull Collection<VcsRef> refs) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/ui/frame/CommitPanel", "sortRefs"));
        }
        VcsRef ref = (VcsRef)ContainerUtil.getFirstItem(refs);
        if (ref == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel", "sortRefs"));
            }
            return list;
        }
        List list = ContainerUtil.sorted(refs, (Comparator)this.myLogData.getLogProvider(ref.getRoot()).getReferenceManager().getLabelsOrderComparator());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel", "sortRefs"));
        }
        return list;
    }

    @NotNull
    public static JBEmptyBorder getDetailsBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        if (jBEmptyBorder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel", "getDetailsBorder"));
        }
        return jBEmptyBorder;
    }

    public Color getBackground() {
        return CommitPanel.getCommitDetailsBackground();
    }

    public boolean isExpanded() {
        return this.myContainingBranchesPanel.isExpanded();
    }

    @NotNull
    public static Color getCommitDetailsBackground() {
        Color color = UIUtil.getTableBackground();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel", "getCommitDetailsBackground"));
        }
        return color;
    }

    @NotNull
    public static String formatDateTime(long time) {
        String string = " on " + DateFormatUtil.formatDate((long)time) + " at " + DateFormatUtil.formatTime((long)time);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel", "formatDateTime"));
        }
        return string;
    }

    private static class RootPanel
    extends JPanel {
        private static final int RIGHT_BORDER = Math.max(UIUtil.getScrollBarWidth(), JBUI.scale((int)14));
        @NotNull
        private final RectanglePainter myLabelPainter;
        @NotNull
        private String myText = "";
        @NotNull
        private Color myColor = CommitPanel.getCommitDetailsBackground();

        RootPanel() {
            this.myLabelPainter = new RectanglePainter(true){

                @Override
                protected Font getLabelFont() {
                    return RootPanel.getLabelFont();
                }
            };
            this.setOpaque(false);
        }

        @NotNull
        private static Font getLabelFont() {
            Font font = VcsHistoryUtil.getCommitDetailsFont();
            Font font2 = font.deriveFont((float)font.getSize() - 2.0f);
            if (font2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$RootPanel", "getLabelFont"));
            }
            return font2;
        }

        public void setRoot(@NotNull String text, @Nullable Color color) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/frame/CommitPanel$RootPanel", "setRoot"));
            }
            this.myText = text;
            this.myColor = text.isEmpty() || color == null ? CommitPanel.getCommitDetailsBackground() : color;
        }

        public void update() {
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!this.myText.isEmpty()) {
                int width;
                Dimension painterSize = this.myLabelPainter.calculateSize(this.myText, this.getFontMetrics(RootPanel.getLabelFont()));
                JBScrollPane scrollPane = (JBScrollPane)UIUtil.getParentOfType(JBScrollPane.class, (Component)this);
                if (scrollPane == null) {
                    width = this.getWidth();
                } else {
                    Rectangle rect = scrollPane.getViewport().getViewRect();
                    width = rect.x + rect.width;
                }
                this.myLabelPainter.paint((Graphics2D)g, this.myText, width - painterSize.width - RIGHT_BORDER, 0, this.myColor);
            }
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.myText.isEmpty()) {
                return new JBDimension(0, 4);
            }
            Dimension size = this.myLabelPainter.calculateSize(this.myText, this.getFontMetrics(RootPanel.getLabelFont()));
            return new Dimension(size.width + JBUI.scale((int)RIGHT_BORDER), size.height);
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    private static class BranchesPanel
    extends HtmlPanel {
        private static final int PER_ROW = 2;
        private static final String LINK_HREF = "show-hide-branches";
        @Nullable
        private List<String> myBranches;
        private boolean myExpanded = false;

        BranchesPanel() {
            DefaultCaret caret = (DefaultCaret)this.getCaret();
            caret.setUpdatePolicy(1);
            this.setBorder((Border)JBUI.Borders.empty((int)12, (int)4, (int)2, (int)0));
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && LINK_HREF.equals(e.getDescription())) {
                this.myExpanded = !this.myExpanded;
                this.update();
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.update();
        }

        void setBranches(@Nullable List<String> branches) {
            this.myBranches = branches == null ? null : branches;
            this.myExpanded = false;
        }

        void update() {
            this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)VcsHistoryUtil.getCommitDetailsFont()) + "</head><body>" + this.getBranchesText() + "</body></html>");
            this.revalidate();
            this.repaint();
        }

        @NotNull
        private String getBranchesText() {
            if (this.myBranches == null) {
                if ("<i>In branches: loading...</i>" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$BranchesPanel", "getBranchesText"));
                }
                return "<i>In branches: loading...</i>";
            }
            if (this.myBranches.isEmpty()) {
                if ("<i>Not in any branch</i>" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$BranchesPanel", "getBranchesText"));
                }
                return "<i>Not in any branch</i>";
            }
            if (this.myExpanded) {
                int rowCount = (int)Math.ceil((double)this.myBranches.size() / 2.0);
                int[] means = new int[1];
                int[] max = new int[1];
                for (int i2 = 0; i2 < rowCount; ++i2) {
                    for (int j = 0; j < 1; ++j) {
                        int index = rowCount * j + i2;
                        if (index >= this.myBranches.size()) continue;
                        int n = j;
                        means[n] = means[n] + this.myBranches.get(index).length();
                        max[j] = Math.max(this.myBranches.get(index).length(), max[j]);
                    }
                }
                int j = 0;
                while (j < 1) {
                    int n = j++;
                    means[n] = means[n] / rowCount;
                }
                HtmlTableBuilder builder = new HtmlTableBuilder();
                for (int i3 = 0; i3 < rowCount; ++i3) {
                    builder.startRow();
                    for (int j2 = 0; j2 < 2; ++j2) {
                        int index = rowCount * j2 + i3;
                        if (index >= this.myBranches.size()) {
                            builder.append("");
                            continue;
                        }
                        String branch = this.myBranches.get(index);
                        if (index != this.myBranches.size() - 1) {
                            int space = 0;
                            if (j2 < 1 && branch.length() == max[j2]) {
                                space = Math.max(means[j2] + 20 - max[j2], 5);
                            }
                            builder.append(branch + StringUtil.repeat((String)"&nbsp;", (int)space), "left");
                            continue;
                        }
                        builder.append(branch, "left");
                    }
                    builder.endRow();
                }
                String string = "<i>In " + this.myBranches.size() + " branches:</i> <a href=\"" + LINK_HREF + "\"><i>(click to hide)</i></a><br>" + builder.build();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$BranchesPanel", "getBranchesText"));
                }
                return string;
            }
            int totalMax = 0;
            int charCount = 0;
            for (String b : this.myBranches) {
                ++totalMax;
                if ((charCount += b.length()) < 50) continue;
                break;
            }
            String branchText = this.myBranches.size() <= totalMax ? StringUtil.join(this.myBranches, (String)", ") : StringUtil.join((Collection)ContainerUtil.getFirstItems(this.myBranches, (int)totalMax), (String)", ") + "\u2026 <a href=\"" + LINK_HREF + "\"><i>(click to show all)</i></a>";
            String string = "<i>In " + this.myBranches.size() + StringUtil.pluralize((String)" branch", (int)this.myBranches.size()) + ":</i> " + branchText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$BranchesPanel", "getBranchesText"));
            }
            return string;
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }
    }

    private static class DataPanel
    extends HtmlPanel {
        @NotNull
        private final Project myProject;
        @Nullable
        private String myMainText;

        DataPanel(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "<init>"));
            }
            this.myProject = project2;
            DefaultCaret caret = (DefaultCaret)this.getCaret();
            caret.setUpdatePolicy(1);
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)2, (int)0));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.update();
        }

        void setData(@Nullable VcsFullCommitDetails commit) {
            if (commit == null) {
                this.myMainText = null;
            } else {
                String hash = ((Hash)commit.getId()).toShortString();
                String hashAndAuthor = DataPanel.getHtmlWithFonts(hash + " " + DataPanel.getAuthorText(commit, hash.length() + 1));
                String messageText = this.getMessageText(commit);
                this.myMainText = messageText + "<br/><br/>" + hashAndAuthor;
            }
        }

        private void customizeLinksStyle() {
            Document document = this.getDocument();
            if (document instanceof HTMLDocument) {
                StyleSheet styleSheet = ((HTMLDocument)document).getStyleSheet();
                String linkColor = "#" + ColorUtil.toHex((Color)UI.getColor((String)"link.foreground"));
                styleSheet.addRule("a { color: " + linkColor + "; text-decoration: none;}");
            }
        }

        @NotNull
        private static String getHtmlWithFonts(@NotNull String input) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getHtmlWithFonts"));
            }
            String string = DataPanel.getHtmlWithFonts(input, VcsHistoryUtil.getCommitDetailsFont().getStyle());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getHtmlWithFonts"));
            }
            return string;
        }

        @NotNull
        private static String getHtmlWithFonts(@NotNull String input, int style) {
            if (input == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getHtmlWithFonts"));
            }
            String string = FontUtil.getHtmlWithFonts(input, style, VcsHistoryUtil.getCommitDetailsFont());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getHtmlWithFonts"));
            }
            return string;
        }

        void update() {
            if (this.myMainText == null) {
                this.setText("");
            } else {
                this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)VcsHistoryUtil.getCommitDetailsFont()) + "</head><body>" + this.myMainText + "</body></html>");
            }
            this.customizeLinksStyle();
            this.revalidate();
            this.repaint();
        }

        @NotNull
        private String getMessageText(@NotNull VcsFullCommitDetails commit) {
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getMessageText"));
            }
            String fullMessage = commit.getFullMessage();
            int separator = fullMessage.indexOf("\n\n");
            String subject = separator > 0 ? fullMessage.substring(0, separator) : fullMessage;
            String description = fullMessage.substring(subject.length());
            String string = "<b>" + DataPanel.getHtmlWithFonts(DataPanel.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, subject)), 1) + "</b>" + DataPanel.getHtmlWithFonts(DataPanel.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, description)));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getMessageText"));
            }
            return string;
        }

        @NotNull
        private static String escapeMultipleSpaces(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "escapeMultipleSpaces"));
            }
            StringBuilder result2 = new StringBuilder();
            for (int i2 = 0; i2 < text.length(); ++i2) {
                if (text.charAt(i2) == ' ') {
                    if (i2 == text.length() - 1 || text.charAt(i2 + 1) != ' ') {
                        result2.append(' ');
                        continue;
                    }
                    result2.append("&nbsp;");
                    continue;
                }
                result2.append(text.charAt(i2));
            }
            String string = result2.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "escapeMultipleSpaces"));
            }
            return string;
        }

        @NotNull
        private static String getAuthorText(@NotNull VcsFullCommitDetails commit, int offset) {
            if (commit == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getAuthorText"));
            }
            long authorTime = commit.getAuthorTime();
            long commitTime = commit.getCommitTime();
            String authorText = DataPanel.getAuthorName(commit.getAuthor()) + CommitPanel.formatDateTime(authorTime);
            if (!VcsUserUtil.isSamePerson(commit.getAuthor(), commit.getCommitter())) {
                String commitTimeText = authorTime != commitTime ? CommitPanel.formatDateTime(commitTime) : "";
                authorText = authorText + DataPanel.getCommitterText(commit.getCommitter(), commitTimeText, offset);
            } else if (authorTime != commitTime) {
                authorText = authorText + DataPanel.getCommitterText(null, CommitPanel.formatDateTime(commitTime), offset);
            }
            String string = authorText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getAuthorText"));
            }
            return string;
        }

        @NotNull
        private static String getCommitterText(@Nullable VcsUser committer, @NotNull String commitTimeText, int offset) {
            if (commitTimeText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitTimeText", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getCommitterText"));
            }
            String alignment = "<br/>" + StringUtil.repeat((String)"&nbsp;", (int)offset);
            String gray = ColorUtil.toHex((Color)JBColor.GRAY);
            String graySpan = "<span style='color:#" + gray + "'>";
            String text = alignment + graySpan + "committed";
            if (committer != null) {
                text = text + " by " + VcsUserUtil.getShortPresentation(committer);
                if (!committer.getEmail().isEmpty()) {
                    text = text + "</span>" + DataPanel.getEmailText(committer) + graySpan;
                }
            }
            String string = text = text + commitTimeText + "</span>";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getCommitterText"));
            }
            return string;
        }

        @NotNull
        private static String getAuthorName(@NotNull VcsUser user) {
            if (user == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getAuthorName"));
            }
            String username = VcsUserUtil.getShortPresentation(user);
            String string = user.getEmail().isEmpty() ? username : username + DataPanel.getEmailText(user);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getAuthorName"));
            }
            return string;
        }

        @NotNull
        private static String getEmailText(@NotNull VcsUser user) {
            if (user == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getEmailText"));
            }
            String string = " <a href='mailto:" + user.getEmail() + "'>&lt;" + user.getEmail() + "&gt;</a>";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/CommitPanel$DataPanel", "getEmailText"));
            }
            return string;
        }

        @Override
        public Color getBackground() {
            return CommitPanel.getCommitDetailsBackground();
        }
    }
}

