/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogStructureFilterImpl;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.ui.history.FileHistoryUiProperties;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class FileHistoryFilterUi
implements VcsLogFilterUi {
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final FileHistoryUiProperties myProperties;

    public FileHistoryFilterUi(@NotNull FilePath path, @NotNull FileHistoryUiProperties properties) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/ui/history/FileHistoryFilterUi", "<init>"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/vcs/log/ui/history/FileHistoryFilterUi", "<init>"));
        }
        this.myPath = path;
        this.myProperties = properties;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogStructureFilterImpl fileFilter = new VcsLogStructureFilterImpl((Collection<FilePath>)Collections.singleton(this.myPath));
        VcsLogBranchFilterImpl branchFilter = this.myProperties.get(FileHistoryUiProperties.SHOW_ALL_BRANCHES) != false ? null : VcsLogBranchFilterImpl.fromBranch("HEAD");
        VcsLogFilterCollection vcsLogFilterCollection = new VcsLogFilterCollectionImpl.VcsLogFilterCollectionBuilder().with(fileFilter).with(branchFilter).build();
        if (vcsLogFilterCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryFilterUi", "getFilters"));
        }
        return vcsLogFilterCollection;
    }

    public void setFilter(@NotNull VcsLogFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/history/FileHistoryFilterUi", "setFilter"));
        }
        throw new UnsupportedOperationException();
    }
}

