/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.history;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.frame.CommitSelectionListenerForDiff;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.history.FileHistoryUi;
import com.intellij.vcs.log.ui.history.FileHistoryVisiblePack;
import com.intellij.vcs.log.ui.history.VcsLogFileRevision;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryPanel
extends JPanel
implements DataProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(FileHistoryPanel.class);
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final DetailsPanel myDetailsPanel;
    @NotNull
    private final JBSplitter myDetailsSplitter;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final FileHistoryUi myUi;
    @NotNull
    private List<Change> mySelectedChanges;
    @NotNull
    private IndexDataGetter myIndexDataGetter;

    public FileHistoryPanel(@NotNull FileHistoryUi ui, @NotNull VcsLogData logData, @NotNull VisiblePack visiblePack, @NotNull FilePath filePath) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "<init>"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "<init>"));
        }
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "<init>"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "<init>"));
        }
        this.mySelectedChanges = Collections.emptyList();
        this.myUi = ui;
        this.myLogData = logData;
        this.myIndexDataGetter = (IndexDataGetter)ObjectUtils.assertNotNull((Object)logData.getIndex().getDataGetter());
        this.myFilePath = filePath;
        this.myGraphTable = new VcsLogGraphTable(this.myUi, logData, visiblePack){

            @Override
            protected boolean isSpeedSearchEnabled() {
                return true;
            }
        };
        this.myDetailsPanel = new DetailsPanel(logData, this.myUi.getColorManager(), this);
        this.myDetailsPanel.setBorder(IdeBorderFactory.createBorder((int)1));
        this.myDetailsSplitter = new OnePixelSplitter(true, "vcs.log.history.details.splitter.proportion", 0.7f);
        this.myDetailsSplitter.setFirstComponent(VcsLogUiUtil.installProgress(VcsLogUiUtil.setupScrolledGraph(this.myGraphTable, 1), this.myLogData, this));
        this.myDetailsSplitter.setSecondComponent((JComponent)(this.myUi.getProperties().get(MainVcsLogUiProperties.SHOW_DETAILS) != false ? this.myDetailsPanel : null));
        this.myGraphTable.getSelectionModel().addListSelectionListener(new MyCommitSelectionListenerForDiff());
        this.myDetailsPanel.installCommitSelectionListener(this.myGraphTable);
        VcsLogUiUtil.installDetailsListeners(this.myGraphTable, this.myDetailsPanel, this.myLogData, this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.myDetailsSplitter, "Center");
        this.add((Component)this.createActionsToolbar(), "West");
        PopupHandler.installPopupHandler((JComponent)((Object)this.myGraphTable), (String)"Vcs.FileHistory.ContextMenu", (String)"Vcs.FileHistory.ContextMenu");
        Disposer.register((Disposable)this.myUi, (Disposable)this);
    }

    @NotNull
    private JComponent createActionsToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.FileHistory.Toolbar"));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)toolbarGroup, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myGraphTable));
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "createActionsToolbar"));
        }
        return jComponent;
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "getGraphTable"));
        }
        return vcsLogGraphTable;
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permanentGraphChanged) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "updateDataPack"));
        }
        this.myGraphTable.updateDataPack(visiblePack, permanentGraphChanged);
    }

    public void showDetails(boolean show) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(show ? this.myDetailsPanel : null));
    }

    @Nullable
    public Object getData(String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            return ArrayUtil.toObjectArray(this.mySelectedChanges, Change.class);
        }
        if (VcsLogInternalDataKeys.LOG_UI_PROPERTIES.is(dataId)) {
            return this.myUi.getProperties();
        }
        if (VcsDataKeys.VCS_FILE_REVISION.is(dataId)) {
            return this.createRevisionForFirstSelectedCommit();
        }
        if (VcsDataKeys.FILE_PATH.is(dataId)) {
            return this.myFilePath;
        }
        if (VcsDataKeys.VCS_VIRTUAL_FILE.is(dataId)) {
            VcsLogFileRevision revision = this.createRevisionForFirstSelectedCommit();
            if (revision != null) {
                return revision.getPath().isDirectory() ? new VcsVirtualFolder(revision.getPath().getPath(), null, (VirtualFileSystem)VcsFileSystem.getInstance()) : new VcsVirtualFile(revision.getPath().getPath(), (VcsFileRevision)revision, (VirtualFileSystem)VcsFileSystem.getInstance());
            }
        } else if (VcsDataKeys.VCS_NON_LOCAL_HISTORY_SESSION.is(dataId)) {
            return false;
        }
        return null;
    }

    private VcsLogFileRevision createRevisionForFirstSelectedCommit() {
        VcsFullCommitDetails details = (VcsFullCommitDetails)ContainerUtil.getFirstItem((List)this.myUi.getVcsLog().getSelectedDetails());
        if (details != null && !(details instanceof LoadingDetails)) {
            List<Change> changes = this.collectRelevantChanges(details);
            Change change = (Change)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(changes));
            if (change.getAfterRevision() == null) {
                LOG.error("After revision for commit " + details.getId() + " change " + change + " is null.");
                return null;
            }
            return new VcsLogFileRevision(details, change, change.getAfterRevision().getFile());
        }
        return null;
    }

    @NotNull
    private List<Change> collectRelevantChanges(@NotNull VcsFullCommitDetails details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "collectRelevantChanges"));
        }
        Set<FilePath> fileNames = this.getFileNames(details);
        if (this.myFilePath.isDirectory()) {
            List list = ContainerUtil.filter((Collection)details.getChanges(), change -> FileHistoryPanel.affectsDirectories(change, fileNames));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "collectRelevantChanges"));
            }
            return list;
        }
        List list = ContainerUtil.filter((Collection)details.getChanges(), change -> FileHistoryPanel.affectsFiles(change, fileNames));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "collectRelevantChanges"));
        }
        return list;
    }

    @NotNull
    private Set<FilePath> getFileNames(@NotNull VcsFullCommitDetails details) {
        Set<FilePath> names;
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "getFileNames"));
        }
        int commitIndex = this.myLogData.getStorage().getCommitIndex((Hash)details.getId(), details.getRoot());
        VisiblePack pack = this.myGraphTable.getModel().getVisiblePack();
        if (pack instanceof FileHistoryVisiblePack) {
            IndexDataGetter.FileNamesData namesData = ((FileHistoryVisiblePack)pack).getNamesData();
            names = namesData.getAffectedPaths(commitIndex);
        } else {
            names = this.myIndexDataGetter.getFileNames(this.myFilePath, commitIndex);
        }
        if (names.isEmpty()) {
            Set<FilePath> set2 = Collections.singleton(this.myFilePath);
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "getFileNames"));
            }
            return set2;
        }
        Set<FilePath> set3 = names;
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "getFileNames"));
        }
        return set3;
    }

    private static boolean affectsFiles(@NotNull Change change, @NotNull Set<FilePath> files) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "affectsFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "affectsFiles"));
        }
        if (change.getAfterRevision() == null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            return files.contains(((ContentRevision)ObjectUtils.assertNotNull((Object)beforeRevision)).getFile());
        }
        return files.contains(change.getAfterRevision().getFile());
    }

    private static boolean affectsDirectories(@NotNull Change change, @NotNull Set<FilePath> directories) {
        FilePath file2;
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "affectsDirectories"));
        }
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/intellij/vcs/log/ui/history/FileHistoryPanel", "affectsDirectories"));
        }
        if (change.getAfterRevision() == null) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (beforeRevision == null) {
                return false;
            }
            file2 = beforeRevision.getFile();
        } else {
            file2 = change.getAfterRevision().getFile();
        }
        return ContainerUtil.find(directories, dir -> VfsUtilCore.isAncestor((File)dir.getIOFile(), (File)file2.getIOFile(), (boolean)false)) != null;
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
    }

    private class MyCommitSelectionListenerForDiff
    extends CommitSelectionListenerForDiff {
        protected MyCommitSelectionListenerForDiff() {
            super(FileHistoryPanel.this.myLogData, FileHistoryPanel.this.myGraphTable);
        }

        @Override
        protected void onDetailsLoaded(@NotNull List<VcsFullCommitDetails> detailsList) {
            if (detailsList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsList", "com/intellij/vcs/log/ui/history/FileHistoryPanel$MyCommitSelectionListenerForDiff", "onDetailsLoaded"));
            }
            List<Object> changes = ContainerUtil.newArrayList();
            List detailsListReversed = ContainerUtil.reverse(detailsList);
            for (VcsFullCommitDetails details : detailsListReversed) {
                changes.addAll(FileHistoryPanel.this.collectRelevantChanges(details));
            }
            changes = CommittedChangesTreeBrowser.zipChanges((List<Change>)changes);
            this.setChangesToDisplay((List<Change>)changes);
        }

        @Override
        protected void setChangesToDisplay(@NotNull List<Change> changes) {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/vcs/log/ui/history/FileHistoryPanel$MyCommitSelectionListenerForDiff", "setChangesToDisplay"));
            }
            FileHistoryPanel.this.mySelectedChanges = changes;
        }

        @Override
        protected void clearChanges() {
            FileHistoryPanel.this.mySelectedChanges = Collections.emptyList();
        }

        @Override
        protected void startLoading() {
        }

        @Override
        protected void stopLoading() {
        }
    }
}

