/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.history;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.history.FileHistoryFilterUi;
import com.intellij.vcs.log.ui.history.FileHistoryPanel;
import com.intellij.vcs.log.ui.history.FileHistoryUiProperties;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileHistoryUi
extends AbstractVcsLogUi {
    @NotNull
    private static final List<String> HIGHLIGHTERS = Arrays.asList("MY_COMMITS", "CURRENT_BRANCH");
    @NotNull
    private final FileHistoryUiProperties myUiProperties;
    @NotNull
    private final FileHistoryFilterUi myFilterUi;
    @NotNull
    private final FilePath myPath;
    @NotNull
    private final FileHistoryPanel myFileHistoryPanel;
    private final MyPropertiesChangeListener myPropertiesChangeListener;

    public FileHistoryUi(@NotNull VcsLogData logData, @NotNull Project project2, @NotNull VcsLogColorManager manager, @NotNull FileHistoryUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @NotNull FilePath path) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/vcs/log/ui/history/FileHistoryUi", "<init>"));
        }
        super(logData, project2, manager, refresher);
        this.myUiProperties = uiProperties;
        this.myFilterUi = new FileHistoryFilterUi(path, uiProperties);
        this.myPath = path;
        this.myFileHistoryPanel = new FileHistoryPanel(this, logData, this.myVisiblePack, path);
        this.updateFilter();
        for (VcsLogHighlighterFactory factory : ContainerUtil.filter((Object[])Extensions.getExtensions((ExtensionPointName)LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)this.myProject), f -> HIGHLIGHTERS.contains(f.getId()))) {
            this.getTable().addHighlighter(factory.createHighlighter(logData, this));
        }
        this.myPropertiesChangeListener = new MyPropertiesChangeListener();
        this.myUiProperties.addChangeListener(this.myPropertiesChangeListener);
    }

    @NotNull
    public FilePath getPath() {
        FilePath filePath = this.myPath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getPath"));
        }
        return filePath;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        FileHistoryFilterUi fileHistoryFilterUi = this.myFilterUi;
        if (fileHistoryFilterUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getFilterUi"));
        }
        return fileHistoryFilterUi;
    }

    @Override
    public boolean areGraphActionsEnabled() {
        return false;
    }

    @Override
    public boolean isCompactReferencesView() {
        return true;
    }

    @Override
    public boolean isShowTagNames() {
        return false;
    }

    public boolean isMultipleRoots() {
        return false;
    }

    @Override
    public boolean isShowRootNames() {
        return false;
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/ui/history/FileHistoryUi", "isHighlighterEnabled"));
        }
        return HIGHLIGHTERS.contains(id);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myFileHistoryPanel.updateDataPack(this.myVisiblePack, permGraphChanged);
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myFileHistoryPanel.getGraphTable();
        if (vcsLogGraphTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getTable"));
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    public Component getMainComponent() {
        FileHistoryPanel fileHistoryPanel = this.myFileHistoryPanel;
        if (fileHistoryPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getMainComponent"));
        }
        return fileHistoryPanel;
    }

    @Override
    protected VcsLogFilterCollection getFilters() {
        return this.myFilterUi.getFilters();
    }

    private void updateFilter() {
        this.myRefresher.onFiltersChange(this.myFilterUi.getFilters());
    }

    @Override
    @NotNull
    public FileHistoryUiProperties getProperties() {
        FileHistoryUiProperties fileHistoryUiProperties = this.myUiProperties;
        if (fileHistoryUiProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/history/FileHistoryUi", "getProperties"));
        }
        return fileHistoryUiProperties;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesChangeListener);
        super.dispose();
    }

    private class MyPropertiesChangeListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyPropertiesChangeListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/history/FileHistoryUi$MyPropertiesChangeListener", "onPropertyChanged"));
            }
            if (property == MainVcsLogUiProperties.SHOW_DETAILS) {
                FileHistoryUi.this.myFileHistoryPanel.showDetails(FileHistoryUi.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_DETAILS));
            } else if (property == FileHistoryUiProperties.SHOW_ALL_BRANCHES) {
                FileHistoryUi.this.updateFilter();
            }
        }
    }
}

