/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.graph.DefaultColorGenerator;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.paint.SimpleGraphCellPainter;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.table.GraphTableController;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.IndexSpeedSearch;
import com.intellij.vcs.log.ui.table.TableWithProgress;
import com.intellij.vcs.log.visible.VisiblePack;
import gnu.trove.TIntHashSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogGraphTable
extends TableWithProgress
implements DataProvider,
CopyProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogGraphTable.class);
    public static final int ROOT_INDICATOR_WHITE_WIDTH = 5;
    private static final int ROOT_INDICATOR_WIDTH = 13;
    private static final int ROOT_NAME_MAX_WIDTH = 200;
    private static final int MAX_DEFAULT_AUTHOR_COLUMN_WIDTH = 200;
    private static final int MAX_ROWS_TO_CALC_WIDTH = 1000;
    @NotNull
    private final AbstractVcsLogUi myUi;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MyDummyTableCellEditor myDummyEditor;
    @NotNull
    private final TableCellRenderer myDummyRenderer;
    @NotNull
    private final GraphCommitCellRenderer myGraphCommitCellRenderer;
    @NotNull
    private final GraphTableController myController;
    @NotNull
    private final StringCellRenderer myStringCellRenderer;
    private boolean myColumnsSizeInitialized;
    @Nullable
    private Selection mySelection;
    @NotNull
    private final Collection<VcsLogHighlighter> myHighlighters;

    public VcsLogGraphTable(@NotNull AbstractVcsLogUi ui, @NotNull VcsLogData logData, @NotNull VisiblePack initialDataPack) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "<init>"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "<init>"));
        }
        super(new GraphTableModel(initialDataPack, logData, ui));
        this.myDummyEditor = new MyDummyTableCellEditor();
        this.myDummyRenderer = new DefaultTableCellRenderer();
        this.myColumnsSizeInitialized = false;
        this.mySelection = null;
        this.myHighlighters = ContainerUtil.newArrayList();
        this.getEmptyText().setText("Changes Log");
        this.myUi = ui;
        this.myLogData = logData;
        SimpleGraphCellPainter graphCellPainter = new SimpleGraphCellPainter(new DefaultColorGenerator()){

            @Override
            protected int getRowHeight() {
                return VcsLogGraphTable.this.getRowHeight();
            }
        };
        this.myGraphCommitCellRenderer = new GraphCommitCellRenderer(logData, graphCellPainter, this, ui.isCompactReferencesView(), ui.isShowTagNames());
        this.myStringCellRenderer = new StringCellRenderer();
        this.myLogData.getProgress().addProgressIndicatorListener(new MyProgressListener(), ui);
        this.setDefaultRenderer(VirtualFile.class, new RootCellRenderer(this.myUi));
        this.setDefaultRenderer(GraphCommitCell.class, this.myGraphCommitCellRenderer);
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)this.myStringCellRenderer));
        this.setShowHorizontalLines(false);
        this.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.setTableHeader((JTableHeader)((Object)new InvisibleResizableHeader()));
        this.myController = new GraphTableController(this, ui, logData, graphCellPainter, this.myGraphCommitCellRenderer);
        this.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
        this.getColumnModel().setColumnSelectionAllowed(false);
        ScrollingUtil.installActions((JTable)((Object)this), (boolean)false);
        new IndexSpeedSearch(this.myLogData.getProject(), this.myLogData.getIndex(), this){

            @Override
            protected boolean isSpeedSearchEnabled() {
                return VcsLogGraphTable.this.isSpeedSearchEnabled() && super.isSpeedSearchEnabled();
            }
        };
        this.initColumnSize();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                VcsLogGraphTable.this.updateCommitColumnWidth();
            }
        });
    }

    protected boolean isSpeedSearchEnabled() {
        return Registry.is((String)"vcs.log.speedsearch");
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permGraphChanged) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "updateDataPack"));
        }
        Selection previousSelection = this.getSelection();
        this.getModel().setVisiblePack(visiblePack);
        previousSelection.restore(visiblePack.getVisibleGraph(), true, permGraphChanged);
        for (VcsLogHighlighter highlighter : this.myHighlighters) {
            highlighter.update((VcsLogDataPack)visiblePack, permGraphChanged);
        }
        this.setPaintBusy(false);
        this.initColumnSize();
    }

    public void initColumnSize() {
        if (!this.myColumnsSizeInitialized && this.getModel().getRowCount() > 0) {
            this.myColumnsSizeInitialized = this.setColumnPreferredSize();
            if (this.myColumnsSizeInitialized) {
                this.setAutoCreateColumnsFromModel(false);
                for (int column = 0; column < this.getColumnCount(); ++column) {
                    this.getColumnModel().getColumn(column).setResizable(column != 0);
                }
            }
        }
    }

    private boolean setColumnPreferredSize() {
        boolean sizeCalculated = false;
        Font tableFont = UIManager.getFont("Table.font");
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            TableColumn column = this.getColumnModel().getColumn(i2);
            if (i2 == 0) {
                this.setRootColumnSize(column);
                continue;
            }
            if (i2 == 2) {
                int maxRowsToCheck = Math.min(1000, this.getRowCount());
                int maxWidth = 0;
                int unloaded = 0;
                for (int row = 0; row < maxRowsToCheck; ++row) {
                    String value = this.getModel().getValueAt(row, i2).toString();
                    if (value.isEmpty()) {
                        ++unloaded;
                        continue;
                    }
                    Font font = tableFont;
                    VcsLogHighlighter.TextStyle style = this.getStyle(row, i2, false, false).getTextStyle();
                    if (VcsLogHighlighter.TextStyle.BOLD.equals((Object)style)) {
                        font = tableFont.deriveFont(1);
                    } else if (VcsLogHighlighter.TextStyle.ITALIC.equals((Object)style)) {
                        font = tableFont.deriveFont(2);
                    }
                    maxWidth = Math.max(this.getFontMetrics(font).stringWidth(value + "*"), maxWidth);
                }
                int min = Math.min(maxWidth + this.myStringCellRenderer.getHorizontalTextPadding(), JBUI.scale((int)200));
                column.setPreferredWidth(min);
                if (unloaded * 2 > maxRowsToCheck) continue;
                sizeCalculated = true;
                continue;
            }
            if (i2 != 3) continue;
            int min = this.getFontMetrics(tableFont.deriveFont(1)).stringWidth(DateFormatUtil.formatDateTime((Date)new Date())) + this.myStringCellRenderer.getHorizontalTextPadding();
            column.setPreferredWidth(min);
        }
        this.updateCommitColumnWidth();
        return sizeCalculated;
    }

    private void updateCommitColumnWidth() {
        int size = this.getWidth();
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            if (i2 == 1) continue;
            TableColumn column = this.getColumnModel().getColumn(i2);
            size -= column.getPreferredWidth();
        }
        TableColumn commitColumn = this.getColumnModel().getColumn(1);
        commitColumn.setPreferredWidth(size);
    }

    private void setRootColumnSize(@NotNull TableColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "setRootColumnSize"));
        }
        int rootWidth = !this.myUi.isMultipleRoots() ? 0 : (!this.myUi.isShowRootNames() ? JBUI.scale((int)13) : Math.min(this.calculateMaxRootWidth(), JBUI.scale((int)200)));
        column.setMinWidth(rootWidth);
        column.setMaxWidth(rootWidth);
        column.setPreferredWidth(rootWidth);
    }

    private int calculateMaxRootWidth() {
        int width = 0;
        for (VirtualFile file2 : this.myLogData.getRoots()) {
            Font tableFont = UIManager.getFont("Table.font");
            width = Math.max(this.getFontMetrics(tableFont).stringWidth(file2.getName() + "  "), width);
        }
        return width;
    }

    public String getToolTipText(@NotNull MouseEvent event) {
        Object at;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "getToolTipText"));
        }
        int row = this.rowAtPoint(event.getPoint());
        int column = this.columnAtPoint(event.getPoint());
        if (column < 0 || row < 0) {
            return null;
        }
        if (column == 0 && (at = this.getValueAt(row, column)) instanceof VirtualFile) {
            return "<html><b>" + ((VirtualFile)at).getPresentableUrl() + "</b><br/>Click to " + (this.myUi.isShowRootNames() ? "collapse" : "expand") + "</html>";
        }
        return null;
    }

    public void jumpToRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex <= this.getRowCount() - 1) {
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
            this.setRowSelectionInterval(rowIndex, rowIndex);
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length == 0 || selectedRows.length > 1000) {
                return null;
            }
            Set roots = ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row -> this.getModel().getRoot((int)row));
            if (roots.size() == 1) {
                return this.myLogData.getLogProvider((VirtualFile)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)roots))).getSupportedVcs();
            }
        } else {
            if (VcsLogDataKeys.VCS_LOG_BRANCHES.is(dataId)) {
                int[] selectedRows = this.getSelectedRows();
                if (selectedRows.length != 1) {
                    return null;
                }
                return this.getModel().getBranchesAtRow(selectedRows[0]);
            }
            if (VcsDataKeys.PRESET_COMMIT_MESSAGE.is(dataId)) {
                int[] selectedRows = this.getSelectedRows();
                if (selectedRows.length == 0) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < Math.min(1000, selectedRows.length); ++i2) {
                    sb.append(this.getModel().getValueAt(selectedRows[i2], 1).toString());
                    if (i2 == selectedRows.length - 1) continue;
                    sb.append("\n");
                }
                return sb.toString();
            }
        }
        return null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "performCopy"));
        }
        StringBuilder sb = new StringBuilder();
        int[] selectedRows = this.getSelectedRows();
        for (int i2 = 0; i2 < Math.min(1000, selectedRows.length); ++i2) {
            int row = selectedRows[i2];
            sb.append(this.getModel().getValueAt(row, 1).toString());
            sb.append(" ").append(this.getModel().getValueAt(row, 2).toString());
            sb.append(" ").append(this.getModel().getValueAt(row, 3).toString());
            if (i2 == selectedRows.length - 1) continue;
            sb.append("\n");
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "isCopyEnabled"));
        }
        return this.getSelectedRowCount() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "isCopyVisible"));
        }
        return true;
    }

    public void addHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "addHighlighter"));
        }
        this.myHighlighters.add(highlighter);
    }

    public void removeHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "removeHighlighter"));
        }
        this.myHighlighters.remove(highlighter);
    }

    public void removeAllHighlighters() {
        this.myHighlighters.clear();
    }

    @NotNull
    public SimpleTextAttributes applyHighlighters(@NotNull Component rendererComponent, int row, int column, boolean hasFocus, boolean selected) {
        if (rendererComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rendererComponent", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "applyHighlighters"));
        }
        VcsLogHighlighter.VcsCommitStyle style = this.getStyle(row, column, hasFocus, selected);
        assert (style.getBackground() != null && style.getForeground() != null && style.getTextStyle() != null);
        rendererComponent.setBackground(style.getBackground());
        rendererComponent.setForeground(style.getForeground());
        switch (style.getTextStyle()) {
            case BOLD: {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                if (simpleTextAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "applyHighlighters"));
                }
                return simpleTextAttributes;
            }
            case ITALIC: {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
                if (simpleTextAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "applyHighlighters"));
                }
                return simpleTextAttributes;
            }
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "applyHighlighters"));
        }
        return simpleTextAttributes;
    }

    public VcsLogHighlighter.VcsCommitStyle getBaseStyle(int row, int column, boolean hasFocus, boolean selected) {
        Component dummyRendererComponent = this.myDummyRenderer.getTableCellRendererComponent((JTable)((Object)this), "", selected, hasFocus, row, column);
        return VcsCommitStyleFactory.createStyle((Color)dummyRendererComponent.getForeground(), (Color)dummyRendererComponent.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
    }

    private VcsLogHighlighter.VcsCommitStyle getStyle(int row, int column, boolean hasFocus, boolean selected) {
        VcsLogHighlighter.VcsCommitStyle baseStyle = this.getBaseStyle(row, column, hasFocus, selected);
        VisibleGraph<Integer> visibleGraph = this.getVisibleGraph();
        if (row < 0 || row >= visibleGraph.getVisibleCommitCount()) {
            LOG.error("Visible graph has " + visibleGraph.getVisibleCommitCount() + " commits, yet we want row " + row);
            return baseStyle;
        }
        RowInfo rowInfo = visibleGraph.getRowInfo(row);
        VcsLogHighlighter.VcsCommitStyle defaultStyle = VcsCommitStyleFactory.createStyle((Color)(rowInfo.getRowType() == RowType.UNMATCHED ? JBColor.GRAY : baseStyle.getForeground()), (Color)baseStyle.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
        VcsShortCommitDetails details = this.myLogData.getMiniDetailsGetter().getCommitDataIfAvailable((Integer)rowInfo.getCommit());
        if (details == null) {
            return defaultStyle;
        }
        List styles = ContainerUtil.map(this.myHighlighters, highlighter -> highlighter.getStyle(details, selected));
        return VcsCommitStyleFactory.combine((Collection)ContainerUtil.append((List)styles, (Object[])new VcsLogHighlighter.VcsCommitStyle[]{defaultStyle}));
    }

    public void viewportSet(JViewport viewport) {
        viewport.addChangeListener(e -> {
            GraphTableModel model = this.getModel();
            Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this));
            model.fireTableChanged(new TableModelEvent(model, (Integer)visibleRows.first - 1, (Integer)visibleRows.second, 0));
        });
    }

    public void rootColumnUpdated() {
        this.setRootColumnSize(this.getColumnModel().getColumn(0));
        this.updateCommitColumnWidth();
    }

    public static JBColor getRootBackgroundColor(@NotNull VirtualFile root, @NotNull VcsLogColorManager colorManager) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "getRootBackgroundColor"));
        }
        if (colorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorManager", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "getRootBackgroundColor"));
        }
        return VcsLogColorManagerImpl.getBackgroundColor(colorManager.getRootColor(root));
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        Component layeredPane = UIUtil.findParentByCondition((Component)((Object)this), component -> component instanceof LoadingDecorator.CursorAware);
        if (layeredPane != null) {
            layeredPane.setCursor(cursor);
        }
    }

    @NotNull
    public GraphTableModel getModel() {
        GraphTableModel graphTableModel = (GraphTableModel)super.getModel();
        if (graphTableModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "getModel"));
        }
        return graphTableModel;
    }

    @NotNull
    public Selection getSelection() {
        if (this.mySelection == null) {
            this.mySelection = new Selection(this);
        }
        Selection selection = this.mySelection;
        if (selection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "getSelection"));
        }
        return selection;
    }

    public void handleAnswer(@Nullable GraphAnswer<Integer> answer, boolean dataCouldChange) {
        this.myController.handleGraphAnswer(answer, dataCouldChange, null, null);
    }

    public void showTooltip(int row) {
        this.myController.showTooltip(row);
    }

    public void setCompactReferencesView(boolean compact) {
        this.myGraphCommitCellRenderer.setCompactReferencesView(compact);
        this.repaint();
    }

    public void setShowTagNames(boolean showTagsNames) {
        this.myGraphCommitCellRenderer.setShowTagsNames(showTagsNames);
        this.repaint();
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        VisibleGraph<Integer> visibleGraph = this.getModel().getVisiblePack().getVisibleGraph();
        if (visibleGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "getVisibleGraph"));
        }
        return visibleGraph;
    }

    public TableCellEditor getCellEditor() {
        return this.myDummyEditor;
    }

    public int getRowHeight() {
        return this.myGraphCommitCellRenderer.getPreferredHeight();
    }

    @Override
    protected void paintFooter(@NotNull Graphics g, int x, int y, int width, int height) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/vcs/log/ui/table/VcsLogGraphTable", "paintFooter"));
        }
        int lastRow = this.getRowCount() - 1;
        if (lastRow >= 0) {
            g.setColor(this.getStyle(lastRow, 1, this.hasFocus(), false).getBackground());
            g.fillRect(x, y, width, height);
            if (this.myUi.isMultipleRoots()) {
                g.setColor((Color)VcsLogGraphTable.getRootBackgroundColor(this.getModel().getRoot(lastRow), this.myUi.getColorManager()));
                int rootWidth = this.getColumnModel().getColumn(0).getWidth();
                if (!this.myUi.isShowRootNames()) {
                    rootWidth -= JBUI.scale((int)5);
                }
                g.fillRect(x, y, rootWidth, height);
            }
        } else {
            g.setColor(this.getBaseStyle(lastRow, 1, this.hasFocus(), false).getBackground());
            g.fillRect(x, y, width, height);
        }
    }

    boolean isResizingColumns() {
        return this.getCursor() == Cursor.getPredefinedCursor(11);
    }

    private class MyProgressListener
    implements VcsLogProgress.ProgressListener {
        @NotNull
        private String myText = "";

        private MyProgressListener() {
        }

        @Override
        public void progressStarted() {
            this.myText = VcsLogGraphTable.this.getEmptyText().getText();
            VcsLogGraphTable.this.getEmptyText().setText("Loading History...");
        }

        @Override
        public void progressStopped() {
            VcsLogGraphTable.this.getEmptyText().setText(this.myText);
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            VcsLogGraphTable.this.mySelection = null;
        }
    }

    private static class MyBasicTableHeaderUI
    extends BasicTableHeaderUI
    implements MouseInputListener {
        public MyBasicTableHeaderUI(@NotNull JTableHeader tableHeader) {
            if (tableHeader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableHeader", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "<init>"));
            }
            this.header = tableHeader;
            this.mouseInputListener = this.createMouseInputListener();
        }

        @NotNull
        private MouseEvent convertMouseEvent(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "convertMouseEvent"));
            }
            MouseEvent mouseEvent = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), 0, e.getXOnScreen(), this.header.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            if (mouseEvent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "convertMouseEvent"));
            }
            return mouseEvent;
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseClicked"));
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "mousePressed"));
            }
            if (this.isOnBorder(e)) {
                return;
            }
            this.mouseInputListener.mousePressed(this.convertMouseEvent(e));
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseReleased"));
            }
            if (this.isOnBorder(e)) {
                return;
            }
            this.mouseInputListener.mouseReleased(this.convertMouseEvent(e));
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseEntered"));
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseExited"));
            }
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseDragged"));
            }
            if (this.isOnBorder(e)) {
                return;
            }
            this.mouseInputListener.mouseDragged(this.convertMouseEvent(e));
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "mouseMoved"));
            }
            if (this.isOnBorder(e)) {
                return;
            }
            this.mouseInputListener.mouseMoved(this.convertMouseEvent(e));
        }

        public boolean isOnBorder(@NotNull MouseEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyBasicTableHeaderUI", "isOnBorder"));
            }
            return Math.abs(this.header.getTable().getWidth() - e.getPoint().x) <= JBUI.scale((int)3);
        }
    }

    private static class EmptyTableCellRenderer
    implements TableCellRenderer {
        private EmptyTableCellRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setMaximumSize(new Dimension(0, 0));
            JPanel jPanel = panel2;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$EmptyTableCellRenderer", "getTableCellRendererComponent"));
            }
            return jPanel;
        }
    }

    private class InvisibleResizableHeader
    extends JBTable.JBTableHeader {
        @NotNull
        private final MyBasicTableHeaderUI myHeaderUI;
        @Nullable
        private Cursor myCursor;

        public InvisibleResizableHeader() {
            super((JBTable)VcsLogGraphTable.this);
            this.myCursor = null;
            this.myHeaderUI = new MyBasicTableHeaderUI((JTableHeader)((Object)this));
            this.setDefaultRenderer(new EmptyTableCellRenderer());
            this.setReorderingAllowed(false);
        }

        public void setTable(JTable table) {
            JTable oldTable = this.getTable();
            if (oldTable != null) {
                oldTable.removeMouseListener(this.myHeaderUI);
                oldTable.removeMouseMotionListener(this.myHeaderUI);
            }
            super.setTable(table);
            if (table != null) {
                table.addMouseListener(this.myHeaderUI);
                table.addMouseMotionListener(this.myHeaderUI);
            }
        }

        public void setCursor(@Nullable Cursor cursor) {
            JTable table = this.getTable();
            if (table != null) {
                table.setCursor(cursor);
                this.myCursor = cursor;
            } else {
                super.setCursor(cursor);
            }
        }

        public Cursor getCursor() {
            if (this.myCursor == null) {
                JTable table = this.getTable();
                if (table == null) {
                    return super.getCursor();
                }
                return table.getCursor();
            }
            return this.myCursor;
        }

        @NotNull
        public Rectangle getHeaderRect(int column) {
            Rectangle headerRect = super.getHeaderRect(column);
            Rectangle rectangle = new Rectangle(headerRect.x, headerRect.y, headerRect.width, 1);
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$InvisibleResizableHeader", "getHeaderRect"));
            }
            return rectangle;
        }
    }

    private class MyDummyTableCellEditor
    implements TableCellEditor {
        private MyDummyTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (!(anEvent instanceof MouseEvent)) {
                return true;
            }
            return VcsLogGraphTable.this.myController.findPrintElement((MouseEvent)anEvent) == null;
        }

        @Override
        public boolean stopCellEditing() {
            return false;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    private class StringCellRenderer
    extends ColoredTableCellRenderer {
        private StringCellRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setBorder(null);
            if (value == null) {
                return;
            }
            this.append(value.toString(), VcsLogGraphTable.this.applyHighlighters((Component)((Object)this), row, column, hasFocus, selected));
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }

        public int getHorizontalTextPadding() {
            Insets borderInsets = this.getMyBorder().getBorderInsets((Component)((Object)this));
            Insets ipad = this.getIpad();
            return borderInsets.left + borderInsets.right + ipad.left + ipad.right;
        }
    }

    private static class RootCellRenderer
    extends JBLabel
    implements TableCellRenderer {
        @NotNull
        private final AbstractVcsLogUi myUi;
        @NotNull
        private Color myColor;
        @NotNull
        private Color myBorderColor;
        private boolean isNarrow;

        RootCellRenderer(@NotNull AbstractVcsLogUi ui) {
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$RootCellRenderer", "<init>"));
            }
            super("", 0);
            this.myColor = UIUtil.getTableBackground();
            this.myBorderColor = UIUtil.getTableBackground();
            this.isNarrow = true;
            this.myUi = ui;
        }

        protected void paintComponent(Graphics g) {
            this.setFont(UIManager.getFont("Table.font"));
            g.setColor(this.myColor);
            int width = this.getWidth();
            if (this.isNarrow) {
                g.fillRect(0, 0, width - JBUI.scale((int)5), this.myUi.getTable().getRowHeight());
                g.setColor(this.myBorderColor);
                g.fillRect(width - JBUI.scale((int)5), 0, JBUI.scale((int)5), this.myUi.getTable().getRowHeight());
            } else {
                g.fillRect(0, 0, width, this.myUi.getTable().getRowHeight());
            }
            super.paintComponent(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color;
            String text;
            if (value instanceof VirtualFile) {
                VirtualFile root = (VirtualFile)value;
                int readableRow = ScrollingUtil.getReadableRow((JTable)table, (int)Math.round((float)this.myUi.getTable().getRowHeight() * 0.5f));
                text = row < readableRow ? "" : (row == 0 || !value.equals(table.getModel().getValueAt(row - 1, column)) || readableRow == row ? root.getName() : "");
                color = VcsLogGraphTable.getRootBackgroundColor(root, this.myUi.getColorManager());
            } else {
                text = null;
                color = UIUtil.getTableBackground((boolean)isSelected);
            }
            this.myColor = color;
            Color background = ((VcsLogGraphTable)((Object)table)).getStyle(row, column, hasFocus, isSelected).getBackground();
            assert (background != null);
            this.myBorderColor = background;
            this.setForeground(UIUtil.getTableForeground((boolean)false));
            if (this.myUi.isShowRootNames()) {
                this.setText(text);
                this.isNarrow = false;
            } else {
                this.setText("");
                this.isNarrow = true;
            }
            return this;
        }

        public void setBackground(Color bg) {
            this.myBorderColor = bg;
        }
    }

    static class Selection {
        @NotNull
        private final VcsLogGraphTable myTable;
        @NotNull
        private final TIntHashSet mySelectedCommits;
        @Nullable
        private final Integer myVisibleSelectedCommit;
        @Nullable
        private final Integer myDelta;
        private final boolean myIsOnTop;

        public Selection(@NotNull VcsLogGraphTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$Selection", "<init>"));
            }
            this.myTable = table;
            List selectedRows = ContainerUtil.sorted((Collection)Ints.asList((int[])this.myTable.getSelectedRows()));
            Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this.myTable));
            this.myIsOnTop = (Integer)visibleRows.first - 1 == 0;
            VisibleGraph<Integer> graph = this.myTable.getVisibleGraph();
            this.mySelectedCommits = new TIntHashSet();
            Integer visibleSelectedCommit = null;
            Integer delta = null;
            Iterator iterator = selectedRows.iterator();
            while (iterator.hasNext()) {
                int row = (Integer)iterator.next();
                if (row >= graph.getVisibleCommitCount()) continue;
                Integer commit = (Integer)graph.getRowInfo(row).getCommit();
                this.mySelectedCommits.add(commit.intValue());
                if ((Integer)visibleRows.first - 1 > row || row > (Integer)visibleRows.second || visibleSelectedCommit != null) continue;
                visibleSelectedCommit = commit;
                delta = this.myTable.getCellRect((int)row, (int)0, (boolean)false).y - this.myTable.getVisibleRect().y;
            }
            if (visibleSelectedCommit == null && (Integer)visibleRows.first - 1 >= 0) {
                visibleSelectedCommit = (Integer)graph.getRowInfo((Integer)visibleRows.first - 1).getCommit();
                delta = this.myTable.getCellRect((int)(((Integer)visibleRows.first).intValue() - 1), (int)0, (boolean)false).y - this.myTable.getVisibleRect().y;
            }
            this.myVisibleSelectedCommit = visibleSelectedCommit;
            this.myDelta = delta;
        }

        public void restore(@NotNull VisibleGraph<Integer> newVisibleGraph, boolean scrollToSelection, boolean permGraphChanged) {
            if (newVisibleGraph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newVisibleGraph", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$Selection", "restore"));
            }
            Pair<TIntHashSet, Integer> toSelectAndScroll = this.findRowsToSelectAndScroll(this.myTable.getModel(), newVisibleGraph);
            if (!((TIntHashSet)toSelectAndScroll.first).isEmpty()) {
                this.myTable.getSelectionModel().setValueIsAdjusting(true);
                ((TIntHashSet)toSelectAndScroll.first).forEach(row -> {
                    this.myTable.addRowSelectionInterval(row, row);
                    return true;
                });
                this.myTable.getSelectionModel().setValueIsAdjusting(false);
            }
            if (scrollToSelection) {
                if (this.myIsOnTop && permGraphChanged) {
                    this.scrollToRow(0, 0);
                } else if (toSelectAndScroll.second != null) {
                    assert (this.myDelta != null);
                    this.scrollToRow((Integer)toSelectAndScroll.second, this.myDelta);
                }
            }
        }

        private void scrollToRow(Integer row, Integer delta) {
            Rectangle startRect = this.myTable.getCellRect(row, 0, true);
            this.myTable.scrollRectToVisible(new Rectangle(startRect.x, Math.max(startRect.y - delta, 0), startRect.width, this.myTable.getVisibleRect().height));
        }

        @NotNull
        private Pair<TIntHashSet, Integer> findRowsToSelectAndScroll(@NotNull GraphTableModel model, @NotNull VisibleGraph<Integer> visibleGraph) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$Selection", "findRowsToSelectAndScroll"));
            }
            if (visibleGraph == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleGraph", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$Selection", "findRowsToSelectAndScroll"));
            }
            TIntHashSet rowsToSelect = new TIntHashSet();
            if (model.getRowCount() == 0) {
                Pair pair = Pair.create((Object)rowsToSelect, null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$Selection", "findRowsToSelectAndScroll"));
                }
                return pair;
            }
            Integer rowToScroll = null;
            for (int row = 0; row < visibleGraph.getVisibleCommitCount() && (rowsToSelect.size() < this.mySelectedCommits.size() || rowToScroll == null); ++row) {
                int commit = (Integer)visibleGraph.getRowInfo(row).getCommit();
                if (this.mySelectedCommits.contains(commit)) {
                    rowsToSelect.add(row);
                }
                if (this.myVisibleSelectedCommit == null || this.myVisibleSelectedCommit != commit) continue;
                rowToScroll = row;
            }
            Pair pair = Pair.create((Object)rowsToSelect, rowToScroll);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$Selection", "findRowsToSelectAndScroll"));
            }
            return pair;
        }
    }
}

