/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class VcsLogUiUtil {
    @NotNull
    public static JComponent installProgress(@NotNull JComponent component, final @NotNull VcsLogData logData, @NotNull Disposable disposableParent) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/vcs/log/util/VcsLogUiUtil", "installProgress"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/util/VcsLogUiUtil", "installProgress"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/util/VcsLogUiUtil", "installProgress"));
        }
        final ProgressStripe progressStripe = new ProgressStripe(component, disposableParent, 300){

            @Override
            public void updateUI() {
                super.updateUI();
                if (this.myDecorator != null && logData.getProgress().isRunning()) {
                    this.startLoadingImmediately();
                }
            }
        };
        logData.getProgress().addProgressIndicatorListener(new VcsLogProgress.ProgressListener(){

            @Override
            public void progressStarted() {
                progressStripe.startLoading();
            }

            @Override
            public void progressStopped() {
                progressStripe.stopLoading();
            }
        }, disposableParent);
        ProgressStripe progressStripe2 = progressStripe;
        if (progressStripe2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsLogUiUtil", "installProgress"));
        }
        return progressStripe2;
    }

    @NotNull
    public static JScrollPane setupScrolledGraph(@NotNull VcsLogGraphTable graphTable, int border) {
        if (graphTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphTable", "com/intellij/vcs/log/util/VcsLogUiUtil", "setupScrolledGraph"));
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)graphTable), (int)border);
        graphTable.viewportSet(scrollPane.getViewport());
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/util/VcsLogUiUtil", "setupScrolledGraph"));
        }
        return jScrollPane;
    }

    public static void installDetailsListeners(@NotNull VcsLogGraphTable graphTable, @NotNull DetailsPanel detailsPanel, @NotNull VcsLogData logData, @NotNull Disposable disposableParent) {
        if (graphTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphTable", "com/intellij/vcs/log/util/VcsLogUiUtil", "installDetailsListeners"));
        }
        if (detailsPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsPanel", "com/intellij/vcs/log/util/VcsLogUiUtil", "installDetailsListeners"));
        }
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/util/VcsLogUiUtil", "installDetailsListeners"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/util/VcsLogUiUtil", "installDetailsListeners"));
        }
        Runnable miniDetailsLoadedListener = () -> {
            if (graphTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphTable", "com/intellij/vcs/log/util/VcsLogUiUtil", "lambda$installDetailsListeners$0"));
            }
            graphTable.initColumnSize();
            graphTable.repaint();
        };
        Runnable containingBranchesListener = () -> {
            if (detailsPanel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "detailsPanel", "com/intellij/vcs/log/util/VcsLogUiUtil", "lambda$installDetailsListeners$1"));
            }
            if (graphTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphTable", "com/intellij/vcs/log/util/VcsLogUiUtil", "lambda$installDetailsListeners$1"));
            }
            detailsPanel.branchesChanged();
            graphTable.repaint();
        };
        logData.getMiniDetailsGetter().addDetailsLoadedListener(miniDetailsLoadedListener);
        logData.getContainingBranchesGetter().addTaskCompletedListener(containingBranchesListener);
        Disposer.register((Disposable)disposableParent, () -> {
            if (logData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/util/VcsLogUiUtil", "lambda$installDetailsListeners$2"));
            }
            logData.getContainingBranchesGetter().removeTaskCompletedListener(containingBranchesListener);
            logData.getMiniDetailsGetter().removeDetailsLoadedListener(miniDetailsLoadedListener);
        });
    }
}

