/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.frame.ThreadComboBoxRenderer;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.frame.XStackFrameContainerEx;
import gnu.trove.TObjectIntHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XFramesView
extends XDebugView {
    private final JPanel myMainPanel;
    private final XDebuggerFramesList myFramesList;
    private final ComboBox myThreadComboBox;
    private final TObjectIntHashMap<XExecutionStack> myExecutionStacksWithSelection;
    private XExecutionStack mySelectedStack;
    private int mySelectedFrameIndex;
    private Rectangle myVisibleRect;
    private boolean myListenersEnabled;
    private final Map<XExecutionStack, StackFramesListBuilder> myBuilders;
    private final ActionToolbarImpl myToolbar;
    private final Wrapper myThreadsPanel;
    private boolean myThreadsCalculated;
    private final TransferToEDTQueue<Runnable> myLaterInvocator;
    private boolean myRefresh;

    public XFramesView(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/frame/XFramesView", "<init>"));
        }
        this.myExecutionStacksWithSelection = new TObjectIntHashMap();
        this.myBuilders = new HashMap();
        this.myThreadsCalculated = false;
        this.myLaterInvocator = TransferToEDTQueue.createRunnableMerger((String)"XFramesView later invocator", (int)50);
        this.myRefresh = false;
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myFramesList = new XDebuggerFramesList(project2);
        this.myFramesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (XFramesView.this.myListenersEnabled && !e.getValueIsAdjusting() && XFramesView.this.mySelectedFrameIndex != XFramesView.this.myFramesList.getSelectedIndex()) {
                    XFramesView.this.processFrameSelection(XDebugView.getSession(e), true);
                }
            }
        });
        this.myFramesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int i2;
                if (XFramesView.this.myListenersEnabled && (i2 = XFramesView.this.myFramesList.locationToIndex(e.getPoint())) != -1 && XFramesView.this.myFramesList.isSelectedIndex(i2)) {
                    XFramesView.this.processFrameSelection(XDebugView.getSession(e), true);
                }
            }
        });
        this.myFramesList.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionManager actionManager = ActionManager.getInstance();
                ActionGroup group = (ActionGroup)actionManager.getAction("XDebugger.Frames.Tree.Popup");
                actionManager.createActionPopupMenu("unknown", group).getComponent().show(comp, x, y);
            }
        });
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myFramesList)), "Center");
        this.myThreadComboBox = new ComboBox();
        this.myThreadComboBox.setRenderer((ListCellRenderer)((Object)new ThreadComboBoxRenderer((JComboBox)this.myThreadComboBox)));
        this.myThreadComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XDebugSession session2;
                Object item;
                if (!XFramesView.this.myListenersEnabled) {
                    return;
                }
                if (e.getStateChange() == 1 && (item = e.getItem()) != XFramesView.this.mySelectedStack && item instanceof XExecutionStack && (session2 = XDebugView.getSession(e)) != null) {
                    XFramesView.this.myRefresh = false;
                    XFramesView.this.updateFrames((XExecutionStack)item, session2);
                }
            }
        });
        this.myThreadComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                XSuspendContext context;
                XDebugSession session2 = XDebugView.getSession(e);
                XSuspendContext xSuspendContext = context = session2 == null ? null : session2.getSuspendContext();
                if (context != null && !XFramesView.this.myThreadsCalculated) {
                    XFramesView.this.myThreadsCalculated = true;
                    XFramesView.this.myThreadComboBox.addItem(null);
                    context.computeExecutionStacks(new XSuspendContext.XExecutionStackContainer(){

                        public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
                            if (executionStacks == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionStacks", "com/intellij/xdebugger/impl/frame/XFramesView$5$1", "addExecutionStack"));
                            }
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (executionStacks == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionStacks", "com/intellij/xdebugger/impl/frame/XFramesView$5$1", "lambda$addExecutionStack$0"));
                                }
                                XFramesView.this.myThreadComboBox.removeItem(null);
                                XFramesView.this.addExecutionStacks(executionStacks);
                                ComboPopup popup = XFramesView.this.myThreadComboBox.getPopup();
                                if (popup != null && popup.isVisible()) {
                                    popup.hide();
                                    popup.show();
                                }
                            });
                        }

                        public void errorOccurred(@NotNull String errorMessage) {
                            if (errorMessage == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/frame/XFramesView$5$1", "errorOccurred"));
                            }
                        }
                    });
                }
            }
        });
        new ComboboxSpeedSearch((JComboBox)this.myThreadComboBox){

            @Override
            protected String getElementText(Object element) {
                return ((XExecutionStack)element).getDisplayName();
            }
        };
        this.myToolbar = this.createToolbar();
        this.myThreadsPanel = new Wrapper();
        this.myThreadsPanel.setBorder((Border)new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, 0, 0, 1, 0));
        this.myThreadsPanel.add((Component)this.myToolbar.getComponent(), (Object)"East");
        this.myMainPanel.add((Component)this.myThreadsPanel, "North");
    }

    private ActionToolbarImpl createToolbar() {
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        framesGroup.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.myFramesList));
        framesGroup.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)this.myFramesList));
        framesGroup.addAll(new AnAction[]{ActionManager.getInstance().getAction("XDebugger.Frames.TopToolbar")});
        ActionToolbarImpl toolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)framesGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setAddSeparatorFirst(true);
        toolbar.getComponent().setBorder(new EmptyBorder(1, 0, 0, 0));
        return toolbar;
    }

    private StackFramesListBuilder getOrCreateBuilder(XExecutionStack executionStack, XDebugSession session2) {
        return this.myBuilders.computeIfAbsent(executionStack, k -> new StackFramesListBuilder(executionStack, session2));
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSession session2) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XFramesView", "processSessionEvent"));
        }
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XFramesView", "processSessionEvent"));
        }
        boolean bl = this.myRefresh = event == XDebugView.SessionEvent.SETTINGS_CHANGED;
        if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
            return;
        }
        XStackFrame currentStackFrame = session2.getCurrentStackFrame();
        XSuspendContext suspendContext = session2.getSuspendContext();
        if (event == XDebugView.SessionEvent.FRAME_CHANGED) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (currentStackFrame != null) {
                this.myFramesList.setSelectedValue(currentStackFrame, true);
                this.mySelectedFrameIndex = this.myFramesList.getSelectedIndex();
                this.myExecutionStacksWithSelection.put((Object)this.mySelectedStack, this.mySelectedFrameIndex);
            }
            return;
        }
        this.myLaterInvocator.offer(() -> {
            boolean invisible;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XFramesView", "lambda$processSessionEvent$1"));
            }
            if (session2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XFramesView", "lambda$processSessionEvent$1"));
            }
            if (event != XDebugView.SessionEvent.SETTINGS_CHANGED) {
                this.mySelectedFrameIndex = 0;
                this.mySelectedStack = null;
                this.myVisibleRect = null;
            } else {
                this.myVisibleRect = this.myFramesList.getVisibleRect();
            }
            this.myListenersEnabled = false;
            this.myBuilders.values().forEach(StackFramesListBuilder::dispose);
            this.myBuilders.clear();
            if (suspendContext == null) {
                this.requestClear();
                return;
            }
            if (event == XDebugView.SessionEvent.PAUSED) {
                this.cancelClear();
                this.clear();
            }
            XExecutionStack[] executionStacks = suspendContext.getExecutionStacks();
            this.addExecutionStacks(Arrays.asList(executionStacks));
            XExecutionStack activeExecutionStack = this.mySelectedStack != null ? this.mySelectedStack : suspendContext.getActiveExecutionStack();
            this.myThreadComboBox.setSelectedItem((Object)activeExecutionStack);
            this.myThreadsPanel.removeAll();
            this.myThreadsPanel.add((Component)this.myToolbar.getComponent(), (Object)"East");
            boolean bl = invisible = executionStacks.length == 1 && StringUtil.isEmpty((String)executionStacks[0].getDisplayName());
            if (!invisible) {
                this.myThreadsPanel.add((Component)this.myThreadComboBox, (Object)"Center");
            }
            this.myToolbar.setAddSeparatorFirst(!invisible);
            this.updateFrames(activeExecutionStack, session2);
        });
    }

    @Override
    protected void clear() {
        this.myThreadComboBox.removeAllItems();
        this.myFramesList.clear();
        this.myThreadsCalculated = false;
        this.myExecutionStacksWithSelection.clear();
    }

    private void addExecutionStacks(List<? extends XExecutionStack> executionStacks) {
        for (XExecutionStack xExecutionStack : executionStacks) {
            if (this.myExecutionStacksWithSelection.contains((Object)xExecutionStack)) continue;
            this.myThreadComboBox.addItem((Object)xExecutionStack);
            this.myExecutionStacksWithSelection.put((Object)xExecutionStack, 0);
        }
    }

    private void updateFrames(XExecutionStack executionStack, @NotNull XDebugSession session2) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XFramesView", "updateFrames"));
        }
        if (this.mySelectedStack != null) {
            this.getOrCreateBuilder(this.mySelectedStack, session2).stop();
        }
        this.mySelectedStack = executionStack;
        if (executionStack != null) {
            this.mySelectedFrameIndex = this.myExecutionStacksWithSelection.get((Object)executionStack);
            StackFramesListBuilder builder = this.getOrCreateBuilder(executionStack, session2);
            this.myListenersEnabled = false;
            builder.initModel(this.myFramesList.getModel());
            this.myListenersEnabled = !builder.start();
        }
    }

    public void dispose() {
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private void processFrameSelection(XDebugSession session2, boolean force) {
        this.mySelectedFrameIndex = this.myFramesList.getSelectedIndex();
        this.myExecutionStacksWithSelection.put((Object)this.mySelectedStack, this.mySelectedFrameIndex);
        Object selected = this.myFramesList.getSelectedValue();
        if (selected instanceof XStackFrame && session2 != null && (force || !this.myRefresh && session2.getCurrentStackFrame() != selected)) {
            session2.setCurrentStackFrame(this.mySelectedStack, (XStackFrame)selected, this.mySelectedFrameIndex == 0);
        }
    }

    private class StackFramesListBuilder
    implements XStackFrameContainerEx {
        private XExecutionStack myExecutionStack;
        private final List<XStackFrame> myStackFrames;
        private String myErrorMessage;
        private int myNextFrameIndex = 0;
        private volatile boolean myRunning;
        private boolean myAllFramesLoaded;
        private final XDebugSession mySession;

        private StackFramesListBuilder(XExecutionStack executionStack, XDebugSession session2) {
            this.myExecutionStack = executionStack;
            this.mySession = session2;
            this.myStackFrames = new ArrayList<XStackFrame>();
        }

        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
            if (stackFrames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackFrames", "com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder", "addStackFrames"));
            }
            this.addStackFrames(stackFrames, null, last);
        }

        @Override
        public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, @Nullable XStackFrame toSelect, boolean last) {
            if (stackFrames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackFrames", "com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder", "addStackFrames"));
            }
            if (this.isObsolete()) {
                return;
            }
            XFramesView.this.myLaterInvocator.offer(() -> {
                int index;
                if (stackFrames == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackFrames", "com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder", "lambda$addStackFrames$0"));
                }
                if (this.isObsolete()) {
                    return;
                }
                this.myStackFrames.addAll(stackFrames);
                this.addFrameListElements(stackFrames, last);
                if (toSelect != null && (index = this.myStackFrames.indexOf(toSelect)) != -1) {
                    XFramesView.this.mySelectedFrameIndex = index;
                }
                this.selectCurrentFrame();
                this.myNextFrameIndex += stackFrames.size();
                this.myAllFramesLoaded = last;
                if (last) {
                    if (XFramesView.this.myVisibleRect != null) {
                        XFramesView.this.myFramesList.scrollRectToVisible(XFramesView.this.myVisibleRect);
                    }
                    this.myRunning = false;
                    XFramesView.this.myListenersEnabled = true;
                }
            });
        }

        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder", "errorOccurred"));
            }
            if (this.isObsolete()) {
                return;
            }
            XFramesView.this.myLaterInvocator.offer(() -> {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/frame/XFramesView$StackFramesListBuilder", "lambda$errorOccurred$1"));
                }
                if (this.isObsolete()) {
                    return;
                }
                if (this.myErrorMessage == null) {
                    this.myErrorMessage = errorMessage;
                    this.addFrameListElements(Collections.singletonList(errorMessage), true);
                    this.myRunning = false;
                    XFramesView.this.myListenersEnabled = true;
                }
            });
        }

        private void addFrameListElements(List<?> values, boolean last) {
            if (this.myExecutionStack != null && this.myExecutionStack == XFramesView.this.mySelectedStack) {
                boolean loadingPresent;
                DefaultListModel model = XFramesView.this.myFramesList.getModel();
                int insertIndex = model.size();
                boolean bl = loadingPresent = !model.isEmpty() && model.getElementAt(model.getSize() - 1) == null;
                if (loadingPresent) {
                    --insertIndex;
                }
                for (Object value : values) {
                    model.add(insertIndex++, value);
                }
                if (last) {
                    if (loadingPresent) {
                        model.removeElementAt(model.getSize() - 1);
                    }
                } else if (!loadingPresent) {
                    model.addElement(null);
                }
                XFramesView.this.myFramesList.repaint();
            }
        }

        public boolean isObsolete() {
            return !this.myRunning;
        }

        public void dispose() {
            this.myRunning = false;
            this.myExecutionStack = null;
        }

        public boolean start() {
            if (this.myExecutionStack == null || this.myErrorMessage != null) {
                return false;
            }
            this.myRunning = true;
            this.myExecutionStack.computeStackFrames(this.myNextFrameIndex, (XExecutionStack.XStackFrameContainer)this);
            return true;
        }

        public void stop() {
            this.myRunning = false;
        }

        private void selectCurrentFrame() {
            if (XFramesView.this.mySelectedStack != null && XFramesView.this.myFramesList.getSelectedIndex() != XFramesView.this.mySelectedFrameIndex && XFramesView.this.myFramesList.getElementCount() > XFramesView.this.mySelectedFrameIndex && XFramesView.this.myFramesList.getModel().get(XFramesView.this.mySelectedFrameIndex) != null) {
                XFramesView.this.myFramesList.setSelectedIndex(XFramesView.this.mySelectedFrameIndex);
                XFramesView.this.processFrameSelection(this.mySession, false);
                XFramesView.this.myListenersEnabled = true;
            }
        }

        public void initModel(DefaultListModel model) {
            model.removeAllElements();
            this.myStackFrames.forEach(model::addElement);
            if (this.myErrorMessage != null) {
                model.addElement(this.myErrorMessage);
            } else if (!this.myAllFramesLoaded) {
                model.addElement(null);
            }
            this.selectCurrentFrame();
        }
    }
}

