/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.jsonSchema.JsonSchemaMappingsConfigurationBase;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsonSchemaMappingsProjectConfiguration", storages={@Storage(file="$PROJECT_CONFIG_DIR$/jsonSchemas.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class JsonSchemaMappingsProjectConfiguration
extends JsonSchemaMappingsConfigurationBase {
    private Project myProject;
    @Transient
    private final Map<VirtualFile, JsonSchemaMappingsConfigurationBase.SchemaInfo> mySchemaFiles = new HashMap<VirtualFile, JsonSchemaMappingsConfigurationBase.SchemaInfo>();

    public static JsonSchemaMappingsProjectConfiguration getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "getInstance"));
        }
        return (JsonSchemaMappingsProjectConfiguration)ServiceManager.getService((Project)project2, JsonSchemaMappingsProjectConfiguration.class);
    }

    public JsonSchemaMappingsProjectConfiguration(Project project2) {
        this.myProject = project2;
    }

    public JsonSchemaMappingsProjectConfiguration() {
    }

    @Override
    public File convertToAbsoluteFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "convertToAbsoluteFile"));
        }
        return this.myProject.getBasePath() == null ? new File(path) : new File(this.myProject.getBasePath(), path);
    }

    public boolean isRegisteredSchemaFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "isRegisteredSchemaFile"));
        }
        return this.mySchemaFiles.containsKey(file2);
    }

    @Override
    public void setState(@NotNull Map<String, JsonSchemaMappingsConfigurationBase.SchemaInfo> state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "setState"));
        }
        super.setState(state);
        this.recalculateSchemaFiles();
    }

    @Override
    public void addSchema(@NotNull JsonSchemaMappingsConfigurationBase.SchemaInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "addSchema"));
        }
        super.addSchema(info);
        this.recalculateSchemaFiles();
    }

    @Override
    public void removeSchema(@NotNull JsonSchemaMappingsConfigurationBase.SchemaInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "removeSchema"));
        }
        super.removeSchema(info);
        this.recalculateSchemaFiles();
    }

    @Override
    public void loadState(JsonSchemaMappingsConfigurationBase state) {
        super.loadState(state);
        this.recalculateSchemaFiles();
    }

    private void recalculateSchemaFiles() {
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> FileTypeManagerEx.getInstanceEx().fireFileTypesChanged()), o -> !this.myProject.isDisposed());
        this.mySchemaFiles.clear();
        if (this.myProject == null || this.myProject.getBaseDir() == null) {
            return;
        }
        for (JsonSchemaMappingsConfigurationBase.SchemaInfo info : this.myState.values()) {
            VirtualFile schemaFile = info.getSchemaFile(this.myProject);
            if (schemaFile == null) continue;
            this.mySchemaFiles.put(schemaFile, info);
        }
    }

    @Nullable
    public JsonSchemaMappingsConfigurationBase.SchemaInfo getSchemaBySchemaFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/jsonSchema/JsonSchemaMappingsProjectConfiguration", "getSchemaBySchemaFile"));
        }
        return this.mySchemaFiles.get(file2);
    }
}

