/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.JsonSchemaFileType;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaPropertyProcessor;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonBySchemaDocumentationProvider
implements DocumentationProvider {
    @NotNull
    private final VirtualFile mySchemaFile;
    @NotNull
    private final JsonSchemaObject myRootSchema;

    public JsonBySchemaDocumentationProvider(@NotNull VirtualFile schemaFile, @NotNull JsonSchemaObject schema) {
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider", "<init>"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider", "<init>"));
        }
        this.mySchemaFile = schemaFile;
        this.myRootSchema = schema;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        JsonProperty jsonProperty;
        JsonProperty jsonProperty2 = jsonProperty = element instanceof JsonProperty ? (JsonProperty)element : (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class);
        if (jsonProperty != null) {
            if (JsonSchemaFileType.INSTANCE.equals(jsonProperty.getContainingFile().getFileType())) {
                JsonProperty description;
                JsonValue value = jsonProperty.getValue();
                if (value instanceof JsonObject && (description = ((JsonObject)value).findProperty("description")) != null && description.getValue() instanceof JsonStringLiteral) {
                    return StringUtil.unquoteString((String)description.getValue().getText());
                }
                return null;
            }
            final Ref result2 = Ref.create();
            final String propertyName = jsonProperty.getName();
            JsonSchemaWalker.findSchemasForCompletion(jsonProperty, new JsonSchemaWalker.CompletionSchemesConsumer(){

                @Override
                public void consume(boolean isName, @NotNull JsonSchemaObject schema, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                    if (schema == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "consume"));
                    }
                    if (schemaFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "consume"));
                    }
                    if (steps == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaDocumentationProvider$1", "consume"));
                    }
                    JsonSchemaPropertyProcessor.process(new JsonSchemaPropertyProcessor.PropertyProcessor(){

                        @Override
                        public boolean process(String name, JsonSchemaObject schema) {
                            if (propertyName.equals(name) && schema != null) {
                                result2.set((Object)schema.getDescription());
                                return false;
                            }
                            return true;
                        }
                    }, schema);
                }
            }, this.myRootSchema, this.mySchemaFile);
            return (String)result2.get();
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }
}

