/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.DataManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.SchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaPropertyProcessor;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonBySchemaObjectCompletionContributor
extends CompletionContributor {
    private static final String BUILTIN_USAGE_KEY = "json.schema.builtin.completion";
    private static final String SCHEMA_USAGE_KEY = "json.schema.schema.completion";
    private static final String USER_USAGE_KEY = "json.schema.user.completion";
    @NotNull
    private final SchemaType myType;
    @NotNull
    private final VirtualFile mySchemaFile;
    @NotNull
    private final JsonSchemaObject myRootSchema;

    public JsonBySchemaObjectCompletionContributor(@NotNull SchemaType type, @NotNull VirtualFile schemaFile, @NotNull JsonSchemaObject rootSchema) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "<init>"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "<init>"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "<init>"));
        }
        this.myType = type;
        this.mySchemaFile = schemaFile;
        this.myRootSchema = rootSchema;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "fillCompletionVariants"));
        }
        PsiElement position = parameters.getPosition();
        PsiFile containingFile = position.getContainingFile();
        if (containingFile == null) {
            return;
        }
        this.updateStat();
        new Worker(this.myRootSchema, this.mySchemaFile, position, (Consumer<LookupElement>)result2).work();
        result2.stopHere();
    }

    public static List<LookupElement> getCompletionVariants(@NotNull JsonSchemaObject schema, @NotNull PsiElement position, @NotNull VirtualFile schemaFile) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "getCompletionVariants"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "getCompletionVariants"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "getCompletionVariants"));
        }
        ArrayList<LookupElement> result2 = new ArrayList<LookupElement>();
        new Worker(schema, schemaFile, position, (Consumer<LookupElement>)((Consumer)element -> result2.add((LookupElement)element))).work();
        return result2;
    }

    private void updateStat() {
        if (SchemaType.schema.equals((Object)this.myType)) {
            UsageTrigger.trigger(SCHEMA_USAGE_KEY);
        } else if (SchemaType.embeddedSchema.equals((Object)this.myType)) {
            UsageTrigger.trigger(BUILTIN_USAGE_KEY);
        } else if (SchemaType.userSchema.equals((Object)this.myType)) {
            UsageTrigger.trigger(USER_USAGE_KEY);
        }
    }

    public static void insertPropertyWithEnum(InsertionContext context, Editor editor, String defaultValue, List<Object> values, JsonSchemaType type) {
        boolean isNumber = JsonSchemaType._integer.equals((Object)type) || JsonSchemaType._number.equals((Object)type);
        String start = isNumber ? ":" : ":\"";
        String end = isNumber ? "" : "\"";
        boolean hasValues = !ContainerUtil.isEmpty(values);
        boolean hasDefaultValue = !StringUtil.isEmpty((String)defaultValue);
        String stringToInsert = start + (hasDefaultValue ? defaultValue : "") + end;
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)start.length());
        if (hasDefaultValue) {
            SelectionModel model = editor.getSelectionModel();
            int caretStart = model.getSelectionStart();
            int newOffset = caretStart + defaultValue.length();
            model.setSelection(caretStart, newOffset);
            editor.getCaretModel().moveToOffset(newOffset);
        }
        JsonBySchemaObjectCompletionContributor.formatInsertedString(context, stringToInsert.length());
        if (hasValues) {
            AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
    }

    public static void formatInsertedString(@NotNull InsertionContext context, int offset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor", "formatInsertedString"));
        }
        Project project2 = context.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(context.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        codeStyleManager.reformatText(context.getFile(), context.getStartOffset(), context.getTailOffset() + offset);
    }

    private static class Worker {
        @NotNull
        private final JsonSchemaObject myRootSchema;
        @NotNull
        private final VirtualFile mySchemaFile;
        @NotNull
        private final PsiElement myPosition;
        @NotNull
        private final Consumer<LookupElement> myResultConsumer;
        private final boolean myInsideStringLiteral;
        private final List<LookupElement> myVariants;

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull VirtualFile schemaFile, @NotNull PsiElement position, @NotNull Consumer<LookupElement> resultConsumer) {
            if (rootSchema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "<init>"));
            }
            if (schemaFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "<init>"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "<init>"));
            }
            if (resultConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultConsumer", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "<init>"));
            }
            this.myRootSchema = rootSchema;
            this.mySchemaFile = schemaFile;
            this.myPosition = position;
            this.myResultConsumer = resultConsumer;
            this.myInsideStringLiteral = position.getParent() instanceof JsonStringLiteral;
            this.myVariants = new ArrayList<LookupElement>();
        }

        public void work() {
            JsonSchemaWalker.findSchemasForCompletion(this.myPosition, new JsonSchemaWalker.CompletionSchemesConsumer(){

                @Override
                public void consume(boolean isName, @NotNull JsonSchemaObject schema, @NotNull VirtualFile schemaFile, @NotNull List<JsonSchemaWalker.Step> steps) {
                    if (schema == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "consume"));
                    }
                    if (schemaFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "consume"));
                    }
                    if (steps == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "steps", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker$1", "consume"));
                    }
                    if (isName) {
                        PsiElement possibleParent = myPosition.getParent().getParent();
                        JsonProperty parent = possibleParent instanceof JsonProperty ? (JsonProperty)possibleParent : null;
                        final boolean hasValue = this.hasValuePart(parent);
                        final Set<String> properties = JsonPsiUtil.getOtherSiblingPropertyNames(parent);
                        JsonSchemaPropertyProcessor.process(new JsonSchemaPropertyProcessor.PropertyProcessor(){

                            @Override
                            public boolean process(String name, JsonSchemaObject schema) {
                                if (properties.contains(name)) {
                                    return true;
                                }
                                this.addPropertyVariant(name, schema, hasValue);
                                return true;
                            }
                        }, schema);
                    } else {
                        this.suggestValues(schema);
                    }
                }
            }, this.myRootSchema, this.mySchemaFile);
            for (LookupElement variant : this.myVariants) {
                this.myResultConsumer.consume((Object)variant);
            }
        }

        public boolean hasValuePart(@Nullable JsonProperty property) {
            return property != null && property.getValue() != null;
        }

        private void suggestValues(JsonSchemaObject schema) {
            this.suggestValuesForSchemaVariants(schema.getAnyOf());
            this.suggestValuesForSchemaVariants(schema.getOneOf());
            this.suggestValuesForSchemaVariants(schema.getAllOf());
            if (schema.getEnum() != null) {
                for (Object o : schema.getEnum()) {
                    this.addValueVariant(o.toString(), null);
                }
            } else {
                JsonSchemaType type = schema.getType();
                if (JsonSchemaType._boolean.equals((Object)type)) {
                    this.addPossibleBooleanValue(type);
                    List<JsonSchemaType> variants = schema.getTypeVariants();
                    if (variants != null) {
                        for (JsonSchemaType variant : variants) {
                            this.addPossibleBooleanValue(variant);
                        }
                    }
                } else if (JsonSchemaType._string.equals((Object)type)) {
                    this.addPossibleStringValue(schema);
                }
            }
        }

        private void addPossibleStringValue(JsonSchemaObject schema) {
            String defaultValueString;
            Object defaultValue = schema.getDefault();
            String string = defaultValueString = defaultValue == null ? null : defaultValue.toString();
            if (!StringUtil.isEmpty((String)defaultValueString)) {
                String quotedValue = defaultValueString;
                if (!StringUtil.isQuotedString((String)quotedValue)) {
                    quotedValue = StringUtil.wrapWithDoubleQuote((String)quotedValue);
                }
                this.addValueVariant(quotedValue, null);
            }
        }

        private void suggestValuesForSchemaVariants(List<JsonSchemaObject> list) {
            if (list != null && list.size() > 0) {
                for (JsonSchemaObject schemaObject : list) {
                    this.suggestValues(schemaObject);
                }
            }
        }

        private void addPossibleBooleanValue(JsonSchemaType type) {
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.addValueVariant("true", null);
                this.addValueVariant("false", null);
            }
        }

        private void addValueVariant(@NotNull String key2, @Nullable String description) {
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "addValueVariant"));
            }
            LookupElementBuilder builder = LookupElementBuilder.create((String)(this.myInsideStringLiteral ? StringUtil.unquoteString((String)key2) : key2));
            if (description != null) {
                builder = builder.withTypeText(description);
            }
            this.myVariants.add((LookupElement)builder);
        }

        private void addPropertyVariant(@NotNull String key2, @NotNull JsonSchemaObject jsonSchemaObject, boolean hasValue) {
            String typeText;
            if (key2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "addPropertyVariant"));
            }
            if (jsonSchemaObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonSchemaObject", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "addPropertyVariant"));
            }
            String description = jsonSchemaObject.getDescription();
            String title = jsonSchemaObject.getTitle();
            key2 = this.myInsideStringLiteral ? key2 : StringUtil.wrapWithDoubleQuote((String)key2);
            LookupElementBuilder builder = LookupElementBuilder.create((String)key2);
            String string = typeText = StringUtil.isEmpty((String)title) ? description : title;
            if (!StringUtil.isEmpty((String)typeText)) {
                builder = builder.withTypeText(typeText, true);
            }
            JsonSchemaType type = jsonSchemaObject.getType();
            List<Object> values = jsonSchemaObject.getEnum();
            if (type != null || !ContainerUtil.isEmpty(values)) {
                builder = builder.withInsertHandler(this.createPropertyInsertHandler(jsonSchemaObject, hasValue));
            } else if (!hasValue) {
                builder = builder.withInsertHandler(this.createDefaultPropertyInsertHandler(hasValue));
            }
            this.myVariants.add((LookupElement)builder);
        }

        private InsertHandler<LookupElement> createDefaultPropertyInsertHandler(final boolean hasValue) {
            return new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    ApplicationManager.getApplication().assertWriteAccessAllowed();
                    Editor editor = context.getEditor();
                    Project project2 = context.getProject();
                    if (this.handleInsideQuotesInsertion(context, editor, hasValue)) {
                        return;
                    }
                    String stringToInsert = ": 1";
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)": 1", (boolean)false, (boolean)true, (int)2);
                    JsonBySchemaObjectCompletionContributor.formatInsertedString(context, ": 1".length());
                    int offset = editor.getCaretModel().getOffset();
                    context.getDocument().deleteString(offset, offset + 1);
                    PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                    AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
                }
            };
        }

        @NotNull
        private InsertHandler<LookupElement> createPropertyInsertHandler(@NotNull JsonSchemaObject jsonSchemaObject, final boolean hasValue) {
            Object defaultValue;
            if (jsonSchemaObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonSchemaObject", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "createPropertyInsertHandler"));
            }
            JsonSchemaType type = jsonSchemaObject.getType();
            final List<Object> values = jsonSchemaObject.getEnum();
            if (type == null && values != null && !values.isEmpty()) {
                type = Worker.detectType(values);
            }
            final String defaultValueAsString = (defaultValue = jsonSchemaObject.getDefault()) == null ? null : String.valueOf(defaultValue);
            final JsonSchemaType finalType = type;
            InsertHandler<LookupElement> insertHandler = new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    ApplicationManager.getApplication().assertWriteAccessAllowed();
                    Editor editor = context.getEditor();
                    Project project2 = context.getProject();
                    if (this.handleInsideQuotesInsertion(context, editor, hasValue)) {
                        return;
                    }
                    if (finalType != null) {
                        switch (finalType) {
                            case _object: {
                                String stringToInsert = ":{}";
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                                PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                                JsonBySchemaObjectCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorEnter");
                                handler2.execute(editor, editor.getCaretModel().getCurrentCaret(), DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
                                break;
                            }
                            case _boolean: {
                                String value = String.valueOf(Boolean.TRUE.toString().equals(defaultValueAsString));
                                String stringToInsert = ":" + value;
                                SelectionModel model = editor.getSelectionModel();
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)stringToInsert.length());
                                JsonBySchemaObjectCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                int start = editor.getSelectionModel().getSelectionStart();
                                model.setSelection(start - value.length(), start);
                                AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
                                break;
                            }
                            case _array: {
                                String stringToInsert = ":[]";
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                                JsonBySchemaObjectCompletionContributor.formatInsertedString(context, stringToInsert.length());
                                break;
                            }
                            case _string: 
                            case _integer: {
                                JsonBySchemaObjectCompletionContributor.insertPropertyWithEnum(context, editor, defaultValueAsString, values, finalType);
                                break;
                            }
                        }
                    } else {
                        JsonBySchemaObjectCompletionContributor.insertPropertyWithEnum(context, editor, defaultValueAsString, values, finalType);
                    }
                }
            };
            if (insertHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonBySchemaObjectCompletionContributor$Worker", "createPropertyInsertHandler"));
            }
            return insertHandler;
        }

        private boolean handleInsideQuotesInsertion(InsertionContext context, Editor editor, boolean hasValue) {
            if (this.myInsideStringLiteral) {
                int endOffset;
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = context.getFile().findElementAt(offset);
                int tailOffset = context.getTailOffset();
                int guessEndOffset = tailOffset + 1;
                if (element != null && (endOffset = element.getTextRange().getEndOffset()) > tailOffset) {
                    context.getDocument().deleteString(tailOffset, endOffset - 1);
                }
                if (hasValue) {
                    return true;
                }
                editor.getCaretModel().moveToOffset(guessEndOffset);
            } else {
                editor.getCaretModel().moveToOffset(context.getTailOffset());
            }
            return false;
        }

        @Nullable
        private static JsonSchemaType detectType(List<Object> values) {
            JsonSchemaType type = null;
            for (Object value : values) {
                JsonSchemaType newType = null;
                if (value instanceof Integer) {
                    newType = JsonSchemaType._integer;
                }
                if (type != null && !type.equals((Object)newType)) {
                    return null;
                }
                type = newType;
            }
            return type;
        }
    }
}

