/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaFileType;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaExportedDefinitions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceEx;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaWalker {
    public static void findSchemasForAnnotation(@NotNull PsiElement element, @NotNull CompletionSchemesConsumer consumer, @NotNull JsonSchemaObject rootSchema, @NotNull VirtualFile schemaFile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForAnnotation"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForAnnotation"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForAnnotation"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForAnnotation"));
        }
        List<Step> position = JsonSchemaWalker.findPosition(element, false, true);
        if (position == null || position.isEmpty()) {
            return;
        }
        if (JsonSchemaFileType.INSTANCE.equals(element.getContainingFile().getFileType()) && position.get(0).getTransition() instanceof PropertyTransition && "definitions".equals(((PropertyTransition)position.get(0).getTransition()).getName())) {
            return;
        }
        JsonSchemaWalker.extractSchemaVariants(element.getProject(), consumer, schemaFile, rootSchema, false, position);
    }

    public static void findSchemasForCompletion(@NotNull PsiElement element, @NotNull CompletionSchemesConsumer consumer, @NotNull JsonSchemaObject rootSchema, @NotNull VirtualFile schemaFile) {
        boolean isName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForCompletion"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForCompletion"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForCompletion"));
        }
        if (schemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findSchemasForCompletion"));
        }
        PsiElement checkable = JsonSchemaWalker.goUpToCheckable(element);
        if (checkable == null) {
            return;
        }
        List<Step> position = JsonSchemaWalker.findPosition(checkable, isName, !(isName = JsonSchemaWalker.isName(checkable)));
        if (position == null || position.isEmpty()) {
            if (isName) {
                consumer.consume(true, rootSchema, schemaFile, Collections.emptyList());
            }
            return;
        }
        JsonSchemaWalker.extractSchemaVariants(element.getProject(), consumer, schemaFile, rootSchema, isName, position);
    }

    public static Pair<List<Step>, String> buildSteps(@NotNull String nameInSchema) {
        if (nameInSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameInSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "buildSteps"));
        }
        String[] chain = JsonSchemaExportedDefinitions.normalizeId(nameInSchema).replace("\\", "/").split("/");
        List steps = Arrays.stream(chain).filter(s -> !s.isEmpty()).map(item -> new Step(StateType._unknown, new PropertyTransition((String)item))).collect(Collectors.toList());
        return Pair.create(steps, (Object)chain[chain.length - 1]);
    }

    public static void extractSchemaVariants(@NotNull Project project2, @NotNull CompletionSchemesConsumer consumer, @NotNull VirtualFile rootSchemaFile, @NotNull JsonSchemaObject rootSchema, boolean isName, List<Step> position) {
        Trinity trinity;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        if (rootSchemaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchemaFile", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        HashSet<Trinity> control = new HashSet<Trinity>();
        JsonSchemaServiceEx serviceEx = JsonSchemaService.Impl.getEx(project2);
        ArrayDeque<Trinity<JsonSchemaObject, VirtualFile, List<Step>>> queue = new ArrayDeque<Trinity<JsonSchemaObject, VirtualFile, List<Step>>>();
        queue.add(Trinity.create((Object)rootSchema, (Object)rootSchemaFile, position));
        while (!queue.isEmpty() && control.add(trinity = (Trinity)queue.removeFirst())) {
            JsonSchemaObject object = (JsonSchemaObject)trinity.getFirst();
            VirtualFile schemaFile = (VirtualFile)trinity.getSecond();
            List path = (List)trinity.getThird();
            if (path.isEmpty()) {
                consumer.consume(isName, object, schemaFile, path);
                continue;
            }
            DefinitionsResolver definitionsResolver = new DefinitionsResolver(path);
            JsonSchemaWalker.extractSchemaVariants(definitionsResolver, object, path);
            if (definitionsResolver.isFound()) {
                List<JsonSchemaObject> list = JsonSchemaWalker.gatherSchemas(definitionsResolver.getSchemaObject());
                for (JsonSchemaObject jsonSchemaObject : list) {
                    if (jsonSchemaObject.getDefinitionAddress() == null) continue;
                    ArrayList<Step> steps = new ArrayList<Step>();
                    if (!isName) {
                        steps.add(new Step(StateType._value, null));
                    }
                    JsonSchemaWalker.visitSchemaByDefinitionAddress(serviceEx, queue, schemaFile, jsonSchemaObject.getDefinitionAddress(), steps);
                }
                consumer.consume(isName, definitionsResolver.getSchemaObject(), schemaFile, path);
                continue;
            }
            List<Pair<JsonSchemaObject, List<Step>>> variants = definitionsResolver.getVariants();
            for (Pair pair : variants) {
                if (((JsonSchemaObject)pair.getFirst()).getDefinitionAddress() == null) continue;
                JsonSchemaWalker.visitSchemaByDefinitionAddress(serviceEx, queue, schemaFile, ((JsonSchemaObject)pair.getFirst()).getDefinitionAddress(), (List)pair.getSecond());
            }
        }
    }

    private static void visitSchemaByDefinitionAddress(JsonSchemaServiceEx serviceEx, ArrayDeque<Trinity<JsonSchemaObject, VirtualFile, List<Step>>> queue, VirtualFile schemaFile, @NotNull String definitionAddress, List<Step> steps) {
        VirtualFile variantSchemaFile;
        if (definitionAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definitionAddress", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "visitSchemaByDefinitionAddress"));
        }
        JsonSchemaReader.SchemaUrlSplitter splitter = new JsonSchemaReader.SchemaUrlSplitter(definitionAddress);
        VirtualFile virtualFile = variantSchemaFile = splitter.isAbsolute() ? serviceEx.getSchemaFileById(splitter.getSchemaId(), schemaFile) : schemaFile;
        if (variantSchemaFile == null) {
            return;
        }
        serviceEx.visitSchemaObject(variantSchemaFile, (Processor<JsonSchemaObject>)((Processor)variantObject -> {
            List variantSteps = (List)JsonSchemaWalker.buildSteps(splitter.getRelativePath()).getFirst();
            variantSteps.addAll(steps);
            queue.add(Trinity.create((Object)variantObject, (Object)variantSchemaFile, (Object)variantSteps));
            return true;
        }));
    }

    private static void extractSchemaVariants(@NotNull DefinitionsResolver consumer, @NotNull JsonSchemaObject rootSchema, @NotNull List<Step> position) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        if (rootSchema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSchema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "extractSchemaVariants"));
        }
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        queue.add(Pair.create((Object)rootSchema, (Object)0));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            JsonSchemaObject schema = (JsonSchemaObject)pair.getFirst();
            Integer level = (Integer)pair.getSecond();
            if (position.size() <= level) {
                return;
            }
            Step step = position.get(level);
            if (step.getTransition() == null) {
                consumer.consumeResult(schema);
                continue;
            }
            if (step.getTransition() != null && !StateType._unknown.equals((Object)step.getType()) && !step.getTransition().possibleFromState(step.getType())) continue;
            Condition byTypeFilter = object -> JsonSchemaWalker.byStateType(step.getType(), object);
            List list = JsonSchemaWalker.gatherSchemas(schema);
            list = ContainerUtil.filter(list, (Condition)byTypeFilter);
            Consumer reporter = object -> {
                if (position == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "lambda$extractSchemaVariants$4"));
                }
                if (consumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "lambda$extractSchemaVariants$4"));
                }
                if (level + 1 >= position.size()) {
                    consumer.consumeResult((JsonSchemaObject)object);
                } else {
                    consumer.consumeSmallStep((JsonSchemaObject)object, level);
                    queue.add(Pair.create((Object)object, (Object)(level + 1)));
                }
            };
            TransitionResultConsumer transitionResultConsumer = new TransitionResultConsumer();
            for (JsonSchemaObject object2 : list) {
                if (schema.getAllOf() == null) {
                    transitionResultConsumer = new TransitionResultConsumer();
                }
                step.getTransition().step(object2, transitionResultConsumer);
                if (transitionResultConsumer.isNothing() || transitionResultConsumer.getSchema() == null) continue;
                reporter.consume((Object)transitionResultConsumer.getSchema());
            }
        }
    }

    private static List<JsonSchemaObject> gatherSchemas(JsonSchemaObject schema) {
        ArrayList<JsonSchemaObject> list = new ArrayList<JsonSchemaObject>();
        list.add(schema);
        if (schema.getAllOf() != null) {
            list.addAll(schema.getAllOf());
        } else {
            if (schema.getAnyOf() != null) {
                list.addAll(schema.getAnyOf());
            }
            if (schema.getOneOf() != null) {
                list.addAll(schema.getOneOf());
            }
        }
        return list;
    }

    private static boolean byStateType(@NotNull StateType type, @NotNull JsonSchemaObject schema) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "byStateType"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "byStateType"));
        }
        if (StateType._unknown.equals((Object)type)) {
            return true;
        }
        JsonSchemaType requiredType = type.getCorrespondingJsonType();
        if (requiredType == null) {
            return true;
        }
        if (schema.getType() != null) {
            return requiredType.equals((Object)schema.getType());
        }
        if (schema.getTypeVariants() != null) {
            for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                if (!requiredType.equals((Object)schemaType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isName(PsiElement checkable) {
        PsiElement parent = checkable.getParent();
        if (parent instanceof JsonObject) {
            return true;
        }
        if (parent instanceof JsonProperty) {
            return PsiTreeUtil.isAncestor((PsiElement)((JsonProperty)parent).getNameElement(), (PsiElement)checkable, (boolean)false);
        }
        return false;
    }

    @Nullable
    private static PsiElement goUpToCheckable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "goUpToCheckable"));
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (!(current instanceof JsonValue) && !(current instanceof JsonProperty)) continue;
            return current;
        }
        return null;
    }

    public static List<Step> findPosition(@NotNull PsiElement element, boolean isName, boolean forceLastTransition) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker", "findPosition"));
        }
        ArrayList<Step> steps = new ArrayList<Step>();
        if (!isName) {
            steps.add(new Step(StateType._value, null));
        }
        PsiElement current = element;
        while (!(current instanceof PsiFile)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof JsonArray) {
                JsonArray array = (JsonArray)current;
                List<JsonValue> list = array.getValueList();
                int idx = -1;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    JsonValue value = list.get(i2);
                    if (!value.equals(position)) continue;
                    idx = i2;
                    break;
                }
                steps.add(new Step(StateType._array, new ArrayTransition(idx)));
                continue;
            }
            if (current instanceof JsonProperty) {
                propertyName = ((JsonProperty)current).getName();
                if (!((current = current.getParent()) instanceof JsonObject)) {
                    return null;
                }
                if (position == element && !forceLastTransition) continue;
                steps.add(new Step(StateType._object, new PropertyTransition(propertyName)));
                continue;
            }
            if (current instanceof JsonObject && position instanceof JsonProperty) {
                if (position == element && !forceLastTransition) continue;
                propertyName = ((JsonProperty)position).getName();
                steps.add(new Step(StateType._object, new PropertyTransition(propertyName)));
                continue;
            }
            if (current instanceof PsiFile) break;
            return null;
        }
        Collections.reverse(steps);
        return steps;
    }

    private static class TransitionResultConsumer {
        @Nullable
        private JsonSchemaObject mySchema;
        private boolean myAny;
        private boolean myNothing = true;

        @Nullable
        public JsonSchemaObject getSchema() {
            return this.mySchema;
        }

        public void setSchema(@Nullable JsonSchemaObject schema) {
            this.mySchema = schema;
            this.myNothing = schema == null;
        }

        public boolean isAny() {
            return this.myAny;
        }

        public void anything() {
            this.myAny = true;
            this.myNothing = false;
        }

        public boolean isNothing() {
            return this.myNothing;
        }

        public void nothing() {
            this.myNothing = true;
            this.myAny = false;
        }
    }

    public static enum StateType {
        _object(JsonSchemaType._object),
        _array(JsonSchemaType._array),
        _value(null),
        _unknown(null);

        @Nullable
        private final JsonSchemaType myCorrespondingJsonType;

        private StateType(JsonSchemaType correspondingJsonType) {
            this.myCorrespondingJsonType = correspondingJsonType;
        }

        @Nullable
        public JsonSchemaType getCorrespondingJsonType() {
            return this.myCorrespondingJsonType;
        }
    }

    private static interface Transition {
        public boolean possibleFromState(@NotNull StateType var1);

        public void step(@NotNull JsonSchemaObject var1, @NotNull TransitionResultConsumer var2);
    }

    private static class ArrayTransition
    implements Transition {
        private final int myIdx;

        private ArrayTransition(int idx) {
            this.myIdx = idx;
        }

        @Override
        public boolean possibleFromState(@NotNull StateType stateType) {
            if (stateType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateType", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$ArrayTransition", "possibleFromState"));
            }
            return StateType._array.equals((Object)stateType);
        }

        @Override
        public void step(@NotNull JsonSchemaObject parent, @NotNull TransitionResultConsumer resultConsumer) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$ArrayTransition", "step"));
            }
            if (resultConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultConsumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$ArrayTransition", "step"));
            }
            if (parent.getItemsSchema() != null) {
                resultConsumer.setSchema(parent.getItemsSchema());
            } else if (parent.getItemsSchemaList() != null) {
                List<JsonSchemaObject> list = parent.getItemsSchemaList();
                if (this.myIdx >= 0 && this.myIdx < list.size()) {
                    resultConsumer.setSchema(list.get(this.myIdx));
                } else if (parent.getAdditionalItemsSchema() != null) {
                    resultConsumer.setSchema(parent.getAdditionalItemsSchema());
                } else if (!Boolean.FALSE.equals(parent.getAdditionalItemsAllowed())) {
                    resultConsumer.anything();
                } else {
                    resultConsumer.nothing();
                }
            }
        }
    }

    public static class PropertyTransition
    implements Transition {
        @NotNull
        private final String myName;

        protected PropertyTransition(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$PropertyTransition", "<init>"));
            }
            this.myName = name;
        }

        @Override
        public boolean possibleFromState(@NotNull StateType stateType) {
            if (stateType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateType", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$PropertyTransition", "possibleFromState"));
            }
            return StateType._object.equals((Object)stateType);
        }

        @Override
        public void step(@NotNull JsonSchemaObject parent, @NotNull TransitionResultConsumer resultConsumer) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$PropertyTransition", "step"));
            }
            if (resultConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultConsumer", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$PropertyTransition", "step"));
            }
            if ("definitions".equals(this.myName) && parent.getDefinitions() != null) {
                SmartPsiElementPointer<JsonObject> pointer = parent.getDefinitionsPointer();
                JsonSchemaObject object = new JsonSchemaObject(pointer);
                object.setProperties(parent.getDefinitions());
                resultConsumer.setSchema(object);
                return;
            }
            JsonSchemaObject child = parent.getProperties().get(this.myName);
            if (child != null) {
                resultConsumer.setSchema(child);
            } else {
                JsonSchemaObject schema = parent.getMatchingPatternPropertySchema(this.myName);
                if (schema != null) {
                    resultConsumer.setSchema(schema);
                    return;
                }
                if (parent.getAdditionalPropertiesSchema() != null) {
                    resultConsumer.setSchema(parent.getAdditionalPropertiesSchema());
                } else if (!Boolean.FALSE.equals(parent.getAdditionalPropertiesAllowed())) {
                    resultConsumer.anything();
                } else {
                    resultConsumer.nothing();
                }
            }
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$PropertyTransition", "getName"));
            }
            return string;
        }
    }

    public static class Step {
        private final StateType myType;
        @Nullable
        private final Transition myTransition;

        public Step(StateType type, @Nullable Transition transition) {
            this.myType = type;
            this.myTransition = transition;
        }

        public StateType getType() {
            return this.myType;
        }

        @Nullable
        public Transition getTransition() {
            return this.myTransition;
        }
    }

    protected static class DefinitionsResolver {
        @NotNull
        private final List<Step> myPosition;
        final List<Pair<JsonSchemaObject, List<Step>>> myVariants;
        private JsonSchemaObject mySchemaObject;

        public DefinitionsResolver(@NotNull List<Step> position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$DefinitionsResolver", "<init>"));
            }
            this.myPosition = position;
            this.myVariants = new ArrayList<Pair<JsonSchemaObject, List<Step>>>();
        }

        public void consumeResult(@NotNull JsonSchemaObject schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$DefinitionsResolver", "consumeResult"));
            }
            this.mySchemaObject = schema;
        }

        public void consumeSmallStep(@NotNull JsonSchemaObject schema, int idx) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/impl/JsonSchemaWalker$DefinitionsResolver", "consumeSmallStep"));
            }
            List list = JsonSchemaWalker.gatherSchemas(schema);
            for (JsonSchemaObject object : list) {
                if (StringUtil.isEmptyOrSpaces((String)object.getDefinitionAddress())) continue;
                this.myVariants.add((Pair<JsonSchemaObject, List<Step>>)Pair.create((Object)object, this.myPosition.subList(idx + 1, this.myPosition.size())));
            }
        }

        public boolean isFound() {
            return this.mySchemaObject != null;
        }

        public JsonSchemaObject getSchemaObject() {
            return this.mySchemaObject;
        }

        public List<Pair<JsonSchemaObject, List<Step>>> getVariants() {
            return this.myVariants;
        }
    }

    public static interface CompletionSchemesConsumer {
        public void consume(boolean var1, @NotNull JsonSchemaObject var2, @NotNull VirtualFile var3, @NotNull List<Step> var4);
    }
}

