/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OptionalGetWithoutIsPresentInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("optional.get.without.is.present.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/OptionalGetWithoutIsPresentInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("optional.get.without.is.present.problem.descriptor", aClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/OptionalGetWithoutIsPresentInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OptionalGetWithoutIsPresentVisitor();
    }

    private static class OptionalGetWithoutIsPresentVisitor
    extends BaseInspectionVisitor {
        private final Set<PsiMethodCallExpression> seen = new THashSet();

        private OptionalGetWithoutIsPresentVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (this.seen.contains(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!OptionalGetWithoutIsPresentVisitor.isOptionalGetMethodName(name)) {
                return;
            }
            final PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier == null) {
                return;
            }
            PsiType type = qualifier.getType();
            if (!TypeUtils.isOptional(type)) {
                return;
            }
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
            if (context instanceof PsiMethod) {
                context = ((PsiMethod)context).getBody();
            } else if (context instanceof PsiClassInitializer) {
                context = ((PsiClassInitializer)context).getBody();
            } else if (context instanceof PsiField) {
                context = ((PsiField)context).getInitializer();
            }
            if (context == null) {
                return;
            }
            StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(false, true, this.isOnTheFly());
            dfaRunner.analyzeMethod(context, new StandardInstructionVisitor(){

                @Override
                public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
                    PsiClass aClass;
                    PsiMethod targetMethod;
                    PsiMethodCallExpression methodCallExpression;
                    int length = instruction.getArgs().length;
                    if (length != 0) {
                        return super.visitMethodCall(instruction, runner, memState);
                    }
                    DfaValue qualifierValue = memState.peek();
                    DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
                    PsiCall callExpression = instruction.getCallExpression();
                    if (callExpression instanceof PsiMethodCallExpression && OptionalGetWithoutIsPresentVisitor.isCallOnSameQualifier(methodCallExpression = (PsiMethodCallExpression)callExpression, qualifierValue, qualifier) && (targetMethod = instruction.getTargetMethod()) != null && TypeUtils.isOptional(aClass = targetMethod.getContainingClass())) {
                        String methodName = targetMethod.getName();
                        if ("isPresent".equals(methodName)) {
                            memState.pop();
                            memState.push(runner.getFactory().getConstFactory().getFalse());
                        } else if (OptionalGetWithoutIsPresentVisitor.isOptionalGetMethodName(methodName)) {
                            seen.add(methodCallExpression);
                            this.registerMethodCallError(methodCallExpression, new Object[]{aClass});
                        }
                    }
                    return states;
                }
            });
        }

        private static boolean isCallOnSameQualifier(PsiMethodCallExpression methodCallExpression, DfaValue qualifierValue, PsiExpression qualifier) {
            if (qualifier instanceof PsiReferenceExpression && qualifierValue instanceof DfaVariableValue && ((DfaVariableValue)qualifierValue).getPsiVariable().equals(((PsiReferenceExpression)qualifier).resolve())) {
                return true;
            }
            PsiReferenceExpression referenceExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = referenceExpression.getQualifierExpression();
            return qualifierExpression != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)qualifierExpression);
        }

        private static boolean isOptionalGetMethodName(String name) {
            return "get".equals(name) || "getAsDouble".equals(name) || "getAsInt".equals(name) || "getAsLong".equals(name);
        }
    }
}

