/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.RefactoringQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.JavaRefactoringActionHandlerFactory;
import com.intellij.refactoring.RefactoringActionHandler;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.RefactoringInspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class EncapsulateVariableFix
extends RefactoringInspectionGadgetsFix
implements RefactoringQuickFix {
    private final String fieldName;

    public EncapsulateVariableFix(String fieldName) {
        this.fieldName = fieldName;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("encapsulate.variable.quickfix", this.fieldName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/EncapsulateVariableFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Encapsulate field" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/EncapsulateVariableFix", "getFamilyName"));
        }
        return "Encapsulate field";
    }

    public PsiElement getElementToRefactor(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)parent;
            PsiElement target = referenceExpression.resolve();
            assert (target instanceof PsiField);
            return target;
        }
        return super.getElementToRefactor(element);
    }

    @NotNull
    public RefactoringActionHandler getHandler() {
        RefactoringActionHandler refactoringActionHandler = JavaRefactoringActionHandlerFactory.getInstance().createEncapsulateFieldsHandler();
        if (refactoringActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/EncapsulateVariableFix", "getHandler"));
        }
        return refactoringActionHandler;
    }
}

