/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JUnit4MethodNamingConventionInspectionBase
extends ConventionInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("junit4.method.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/JUnit4MethodNamingConventionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("junit4.method.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z_\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JUnit4MethodNamingConventionVisitor();
    }

    private class JUnit4MethodNamingConventionVisitor
    extends BaseInspectionVisitor {
        private JUnit4MethodNamingConventionVisitor() {
        }

        public void visitMethod(PsiMethod method2) {
            super.visitMethod(method2);
            if (!TestUtils.isAnnotatedTestMethod(method2)) {
                return;
            }
            PsiIdentifier nameIdentifier = method2.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            String name = method2.getName();
            if (JUnit4MethodNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            if (!this.isOnTheFly() && MethodUtils.hasSuper(method2)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method2)) {
                return;
            }
            this.registerMethodError(method2, name);
        }
    }
}

