/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.testIntegration.TestFramework;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class InstanceMethodNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instance.method.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/InstanceMethodNamingConventionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("instance.method.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    private static boolean isTestNGTestMethod(PsiMethod method2) {
        TestFramework[] testFrameworks;
        for (TestFramework framework : testFrameworks = (TestFramework[])Extensions.getExtensions((ExtensionPointName)TestFramework.EXTENSION_NAME)) {
            if (!"TestNG".equals(framework.getName())) continue;
            return framework.isTestMethod((PsiElement)method2);
        }
        return false;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method2) {
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/naming/InstanceMethodNamingConventionInspectionBase$NamingConventionsVisitor", "visitMethod"));
            }
            super.visitMethod(method2);
            if (method2.isConstructor() || method2.hasModifierProperty("static")) {
                return;
            }
            if (method2.hasModifierProperty("native") && BaseInspection.isInspectionEnabled("NativeMethodNamingConvention", (PsiElement)method2)) {
                return;
            }
            PsiIdentifier nameIdentifier = method2.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            if (TestUtils.isRunnable(method2)) {
                if (TestUtils.isAnnotatedTestMethod(method2) && BaseInspection.isInspectionEnabled("JUnit4MethodNamingConvention", (PsiElement)method2)) {
                    return;
                }
                if (TestUtils.isJUnit3TestMethod(method2) && BaseInspection.isInspectionEnabled("JUnit3MethodNamingConvention", (PsiElement)method2)) {
                    return;
                }
            }
            if (InstanceMethodNamingConventionInspectionBase.isTestNGTestMethod(method2) && BaseInspection.isInspectionEnabled("TestNGMethodNamingConvention", (PsiElement)method2)) {
                return;
            }
            String name = method2.getName();
            if (InstanceMethodNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            if (!this.isOnTheFly() && MethodUtils.hasSuper(method2)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method2)) {
                return;
            }
            this.registerMethodError(method2, name);
        }
    }
}

