/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.dependency.DependencyUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisjointPackageInspection
extends BaseGlobalInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("disjoint.package.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/packaging/DisjointPackageInspection", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/packaging/DisjointPackageInspection", "checkElement"));
        }
        if (analysisScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analysisScope", "com/siyeh/ig/packaging/DisjointPackageInspection", "checkElement"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionManager", "com/siyeh/ig/packaging/DisjointPackageInspection", "checkElement"));
        }
        if (globalInspectionContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalInspectionContext", "com/siyeh/ig/packaging/DisjointPackageInspection", "checkElement"));
        }
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        RefPackage refPackage = (RefPackage)refEntity;
        List children2 = refPackage.getChildren();
        HashSet<RefClass> childClasses = new HashSet<RefClass>();
        for (RefEntity child : children2) {
            PsiClass psiClass;
            if (!(child instanceof RefClass) || ClassUtils.isInnerClass(psiClass = ((RefClass)child).getElement())) continue;
            childClasses.add((RefClass)child);
        }
        if (childClasses.isEmpty()) {
            return null;
        }
        Set<Set<RefClass>> components = DisjointPackageInspection.createComponents(refPackage, childClasses);
        if (components.size() == 1) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("disjoint.package.problem.descriptor", refPackage.getQualifiedName(), components.size());
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    private static Set<Set<RefClass>> createComponents(RefPackage aPackage, Set<RefClass> classes) {
        HashSet<RefClass> allClasses = new HashSet<RefClass>(classes);
        HashSet<Set<RefClass>> out = new HashSet<Set<RefClass>>();
        while (!allClasses.isEmpty()) {
            RefClass seed = (RefClass)allClasses.iterator().next();
            allClasses.remove(seed);
            HashSet<RefClass> currentComponent = new HashSet<RefClass>();
            currentComponent.add(seed);
            ArrayList<RefClass> pendingClasses = new ArrayList<RefClass>();
            pendingClasses.add(seed);
            while (!pendingClasses.isEmpty()) {
                RefClass classToProcess = (RefClass)pendingClasses.remove(0);
                Set<RefClass> relatedClasses = DisjointPackageInspection.getRelatedClasses(aPackage, classToProcess);
                for (RefClass relatedClass : relatedClasses) {
                    if (currentComponent.contains(relatedClass) || pendingClasses.contains(relatedClass)) continue;
                    currentComponent.add(relatedClass);
                    pendingClasses.add(relatedClass);
                    allClasses.remove(relatedClass);
                }
            }
            out.add(currentComponent);
        }
        return out;
    }

    private static Set<RefClass> getRelatedClasses(RefPackage aPackage, RefClass classToProcess) {
        HashSet<RefClass> out = new HashSet<RefClass>();
        Set<RefClass> dependencies = DependencyUtils.calculateDependenciesForClass(classToProcess);
        for (RefClass dependency : dependencies) {
            if (!DisjointPackageInspection.packageContainsClass(aPackage, dependency)) continue;
            out.add(dependency);
        }
        Set<RefClass> dependents = DependencyUtils.calculateDependentsForClass(classToProcess);
        for (RefClass dependent : dependents) {
            if (!DisjointPackageInspection.packageContainsClass(aPackage, dependent)) continue;
            out.add(dependent);
        }
        return out;
    }

    private static boolean packageContainsClass(RefPackage aPackage, RefClass aClass) {
        return aPackage.equals(RefJavaUtil.getPackage((RefEntity)aClass));
    }
}

