/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegation(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/BoolUtils", "isNegation"));
        }
        if (!(expression instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExp = (PsiPrefixExpression)expression;
        IElementType tokenType = prefixExp.getOperationTokenType();
        return JavaTokenType.EXCL.equals(tokenType);
    }

    public static boolean isNegated(PsiExpression exp) {
        PsiExpression ancestor = exp;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        return parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent);
    }

    @Nullable
    public static PsiExpression getNegated(PsiExpression expression) {
        if (!(expression instanceof PsiPrefixExpression)) {
            return null;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        if (!JavaTokenType.EXCL.equals(tokenType)) {
            return null;
        }
        PsiExpression operand = prefixExpression.getOperand();
        return ParenthesesUtils.stripParentheses(operand);
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression condition) {
        String string = BoolUtils.getNegatedExpressionText(condition, 17);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
        }
        return string;
    }

    @NotNull
    public static String getNegatedExpressionText(@Nullable PsiExpression expression, int precedence) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
            }
            return "";
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            boolean needParenthesis = ParenthesesUtils.getPrecedence((PsiExpression)conditionalExpression) >= precedence;
            String text = conditionalExpression.getCondition().getText() + '?' + BoolUtils.getNegatedExpressionText(conditionalExpression.getThenExpression()) + ':' + BoolUtils.getNegatedExpressionText(conditionalExpression.getElseExpression());
            String string = needParenthesis ? "(" + text + ")" : text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
            }
            return string;
        }
        if (BoolUtils.isNegation(expression)) {
            PsiExpression negated = BoolUtils.getNegated(expression);
            if (negated == null) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
                }
                return "";
            }
            String string = ParenthesesUtils.getText(negated, precedence);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
            }
            return string;
        }
        if (ComparisonUtils.isComparison(expression)) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            String negatedComparison = ComparisonUtils.getNegatedComparison(polyadicExpression.getOperationTokenType());
            StringBuilder result2 = new StringBuilder();
            PsiExpression[] operands = polyadicExpression.getOperands();
            boolean isEven = (operands.length & 1) != 1;
            int length = operands.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiExpression operand = operands[i2];
                if (TypeUtils.hasFloatingPointType(operand)) {
                    String string = "!(" + polyadicExpression.getText() + ')';
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
                    }
                    return string;
                }
                if (i2 > 0) {
                    if (isEven && (i2 & 1) != 1) {
                        PsiJavaToken token = polyadicExpression.getTokenBeforeOperand(operand);
                        if (token != null) {
                            result2.append(token.getText());
                        }
                    } else {
                        result2.append(negatedComparison);
                    }
                }
                result2.append(operand.getText());
            }
            String string = result2.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
            }
            return string;
        }
        String string = '!' + ParenthesesUtils.getText(expression, 3);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/BoolUtils", "getNegatedExpressionText"));
        }
        return string;
    }

    @Nullable
    public static PsiExpression findNegation(PsiExpression expression) {
        PsiPrefixExpression prefixAncestor;
        PsiExpression ancestor = expression;
        PsiElement parent = ancestor.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            ancestor = (PsiExpression)parent;
            parent = ancestor.getParent();
        }
        if (parent instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals((prefixAncestor = (PsiPrefixExpression)parent).getOperationTokenType())) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isBooleanLiteral(PsiExpression expression) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
        String text = literalExpression.getText();
        return "true".equals(text) || "false".equals(text);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isTrue(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return false;
        }
        return "true".equals(expression.getText());
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isFalse(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) == null) {
            return false;
        }
        return "false".equals(expression.getText());
    }
}

