/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtils {
    private static final Set<String> s_genericExceptionTypes = new HashSet<String>(4);

    private ExceptionUtils() {
    }

    @NotNull
    public static Set<PsiClassType> calculateExceptionsThrown(@Nullable PsiElement element) {
        Set<PsiClassType> set2 = ExceptionUtils.calculateExceptionsThrown(element, new LinkedHashSet<PsiClassType>(5));
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ExceptionUtils", "calculateExceptionsThrown"));
        }
        return set2;
    }

    @NotNull
    public static Set<PsiClassType> calculateExceptionsThrown(@Nullable PsiElement element, @NotNull Set<PsiClassType> out) {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/siyeh/ig/psiutils/ExceptionUtils", "calculateExceptionsThrown"));
        }
        if (element == null) {
            Set<PsiClassType> set2 = out;
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ExceptionUtils", "calculateExceptionsThrown"));
            }
            return set2;
        }
        if (element instanceof PsiResourceList) {
            PsiResourceList resourceList = (PsiResourceList)element;
            for (PsiResourceListElement resource : resourceList) {
                out.addAll(ExceptionUtil.getCloserExceptions(resource));
            }
        }
        ExceptionsThrownVisitor visitor = new ExceptionsThrownVisitor(out);
        element.accept((PsiElementVisitor)visitor);
        Set<PsiClassType> set3 = out;
        if (set3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ExceptionUtils", "calculateExceptionsThrown"));
        }
        return set3;
    }

    public static boolean isGenericExceptionClass(@Nullable PsiType exceptionType) {
        if (!(exceptionType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)exceptionType;
        String className = classType.getCanonicalText();
        return s_genericExceptionTypes.contains(className);
    }

    public static boolean isThrowableRethrown(PsiParameter throwable, PsiCodeBlock catchBlock) {
        PsiStatement lastStatement = ControlFlowUtils.getLastStatementInBlock(catchBlock);
        if (!(lastStatement instanceof PsiThrowStatement)) {
            return false;
        }
        PsiThrowStatement throwStatement = (PsiThrowStatement)lastStatement;
        PsiExpression expression = throwStatement.getException();
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement element = referenceExpression.resolve();
        return throwable.equals(element);
    }

    static boolean statementThrowsException(PsiStatement statement2) {
        if (statement2 == null) {
            return false;
        }
        if (statement2 instanceof PsiBreakStatement || statement2 instanceof PsiContinueStatement || statement2 instanceof PsiAssertStatement || statement2 instanceof PsiReturnStatement || statement2 instanceof PsiExpressionStatement || statement2 instanceof PsiExpressionListStatement || statement2 instanceof PsiForeachStatement || statement2 instanceof PsiDeclarationStatement || statement2 instanceof PsiEmptyStatement || statement2 instanceof PsiSwitchLabelStatement) {
            return false;
        }
        if (statement2 instanceof PsiThrowStatement) {
            return true;
        }
        if (statement2 instanceof PsiForStatement) {
            return ExceptionUtils.forStatementThrowsException((PsiForStatement)statement2);
        }
        if (statement2 instanceof PsiWhileStatement) {
            return ExceptionUtils.whileStatementThrowsException((PsiWhileStatement)statement2);
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            return ExceptionUtils.doWhileThrowsException((PsiDoWhileStatement)statement2);
        }
        if (statement2 instanceof PsiSynchronizedStatement) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)statement2;
            PsiCodeBlock body = synchronizedStatement.getBody();
            return ExceptionUtils.blockThrowsException(body);
        }
        if (statement2 instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)statement2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            return ExceptionUtils.blockThrowsException(codeBlock);
        }
        if (statement2 instanceof PsiLabeledStatement) {
            PsiLabeledStatement labeledStatement = (PsiLabeledStatement)statement2;
            PsiStatement statementLabeled = labeledStatement.getStatement();
            return ExceptionUtils.statementThrowsException(statementLabeled);
        }
        if (statement2 instanceof PsiIfStatement) {
            return ExceptionUtils.ifStatementThrowsException((PsiIfStatement)statement2);
        }
        if (statement2 instanceof PsiTryStatement) {
            return ExceptionUtils.tryStatementThrowsException((PsiTryStatement)statement2);
        }
        if (statement2 instanceof PsiSwitchStatement) {
            return false;
        }
        return false;
    }

    static boolean blockThrowsException(@Nullable PsiCodeBlock block) {
        PsiStatement[] statements;
        if (block == null) {
            return false;
        }
        for (PsiStatement statement2 : statements = block.getStatements()) {
            if (!ExceptionUtils.statementThrowsException(statement2)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryStatementThrowsException(PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock;
        PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
        if (catchBlocks.length == 0 && ExceptionUtils.blockThrowsException(tryBlock = tryStatement.getTryBlock())) {
            return true;
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        return ExceptionUtils.blockThrowsException(finallyBlock);
    }

    private static boolean ifStatementThrowsException(PsiIfStatement ifStatement) {
        return ExceptionUtils.statementThrowsException(ifStatement.getThenBranch()) && ExceptionUtils.statementThrowsException(ifStatement.getElseBranch());
    }

    private static boolean doWhileThrowsException(PsiDoWhileStatement doWhileStatement) {
        return ExceptionUtils.statementThrowsException(doWhileStatement.getBody());
    }

    private static boolean whileStatementThrowsException(PsiWhileStatement whileStatement) {
        PsiStatement body;
        PsiExpression condition = whileStatement.getCondition();
        return BoolUtils.isTrue(condition) && ExceptionUtils.statementThrowsException(body = whileStatement.getBody());
    }

    private static boolean forStatementThrowsException(PsiForStatement forStatement) {
        PsiStatement initialization = forStatement.getInitialization();
        if (ExceptionUtils.statementThrowsException(initialization)) {
            return true;
        }
        PsiExpression test = forStatement.getCondition();
        if (BoolUtils.isTrue(test)) {
            PsiStatement body = forStatement.getBody();
            if (ExceptionUtils.statementThrowsException(body)) {
                return true;
            }
            PsiStatement update = forStatement.getUpdate();
            if (ExceptionUtils.statementThrowsException(update)) {
                return true;
            }
        }
        return false;
    }

    public static Set<PsiType> getExceptionTypesHandled(PsiTryStatement statement2) {
        HashSet<PsiType> out = new HashSet<PsiType>(5);
        for (PsiParameter parameter : statement2.getCatchBlockParameters()) {
            PsiType type = parameter.getType();
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                out.addAll(disjunctionType.getDisjunctions());
                continue;
            }
            out.add(type);
        }
        return out;
    }

    public static boolean isExceptionArgument(@NotNull PsiExpression expression) {
        PsiMethodCallExpression methodCallExpression;
        PsiType newExpressionType;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ExceptionUtils", "isExceptionArgument"));
        }
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiNewExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class});
        return newExpression != null ? InheritanceUtil.isInheritor((PsiType)(newExpressionType = newExpression.getType()), (String)"java.lang.Throwable") : RefactoringChangeUtil.isSuperOrThisMethodCall((PsiElement)(methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class})));
    }

    static {
        s_genericExceptionTypes.add("java.lang.Throwable");
        s_genericExceptionTypes.add("java.lang.Exception");
        s_genericExceptionTypes.add("java.lang.RuntimeException");
        s_genericExceptionTypes.add("java.lang.Error");
    }

    private static class ExceptionsThrownVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final Set<PsiClassType> m_exceptionsThrown;

        private ExceptionsThrownVisitor(Set<PsiClassType> thrownTypes) {
            this.m_exceptionsThrown = thrownTypes;
        }

        public void visitClass(PsiClass aClass) {
        }

        public void visitLambdaExpression(PsiLambdaExpression expression) {
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            JavaResolveResult resolveResult = callExpression.resolveMethodGenerics();
            PsiElement target = resolveResult.getElement();
            if (!(target instanceof PsiMethod)) {
                return;
            }
            PsiClassType[] referencedTypes = ((PsiMethod)target).getThrowsList().getReferencedTypes();
            this.m_exceptionsThrown.addAll(ExceptionUtil.collectSubstituted(resolveResult.getSubstitutor(), referencedTypes, callExpression.getResolveScope()));
        }

        public void visitThrowStatement(PsiThrowStatement statement2) {
            super.visitThrowStatement(statement2);
            PsiExpression exception = statement2.getException();
            if (exception == null) {
                return;
            }
            PsiType type = exception.getType();
            if (type instanceof PsiClassType) {
                this.m_exceptionsThrown.add((PsiClassType)type);
            }
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/psiutils/ExceptionUtils$ExceptionsThrownVisitor", "visitTryStatement"));
            }
            Set<PsiType> exceptionsHandled = ExceptionUtils.getExceptionTypesHandled(statement2);
            for (PsiClassType resourceException : ExceptionUtils.calculateExceptionsThrown((PsiElement)statement2.getResourceList())) {
                if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, (PsiType)resourceException)) continue;
                this.m_exceptionsThrown.add(resourceException);
            }
            for (PsiClassType tryException : ExceptionUtils.calculateExceptionsThrown((PsiElement)statement2.getTryBlock())) {
                if (ExceptionsThrownVisitor.isExceptionHandled(exceptionsHandled, (PsiType)tryException)) continue;
                this.m_exceptionsThrown.add(tryException);
            }
            ExceptionUtils.calculateExceptionsThrown((PsiElement)statement2.getFinallyBlock(), this.m_exceptionsThrown);
            for (PsiCodeBlock catchBlock : statement2.getCatchBlocks()) {
                ExceptionUtils.calculateExceptionsThrown((PsiElement)catchBlock, this.m_exceptionsThrown);
            }
        }

        private static boolean isExceptionHandled(Set<PsiType> exceptionsHandled, @NotNull PsiType thrownType) {
            if (thrownType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thrownType", "com/siyeh/ig/psiutils/ExceptionUtils$ExceptionsThrownVisitor", "isExceptionHandled"));
            }
            if (exceptionsHandled.contains(thrownType)) {
                return true;
            }
            for (PsiType exceptionHandled : exceptionsHandled) {
                if (!exceptionHandled.isAssignableFrom(thrownType)) continue;
                return true;
            }
            return false;
        }
    }
}

