/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionUtils {
    @NonNls
    static final Set<String> convertableBoxedClassNames = new HashSet<String>(3);

    private ExpressionUtils() {
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable PsiExpression expression) {
        return ExpressionUtils.computeConstantExpression(expression, false);
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable PsiExpression expression, boolean throwConstantEvaluationOverflowException) {
        if (expression == null) {
            return null;
        }
        Project project2 = expression.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiConstantEvaluationHelper constantEvaluationHelper = psiFacade.getConstantEvaluationHelper();
        return constantEvaluationHelper.computeConstantExpression((PsiElement)expression, throwConstantEvaluationOverflowException);
    }

    public static boolean isConstant(PsiField field) {
        if (!field.hasModifierProperty("final")) {
            return false;
        }
        if (CollectionUtils.isEmptyArray((PsiVariable)field)) {
            return true;
        }
        PsiType type = field.getType();
        return ClassUtils.isImmutable(type);
    }

    public static boolean hasExpressionCount(@Nullable PsiExpressionList expressionList, int count) {
        return ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)expressionList, count, PsiExpression.class);
    }

    @Nullable
    public static PsiExpression getFirstExpressionInList(@Nullable PsiExpressionList expressionList) {
        return (PsiExpression)PsiTreeUtil.getChildOfType((PsiElement)expressionList, PsiExpression.class);
    }

    @Nullable
    public static PsiExpression getOnlyExpressionInList(@Nullable PsiExpressionList expressionList) {
        return ControlFlowUtils.getOnlyChildOfType((PsiElement)expressionList, PsiExpression.class);
    }

    public static boolean isDeclaredConstant(PsiExpression expression) {
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class);
        if (field == null) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiAssignmentExpression.class);
            if (assignmentExpression == null) {
                return false;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            field = (PsiField)target;
        }
        return field.hasModifierProperty("static") && field.hasModifierProperty("final");
    }

    @Contract(value="null -> false")
    public static boolean isEvaluatedAtCompileTime(@Nullable PsiExpression expression) {
        if (expression instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression instanceof PsiPolyadicExpression) {
            PsiExpression[] operands;
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                if (ExpressionUtils.isEvaluatedAtCompileTime(operand)) continue;
                return false;
            }
            return true;
        }
        if (expression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
            PsiExpression operand = prefixExpression.getOperand();
            return ExpressionUtils.isEvaluatedAtCompileTime(operand);
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement qualifier = referenceExpression.getQualifier();
            if (qualifier instanceof PsiThisExpression) {
                return false;
            }
            PsiElement element = referenceExpression.resolve();
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                PsiExpression initializer = field.getInitializer();
                return field.hasModifierProperty("final") && ExpressionUtils.isEvaluatedAtCompileTime(initializer);
            }
            if (element instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)element;
                if (PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)expression, (boolean)true)) {
                    return false;
                }
                PsiExpression initializer = variable.getInitializer();
                return variable.hasModifierProperty("final") && ExpressionUtils.isEvaluatedAtCompileTime(initializer);
            }
        }
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            PsiExpression deparenthesizedExpression = parenthesizedExpression.getExpression();
            return ExpressionUtils.isEvaluatedAtCompileTime(deparenthesizedExpression);
        }
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            PsiExpression condition = conditionalExpression.getCondition();
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            return ExpressionUtils.isEvaluatedAtCompileTime(condition) && ExpressionUtils.isEvaluatedAtCompileTime(thenExpression) && ExpressionUtils.isEvaluatedAtCompileTime(elseExpression);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
            PsiTypeElement castType = typeCastExpression.getCastType();
            if (castType == null) {
                return false;
            }
            PsiType type = castType.getType();
            return TypeUtils.typeEquals("java.lang.String", type);
        }
        return false;
    }

    @Nullable
    public static String getLiteralString(@Nullable PsiExpression expression) {
        PsiLiteralExpression literal = ExpressionUtils.getLiteral(expression);
        if (literal == null) {
            return null;
        }
        Object value = literal.getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Nullable
    public static PsiLiteralExpression getLiteral(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiLiteralExpression) {
            return (PsiLiteralExpression)expression;
        }
        if (!(expression instanceof PsiTypeCastExpression)) {
            return null;
        }
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression;
        PsiExpression operand = ParenthesesUtils.stripParentheses(typeCastExpression.getOperand());
        if (!(operand instanceof PsiLiteralExpression)) {
            return null;
        }
        return (PsiLiteralExpression)operand;
    }

    public static boolean isLiteral(@Nullable PsiExpression expression) {
        return ExpressionUtils.getLiteral(expression) != null;
    }

    public static boolean isEmptyStringLiteral(@Nullable PsiExpression expression) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiLiteralExpression)) {
            return false;
        }
        String text = expression.getText();
        return "\"\"".equals(text);
    }

    public static boolean isNullLiteral(@Nullable PsiExpression expression) {
        return (expression = ParenthesesUtils.stripParentheses(expression)) != null && PsiType.NULL.equals((Object)expression.getType());
    }

    public static boolean isZero(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        PsiType expressionType = expression.getType();
        Object value = ConstantExpressionUtil.computeCastTo((PsiExpression)expression, (PsiType)expressionType);
        if (value == null) {
            return false;
        }
        if (value instanceof Double && (Double)value == 0.0) {
            return true;
        }
        if (value instanceof Float && ((Float)value).floatValue() == 0.0f) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == 0) {
            return true;
        }
        if (value instanceof Long && (Long)value == 0L) {
            return true;
        }
        if (value instanceof Short && (Short)value == 0) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\u0000') {
            return true;
        }
        return value instanceof Byte && (Byte)value == 0;
    }

    public static boolean isOne(@Nullable PsiExpression expression) {
        if (expression == null) {
            return false;
        }
        Object value = ExpressionUtils.computeConstantExpression(expression);
        if (value == null) {
            return false;
        }
        if (value instanceof Double && (Double)value == 1.0) {
            return true;
        }
        if (value instanceof Float && ((Float)value).floatValue() == 1.0f) {
            return true;
        }
        if (value instanceof Integer && (Integer)value == 1) {
            return true;
        }
        if (value instanceof Long && (Long)value == 1L) {
            return true;
        }
        if (value instanceof Short && (Short)value == 1) {
            return true;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\u0001') {
            return true;
        }
        return value instanceof Byte && (Byte)value == 1;
    }

    public static boolean isNegation(@Nullable PsiExpression condition, boolean ignoreNegatedNullComparison, boolean ignoreNegatedZeroComparison) {
        if ((condition = ParenthesesUtils.stripParentheses(condition)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            return tokenType.equals(JavaTokenType.EXCL);
        }
        if (condition instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            if (lhs == null || rhs == null) {
                return false;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.NE)) {
                if (ignoreNegatedNullComparison) {
                    String lhsText = lhs.getText();
                    String rhsText = rhs.getText();
                    if ("null".equals(lhsText) || "null".equals(rhsText)) {
                        return false;
                    }
                }
                return !ignoreNegatedZeroComparison || !ExpressionUtils.isZeroLiteral(lhs) && !ExpressionUtils.isZeroLiteral(rhs);
            }
        }
        return false;
    }

    private static boolean isZeroLiteral(PsiExpression expression) {
        if (!(expression instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
        Object value = literalExpression.getValue();
        return value instanceof Integer ? (Integer)value == 0 : value instanceof Long && (Long)value == 0L;
    }

    public static boolean isOffsetArrayAccess(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/ExpressionUtils", "isOffsetArrayAccess"));
        }
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
        if (!(strippedExpression instanceof PsiArrayAccessExpression)) {
            return false;
        }
        PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)strippedExpression;
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)arrayExpression)) {
            return false;
        }
        PsiExpression index = arrayAccessExpression.getIndexExpression();
        if (index == null) {
            return false;
        }
        return ExpressionUtils.expressionIsOffsetVariableLookup(index, variable);
    }

    private static boolean expressionIsOffsetVariableLookup(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/ExpressionUtils", "expressionIsOffsetVariableLookup"));
        }
        if (VariableAccessUtils.evaluatesToVariable(expression, variable)) {
            return true;
        }
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
        if (!(strippedExpression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)strippedExpression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!JavaTokenType.PLUS.equals(tokenType) && !JavaTokenType.MINUS.equals(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        if (ExpressionUtils.expressionIsOffsetVariableLookup(lhs, variable)) {
            return true;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        return ExpressionUtils.expressionIsOffsetVariableLookup(rhs, variable) && !JavaTokenType.MINUS.equals(tokenType);
    }

    public static boolean isVariableLessThanComparison(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/ExpressionUtils", "isVariableLessThanComparison"));
        }
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE)) {
            PsiExpression lhs = binaryExpression.getLOperand();
            return VariableAccessUtils.evaluatesToVariable(lhs, variable);
        }
        if (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE)) {
            PsiExpression rhs = binaryExpression.getROperand();
            return VariableAccessUtils.evaluatesToVariable(rhs, variable);
        }
        return false;
    }

    public static boolean isVariableGreaterThanComparison(@Nullable PsiExpression expression, @NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/ExpressionUtils", "isVariableGreaterThanComparison"));
        }
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE)) {
            PsiExpression lhs = binaryExpression.getLOperand();
            return VariableAccessUtils.evaluatesToVariable(lhs, variable);
        }
        if (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE)) {
            PsiExpression rhs = binaryExpression.getROperand();
            return VariableAccessUtils.evaluatesToVariable(rhs, variable);
        }
        return false;
    }

    public static boolean isZeroLengthArrayConstruction(@Nullable PsiExpression expression) {
        if (!(expression instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression;
        PsiExpression[] dimensions = newExpression.getArrayDimensions();
        if (dimensions.length == 0) {
            PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
            if (arrayInitializer == null) {
                return false;
            }
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            return initializers.length == 0;
        }
        for (PsiExpression dimension : dimensions) {
            String dimensionText = dimension.getText();
            if ("0".equals(dimensionText)) continue;
            return false;
        }
        return true;
    }

    public static boolean isStringConcatenationOperand(PsiExpression expression) {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        if (!JavaTokenType.PLUS.equals(polyadicExpression.getOperationTokenType())) {
            return false;
        }
        Object[] operands = polyadicExpression.getOperands();
        if (operands.length < 2) {
            return false;
        }
        int index = ArrayUtil.indexOf((Object[])operands, (Object)expression);
        for (int i2 = 0; i2 < index; ++i2) {
            PsiType type = operands[i2].getType();
            if (!TypeUtils.isJavaLangString(type)) continue;
            return true;
        }
        if (index == 0) {
            PsiType type = operands[index + 1].getType();
            return TypeUtils.isJavaLangString(type);
        }
        return false;
    }

    public static boolean isConstructorInvocation(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String callName = methodExpression.getReferenceName();
        return "this".equals(callName) || "super".equals(callName);
    }

    public static boolean hasType(@Nullable PsiExpression expression, @NonNls @NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/siyeh/ig/psiutils/ExpressionUtils", "hasType"));
        }
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        return TypeUtils.typeEquals(typeName, type);
    }

    public static boolean hasStringType(@Nullable PsiExpression expression) {
        return ExpressionUtils.hasType(expression, "java.lang.String");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConversionToStringNecessary(PsiExpression expression, boolean throwable) {
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            PsiType type = polyadicExpression.getType();
            if (!TypeUtils.typeEquals("java.lang.String", type)) {
                return true;
            }
            PsiExpression[] operands = polyadicExpression.getOperands();
            boolean expressionSeen = false;
            int length = operands.length;
            for (int i2 = 0; i2 < length; ++i2) {
                PsiExpression operand = operands[i2];
                if (PsiTreeUtil.isAncestor((PsiElement)operand, (PsiElement)expression, (boolean)false)) {
                    if (i2 > 0) {
                        return true;
                    }
                    expressionSeen = true;
                    continue;
                }
                if (expressionSeen && i2 != 1 || !TypeUtils.isJavaLangString(operand.getType())) continue;
                return false;
            }
            return true;
        }
        if (!(parent instanceof PsiExpressionList)) return true;
        PsiExpressionList expressionList = (PsiExpressionList)parent;
        PsiElement grandParent = expressionList.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return true;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
        String name = methodExpression1.getReferenceName();
        PsiExpression[] expressions = expressionList.getExpressions();
        if ("insert".equals(name)) {
            if (expressions.length < 2 || !expression.equals(ParenthesesUtils.stripParentheses(expressions[1]))) {
                return true;
            }
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.lang.StringBuilder", "java.lang.StringBuffer")) return false;
            return true;
        }
        if ("append".equals(name)) {
            if (expressions.length < 1 || !expression.equals(ParenthesesUtils.stripParentheses(expressions[0]))) {
                return true;
            }
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.lang.StringBuilder", "java.lang.StringBuffer")) return false;
            return true;
        }
        if ("print".equals(name) || "println".equals(name)) {
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.io.PrintStream", "java.io.PrintWriter")) return false;
            return true;
        }
        if (!"trace".equals(name) && !"debug".equals(name) && !"info".equals(name) && !"warn".equals(name) && !"error".equals(name)) return true;
        if (!ExpressionUtils.isCallToMethodIn(methodCallExpression, "org.slf4j.Logger")) {
            return true;
        }
        int l = 1;
        for (int i3 = 0; i3 < expressions.length; ++i3) {
            PsiExpression expression1 = expressions[i3];
            if (i3 == 0 && TypeUtils.expressionHasTypeOrSubtype(expression1, "org.slf4j.Marker")) {
                l = 2;
            }
            if (expression1 != expression || i3 >= l && (!throwable || i3 != expressions.length - 1)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCallToMethodIn(PsiMethodCallExpression methodCallExpression, String ... classNames) {
        PsiMethod method2 = methodCallExpression.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        for (String className : classNames) {
            if (!className.equals(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNegative(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ExpressionUtils", "isNegative"));
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        return JavaTokenType.MINUS.equals(tokenType);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiVariable getVariableFromNullComparison(PsiExpression expression, boolean equals) {
        PsiReferenceExpression referenceExpression = ExpressionUtils.getReferenceExpressionFromNullComparison(expression, equals);
        PsiElement target = referenceExpression != null ? referenceExpression.resolve() : null;
        return target instanceof PsiVariable ? (PsiVariable)target : null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiReferenceExpression getReferenceExpressionFromNullComparison(PsiExpression expression, boolean equals) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (equals ? !JavaTokenType.EQEQ.equals(tokenType) : !JavaTokenType.NE.equals(tokenType)) {
            return null;
        }
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operands.length != 2) {
            return null;
        }
        PsiExpression comparedToNull = null;
        if (PsiType.NULL.equals((Object)operands[0].getType())) {
            comparedToNull = operands[1];
        } else if (PsiType.NULL.equals((Object)operands[1].getType())) {
            comparedToNull = operands[0];
        }
        comparedToNull = ParenthesesUtils.stripParentheses(comparedToNull);
        return comparedToNull instanceof PsiReferenceExpression ? (PsiReferenceExpression)comparedToNull : null;
    }

    @Nullable
    public static PsiExpression getValueComparedWithNull(@NotNull PsiBinaryExpression binOp) {
        if (binOp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binOp", "com/siyeh/ig/psiutils/ExpressionUtils", "getValueComparedWithNull"));
        }
        IElementType tokenType = binOp.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.EQEQ) && !tokenType.equals(JavaTokenType.NE)) {
            return null;
        }
        PsiExpression left = binOp.getLOperand();
        PsiExpression right = binOp.getROperand();
        if (ExpressionUtils.isNullLiteral(right)) {
            return left;
        }
        if (ExpressionUtils.isNullLiteral(left)) {
            return right;
        }
        return null;
    }

    public static boolean isConcatenation(PsiElement element) {
        if (!(element instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression = (PsiPolyadicExpression)element;
        PsiType type = expression.getType();
        return type != null && type.equalsToText("java.lang.String");
    }

    public static boolean isAnnotatedNotNull(PsiExpression expression) {
        return ExpressionUtils.isAnnotated(expression, false);
    }

    public static boolean isAnnotatedNullable(PsiExpression expression) {
        return ExpressionUtils.isAnnotated(expression, true);
    }

    private static boolean isAnnotated(PsiExpression expression, boolean nullable) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)target;
        return nullable ? NullableNotNullManager.isNullable((PsiModifierListOwner)modifierListOwner) : NullableNotNullManager.isNotNull((PsiModifierListOwner)modifierListOwner);
    }

    @Contract(value="null -> false")
    public static boolean isSimpleExpression(@Nullable PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiLiteralExpression || expression instanceof PsiThisExpression || expression instanceof PsiClassObjectAccessExpression || ExpressionUtils.isEvaluatedAtCompileTime(expression)) {
            return true;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiElement resolvedQualifier;
            PsiExpression qualifier = ((PsiReferenceExpression)expression).getQualifierExpression();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                return true;
            }
            if (qualifier instanceof PsiReferenceExpression && (resolvedQualifier = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass) {
                return true;
            }
        }
        return false;
    }

    @Contract(value="null -> null")
    public static PsiAssignmentExpression getAssignment(PsiElement element) {
        PsiAssignmentExpression assignment;
        if (element instanceof PsiExpressionStatement) {
            element = ((PsiExpressionStatement)element).getExpression();
        }
        if (element instanceof PsiExpression && (element = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)element))) instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)element).getOperationTokenType().equals(JavaTokenType.EQ)) {
            return assignment;
        }
        return null;
    }

    @Contract(value="null, _ -> null; _, null -> null")
    public static PsiExpression getAssignmentTo(PsiElement element, PsiVariable target) {
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
        if (assignment != null && ExpressionUtils.isReferenceTo(assignment.getLExpression(), target)) {
            return assignment.getRExpression();
        }
        return null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isLiteral(PsiElement element, Object value) {
        return element instanceof PsiLiteralExpression && value.equals(((PsiLiteralExpression)element).getValue());
    }

    public static boolean isAutoBoxed(@NotNull PsiExpression expression) {
        PsiMethodCallExpression methodCallExpression;
        PsiMethod method2;
        PsiElement grandParent;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/psiutils/ExpressionUtils", "isAutoBoxed"));
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiParenthesizedExpression) {
            return false;
        }
        if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && (method2 = (methodCallExpression = (PsiMethodCallExpression)grandParent).resolveMethod()) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method2, Collections.singletonList("java.lang.invoke.MethodHandle.PolymorphicSignature"))) {
            return false;
        }
        PsiType expressionType = expression.getType();
        if (PsiPrimitiveType.getUnboxedType((PsiType)expressionType) != null && (parent instanceof PsiPrefixExpression || parent instanceof PsiPostfixExpression)) {
            return true;
        }
        if (expressionType == null || expressionType.equals(PsiType.VOID) || !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expressionType)) {
            return false;
        }
        PsiPrimitiveType primitiveType = (PsiPrimitiveType)expressionType;
        PsiClassType boxedType = primitiveType.getBoxedType((PsiElement)expression);
        if (boxedType == null) {
            return false;
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true);
        if (expectedType == null || ClassUtils.isPrimitive(expectedType)) {
            return false;
        }
        if (!expectedType.isAssignableFrom((PsiType)boxedType)) {
            if (!(expectedType instanceof PsiClassType) || !PsiUtil.isConstantExpression((PsiExpression)expression)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)expectedType;
            String className = classType.getCanonicalText();
            if (!convertableBoxedClassNames.contains(className)) {
                return false;
            }
            if (!(PsiType.BYTE.equals((Object)expressionType) || PsiType.CHAR.equals((Object)expressionType) || PsiType.SHORT.equals((Object)expressionType) || PsiType.INT.equals((Object)expressionType))) {
                return false;
            }
        }
        return true;
    }

    @Contract(value="null, _ -> null; !null, null -> null")
    public static PsiExpression getOtherOperand(@Nullable PsiBinaryExpression binOp, @Nullable PsiVariable variable) {
        if (binOp == null || variable == null) {
            return null;
        }
        if (ExpressionUtils.isReferenceTo(binOp.getLOperand(), variable)) {
            return binOp.getROperand();
        }
        if (ExpressionUtils.isReferenceTo(binOp.getROperand(), variable)) {
            return binOp.getLOperand();
        }
        return null;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean isReferenceTo(PsiExpression expression, PsiVariable variable) {
        return (expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).isReferenceTo((PsiElement)variable);
    }

    @Contract(value="null -> null", pure=true)
    public static PsiMethodCallExpression getCallForQualifier(PsiExpression qualifier) {
        PsiElement gParent;
        PsiReferenceExpression methodExpression;
        if (qualifier == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)qualifier.getParent());
        if (parent instanceof PsiReferenceExpression && PsiTreeUtil.isAncestor((PsiElement)(methodExpression = (PsiReferenceExpression)parent).getQualifierExpression(), (PsiElement)qualifier, (boolean)false) && (gParent = methodExpression.getParent()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)gParent;
        }
        return null;
    }

    @Nullable
    public static PsiExpression getArrayFromLengthExpression(PsiExpression expression) {
        if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)expression;
        String referenceName = reference.getReferenceName();
        if (!"length".equals(referenceName)) {
            return null;
        }
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType type = qualifier.getType();
        if (type == null || type.getArrayDimensions() <= 0) {
            return null;
        }
        return qualifier;
    }

    @NotNull
    public static PsiExpression getQualifierOrThis(@NotNull PsiReferenceExpression ref) {
        PsiClass memberClass;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/siyeh/ig/psiutils/ExpressionUtils", "getQualifierOrThis"));
        }
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier != null) {
            PsiExpression psiExpression = qualifier;
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ExpressionUtils", "getQualifierOrThis"));
            }
            return psiExpression;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ref.getProject());
        PsiMember member = (PsiMember)ObjectUtils.tryCast((Object)ref.resolve(), PsiMember.class);
        if (member != null && (memberClass = member.getContainingClass()) != null) {
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)ref);
            if (containingClass == null) {
                containingClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)ref, (Class[])new Class[]{PsiClass.class});
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
                containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
                while (containingClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
                    containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
                }
                if (containingClass != null) {
                    PsiExpression psiExpression = factory.createExpressionFromText(containingClass.getQualifiedName() + "." + "this", (PsiElement)ref);
                    if (psiExpression == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ExpressionUtils", "getQualifierOrThis"));
                    }
                    return psiExpression;
                }
            }
        }
        PsiExpression psiExpression = factory.createExpressionFromText("this", (PsiElement)ref);
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/psiutils/ExpressionUtils", "getQualifierOrThis"));
        }
        return psiExpression;
    }

    static {
        convertableBoxedClassNames.add("java.lang.Byte");
        convertableBoxedClassNames.add("java.lang.Character");
        convertableBoxedClassNames.add("java.lang.Short");
    }
}

