/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class SingletonUtil {
    private SingletonUtil() {
    }

    public static boolean isSingleton(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/psiutils/SingletonUtil", "isSingleton"));
        }
        if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiMethod[] constructors = SingletonUtil.getIfOnlyInvisibleConstructors(aClass);
        if (constructors.length == 0) {
            return false;
        }
        PsiField selfInstance = SingletonUtil.getIfOneStaticSelfInstance(aClass);
        if (selfInstance == null) {
            return false;
        }
        return SingletonUtil.newOnlyAssignsToStaticSelfInstance(constructors[0], selfInstance);
    }

    private static PsiField getIfOneStaticSelfInstance(PsiClass aClass) {
        PsiClass[] innerClasses;
        PsiField[] fields = aClass.getFields();
        PsiField result2 = null;
        for (PsiField field : fields) {
            PsiClassType classType;
            PsiClass targetClass;
            PsiType type;
            if (!field.hasModifierProperty("static") || !((type = field.getType()) instanceof PsiClassType) || !aClass.equals(targetClass = (classType = (PsiClassType)type).resolve())) continue;
            if (result2 != null) {
                return null;
            }
            result2 = field;
        }
        for (PsiClass innerClass : innerClasses = aClass.getInnerClasses()) {
            PsiField[] fields1;
            if (!innerClass.hasModifierProperty("static")) continue;
            for (PsiField field : fields1 = innerClass.getFields()) {
                PsiClassType classType;
                PsiClass targetClass;
                PsiType type;
                if (!field.hasModifierProperty("static") || !((type = field.getType()) instanceof PsiClassType) || !aClass.equals(targetClass = (classType = (PsiClassType)type).resolve())) continue;
                if (result2 != null) {
                    return null;
                }
                result2 = field;
            }
        }
        return result2;
    }

    private static PsiMethod[] getIfOnlyInvisibleConstructors(PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return PsiMethod.EMPTY_ARRAY;
        }
        for (PsiMethod constructor : constructors) {
            if (constructor.hasModifierProperty("public")) {
                return PsiMethod.EMPTY_ARRAY;
            }
            if (constructor.hasModifierProperty("private") || constructor.hasModifierProperty("protected")) continue;
            return PsiMethod.EMPTY_ARRAY;
        }
        return constructors;
    }

    private static boolean newOnlyAssignsToStaticSelfInstance(PsiMethod method2, PsiField field) {
        Query search = MethodReferencesSearch.search((PsiMethod)method2, (SearchScope)field.getUseScope(), (boolean)false);
        NewOnlyAssignedToFieldProcessor processor2 = new NewOnlyAssignedToFieldProcessor(field);
        search.forEach((Processor)processor2);
        return processor2.isNewOnlyAssignedToField();
    }

    private static class NewOnlyAssignedToFieldProcessor
    implements Processor<PsiReference> {
        private boolean newOnlyAssignedToField = true;
        private final PsiField field;

        public NewOnlyAssignedToFieldProcessor(PsiField field) {
            this.field = field;
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (this.field.equals(grandParent)) {
                return true;
            }
            if (!(grandParent instanceof PsiAssignmentExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)grandParent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!this.field.equals(target)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            return true;
        }

        public boolean isNewOnlyAssignedToField() {
            return this.newOnlyAssignedToField;
        }
    }
}

