/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#org.intellij.plugins.relaxNG.references.PrefixReferenceProvider");

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider", "getReferencesByElement"));
        }
        XmlAttributeValue value = (XmlAttributeValue)element;
        String s = value.getValue();
        int i2 = s.indexOf(58);
        if (i2 <= 0 || s.startsWith("xml:")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PrefixReference(value, i2)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class PrefixReference
    extends BasicAttributeValueReference
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        public PrefixReference(XmlAttributeValue value, int length) {
            super((PsiElement)value, TextRange.from((int)1, (int)length));
        }

        @Nullable
        public PsiElement resolve() {
            String prefix = this.getCanonicalText();
            for (XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class); tag != null; tag = tag.getParentTag()) {
                if (!tag.getLocalNamespaceDeclarations().containsKey(prefix)) continue;
                XmlAttribute attribute = tag.getAttribute("xmlns:" + prefix, "");
                TextRange textRange = TextRange.from((int)"xmlns:".length(), (int)prefix.length());
                return new SchemaPrefix(attribute, textRange, prefix);
            }
            return null;
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            PsiElement e;
            if (element instanceof SchemaPrefix && element.getContainingFile() == this.myElement.getContainingFile() && (e = this.resolve()) instanceof SchemaPrefix) {
                String s = ((SchemaPrefix)e).getName();
                return s != null && s.equals(((SchemaPrefix)element).getName());
            }
            return super.isReferenceTo(element);
        }

        @Nullable
        public LocalQuickFix[] getQuickFixes() {
            PsiElement element = this.getElement();
            XmlElementFactory factory = XmlElementFactory.getInstance((Project)element.getProject());
            String value = ((XmlAttributeValue)element).getValue();
            String[] name = value.split(":");
            XmlTag tag = factory.createTagFromText((CharSequence)("<" + (name.length > 1 ? name[1] : value) + " />"), (Language)XMLLanguage.INSTANCE);
            return new LocalQuickFix[]{XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)tag, this.getCanonicalText(), null)};
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider$PrefixReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            if ("Undefined namespace prefix ''{0}''" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider$PrefixReference", "getUnresolvedMessagePattern"));
            }
            return "Undefined namespace prefix ''{0}''";
        }
    }
}

