/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.PlatformUtils;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.RootProvider;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/builtInWebServer/DefaultWebServerRootsProvider;", "Lorg/jetbrains/builtInWebServer/WebServerRootsProvider;", "()V", "getPathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "resolve", "path", "", "built-in-server"})
final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project2) {
        Module module2;
        RootProvider rootProvider;
        Object it;
        PathInfo file$iv;
        int n;
        int n2;
        void effectivePath;
        int index;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = path;
        if (PlatformUtils.isIntelliJ() && (index = StringsKt.indexOf$default((CharSequence)((String)effectivePath.element), (char)'/', (int)0, (boolean)false, (int)6, null)) > 0) {
            String string = (String)effectivePath.element;
            String string2 = project2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"project.name");
            if (!StringsKt.regionMatches((String)string, (int)0, (String)string2, (int)0, (int)index, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                String string3 = (String)effectivePath.element;
                n2 = 0;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n2, index);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String moduleName = string5;
                Module module3 = (Module)ApplicationManager.getApplication().runReadAction(new Computable<T>(project2, moduleName){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ String $moduleName$inlined;

                    public final T compute() {
                        return (T)ModuleManager.getInstance((Project)this.$project$inlined).findModuleByName(this.$moduleName$inlined);
                    }
                    {
                        this.$project$inlined = project2;
                        this.$moduleName$inlined = string;
                    }
                });
                if (module3 != null && !module3.isDisposed()) {
                    PathInfo result2;
                    PathInfo pathInfo;
                    PathInfo pathInfo2;
                    FileResolver resolver;
                    block13: {
                        void $receiver$iv;
                        String $i$f$runReadAction = (String)effectivePath.element;
                        int n3 = index + 1;
                        void var17_12 = effectivePath;
                        String string6 = $i$f$runReadAction;
                        if (string6 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string7 = string6.substring(n3);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                        String string8 = string7;
                        var17_12.element = string8;
                        resolver = WebServerPathToFileManager.Companion.getInstance(project2).getResolver((String)effectivePath.element);
                        Object[] objectArray = (Object[])RootProvider.values();
                        for (n = 0; n < ((void)$receiver$iv).length; ++n) {
                            file$iv = $receiver$iv[n];
                            it = (RootProvider)file$iv;
                            PathInfo result$iv = DefaultWebServerRootsProviderKt.access$findByRelativePath((String)effectivePath.element, it.getRoots(ProjectKt.getRootManager(module3)), resolver, moduleName);
                            if (result$iv == null) continue;
                            pathInfo2 = result$iv;
                            break block13;
                        }
                        pathInfo2 = null;
                    }
                    if ((pathInfo = (PathInfo)pathInfo2) == null) {
                        pathInfo = result2 = DefaultWebServerRootsProviderKt.access$findInModuleLibraries((String)effectivePath.element, module3, resolver);
                    }
                    if (result2 != null) {
                        return result2;
                    }
                }
            }
        }
        FileResolver resolver = WebServerPathToFileManager.Companion.getInstance(project2).getResolver((String)effectivePath.element);
        Module[] modules = (Module[])ApplicationManager.getApplication().runReadAction(new Computable<T>(project2){
            final /* synthetic */ Project $project$inlined;

            public final T compute() {
                return (T)ModuleManager.getInstance((Project)this.$project$inlined).getModules();
            }
            {
                this.$project$inlined = project2;
            }
        });
        RootProvider[] rootProviderArray = RootProvider.values();
        for (n2 = 0; n2 < rootProviderArray.length; ++n2) {
            rootProvider = rootProviderArray[n2];
            for (n = 0; n < modules.length; ++n) {
                module2 = modules[n];
                if (module2.isDisposed()) continue;
                PathInfo pathInfo = DefaultWebServerRootsProviderKt.access$findByRelativePath(path, rootProvider.getRoots(ProjectKt.getRootManager(module2)), resolver, null);
                if (pathInfo == null) continue;
                file$iv = pathInfo;
                it = file$iv;
                it.setModuleName(DefaultWebServerRootsProviderKt.access$getModuleNameQualifier(project2, module2));
                return it;
            }
        }
        rootProviderArray = RootProvider.values();
        for (n2 = 0; n2 < rootProviderArray.length; ++n2) {
            rootProvider = rootProviderArray[n2];
            for (n = 0; n < modules.length; ++n) {
                module2 = modules[n];
                if (module2.isDisposed()) continue;
                VirtualFile[] virtualFileArray = rootProvider.getRoots(ProjectKt.getRootManager(module2));
                for (int j = 0; j < virtualFileArray.length; ++j) {
                    VirtualFile root = virtualFileArray[j];
                    if (FileResolver.DefaultImpls.resolve$default(resolver, "/config.json", root, null, false, 12, null) == null) continue;
                    PathInfo pathInfo = FileResolver.DefaultImpls.resolve$default(resolver, "/index.html", root, null, false, 12, null);
                    if (pathInfo == null) continue;
                    PathInfo pathInfo3 = pathInfo;
                    PathInfo it2 = pathInfo3;
                    it2.setModuleName(DefaultWebServerRootsProviderKt.access$getModuleNameQualifier(project2, module2));
                    return it2;
                }
            }
        }
        return DefaultWebServerRootsProviderKt.access$findInLibraries(project2, (String)effectivePath.element, resolver);
    }

    @Nullable
    public PathInfo getPathInfo(@NotNull VirtualFile file2, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return (PathInfo)ApplicationManager.getApplication().runReadAction(new Computable<T>(project2, file2){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ VirtualFile $file$inlined;

            public final T compute() {
                PathInfo pathInfo;
                DirectoryIndex directoryIndex = DirectoryIndex.getInstance(this.$project$inlined);
                DirectoryInfo info = directoryIndex.getInfoForFile(this.$file$inlined);
                if (!info.isExcluded() && !info.isInProject()) {
                    pathInfo = Intrinsics.areEqual((Object)this.$file$inlined.getFileSystem(), (Object)JarFileSystem.getInstance()) ? DefaultWebServerRootsProviderKt.access$getInfoForDocJar(this.$file$inlined, this.$project$inlined) : (PathInfo)null;
                } else {
                    boolean isLibrary;
                    boolean isRootNameOptionalInPath;
                    VirtualFile root = info.getSourceRoot();
                    if (root == null) {
                        isRootNameOptionalInPath = false;
                        root = info.getContentRoot();
                        if (root == null) {
                            root = info.getLibraryClassRoot();
                            isLibrary = true;
                            boolean bl = root != null;
                            if (_Assertions.ENABLED && !bl) {
                                String string = this.$file$inlined.getPresentableUrl();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.presentableUrl");
                                String string2 = string;
                                throw (Throwable)((Object)new AssertionError((Object)string2));
                            }
                        } else {
                            isLibrary = false;
                        }
                    } else {
                        isLibrary = info.isInLibrarySource();
                        isRootNameOptionalInPath = !isLibrary;
                    }
                    Module module2 = info.getModule();
                    if (isLibrary && module2 == null) {
                        for (OrderEntry entry : directoryIndex.getOrderEntries(info)) {
                            if (!(entry instanceof ModuleLibraryOrderEntryImpl)) continue;
                            module2 = ((ModuleLibraryOrderEntryImpl)entry).getOwnerModule();
                            break;
                        }
                    }
                    Path path = null;
                    VirtualFile virtualFile = root;
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root!!");
                    pathInfo = new PathInfo(path, this.$file$inlined, virtualFile, DefaultWebServerRootsProviderKt.access$getModuleNameQualifier(this.$project$inlined, module2), isLibrary, isRootNameOptionalInPath);
                }
                return (T)pathInfo;
            }
            {
                this.$project$inlined = project2;
                this.$file$inlined = virtualFile;
            }
        });
    }
}

