/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.PlatformUtils;
import java.nio.file.Path;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u001a7\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\"\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001aC\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u001c\u0010\u0017\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0018H\u0002\u00a2\u0006\u0002\u0010\u001a\u001a8\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00022\u001c\u0010\u0017\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0018H\u0002\u001a\"\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\n\u0010!\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u001c\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\u0019H\u0002\"(\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u00018BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006#"}, d2={"ORDER_ROOT_TYPES", "", "Lcom/intellij/openapi/roots/OrderRootType;", "kotlin.jvm.PlatformType", "getORDER_ROOT_TYPES", "()[Lcom/intellij/openapi/roots/OrderRootType;", "ORDER_ROOT_TYPES$delegate", "Lkotlin/Lazy;", "findByRelativePath", "Lorg/jetbrains/builtInWebServer/PathInfo;", "path", "", "roots", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "moduleName", "(Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/builtInWebServer/FileResolver;Ljava/lang/String;)Lorg/jetbrains/builtInWebServer/PathInfo;", "findInLibraries", "project", "Lcom/intellij/openapi/project/Project;", "findInLibrariesAndSdk", "rootTypes", "fileProcessor", "Lkotlin/Function2;", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/roots/OrderRootType;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/builtInWebServer/PathInfo;", "findInModuleLevelLibraries", "module", "rootType", "findInModuleLibraries", "getInfoForDocJar", "file", "getJavadocOrderRootType", "getModuleNameQualifier", "built-in-server"})
public final class DefaultWebServerRootsProviderKt {
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Lazy ORDER_ROOT_TYPES$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(DefaultWebServerRootsProviderKt.class, (String)"built-in-server"), "ORDER_ROOT_TYPES", "getORDER_ROOT_TYPES()[Lcom/intellij/openapi/roots/OrderRootType;"))};
        ORDER_ROOT_TYPES$delegate = LazyKt.lazy((Function0)ORDER_ROOT_TYPES.2.INSTANCE);
    }

    private static final OrderRootType[] getORDER_ROOT_TYPES() {
        Lazy lazy = ORDER_ROOT_TYPES$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        return (OrderRootType[])lazy.getValue();
    }

    private static final OrderRootType getJavadocOrderRootType() {
        try {
            return JavadocOrderRootType.getInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final PathInfo findInModuleLibraries(String path, Module module2, FileResolver resolver) {
        PathInfo pathInfo;
        block4: {
            void $receiver$iv;
            int index = StringsKt.indexOf$default((CharSequence)((CharSequence)path), (char)'/', (int)0, (boolean)false, (int)6, null);
            if (index <= 0) {
                return null;
            }
            Object[] objectArray = path;
            int n = 0;
            if (objectArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string = objectArray.substring(n, index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String libraryFileName = string;
            Object[] objectArray2 = path;
            int n2 = index + 1;
            if (objectArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = objectArray2.substring(n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            String relativePath = string2;
            objectArray2 = DefaultWebServerRootsProviderKt.getORDER_ROOT_TYPES();
            for (n2 = 0; n2 < ((void)$receiver$iv).length; ++n2) {
                OrderRootType it;
                void file$iv = $receiver$iv[n2];
                OrderRootType orderRootType = it = (OrderRootType)file$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)orderRootType, (String)"it");
                PathInfo result$iv = DefaultWebServerRootsProviderKt.findInModuleLevelLibraries(module2, orderRootType, (Function2<? super VirtualFile, ? super Module, PathInfo>)((Function2)new Function2<VirtualFile, Module, PathInfo>(module2, libraryFileName, resolver, relativePath){
                    final /* synthetic */ Module $module$inlined;
                    final /* synthetic */ String $libraryFileName$inlined;
                    final /* synthetic */ FileResolver $resolver$inlined;
                    final /* synthetic */ String $relativePath$inlined;

                    public final PathInfo invoke(VirtualFile root, Module module2) {
                        return StringUtil.equalsIgnoreCase((CharSequence)root.getNameSequence(), (CharSequence)this.$libraryFileName$inlined) ? FileResolver.DefaultImpls.resolve$default(this.$resolver$inlined, this.$relativePath$inlined, root, null, true, 4, null) : (PathInfo)null;
                    }
                    {
                        this.$module$inlined = module2;
                        this.$libraryFileName$inlined = string;
                        this.$resolver$inlined = fileResolver;
                        this.$relativePath$inlined = string2;
                        super(2);
                    }
                }));
                if (result$iv == null) continue;
                pathInfo = result$iv;
                break block4;
            }
            pathInfo = null;
        }
        return pathInfo;
    }

    private static final PathInfo findInLibraries(Project project2, String path, FileResolver resolver) {
        int index = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index < 0) {
            return null;
        }
        String string = path;
        int n = 0;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String libraryFileName = string3;
        String string4 = path;
        int n2 = index + 1;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        String relativePath = string6;
        return DefaultWebServerRootsProviderKt.findInLibrariesAndSdk(project2, DefaultWebServerRootsProviderKt.getORDER_ROOT_TYPES(), (Function2<? super VirtualFile, ? super Module, PathInfo>)((Function2)new Function2<VirtualFile, Module, PathInfo>(libraryFileName, resolver, relativePath){
            final /* synthetic */ String $libraryFileName;
            final /* synthetic */ FileResolver $resolver;
            final /* synthetic */ String $relativePath;

            @Nullable
            public final PathInfo invoke(@NotNull VirtualFile root, @Nullable Module module2) {
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                return StringUtil.equalsIgnoreCase((CharSequence)root.getNameSequence(), (CharSequence)this.$libraryFileName) ? FileResolver.DefaultImpls.resolve$default(this.$resolver, this.$relativePath, root, null, true, 4, null) : (PathInfo)null;
            }
            {
                this.$libraryFileName = string;
                this.$resolver = fileResolver;
                this.$relativePath = string2;
                super(2);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final PathInfo getInfoForDocJar(VirtualFile file2, Project project2) {
        void elements$iv;
        OrderRootType orderRootType = DefaultWebServerRootsProviderKt.getJavadocOrderRootType();
        if (orderRootType == null) {
            return null;
        }
        OrderRootType javaDocRootType = orderRootType;
        OrderRootType[] orderRootTypeArray = new OrderRootType[]{javaDocRootType};
        Project project3 = project2;
        Object[] objectArray = (Object[])elements$iv;
        return DefaultWebServerRootsProviderKt.findInLibrariesAndSdk(project3, (OrderRootType[])objectArray, (Function2<? super VirtualFile, ? super Module, PathInfo>)((Function2)new Function2<VirtualFile, Module, PathInfo>(file2, project2){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;

            @Nullable
            public final PathInfo invoke(@NotNull VirtualFile root, @Nullable Module module2) {
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                return VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)this.$file, (boolean)false) ? new PathInfo((Path)null, this.$file, root, DefaultWebServerRootsProviderKt.access$getModuleNameQualifier(this.$project, module2), true, false, 32, null) : (PathInfo)null;
            }
            {
                this.$file = virtualFile;
                this.$project = project2;
                super(2);
            }
        }));
    }

    private static final String getModuleNameQualifier(Project project2, Module module2) {
        if (module2 != null && PlatformUtils.isIntelliJ() && !StringsKt.equals((String)module2.getName(), (String)project2.getName(), (boolean)true)) {
            String string = module2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
            if (!BuiltInWebServerKt.compareNameAndProjectBasePath(string, project2)) {
                return module2.getName();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final PathInfo findByRelativePath(String path, VirtualFile[] roots, FileResolver resolver, String moduleName) {
        PathInfo pathInfo;
        block1: {
            void $receiver$iv;
            Object[] objectArray = roots;
            for (int j = 0; j < ((void)$receiver$iv).length; ++j) {
                void file$iv = $receiver$iv[j];
                VirtualFile it = (VirtualFile)file$iv;
                PathInfo result$iv = FileResolver.DefaultImpls.resolve$default(resolver, path, it, moduleName, false, 8, null);
                if (result$iv == null) continue;
                pathInfo = result$iv;
                break block1;
            }
            pathInfo = null;
        }
        return pathInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static final PathInfo findInLibrariesAndSdk(Project project2, OrderRootType[] rootTypes, Function2<? super VirtualFile, ? super Module, PathInfo> fileProcessor) {
        PathInfo pathInfo;
        block1: {
            void $receiver$iv;
            Function2<LibraryTable, OrderRootType, PathInfo> findInLibraryTable$ = new Function2<LibraryTable, OrderRootType, PathInfo>(fileProcessor){
                final /* synthetic */ Function2 $fileProcessor;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final PathInfo invoke(@NotNull LibraryTable table, @NotNull OrderRootType rootType) {
                    PathInfo pathInfo;
                    block3: {
                        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
                        Intrinsics.checkParameterIsNotNull((Object)rootType, (String)"rootType");
                        Iterator $receiver$iv = table.getLibraryIterator();
                        Iterator iterator = $receiver$iv;
                        Iterator iterator2 = iterator;
                        while (iterator2.hasNext()) {
                            PathInfo result$iv;
                            PathInfo pathInfo2;
                            block2: {
                                void $receiver$iv2;
                                E file$iv = iterator2.next();
                                Library it = (Library)file$iv;
                                Object[] objectArray = it.getFiles(rootType);
                                for (int j = 0; j < ((void)$receiver$iv2).length; ++j) {
                                    VirtualFile it2;
                                    void file$iv2 = $receiver$iv2[j];
                                    VirtualFile virtualFile = it2 = (VirtualFile)file$iv2;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                                    PathInfo result$iv2 = (PathInfo)this.$fileProcessor.invoke((Object)virtualFile, null);
                                    if (result$iv2 == null) continue;
                                    pathInfo2 = result$iv2;
                                    break block2;
                                }
                                pathInfo2 = null;
                            }
                            if ((result$iv = (PathInfo)pathInfo2) == null) continue;
                            pathInfo = result$iv;
                            break block3;
                        }
                        pathInfo = null;
                    }
                    return pathInfo;
                }
                {
                    this.$fileProcessor = function2;
                    super(2);
                }
            };
            Function1<OrderRootType, PathInfo> findInProjectSdkOrInAll$ = new Function1<OrderRootType, PathInfo>(fileProcessor, project2){
                final /* synthetic */ Function2 $fileProcessor;
                final /* synthetic */ Project $project;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final PathInfo invoke(@NotNull OrderRootType rootType) {
                    PathInfo pathInfo;
                    block6: {
                        PathInfo pathInfo2;
                        block4: {
                            void $receiver$iv;
                            PathInfo pathInfo3;
                            PathInfo projectSdk;
                            Function1 inSdkFinder2;
                            block5: {
                                Intrinsics.checkParameterIsNotNull((Object)rootType, (String)"rootType");
                                inSdkFinder2 = (Function1)new Function1<Sdk, PathInfo>(this, rootType){
                                    final /* synthetic */ findInLibrariesAndSdk.2 this$0;
                                    final /* synthetic */ OrderRootType $rootType;

                                    @Nullable
                                    public final PathInfo invoke(@NotNull Sdk sdk) {
                                        PathInfo pathInfo;
                                        block1: {
                                            Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
                                            Object[] $receiver$iv = sdk.getRootProvider().getFiles(this.$rootType);
                                            for (int j = 0; j < $receiver$iv.length; ++j) {
                                                Object file$iv = $receiver$iv[j];
                                                VirtualFile it = (VirtualFile)file$iv;
                                                Function2 function2 = this.this$0.$fileProcessor;
                                                VirtualFile virtualFile = it;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                                                PathInfo result$iv = (PathInfo)function2.invoke((Object)virtualFile, null);
                                                if (result$iv == null) continue;
                                                pathInfo = result$iv;
                                                break block1;
                                            }
                                            pathInfo = null;
                                        }
                                        return pathInfo;
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$rootType = orderRootType;
                                        super(1);
                                    }
                                };
                                projectSdk = ProjectRootManager.getInstance((Project)this.$project).getProjectSdk();
                                pathInfo = projectSdk;
                                if (pathInfo == null) break block5;
                                pathInfo3 = pathInfo;
                                pathInfo = (PathInfo)inSdkFinder2.invoke((Object)pathInfo3);
                                if (pathInfo != null) break block6;
                            }
                            pathInfo3 = (PathInfo)ProjectJdkTable.getInstance().getAllJdks();
                            for (int j = 0; j < ((void)$receiver$iv).length; ++j) {
                                PathInfo result$iv;
                                PathInfo pathInfo4;
                                void file$iv = $receiver$iv[j];
                                Sdk it = (Sdk)file$iv;
                                if (it == projectSdk) {
                                    pathInfo4 = null;
                                } else {
                                    Sdk sdk = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)sdk, (String)"it");
                                    pathInfo4 = result$iv = (PathInfo)inSdkFinder2.invoke((Object)sdk);
                                }
                                if (result$iv == null) continue;
                                pathInfo2 = result$iv;
                                break block4;
                            }
                            pathInfo2 = null;
                        }
                        pathInfo = pathInfo2;
                    }
                    return pathInfo;
                }
                {
                    this.$fileProcessor = function2;
                    this.$project = project2;
                    super(1);
                }
            };
            Object[] objectArray = rootTypes;
            for (int j = 0; j < ((void)$receiver$iv).length; ++j) {
                void file$iv = $receiver$iv[j];
                OrderRootType rootType = (OrderRootType)file$iv;
                PathInfo result$iv = (PathInfo)ApplicationManager.getApplication().runReadAction(new Computable<T>(rootType, findInLibraryTable$, project2, findInProjectSdkOrInAll$, fileProcessor){
                    final /* synthetic */ OrderRootType $rootType$inlined;
                    final /* synthetic */ findInLibrariesAndSdk.1 $findInLibraryTable$inlined;
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ findInLibrariesAndSdk.2 $findInProjectSdkOrInAll$inlined;
                    final /* synthetic */ Function2 $fileProcessor$inlined;

                    public final T compute() {
                        PathInfo pathInfo;
                        PathInfo pathInfo2;
                        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(this.$project$inlined);
                        Intrinsics.checkExpressionValueIsNotNull((Object)libraryTable, (String)"LibraryTablesRegistrar.g\u2026.getLibraryTable(project)");
                        PathInfo pathInfo3 = this.$findInLibraryTable$inlined.invoke(libraryTable, this.$rootType$inlined);
                        if (pathInfo3 == null) {
                            pathInfo3 = pathInfo2 = this.$findInProjectSdkOrInAll$inlined.invoke(this.$rootType$inlined);
                        }
                        if (pathInfo3 == null) {
                            PathInfo pathInfo4;
                            block6: {
                                Object[] $receiver$iv = ModuleManager.getInstance((Project)this.$project$inlined).getModules();
                                for (int j = 0; j < $receiver$iv.length; ++j) {
                                    PathInfo result$iv;
                                    PathInfo pathInfo5;
                                    Object file$iv = $receiver$iv[j];
                                    Module it = (Module)file$iv;
                                    if (it.isDisposed()) {
                                        pathInfo5 = null;
                                    } else {
                                        Module module2 = it;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"it");
                                        pathInfo5 = result$iv = DefaultWebServerRootsProviderKt.access$findInModuleLevelLibraries(module2, this.$rootType$inlined, this.$fileProcessor$inlined);
                                    }
                                    if (result$iv == null) continue;
                                    pathInfo4 = result$iv;
                                    break block6;
                                }
                                pathInfo4 = null;
                            }
                            pathInfo2 = pathInfo = (PathInfo)pathInfo4;
                        }
                        if (pathInfo2 == null) {
                            LibraryTable libraryTable2 = LibraryTablesRegistrar.getInstance().getLibraryTable();
                            Intrinsics.checkExpressionValueIsNotNull((Object)libraryTable2, (String)"LibraryTablesRegistrar.getInstance().libraryTable");
                            pathInfo = this.$findInLibraryTable$inlined.invoke(libraryTable2, this.$rootType$inlined);
                        }
                        return (T)pathInfo;
                    }
                    {
                        this.$rootType$inlined = orderRootType;
                        this.$findInLibraryTable$inlined = var2_2;
                        this.$project$inlined = project2;
                        this.$findInProjectSdkOrInAll$inlined = var4_4;
                        this.$fileProcessor$inlined = function2;
                    }
                });
                if (result$iv == null) continue;
                pathInfo = result$iv;
                break block1;
            }
            pathInfo = null;
        }
        return pathInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static final PathInfo findInModuleLevelLibraries(Module module2, OrderRootType rootType, Function2<? super VirtualFile, ? super Module, PathInfo> fileProcessor) {
        PathInfo pathInfo;
        block5: {
            Object[] $receiver$iv = ProjectKt.getRootManager(module2).getOrderEntries();
            for (int j = 0; j < $receiver$iv.length; ++j) {
                PathInfo result$iv;
                PathInfo pathInfo2;
                Object file$iv = $receiver$iv[j];
                OrderEntry it = (OrderEntry)file$iv;
                if (it instanceof LibraryOrderEntry && ((LibraryOrderEntry)it).isModuleLevel()) {
                    PathInfo pathInfo3;
                    block4: {
                        void $receiver$iv2;
                        Object[] objectArray = it.getFiles(rootType);
                        for (int k = 0; k < ((void)$receiver$iv2).length; ++k) {
                            VirtualFile it2;
                            void file$iv2 = $receiver$iv2[k];
                            VirtualFile virtualFile = it2 = (VirtualFile)file$iv2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                            PathInfo result$iv2 = (PathInfo)fileProcessor.invoke((Object)virtualFile, (Object)module2);
                            if (result$iv2 == null) continue;
                            pathInfo3 = result$iv2;
                            break block4;
                        }
                        pathInfo3 = null;
                    }
                    pathInfo2 = pathInfo3;
                } else {
                    pathInfo2 = result$iv = (PathInfo)null;
                }
                if (result$iv == null) continue;
                pathInfo = result$iv;
                break block5;
            }
            pathInfo = null;
        }
        return pathInfo;
    }

    @Nullable
    public static final /* synthetic */ PathInfo access$findByRelativePath(@NotNull String path, @NotNull VirtualFile[] roots, @NotNull FileResolver resolver, @Nullable String moduleName) {
        return DefaultWebServerRootsProviderKt.findByRelativePath(path, roots, resolver, moduleName);
    }

    @Nullable
    public static final /* synthetic */ PathInfo access$findInModuleLibraries(@NotNull String path, @NotNull Module module2, @NotNull FileResolver resolver) {
        return DefaultWebServerRootsProviderKt.findInModuleLibraries(path, module2, resolver);
    }

    @Nullable
    public static final /* synthetic */ String access$getModuleNameQualifier(@NotNull Project project2, @Nullable Module module2) {
        return DefaultWebServerRootsProviderKt.getModuleNameQualifier(project2, module2);
    }

    @Nullable
    public static final /* synthetic */ PathInfo access$findInLibraries(@NotNull Project project2, @NotNull String path, @NotNull FileResolver resolver) {
        return DefaultWebServerRootsProviderKt.findInLibraries(project2, path, resolver);
    }

    @Nullable
    public static final /* synthetic */ PathInfo access$getInfoForDocJar(@NotNull VirtualFile file2, @NotNull Project project2) {
        return DefaultWebServerRootsProviderKt.getInfoForDocJar(file2, project2);
    }

    @Nullable
    public static final /* synthetic */ PathInfo access$findInModuleLevelLibraries(@NotNull Module module2, @NotNull OrderRootType rootType, @NotNull Function2 fileProcessor) {
        return DefaultWebServerRootsProviderKt.findInModuleLevelLibraries(module2, rootType, (Function2<? super VirtualFile, ? super Module, PathInfo>)fileProcessor);
    }

    @Nullable
    public static final /* synthetic */ OrderRootType access$getJavadocOrderRootType() {
        return DefaultWebServerRootsProviderKt.getJavadocOrderRootType();
    }
}

