/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManagerKt;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0014J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u000fJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u000fJ\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\tR-\u0010\u0007\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u000e\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\u000f0\u000f\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager;", "", "application", "Lcom/intellij/openapi/application/Application;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/application/Application;Lcom/intellij/openapi/project/Project;)V", "pathToInfoCache", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/builtInWebServer/PathInfo;", "getPathToInfoCache", "()Lcom/google/common/cache/Cache;", "virtualFileToPathInfo", "Lcom/intellij/openapi/vfs/VirtualFile;", "clearCache", "", "doFindByRelativePath", "path", "doFindByRelativePath$built_in_server", "findVirtualFile", "cacheResult", "", "getPath", "file", "getPathInfo", "child", "getResolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "Companion", "built-in-server"})
public final class WebServerPathToFileManager {
    @NotNull
    private final Cache<String, PathInfo> pathToInfoCache;
    private final Cache<VirtualFile, PathInfo> virtualFileToPathInfo;
    private final Project project;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Cache<String, PathInfo> getPathToInfoCache() {
        return this.pathToInfoCache;
    }

    private final void clearCache() {
        this.pathToInfoCache.invalidateAll();
        this.virtualFileToPathInfo.invalidateAll();
    }

    @JvmOverloads
    @Nullable
    public final VirtualFile findVirtualFile(@NotNull String path, boolean cacheResult) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        PathInfo pathInfo = this.getPathInfo(path, cacheResult);
        if (pathInfo == null) {
            return null;
        }
        PathInfo pathInfo2 = pathInfo;
        VirtualFile virtualFile = pathInfo2.getFile();
        if (virtualFile == null) {
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            Path path2 = pathInfo2.getIoFile();
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            virtualFile = localFileSystem.findFileByPath(PathKt.getSystemIndependentPath(path2));
        }
        return virtualFile;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ VirtualFile findVirtualFile$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVirtualFile");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return webServerPathToFileManager.findVirtualFile(string, bl);
    }

    @JvmOverloads
    @Nullable
    public VirtualFile findVirtualFile(@NotNull String path) {
        return WebServerPathToFileManager.findVirtualFile$default(this, path, false, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final PathInfo getPathInfo(@NotNull String path, boolean cacheResult) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        PathInfo pathInfo = (PathInfo)this.pathToInfoCache.getIfPresent((Object)path);
        if (pathInfo == null || !pathInfo.isValid()) {
            pathInfo = this.doFindByRelativePath$built_in_server(path);
            if (cacheResult && pathInfo != null && pathInfo.isValid()) {
                this.pathToInfoCache.put((Object)path, (Object)pathInfo);
            }
        }
        return pathInfo;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ PathInfo getPathInfo$default(WebServerPathToFileManager webServerPathToFileManager, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPathInfo");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return webServerPathToFileManager.getPathInfo(string, bl);
    }

    @JvmOverloads
    @Nullable
    public PathInfo getPathInfo(@NotNull String path) {
        return WebServerPathToFileManager.getPathInfo$default(this, path, false, 2, null);
    }

    @Nullable
    public final String getPath(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        PathInfo pathInfo = this.getPathInfo(file2);
        return pathInfo != null ? pathInfo.getPath() : null;
    }

    @Nullable
    public final PathInfo getPathInfo(@NotNull VirtualFile child) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        PathInfo result2 = (PathInfo)this.virtualFileToPathInfo.getIfPresent((Object)child);
        if (result2 == null) {
            PathInfo pathInfo;
            block3: {
                Object[] $receiver$iv = WebServerRootsProvider.EP_NAME.getExtensions();
                for (int j = 0; j < $receiver$iv.length; ++j) {
                    Object file$iv = $receiver$iv[j];
                    WebServerRootsProvider it = (WebServerRootsProvider)file$iv;
                    PathInfo result$iv = it.getPathInfo(child, this.project);
                    if (result$iv == null) continue;
                    pathInfo = result$iv;
                    break block3;
                }
                pathInfo = null;
            }
            result2 = pathInfo;
            if (result2 != null) {
                this.virtualFileToPathInfo.put((Object)child, (Object)result2);
            }
        }
        return result2;
    }

    @Nullable
    public final PathInfo doFindByRelativePath$built_in_server(@NotNull String path) {
        PathInfo result2;
        block3: {
            PathInfo pathInfo;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Object[] $receiver$iv = WebServerRootsProvider.EP_NAME.getExtensions();
                for (int j = 0; j < $receiver$iv.length; ++j) {
                    Object file$iv = $receiver$iv[j];
                    WebServerRootsProvider it = (WebServerRootsProvider)file$iv;
                    PathInfo result$iv = it.resolve(path, this.project);
                    if (result$iv == null) continue;
                    pathInfo = result$iv;
                    break block2;
                }
                pathInfo = null;
            }
            PathInfo pathInfo2 = pathInfo;
            if (pathInfo2 == null) {
                return null;
            }
            result2 = pathInfo2;
            VirtualFile virtualFile = result2.getFile();
            if (virtualFile == null) break block3;
            VirtualFile virtualFile2 = virtualFile;
            VirtualFile it = virtualFile2;
            this.virtualFileToPathInfo.put((Object)it, (Object)result2);
        }
        return result2;
    }

    @NotNull
    public final FileResolver getResolver(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        CharSequence charSequence = path;
        return charSequence.length() == 0 ? WebServerPathToFileManagerKt.access$getEMPTY_PATH_RESOLVER$p() : WebServerPathToFileManagerKt.access$getRELATIVE_PATH_RESOLVER$p();
    }

    public WebServerPathToFileManager(@NotNull Application application, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        Cache cache = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(10L, TimeUnit.MINUTES).build();
        if (cache == null) {
            Intrinsics.throwNpe();
        }
        this.pathToInfoCache = cache;
        this.virtualFileToPathInfo = CacheBuilder.newBuilder().maximumSize(512L).expireAfterAccess(11L, TimeUnit.MINUTES).build();
        application.getMessageBus().connect((Disposable)this.project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                block0: for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent) {
                        VirtualFile file2 = ((VFileContentChangeEvent)vFileEvent).getFile();
                        WebServerRootsProvider[] webServerRootsProviderArray = (WebServerRootsProvider[])WebServerRootsProvider.EP_NAME.getExtensions();
                        for (int j = 0; j < webServerRootsProviderArray.length; ++j) {
                            WebServerRootsProvider rootsProvider = webServerRootsProviderArray[j];
                            if (!rootsProvider.isClearCacheOnFileContentChanged(file2)) continue;
                            this.clearCache();
                            continue block0;
                        }
                        continue;
                    }
                    this.clearCache();
                    break;
                }
            }
        });
        this.project.getMessageBus().connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                this.clearCache();
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final WebServerPathToFileManager getInstance(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/builtInWebServer/WebServerPathToFileManager;", "project", "Lcom/intellij/openapi/project/Project;", "built-in-server"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final WebServerPathToFileManager getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Object object = ServiceManager.getService((Project)project2, WebServerPathToFileManager.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (WebServerPathToFileManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

