/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkListener;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugProcessImpl$WhenMappings;
import org.jetbrains.debugger.ExecutionStackView;
import org.jetbrains.debugger.LineBreakpointHandler;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.MultiVmDebugProcess;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.SuspendContextView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u00032\u00020\u0004B9\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010R\u001a\u00020S2\u0006\u0010N\u001a\u00020\u0017H\u0004J\u0010\u0010T\u001a\u00020S2\u0006\u0010N\u001a\u00020\u0017H\u0014J\b\u0010U\u001a\u00020'H\u0016J\u0006\u0010V\u001a\u00020'J\u0016\u0010W\u001a\b\u0012\u0002\b\u0003\u0018\u00010X2\u0006\u0010Y\u001a\u000207H\u0015J\u001e\u0010W\u001a\b\u0012\u0002\b\u0003\u0018\u00010X2\u0006\u0010N\u001a\u00020\u00172\u0006\u0010Y\u001a\u000207H\u0014J\u0017\u0010Z\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H$\u00a2\u0006\u0002\u0010\u0013J\b\u0010[\u001a\u00020BH\u0014J\u0010\u0010\\\u001a\u00020S2\u0006\u0010]\u001a\u00020'H\u0014JA\u0010^\u001a8\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u001e*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u0011 \u001e*\u001c\u0012\u0016\b\u0001\u0012\u0012\u0012\u0002\b\u0003 \u001e*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010\u00a2\u0006\u0002\u0010\u0013J\r\u0010_\u001a\t\u0018\u00010`\u00a2\u0006\u0002\baJ\u000b\u0010b\u001a\u00070c\u00a2\u0006\u0002\b\u001fJ\u0006\u0010d\u001a\u00020\tJ\u001a\u0010e\u001a\b\u0012\u0004\u0012\u00020g0f2\n\u0010h\u001a\u0006\u0012\u0002\b\u00030iH\u0017J\"\u0010e\u001a\b\u0012\u0004\u0012\u00020g0f2\u0006\u0010N\u001a\u00020\u00172\n\u0010h\u001a\u0006\u0012\u0002\b\u00030iH\u0016J\f\u0010j\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bJ\u0010\u0010k\u001a\u00020'2\u0006\u0010]\u001a\u00020'H\u0004J\u0015\u0010l\u001a\u00020S2\u0006\u0010m\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010nJ\b\u0010o\u001a\u00020'H\u0016J\u0006\u0010p\u001a\u00020'J\b\u0010q\u001a\u00020'H\u0014J'\u0010r\u001a\u00020S2\u001c\u0010s\u001a\u0018\u0012\u0004\u0012\u00020u\u0012\b\u0012\u0006\u0012\u0002\b\u00030i\u0012\u0004\u0012\u00020S0tH\u0084\bJ\u0012\u0010v\u001a\u00020S2\b\u0010w\u001a\u0004\u0018\u00010PH\u0016J\u0010\u0010v\u001a\u00020S2\u0006\u0010N\u001a\u00020\u0017H\u0016J\u0016\u0010x\u001a\u00020S2\u0006\u0010y\u001a\u00020J2\u0006\u0010z\u001a\u00020KJ\u0014\u0010{\u001a\u00020S2\n\u0010w\u001a\u0006\u0012\u0002\b\u00030|H\u0004J\u0010\u0010}\u001a\u00020S2\b\u0010w\u001a\u0004\u0018\u00010PJ\u0006\u0010~\u001a\u00020SJ\u0010\u0010\u007f\u001a\u00020S2\b\u0010w\u001a\u0004\u0018\u00010PJ\u0011\u0010\u0080\u0001\u001a\u00020S2\b\u0010w\u001a\u0004\u0018\u00010PJ\u0011\u0010\u0081\u0001\u001a\u00020S2\b\u0010w\u001a\u0004\u0018\u00010PJ\u0011\u0010\u0082\u0001\u001a\u00020S2\u0006\u0010N\u001a\u00020\u0017H\u0002R$\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00108BX\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u0015\u0012\f\u0012\n \u001e*\u0004\u0018\u00018\u00008\u00000\u001d\u00a2\u0006\u0002\b\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u001e\u0010&\u001a\u00020'8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001e\u0010.\u001a\u00020'8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010)\"\u0004\b/\u0010+R \u00100\u001a\u0004\u0018\u0001018\u0004@\u0004X\u0085\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R \u00106\u001a\u0004\u0018\u0001078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0013\u0010<\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0019R\u001a\u0010>\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010)\"\u0004\b@\u0010+R\u0016\u0010A\u001a\u0004\u0018\u00010B8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0014\u0010E\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010H\u001a\u000e\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020K0IX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010MR\u0013\u0010N\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\bO\u0010\u0019R\u0017\u0010N\u001a\u00020\u0017*\u0004\u0018\u00010P8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010Q\u00a8\u0006\u0083\u0001"}, d2={"Lorg/jetbrains/debugger/DebugProcessImpl;", "C", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lcom/intellij/xdebugger/XDebugProcess;", "Lorg/jetbrains/debugger/MultiVmDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "connection", "editorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "smartStepIntoHandler", "Lcom/intellij/xdebugger/stepping/XSmartStepIntoHandler;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "(Lcom/intellij/xdebugger/XDebugSession;Lorg/jetbrains/debugger/connection/VmConnection;Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;Lcom/intellij/xdebugger/stepping/XSmartStepIntoHandler;Lcom/intellij/execution/ExecutionResult;)V", "_breakpointHandlers", "", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "get_breakpointHandlers", "()[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "_breakpointHandlers$delegate", "Lkotlin/Lazy;", "activeOrMainVm", "Lorg/jetbrains/debugger/Vm;", "getActiveOrMainVm", "()Lorg/jetbrains/debugger/Vm;", "breakpointsInitiated", "Ljava/util/concurrent/atomic/AtomicBoolean;", "childConnections", "Lcom/intellij/util/containers/ConcurrentList;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getChildConnections", "()Lcom/intellij/util/containers/ConcurrentList;", "connectedListenerAdded", "getConnection", "()Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/connection/VmConnection;", "disableDoNotStepIntoLibraries", "", "getDisableDoNotStepIntoLibraries", "()Z", "setDisableDoNotStepIntoLibraries", "(Z)V", "getExecutionResult", "()Lcom/intellij/execution/ExecutionResult;", "isForceStep", "setForceStep", "lastCallFrame", "Lorg/jetbrains/debugger/CallFrame;", "getLastCallFrame", "()Lorg/jetbrains/debugger/CallFrame;", "setLastCallFrame", "(Lorg/jetbrains/debugger/CallFrame;)V", "lastStep", "Lorg/jetbrains/debugger/StepAction;", "getLastStep", "()Lorg/jetbrains/debugger/StepAction;", "setLastStep", "(Lorg/jetbrains/debugger/StepAction;)V", "mainVm", "getMainVm", "processBreakpointConditionsAtIdeSide", "getProcessBreakpointConditionsAtIdeSide", "setProcessBreakpointConditionsAtIdeSide", "realProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "getRealProcessHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "repeatStepInto", "getRepeatStepInto", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "urlToFileCache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/util/Url;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getUrlToFileCache", "()Ljava/util/concurrent/ConcurrentMap;", "vm", "getVm", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "(Lcom/intellij/xdebugger/frame/XSuspendContext;)Lorg/jetbrains/debugger/Vm;", "addChildVm", "", "beforeInitBreakpoints", "checkCanInitBreakpoints", "checkCanPerformCommands", "continueVm", "Lorg/jetbrains/concurrency/Promise;", "stepAction", "createBreakpointHandlers", "doGetProcessHandler", "doInitBreakpoints", "setBreakpoints", "getBreakpointHandlers", "getCurrentStateHyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "Lorg/jetbrains/annotations/Nullable;", "getCurrentStateMessage", "", "getEditorsProvider", "getLocationsForBreakpoint", "", "Lorg/jetbrains/debugger/Location;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "getSmartStepIntoHandler", "initBreakpoints", "initChildConnection", "childConnection", "(Lorg/jetbrains/debugger/connection/VmConnection;)V", "isLibraryFrameFilterSupported", "isValuesCustomSorted", "isVmStepOutCorrect", "processBreakpoints", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/debugger/LineBreakpointHandler;", "resume", "context", "saveResolvedFile", "url", "file", "setOverlay", "Lorg/jetbrains/debugger/SuspendContext;", "startForceStepInto", "startPausing", "startStepInto", "startStepOut", "startStepOver", "updateLastCallFrame", "script-debugger-ui"})
public abstract class DebugProcessImpl<C extends VmConnection<?>>
extends XDebugProcess
implements MultiVmDebugProcess {
    @NotNull
    private final AtomicBoolean repeatStepInto;
    @Nullable
    private volatile StepAction lastStep;
    @Nullable
    private volatile CallFrame lastCallFrame;
    private volatile boolean isForceStep;
    private volatile boolean disableDoNotStepIntoLibraries;
    @NotNull
    private final ConcurrentMap<Url, VirtualFile> urlToFileCache;
    private boolean processBreakpointConditionsAtIdeSide;
    private final AtomicBoolean connectedListenerAdded;
    private final AtomicBoolean breakpointsInitiated;
    private final Lazy _breakpointHandlers$delegate;
    @NotNull
    private final ConcurrentList<C> childConnections;
    @NotNull
    private final C connection;
    private final XDebuggerEditorsProvider editorsProvider;
    private final XSmartStepIntoHandler<?> smartStepIntoHandler;
    @Nullable
    private final ExecutionResult executionResult;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @NotNull
    protected final AtomicBoolean getRepeatStepInto() {
        return this.repeatStepInto;
    }

    @Nullable
    public final StepAction getLastStep() {
        return this.lastStep;
    }

    public final void setLastStep(@Nullable StepAction stepAction) {
        this.lastStep = stepAction;
    }

    @Nullable
    protected final CallFrame getLastCallFrame() {
        return this.lastCallFrame;
    }

    protected final void setLastCallFrame(@Nullable CallFrame callFrame) {
        this.lastCallFrame = callFrame;
    }

    protected final boolean isForceStep() {
        return this.isForceStep;
    }

    protected final void setForceStep(boolean bl) {
        this.isForceStep = bl;
    }

    protected final boolean getDisableDoNotStepIntoLibraries() {
        return this.disableDoNotStepIntoLibraries;
    }

    protected final void setDisableDoNotStepIntoLibraries(boolean bl) {
        this.disableDoNotStepIntoLibraries = bl;
    }

    @NotNull
    protected final ConcurrentMap<Url, VirtualFile> getUrlToFileCache() {
        return this.urlToFileCache;
    }

    public final boolean getProcessBreakpointConditionsAtIdeSide() {
        return this.processBreakpointConditionsAtIdeSide;
    }

    public final void setProcessBreakpointConditionsAtIdeSide(boolean bl) {
        this.processBreakpointConditionsAtIdeSide = bl;
    }

    private final XBreakpointHandler<?>[] get_breakpointHandlers() {
        Lazy lazy = this._breakpointHandlers$delegate;
        DebugProcessImpl debugProcessImpl = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (XBreakpointHandler[])lazy.getValue();
    }

    @Nullable
    protected final ProcessHandler getRealProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        return executionResult != null ? executionResult.getProcessHandler() : null;
    }

    @Nullable
    public final XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.smartStepIntoHandler;
    }

    public final XBreakpointHandler<?>[] getBreakpointHandlers() {
        XBreakpointHandler[] xBreakpointHandlerArray;
        switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$0[((VmConnection)this.connection).getState().getStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                xBreakpointHandlerArray = XBreakpointHandler.EMPTY_ARRAY;
                break;
            }
            default: {
                xBreakpointHandlerArray = this.get_breakpointHandlers();
            }
        }
        return xBreakpointHandlerArray;
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    @Nullable
    public final Vm getVm() {
        return ((VmConnection)this.connection).getVm();
    }

    @Override
    @Nullable
    public final Vm getMainVm() {
        return ((VmConnection)this.connection).getVm();
    }

    @Override
    @Nullable
    public final Vm getActiveOrMainVm() {
        Object object;
        XSuspendContext xSuspendContext = this.getSession().getSuspendContext();
        Object object2 = xSuspendContext != null ? xSuspendContext.getActiveExecutionStack() : null;
        if (!(object2 instanceof ExecutionStackView)) {
            object2 = null;
        }
        if ((object = (ExecutionStackView)((Object)object2)) == null || (object = ((ExecutionStackView)((Object)object)).getSuspendContext()) == null || (object = object.getVm()) == null) {
            object = this.getMainVm();
        }
        return object;
    }

    @NotNull
    public final ConcurrentList<C> getChildConnections() {
        return this.childConnections;
    }

    @NotNull
    protected abstract XBreakpointHandler<?>[] createBreakpointHandlers();

    private final void updateLastCallFrame(Vm vm) {
        SuspendContext<? extends CallFrame> suspendContext = vm.getSuspendContextManager().getContext();
        this.lastCallFrame = suspendContext != null ? suspendContext.getTopFrame() : null;
    }

    public final boolean checkCanPerformCommands() {
        return this.getActiveOrMainVm() != null;
    }

    public final boolean isValuesCustomSorted() {
        return true;
    }

    public final void startStepOver(@Nullable XSuspendContext context) {
        Vm vm = this.getVm(context);
        this.updateLastCallFrame(vm);
        this.continueVm(vm, StepAction.OVER);
    }

    @NotNull
    public final Vm getVm(@Nullable XSuspendContext $receiver) {
        Object object;
        XSuspendContext xSuspendContext = $receiver;
        if (!(xSuspendContext instanceof SuspendContextView)) {
            xSuspendContext = null;
        }
        if (((object = (SuspendContextView)xSuspendContext) == null || (object = ((SuspendContextView)((Object)object)).getActiveExecutionStack()) == null || (object = ((ExecutionStackView)((Object)object)).getSuspendContext()) == null || (object = object.getVm()) == null) && (object = this.getMainVm()) == null) {
            Intrinsics.throwNpe();
        }
        return object;
    }

    public final void startForceStepInto(@Nullable XSuspendContext context) {
        this.isForceStep = true;
        this.startStepInto(context);
    }

    public final void startStepInto(@Nullable XSuspendContext context) {
        Vm vm = this.getVm(context);
        this.updateLastCallFrame(vm);
        this.continueVm(vm, StepAction.IN);
    }

    public final void startStepOut(@Nullable XSuspendContext context) {
        Vm vm = this.getVm(context);
        if (this.isVmStepOutCorrect()) {
            this.lastCallFrame = null;
        } else {
            this.updateLastCallFrame(vm);
        }
        this.continueVm(vm, StepAction.OUT);
    }

    protected boolean isVmStepOutCorrect() {
        return true;
    }

    public void resume(@Nullable XSuspendContext context) {
        this.continueVm(this.getVm(context), StepAction.CONTINUE);
    }

    public void resume(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        this.continueVm(vm, StepAction.CONTINUE);
    }

    @Deprecated(message="Pass vm explicitly", replaceWith=@ReplaceWith(expression="continueVm(vm!!, stepAction)", imports={}))
    @Nullable
    protected Promise<?> continueVm(@NotNull StepAction stepAction) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stepAction), (String)"stepAction");
        Vm vm = this.getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        return this.continueVm(vm, stepAction);
    }

    @Nullable
    protected Promise<?> continueVm(@NotNull Vm vm, @NotNull StepAction stepAction) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull((Object)((Object)stepAction), (String)"stepAction");
        SuspendContextManager<? extends CallFrame> suspendContextManager = vm.getSuspendContextManager();
        if (stepAction == StepAction.CONTINUE) {
            if (suspendContextManager.getContext() == null) {
                return null;
            }
            this.lastStep = null;
            this.lastCallFrame = null;
            this.urlToFileCache.clear();
            this.disableDoNotStepIntoLibraries = false;
        } else {
            this.lastStep = stepAction;
        }
        return SuspendContextManager.DefaultImpls.continueVm$default(suspendContextManager, stepAction, 0, 2, null);
    }

    protected final void setOverlay(@NotNull SuspendContext<?> context) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Vm vm = this.getMainVm();
        if (Intrinsics.areEqual((Object)context.getVm(), (Object)vm)) {
            vm.getSuspendContextManager().setOverlayMessage("Paused in debugger");
        }
    }

    public final void startPausing() {
        Vm vm = this.getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        Promise<?> promise2 = vm.getSuspendContextManager().suspend();
        XDebugSession xDebugSession = this.getSession();
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
        promise2.rejected((Consumer)new RejectErrorReporter(xDebugSession, "Cannot pause"));
    }

    @NotNull
    public final String getCurrentStateMessage() {
        return ((VmConnection)this.connection).getState().getMessage();
    }

    @Nullable
    public final HyperlinkListener getCurrentStateHyperlinkListener() {
        return ((VmConnection)this.connection).getState().getMessageLinkListener();
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ExecutionResult executionResult = this.executionResult;
        if (executionResult == null || (executionResult = executionResult.getProcessHandler()) == null) {
            executionResult = (ProcessHandler)new DefaultDebugProcessHandler(){

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return executionResult;
    }

    public final void saveResolvedFile(@NotNull Url url, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.urlToFileCache.putIfAbsent(url, file2);
    }

    @NotNull
    public List<Location> getLocationsForBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Vm vm = this.getActiveOrMainVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        return this.getLocationsForBreakpoint(vm, breakpoint);
    }

    @NotNull
    public List<Location> getLocationsForBreakpoint(@NotNull Vm vm, @NotNull XLineBreakpoint<?> breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        throw (Throwable)new UnsupportedOperationException();
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    public boolean checkCanInitBreakpoints() {
        if (Intrinsics.areEqual((Object)((Object)((VmConnection)this.connection).getState().getStatus()), (Object)((Object)ConnectionStatus.CONNECTED))) {
            return this.initBreakpoints(false);
        }
        if (this.connectedListenerAdded.compareAndSet(false, true)) {
            ((VmConnection)this.connection).stateChanged((Function1<ConnectionState, Unit>)((Function1)new Function1<ConnectionState, Unit>(this){
                final /* synthetic */ DebugProcessImpl this$0;

                public final void invoke(@NotNull ConnectionState it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (Intrinsics.areEqual((Object)((Object)it.getStatus()), (Object)((Object)ConnectionStatus.CONNECTED))) {
                        this.this$0.initBreakpoints(true);
                    }
                }
                {
                    this.this$0 = debugProcessImpl;
                    super(1);
                }
            }));
        }
        return false;
    }

    protected final boolean initBreakpoints(boolean setBreakpoints) {
        if (this.breakpointsInitiated.compareAndSet(false, true)) {
            this.doInitBreakpoints(setBreakpoints);
            return true;
        }
        return false;
    }

    protected void doInitBreakpoints(boolean setBreakpoints) {
        if (setBreakpoints) {
            Vm vm = this.getMainVm();
            if (vm == null) {
                Intrinsics.throwNpe();
            }
            this.beforeInitBreakpoints(vm);
            ApplicationManager.getApplication().runReadAction(new Computable<T>(this){
                final /* synthetic */ DebugProcessImpl this$0;

                public final T compute() {
                    this.this$0.getSession().initBreakpoints();
                    return (T)Unit.INSTANCE;
                }
                {
                    this.this$0 = debugProcessImpl;
                }
            });
        }
    }

    protected void beforeInitBreakpoints(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
    }

    /*
     * WARNING - void declaration
     */
    protected final void addChildVm(@NotNull Vm vm) {
        Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
        this.beforeInitBreakpoints(vm);
        DebugProcessImpl this_$iv = this;
        XBreakpointManager breakpointManager$iv = XDebuggerManager.getInstance((Project)this_$iv.getSession().getProject()).getBreakpointManager();
        XBreakpointHandler<?>[] xBreakpointHandlerArray = this_$iv.getBreakpointHandlers();
        for (int j = 0; j < xBreakpointHandlerArray.length; ++j) {
            XBreakpointHandler<?> breakpointHandler$iv = xBreakpointHandlerArray[j];
            if (!(breakpointHandler$iv instanceof LineBreakpointHandler)) continue;
            Collection breakpoints$iv = (Collection)ApplicationManager.getApplication().runReadAction(new Computable<T>(breakpointManager$iv, breakpointHandler$iv){
                final /* synthetic */ XBreakpointManager $breakpointManager$inlined;
                final /* synthetic */ XBreakpointHandler $breakpointHandler$inlined;

                public final T compute() {
                    return (T)this.$breakpointManager$inlined.getBreakpoints(((LineBreakpointHandler)this.$breakpointHandler$inlined).getBreakpointTypeClass());
                }
                {
                    this.$breakpointManager$inlined = xBreakpointManager;
                    this.$breakpointHandler$inlined = xBreakpointHandler;
                }
            });
            for (XLineBreakpoint breakpoint$iv : breakpoints$iv) {
                void breakpoint;
                Intrinsics.checkExpressionValueIsNotNull((Object)breakpoint$iv, (String)"breakpoint");
                LineBreakpointHandler handler2 = (LineBreakpointHandler)breakpointHandler$iv;
                handler2.getManager$script_debugger_ui().setBreakpoint(vm, (XLineBreakpoint<?>)breakpoint);
            }
        }
    }

    protected void initChildConnection(@NotNull C childConnection) {
        Intrinsics.checkParameterIsNotNull(childConnection, (String)"childConnection");
        this.childConnections.add(childConnection);
        ((VmConnection)childConnection).stateChanged((Function1<ConnectionState, Unit>)((Function1)new Function1<ConnectionState, Unit>(this, childConnection){
            final /* synthetic */ DebugProcessImpl this$0;
            final /* synthetic */ VmConnection $childConnection;

            public final void invoke(@NotNull ConnectionState it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)((Object)it.getStatus()), (Object)((Object)ConnectionStatus.CONNECTION_FAILED)) || Intrinsics.areEqual((Object)((Object)it.getStatus()), (Object)((Object)ConnectionStatus.DISCONNECTED)) || Intrinsics.areEqual((Object)((Object)it.getStatus()), (Object)((Object)ConnectionStatus.DETACHED))) {
                    this.this$0.getChildConnections().remove((Object)this.$childConnection);
                }
            }
            {
                this.this$0 = debugProcessImpl;
                this.$childConnection = vmConnection;
                super(1);
            }
        }));
    }

    protected final void processBreakpoints(@NotNull Function2<? super LineBreakpointHandler, ? super XLineBreakpoint<?>, Unit> processor2) {
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)this.getSession().getProject()).getBreakpointManager();
        XBreakpointHandler<?>[] xBreakpointHandlerArray = this.getBreakpointHandlers();
        for (int j = 0; j < xBreakpointHandlerArray.length; ++j) {
            XBreakpointHandler<?> breakpointHandler = xBreakpointHandlerArray[j];
            if (!(breakpointHandler instanceof LineBreakpointHandler)) continue;
            Collection breakpoints = (Collection)ApplicationManager.getApplication().runReadAction(new Computable<T>(breakpointManager, breakpointHandler){
                final /* synthetic */ XBreakpointManager $breakpointManager$inlined;
                final /* synthetic */ XBreakpointHandler $breakpointHandler$inlined;

                public final T compute() {
                    return (T)this.$breakpointManager$inlined.getBreakpoints(((LineBreakpointHandler)this.$breakpointHandler$inlined).getBreakpointTypeClass());
                }
                {
                    this.$breakpointManager$inlined = xBreakpointManager;
                    this.$breakpointHandler$inlined = xBreakpointHandler;
                }
            });
            Iterator iterator = breakpoints.iterator();
            while (iterator.hasNext()) {
                XLineBreakpoint breakpoint;
                XLineBreakpoint xLineBreakpoint = breakpoint = (XLineBreakpoint)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint, (String)"breakpoint");
                processor2.invoke(breakpointHandler, (Object)xLineBreakpoint);
            }
        }
    }

    @NotNull
    public final C getConnection() {
        return this.connection;
    }

    @Nullable
    protected final ExecutionResult getExecutionResult() {
        return this.executionResult;
    }

    public DebugProcessImpl(@NotNull XDebugSession session2, @NotNull C connection, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XSmartStepIntoHandler<?> smartStepIntoHandler, @Nullable ExecutionResult executionResult) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull(connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)editorsProvider, (String)"editorsProvider");
        super(session2);
        this.connection = connection;
        this.editorsProvider = editorsProvider;
        this.smartStepIntoHandler = smartStepIntoHandler;
        this.executionResult = executionResult;
        this.repeatStepInto = new AtomicBoolean();
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap<Url, VirtualFile>()");
        this.urlToFileCache = concurrentMap;
        this.connectedListenerAdded = new AtomicBoolean();
        this.breakpointsInitiated = new AtomicBoolean();
        this._breakpointHandlers$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<XBreakpointHandler<?>[]>(this){
            final /* synthetic */ DebugProcessImpl this$0;

            @NotNull
            public final XBreakpointHandler<?>[] invoke() {
                return this.this$0.createBreakpointHandlers();
            }
            {
                this.this$0 = debugProcessImpl;
                super(0);
            }
        }));
        this.childConnections = ContainerUtil.createConcurrentList();
        ((VmConnection)this.connection).stateChanged((Function1<ConnectionState, Unit>)((Function1)new Function1<ConnectionState, Unit>(){

            public final void invoke(@NotNull ConnectionState it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                switch (DebugProcessImpl$WhenMappings.$EnumSwitchMapping$1[it.getStatus().ordinal()]) {
                    case 1: 
                    case 2: {
                        if (Intrinsics.areEqual((Object)((Object)it.getStatus()), (Object)((Object)ConnectionStatus.DETACHED)) && this.getRealProcessHandler() != null) {
                            this.getProcessHandler().detachProcess();
                        }
                        this.getSession().stop();
                        break;
                    }
                    case 3: {
                        this.getSession().reportError(it.getMessage());
                        this.getSession().stop();
                        break;
                    }
                    default: {
                        this.getSession().rebuildViews();
                    }
                }
            }
        }));
    }

    public /* synthetic */ DebugProcessImpl(XDebugSession xDebugSession, VmConnection vmConnection, XDebuggerEditorsProvider xDebuggerEditorsProvider, XSmartStepIntoHandler xSmartStepIntoHandler, ExecutionResult executionResult, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            xSmartStepIntoHandler = null;
        }
        if ((n & 0x10) != 0) {
            executionResult = null;
        }
        this(xDebugSession, vmConnection, xDebuggerEditorsProvider, xSmartStepIntoHandler, executionResult);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DebugProcessImpl.class), "_breakpointHandlers", "get_breakpointHandlers()[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;"))};
    }
}

