/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.NettyKt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiRequestKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010J \u0010\u0015\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\u001cR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "", "requestId", "", "allocator", "Lio/netty/buffer/ByteBufAllocator;", "(ILio/netty/buffer/ByteBufAllocator;)V", "buffer", "Lio/netty/buffer/ByteBuf;", "getRequestId", "()I", "addHeader", "", "key", "", "value", "", "writeFileHeaders", "pathInfo", "Lorg/jetbrains/builtInWebServer/PathInfo;", "canonicalRequestPath", "writeHeader", "type", "length", "writeHeaders", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "clientChannel", "Lio/netty/channel/Channel;", "writeToServerChannel", "content", "fastCgiChannel", "built-in-server"})
public final class FastCgiRequest {
    private ByteBuf buffer;
    private final int requestId;

    public final void writeFileHeaders(@NotNull PathInfo pathInfo, @NotNull CharSequence canonicalRequestPath) {
        Intrinsics.checkParameterIsNotNull((Object)pathInfo, (String)"pathInfo");
        Intrinsics.checkParameterIsNotNull((Object)canonicalRequestPath, (String)"canonicalRequestPath");
        VirtualFile root = pathInfo.getRoot();
        this.addHeader("DOCUMENT_ROOT", FileUtil.toSystemDependentName((String)root.getPath()));
        this.addHeader("SCRIPT_FILENAME", pathInfo.getFilePath());
        this.addHeader("SCRIPT_NAME", canonicalRequestPath);
    }

    public final void addHeader(@NotNull String key2, @Nullable CharSequence value) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        if (value == null) {
            return;
        }
        int keyLength = key2.length();
        int valLength = value.length();
        ByteBuf byteBuf = this.buffer;
        if (byteBuf == null) {
            Intrinsics.throwNpe();
        }
        this.writeHeader(byteBuf, FastCgiRequestKt.access$getPARAMS$p(), keyLength + valLength + (keyLength < 128 ? 1 : 4) + (valLength < 128 ? 1 : 4));
        if (keyLength < 128) {
            ByteBuf byteBuf2 = this.buffer;
            if (byteBuf2 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf2.writeByte(keyLength);
        } else {
            ByteBuf byteBuf3 = this.buffer;
            if (byteBuf3 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf3.writeByte(0x80 | keyLength >> 24);
            ByteBuf byteBuf4 = this.buffer;
            if (byteBuf4 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf4.writeByte(keyLength >> 16);
            ByteBuf byteBuf5 = this.buffer;
            if (byteBuf5 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf5.writeByte(keyLength >> 8);
            ByteBuf byteBuf6 = this.buffer;
            if (byteBuf6 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf6.writeByte(keyLength);
        }
        if (valLength < 128) {
            ByteBuf byteBuf7 = this.buffer;
            if (byteBuf7 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf7.writeByte(valLength);
        } else {
            ByteBuf byteBuf8 = this.buffer;
            if (byteBuf8 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf8.writeByte(0x80 | valLength >> 24);
            ByteBuf byteBuf9 = this.buffer;
            if (byteBuf9 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf9.writeByte(valLength >> 16);
            ByteBuf byteBuf10 = this.buffer;
            if (byteBuf10 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf10.writeByte(valLength >> 8);
            ByteBuf byteBuf11 = this.buffer;
            if (byteBuf11 == null) {
                Intrinsics.throwNpe();
            }
            byteBuf11.writeByte(valLength);
        }
        ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)key2);
        ByteBuf byteBuf12 = this.buffer;
        if (byteBuf12 == null) {
            Intrinsics.throwNpe();
        }
        NettyKt.writeUtf8(byteBuf12, value);
    }

    public final void writeHeaders(@NotNull FullHttpRequest request, @NotNull Channel clientChannel) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)clientChannel, (String)"clientChannel");
        this.addHeader("REQUEST_URI", request.uri());
        this.addHeader("REQUEST_METHOD", request.method().name());
        SocketAddress socketAddress = clientChannel.remoteAddress();
        if (socketAddress == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress remote = (InetSocketAddress)socketAddress;
        this.addHeader("REMOTE_ADDR", remote.getAddress().getHostAddress());
        this.addHeader("REMOTE_PORT", Integer.toString(remote.getPort()));
        SocketAddress socketAddress2 = clientChannel.localAddress();
        if (socketAddress2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.InetSocketAddress");
        }
        InetSocketAddress local = (InetSocketAddress)socketAddress2;
        this.addHeader("SERVER_SOFTWARE", Responses.getServerHeaderValue());
        this.addHeader("SERVER_NAME", Responses.getServerHeaderValue());
        this.addHeader("SERVER_ADDR", local.getAddress().getHostAddress());
        this.addHeader("SERVER_PORT", Integer.toString(local.getPort()));
        this.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader("SERVER_PROTOCOL", request.protocolVersion().text());
        this.addHeader("REDIRECT_STATUS", "200");
        String queryString = "";
        int queryIndex = StringsKt.indexOf$default((CharSequence)request.uri(), (char)'?', (int)0, (boolean)false, (int)6, null);
        if (queryIndex != -1) {
            object = request.uri();
            int n = queryIndex + 1;
            String string = object;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            queryString = string2;
        }
        this.addHeader("QUERY_STRING", queryString);
        this.addHeader("CONTENT_LENGTH", String.valueOf(request.content().readableBytes()));
        Iterator iterator = request.headers().iteratorAsString();
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String string;
            Locale locale;
            Object object2 = object = (Map.Entry)iterator2.next();
            String key2 = (String)object2.getKey();
            Object object3 = object;
            String value = (String)object3.getValue();
            if (StringsKt.equals((String)key2, (String)"keep-alive", (boolean)true)) continue;
            StringBuilder stringBuilder = new StringBuilder().append("HTTP_");
            object3 = StringsKt.replace$default((String)key2, (char)'-', (char)'_', (boolean)false, (int)4, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.ENGLISH, (String)"Locale.ENGLISH");
            StringBuilder stringBuilder2 = stringBuilder;
            FastCgiRequest fastCgiRequest = this;
            Object object4 = object3;
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object4).toUpperCase(locale), (String)"(this as java.lang.String).toUpperCase(locale)");
            fastCgiRequest.addHeader(stringBuilder2.append(string).toString(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeToServerChannel(@Nullable ByteBuf content, @NotNull Channel fastCgiChannel) {
        block12: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)fastCgiChannel, (String)"fastCgiChannel");
            if (fastCgiChannel.pipeline().first() == null) {
                throw (Throwable)new IllegalStateException("No handler in the pipeline");
            }
            boolean releaseContent = content != null;
            try {
                ByteBuf byteBuf = this.buffer;
                if (byteBuf == null) {
                    Intrinsics.throwNpe();
                }
                this.writeHeader(byteBuf, FastCgiRequestKt.access$getPARAMS$p(), 0);
                if (content != null) {
                    ByteBuf byteBuf2 = this.buffer;
                    if (byteBuf2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.writeHeader(byteBuf2, FastCgiRequestKt.access$getSTDIN$p(), content.readableBytes());
                }
                fastCgiChannel.write((Object)this.buffer);
                this.buffer = null;
                if (content != null) {
                    ByteBuf headerBuffer;
                    fastCgiChannel.write((Object)content);
                    releaseContent = false;
                    ByteBuf byteBuf3 = headerBuffer = fastCgiChannel.alloc().ioBuffer(8, 8);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf3, (String)"headerBuffer");
                    this.writeHeader(byteBuf3, FastCgiRequestKt.access$getSTDIN$p(), 0);
                    fastCgiChannel.write((Object)headerBuffer);
                }
                if (!releaseContent) break block12;
                bl = content != null;
            }
            catch (Throwable throwable) {
                if (releaseContent) {
                    boolean bl2 = content != null;
                    if (_Assertions.ENABLED && !bl2) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    ByteBuf byteBuf = content;
                    if (byteBuf == null) {
                        Intrinsics.throwNpe();
                    }
                    byteBuf.release();
                }
                throw throwable;
            }
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            ByteBuf byteBuf = content;
            if (byteBuf == null) {
                Intrinsics.throwNpe();
            }
            byteBuf.release();
        }
        fastCgiChannel.flush();
    }

    private final void writeHeader(ByteBuf buffer, int type, int length) {
        buffer.writeByte(FastCgiRequestKt.access$getVERSION$p());
        buffer.writeByte(type);
        buffer.writeShort(this.requestId);
        buffer.writeShort(length);
        buffer.writeZero(2);
    }

    public final int getRequestId() {
        return this.requestId;
    }

    public FastCgiRequest(int requestId, @NotNull ByteBufAllocator allocator) {
        Intrinsics.checkParameterIsNotNull((Object)allocator, (String)"allocator");
        this.requestId = requestId;
        ByteBuf byteBuf = this.buffer = allocator.ioBuffer(4096);
        if (byteBuf == null) {
            Intrinsics.throwNpe();
        }
        this.writeHeader(byteBuf, FastCgiRequestKt.access$getBEGIN_REQUEST$p(), 8);
        ByteBuf byteBuf2 = this.buffer;
        if (byteBuf2 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf2.writeShort(FastCgiRequestKt.access$getRESPONDER$p());
        ByteBuf byteBuf3 = this.buffer;
        if (byteBuf3 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf3.writeByte(FastCgiRequestKt.access$getFCGI_KEEP_CONNECTION$p());
        ByteBuf byteBuf4 = this.buffer;
        if (byteBuf4 == null) {
            Intrinsics.throwNpe();
        }
        byteBuf4.writeZero(5);
    }
}

