/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class FilterPattern {
    private static final Logger LOG = Logger.getInstance((String)"#FilterPattern");
    private static final Set<String> loggerNames = new THashSet();
    private String fieldName;
    private String fieldType;
    private String methodName;
    private String methodType;
    private boolean constantField;
    private boolean staticModifier;
    private boolean transientModifier;
    private boolean enumField;
    private boolean loggers;
    private Pattern methodNamePattern;
    private Pattern methodTypePattern;
    private Pattern fieldNamePattern;
    private Pattern fieldTypePattern;

    public boolean fieldMatches(PsiField field) {
        if (this.isConstantField() && PsiAdapter.isConstantField(field)) {
            return true;
        }
        if (this.isEnumField() && PsiAdapter.isEnumField(field)) {
            return true;
        }
        if (this.isStaticModifier() && field.hasModifierProperty("static")) {
            return true;
        }
        if (this.isTransientModifier() && field.hasModifierProperty("transient")) {
            return true;
        }
        Pattern fieldNamePattern = this.getFieldNamePattern();
        if (fieldNamePattern != null && fieldNamePattern.matcher(field.getName()).matches()) {
            return true;
        }
        String typeText = field.getType().getCanonicalText();
        Pattern fieldTypePattern = this.getFieldTypePattern();
        if (fieldTypePattern != null && fieldTypePattern.matcher(typeText).matches()) {
            return true;
        }
        return this.isLoggers() && loggerNames.contains(typeText);
    }

    public boolean methodMatches(@NotNull PsiMethod method2) {
        if (method2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/java/generate/config/FilterPattern", "methodMatches"));
        }
        String methodName = method2.getName();
        Pattern methodNamePattern = this.getMethodNamePattern();
        if (methodNamePattern != null && methodNamePattern.matcher(methodName).matches()) {
            return true;
        }
        PsiType returnType = method2.getReturnType();
        if (returnType == null) {
            return false;
        }
        Pattern patternTypePattern = this.getMethodTypePattern();
        String methodType = returnType.getCanonicalText();
        return patternTypePattern != null && this.methodTypePattern.matcher(methodType).matches();
    }

    public Pattern getFieldNamePattern() {
        if (StringUtil.isEmpty((String)this.fieldName)) {
            return null;
        }
        if (this.fieldNamePattern == null) {
            try {
                this.fieldNamePattern = Pattern.compile(this.fieldName);
            }
            catch (PatternSyntaxException e) {
                this.fieldName = null;
                LOG.warn(e.getMessage());
            }
        }
        return this.fieldNamePattern;
    }

    public void setFieldName(String regexp) {
        this.fieldName = regexp;
    }

    public boolean isConstantField() {
        return this.constantField;
    }

    public void setConstantField(boolean constantField) {
        this.constantField = constantField;
    }

    public boolean isTransientModifier() {
        return this.transientModifier;
    }

    public void setTransientModifier(boolean transientModifier) {
        this.transientModifier = transientModifier;
    }

    public boolean isStaticModifier() {
        return this.staticModifier;
    }

    public void setStaticModifier(boolean staticModifier) {
        this.staticModifier = staticModifier;
    }

    public Pattern getMethodNamePattern() {
        if (StringUtil.isEmpty((String)this.methodName)) {
            return null;
        }
        if (this.methodNamePattern == null) {
            try {
                this.methodNamePattern = Pattern.compile(this.methodName);
            }
            catch (PatternSyntaxException e) {
                this.methodName = null;
                LOG.warn(e.getMessage());
            }
        }
        return this.methodNamePattern;
    }

    public void setMethodName(String regexp) {
        this.methodName = regexp;
    }

    public boolean isEnumField() {
        return this.enumField;
    }

    public void setEnumField(boolean enumField) {
        this.enumField = enumField;
    }

    public boolean isLoggers() {
        return this.loggers;
    }

    public void setLoggers(boolean loggers) {
        this.loggers = loggers;
    }

    public Pattern getFieldTypePattern() {
        if (StringUtil.isEmpty((String)this.fieldType)) {
            return null;
        }
        if (this.fieldTypePattern == null) {
            try {
                this.fieldTypePattern = Pattern.compile(this.fieldType);
            }
            catch (PatternSyntaxException e) {
                this.fieldType = null;
                LOG.warn(e.getMessage());
            }
        }
        return this.fieldTypePattern;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public Pattern getMethodTypePattern() {
        if (StringUtil.isEmpty((String)this.methodType)) {
            return null;
        }
        if (this.methodTypePattern == null) {
            try {
                this.methodTypePattern = Pattern.compile(this.methodType);
            }
            catch (PatternSyntaxException e) {
                this.methodType = null;
                LOG.warn(e.getMessage());
            }
        }
        return this.methodTypePattern;
    }

    public void setMethodType(String methodType) {
        this.methodType = methodType;
    }

    public String toString() {
        return "FilterPattern{fieldName='" + this.fieldName + "'fieldType='" + this.fieldType + "', methodName='" + this.methodName + "', methodType='" + this.methodType + "', constantField=" + this.constantField + ", staticModifier=" + this.staticModifier + ", transientModifier=" + this.transientModifier + ", enumField=" + this.enumField + ", loggers=" + this.loggers + "}";
    }

    static {
        Collections.addAll(loggerNames, "org.apache.log4j.Logger", "java.util.logging.Logger", "org.apache.commons.logging.Log", "org.slf4j.Logger");
    }
}

