/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.gitrepo.ManifestParser;
import org.eclipse.jgit.gitrepo.RepoProject;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class RepoCommand
extends GitCommand<RevCommit> {
    private String path;
    private String uri;
    private String groupsParam;
    private String branch;
    private String targetBranch = "HEAD";
    private boolean recordRemoteBranch = false;
    private boolean recordSubmoduleLabels = false;
    private boolean recordShallowSubmodules = false;
    private PersonIdent author;
    private RemoteReader callback;
    private InputStream inputStream;
    private ManifestParser.IncludedFileReader includedReader;
    private boolean ignoreRemoteFailures = false;
    private List<RepoProject> bareProjects;
    private Git git;
    private ProgressMonitor monitor;

    public RepoCommand(Repository repo) {
        super(repo);
    }

    public RepoCommand setPath(String path) {
        this.path = path;
        return this;
    }

    public RepoCommand setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public RepoCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public RepoCommand setGroups(String groups) {
        this.groupsParam = groups;
        return this;
    }

    public RepoCommand setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public RepoCommand setTargetBranch(String branch) {
        this.targetBranch = "refs/heads/" + branch;
        return this;
    }

    public RepoCommand setRecordRemoteBranch(boolean enable) {
        this.recordRemoteBranch = enable;
        return this;
    }

    public RepoCommand setRecordSubmoduleLabels(boolean enable) {
        this.recordSubmoduleLabels = enable;
        return this;
    }

    public RepoCommand setRecommendShallow(boolean enable) {
        this.recordShallowSubmodules = enable;
        return this;
    }

    public RepoCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public RepoCommand setIgnoreRemoteFailures(boolean ignore) {
        this.ignoreRemoteFailures = ignore;
        return this;
    }

    public RepoCommand setAuthor(PersonIdent author) {
        this.author = author;
        return this;
    }

    public RepoCommand setRemoteReader(RemoteReader callback) {
        this.callback = callback;
        return this;
    }

    public RepoCommand setIncludedFileReader(ManifestParser.IncludedFileReader reader) {
        this.includedReader = reader;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws GitAPIException {
        try {
            this.checkCallable();
            if (this.uri == null) throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
            if (this.uri.length() == 0) {
                throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
            }
            if (this.inputStream == null) {
                if (this.path == null) throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
                if (this.path.length() == 0) {
                    throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
                }
                try {
                    this.inputStream = new FileInputStream(this.path);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
                }
            }
            if (this.repo.isBare()) {
                this.bareProjects = new ArrayList<RepoProject>();
                if (this.author == null) {
                    this.author = new PersonIdent(this.repo);
                }
                if (this.callback == null) {
                    this.callback = new DefaultRemoteReader();
                }
            } else {
                this.git = new Git(this.repo);
            }
            ManifestParser parser = new ManifestParser(this.includedReader, this.path, this.branch, this.uri, this.groupsParam, this.repo);
            try {
                parser.read(this.inputStream);
                for (RepoProject proj : parser.getFilteredProjects()) {
                    this.addSubmodule(proj.getUrl(), proj.getPath(), proj.getRevision(), proj.getCopyFiles(), proj.getGroups(), proj.getRecommendShallow());
                }
            }
            catch (IOException | GitAPIException e) {
                throw new ManifestErrorException(e);
            }
        }
        finally {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException parser) {}
        }
        if (!this.repo.isBare()) return this.git.commit().setMessage(RepoText.get().repoCommitMessage).call();
        DirCache index = DirCache.newInCore();
        DirCacheBuilder builder = index.builder();
        ObjectInserter inserter = this.repo.newObjectInserter();
        try (RevWalk rw = new RevWalk(this.repo);){
            Config cfg = new Config();
            StringBuilder attributes = new StringBuilder();
            for (RepoProject proj : this.bareProjects) {
                ObjectId objectId;
                String name = proj.getPath();
                String nameUri = proj.getName();
                if (ObjectId.isId(proj.getRevision()) && !this.ignoreRemoteFailures) {
                    objectId = ObjectId.fromString(proj.getRevision());
                } else {
                    objectId = this.callback.sha1(nameUri, proj.getRevision());
                    if (objectId == null) {
                        if (!this.ignoreRemoteFailures) throw new RemoteUnavailableException(nameUri);
                        continue;
                    }
                    if (this.recordRemoteBranch) {
                        cfg.setString("submodule", name, "branch", proj.getRevision());
                    }
                    if (this.recordShallowSubmodules && proj.getRecommendShallow() != null) {
                        cfg.setBoolean("submodule", name, "shallow", true);
                    }
                }
                if (this.recordSubmoduleLabels) {
                    StringBuilder rec = new StringBuilder();
                    rec.append("/");
                    rec.append(name);
                    for (String group : proj.getGroups()) {
                        rec.append(" ");
                        rec.append(group);
                    }
                    rec.append("\n");
                    attributes.append(rec.toString());
                }
                cfg.setString("submodule", name, "path", name);
                cfg.setString("submodule", name, "url", nameUri);
                DirCacheEntry dcEntry = new DirCacheEntry(name);
                dcEntry.setObjectId(objectId);
                dcEntry.setFileMode(FileMode.GITLINK);
                builder.add(dcEntry);
                for (RepoProject.CopyFile copyfile : proj.getCopyFiles()) {
                    byte[] src = this.callback.readFile(nameUri, proj.getRevision(), copyfile.src);
                    objectId = inserter.insert(3, src);
                    dcEntry = new DirCacheEntry(copyfile.dest);
                    dcEntry.setObjectId(objectId);
                    dcEntry.setFileMode(FileMode.REGULAR_FILE);
                    builder.add(dcEntry);
                }
            }
            String content = cfg.toText();
            DirCacheEntry dcEntry = new DirCacheEntry(".gitmodules");
            ObjectId objectId = inserter.insert(3, content.getBytes("UTF-8"));
            dcEntry.setObjectId(objectId);
            dcEntry.setFileMode(FileMode.REGULAR_FILE);
            builder.add(dcEntry);
            if (this.recordSubmoduleLabels) {
                DirCacheEntry dcEntryAttr = new DirCacheEntry(".gitattributes");
                ObjectId attrId = inserter.insert(3, attributes.toString().getBytes("UTF-8"));
                dcEntryAttr.setObjectId(attrId);
                dcEntryAttr.setFileMode(FileMode.REGULAR_FILE);
                builder.add(dcEntryAttr);
            }
            builder.finish();
            ObjectId treeId = index.writeTree(inserter);
            ObjectId headId = this.repo.resolve(this.targetBranch + "^{commit}");
            CommitBuilder commit = new CommitBuilder();
            commit.setTreeId(treeId);
            if (headId != null) {
                commit.setParentIds(headId);
            }
            commit.setAuthor(this.author);
            commit.setCommitter(this.author);
            commit.setMessage(RepoText.get().repoCommitMessage);
            ObjectId commitId = inserter.insert(commit);
            inserter.flush();
            RefUpdate ru = this.repo.updateRef(this.targetBranch);
            ru.setNewObjectId(commitId);
            ru.setExpectedOldObjectId(headId != null ? headId : ObjectId.zeroId());
            RefUpdate.Result rc = ru.update(rw);
            switch (rc) {
                case NEW: 
                case FORCED: 
                case FAST_FORWARD: {
                    break;
                }
                case REJECTED: 
                case LOCK_FAILURE: {
                    throw new ConcurrentRefUpdateException(MessageFormat.format(JGitText.get().cannotLock, this.targetBranch), ru.getRef(), rc);
                }
                default: {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{this.targetBranch, commitId.name(), rc}));
                }
            }
            RevCommit revCommit = rw.parseCommit(commitId);
            return revCommit;
        }
        catch (IOException e) {
            throw new ManifestErrorException(e);
        }
    }

    private void addSubmodule(String url, String name, String revision, List<RepoProject.CopyFile> copyfiles, Set<String> groups, String recommendShallow) throws GitAPIException, IOException {
        if (this.repo.isBare()) {
            RepoProject proj = new RepoProject(url, name, revision, null, groups, recommendShallow);
            proj.addCopyFiles(copyfiles);
            this.bareProjects.add(proj);
        } else {
            SubmoduleAddCommand add = this.git.submoduleAdd().setPath(name).setURI(url);
            if (this.monitor != null) {
                add.setProgressMonitor(this.monitor);
            }
            Repository subRepo = add.call();
            if (revision != null) {
                try (Git sub = new Git(subRepo);){
                    sub.checkout().setName(RepoCommand.findRef(revision, subRepo)).call();
                }
                subRepo.close();
                this.git.add().addFilepattern(name).call();
            }
            for (RepoProject.CopyFile copyfile : copyfiles) {
                copyfile.copy();
                this.git.add().addFilepattern(copyfile.dest).call();
            }
        }
    }

    private static String findRef(String ref, Repository repo) throws IOException {
        Ref r;
        if (!ObjectId.isId(ref) && (r = repo.exactRef("refs/remotes/origin/" + ref)) != null) {
            return r.getName();
        }
        return ref;
    }

    private static class RemoteUnavailableException
    extends GitAPIException {
        RemoteUnavailableException(String uri) {
            super(MessageFormat.format(RepoText.get().errorRemoteUnavailable, uri));
        }
    }

    private static class ManifestErrorException
    extends GitAPIException {
        ManifestErrorException(Throwable cause) {
            super(RepoText.get().invalidManifest, cause);
        }
    }

    public static class DefaultRemoteReader
    implements RemoteReader {
        @Override
        public ObjectId sha1(String uri, String ref) throws GitAPIException {
            Map<String, Ref> map = Git.lsRemoteRepository().setRemote(uri).callAsMap();
            Ref r = RefDatabase.findRef(map, ref);
            return r != null ? r.getObjectId() : null;
        }

        /*
         * Exception decompiling
         */
        @Override
        public byte[] readFile(String uri, String ref, String path) throws GitAPIException, IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        protected byte[] readFileFromRepo(Repository repo, String ref, String path) throws GitAPIException, IOException {
            try (ObjectReader reader = repo.newObjectReader();){
                ObjectId oid = repo.resolve(ref + ":" + path);
                byte[] byArray = reader.open(oid).getBytes(Integer.MAX_VALUE);
                return byArray;
            }
        }
    }

    public static interface RemoteReader {
        @Nullable
        public ObjectId sha1(String var1, String var2) throws GitAPIException;

        public byte[] readFile(String var1, String var2, String var3) throws GitAPIException, IOException;
    }
}

