/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.io.Flushable;
import java.io.IOException;
import org.fusesource.jansi.Ansi;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.logging.console.ColorMap;
import org.gradle.internal.logging.console.Console;
import org.gradle.internal.logging.console.Label;
import org.gradle.internal.logging.console.TextArea;
import org.gradle.internal.logging.text.AbstractLineChoppingStyledTextOutput;

public class AnsiConsole
implements Console {
    private static final int CHARS_PER_TAB_STOP = 8;
    private final Appendable target;
    private final Flushable flushable;
    private final LabelImpl statusBar;
    private final TextAreaImpl textArea;
    private final ColorMap colorMap;
    private final boolean forceAnsi;
    private final Cursor writeCursor = new Cursor();
    private final Cursor textCursor = new Cursor();
    private final Cursor statusBarCursor = new Cursor();

    public AnsiConsole(Appendable target, Flushable flushable, ColorMap colorMap) {
        this(target, flushable, colorMap, false);
    }

    public AnsiConsole(Appendable target, Flushable flushable, ColorMap colorMap, boolean forceAnsi) {
        this.target = target;
        this.flushable = flushable;
        this.colorMap = colorMap;
        this.textArea = new TextAreaImpl(this.textCursor);
        this.statusBar = new LabelImpl(this.statusBarCursor);
        this.forceAnsi = forceAnsi;
    }

    public void flush() {
        this.statusBar.redraw();
        try {
            this.flushable.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    Ansi createAnsi() {
        if (this.forceAnsi) {
            return new Ansi();
        }
        return Ansi.ansi();
    }

    private void positionCursorAt(Cursor position, Ansi ansi) {
        if (this.writeCursor.row == position.row) {
            if (this.writeCursor.col == position.col) {
                return;
            }
            if (this.writeCursor.col < position.col) {
                ansi.cursorRight(position.col - this.writeCursor.col);
            } else {
                ansi.cursorLeft(this.writeCursor.col - position.col);
            }
        } else {
            if (this.writeCursor.col > 0) {
                ansi.cursorLeft(this.writeCursor.col);
            }
            if (this.writeCursor.row < position.row) {
                ansi.cursorUp(position.row - this.writeCursor.row);
            } else {
                ansi.cursorDown(this.writeCursor.row - position.row);
            }
            if (position.col > 0) {
                ansi.cursorRight(position.col);
            }
        }
        this.writeCursor.copyFrom(position);
    }

    private void charactersWritten(Cursor cursor, int count) {
        this.writeCursor.col += count;
        cursor.copyFrom(this.writeCursor);
    }

    private void newLineWritten(Cursor cursor) {
        this.writeCursor.col = 0;
        if (this.writeCursor.row > 0) {
            --this.writeCursor.row;
        } else {
            this.writeCursor.row = 0;
            ++this.textCursor.row;
            ++this.statusBarCursor.row;
        }
        cursor.copyFrom(this.writeCursor);
    }

    private void write(Ansi ansi) {
        try {
            this.target.append(ansi.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public Label getStatusBar() {
        return this.statusBar;
    }

    public TextArea getMainArea() {
        return this.textArea;
    }

    private class TextAreaImpl
    extends AbstractLineChoppingStyledTextOutput
    implements TextArea {
        private final Cursor writePos;

        public TextAreaImpl(Cursor writePos) {
            this.writePos = writePos;
        }

        protected void doLineText(CharSequence text) {
            if (text.length() == 0) {
                return;
            }
            Ansi ansi = AnsiConsole.this.createAnsi();
            AnsiConsole.this.positionCursorAt(this.writePos, ansi);
            ColorMap.Color color = AnsiConsole.this.colorMap.getColourFor(this.getStyle());
            color.on(ansi);
            String textStr = text.toString();
            int pos = 0;
            while (pos < text.length()) {
                int next = textStr.indexOf(9, pos);
                if (next == pos) {
                    int charsToNextStop = 8 - this.writePos.col % 8;
                    for (int i = 0; i < charsToNextStop; ++i) {
                        ansi.a(" ");
                    }
                    AnsiConsole.this.charactersWritten(this.writePos, charsToNextStop);
                    ++pos;
                    continue;
                }
                if (next > pos) {
                    ansi.a(textStr.substring(pos, next));
                    AnsiConsole.this.charactersWritten(this.writePos, next - pos);
                    pos = next;
                    continue;
                }
                ansi.a(textStr.substring(pos, textStr.length()));
                AnsiConsole.this.charactersWritten(this.writePos, textStr.length() - pos);
                pos = textStr.length();
            }
            color.off(ansi);
            AnsiConsole.this.write(ansi);
        }

        protected void doEndLine(CharSequence endOfLine) {
            Ansi ansi = AnsiConsole.this.createAnsi();
            AnsiConsole.this.positionCursorAt(this.writePos, ansi);
            if (this.writePos.row == ((AnsiConsole)AnsiConsole.this).statusBarCursor.row && ((AnsiConsole)AnsiConsole.this).statusBarCursor.col > this.writePos.col) {
                ansi.eraseLine(Ansi.Erase.FORWARD);
            }
            ansi.newline();
            AnsiConsole.this.write(ansi);
            AnsiConsole.this.newLineWritten(this.writePos);
        }
    }

    private class LabelImpl
    implements Label {
        private final Cursor writePos;
        private String writtenText = "";
        private String text = "";

        public LabelImpl(Cursor writePos) {
            this.writePos = writePos;
        }

        public void setText(String text) {
            if (text.equals(this.text)) {
                return;
            }
            this.text = text;
        }

        public void redraw() {
            boolean hasTextOnBottomLine;
            boolean bl = hasTextOnBottomLine = ((AnsiConsole)AnsiConsole.this).textCursor.row == 0 && ((AnsiConsole)AnsiConsole.this).textCursor.col > 0;
            if (this.writePos.row == 0 && this.writtenText.equals(this.text) && !hasTextOnBottomLine) {
                return;
            }
            Ansi ansi = AnsiConsole.this.createAnsi();
            if (hasTextOnBottomLine) {
                int staleStatusChars = this.writePos.row > 0 ? 0 : this.writtenText.length();
                this.writePos.copyFrom(AnsiConsole.this.textCursor);
                AnsiConsole.this.positionCursorAt(this.writePos, ansi);
                if (staleStatusChars > ((AnsiConsole)AnsiConsole.this).textCursor.col) {
                    ansi.eraseLine(Ansi.Erase.FORWARD);
                }
                ansi.newline();
                AnsiConsole.this.newLineWritten(this.writePos);
                this.writtenText = "";
            } else {
                this.writePos.bottomLeft();
                AnsiConsole.this.positionCursorAt(this.writePos, ansi);
            }
            if (this.text.length() > 0) {
                ColorMap.Color color = AnsiConsole.this.colorMap.getStatusBarColor();
                color.on(ansi);
                ansi.a(this.text);
                color.off(ansi);
            }
            if (this.text.length() < this.writtenText.length()) {
                ansi.eraseLine(Ansi.Erase.FORWARD);
            }
            AnsiConsole.this.write(ansi);
            AnsiConsole.this.charactersWritten(this.writePos, this.text.length());
            this.writtenText = this.text;
        }
    }

    private class Cursor {
        int col;
        int row;

        private Cursor() {
        }

        public void copyFrom(Cursor position) {
            if (position == this) {
                return;
            }
            this.col = position.col;
            this.row = position.row;
        }

        public void bottomLeft() {
            this.col = 0;
            this.row = 0;
        }
    }
}

