/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.tools.idea.editors.gfxtrace.actions.GfxTraceCaptureAction;
import com.android.tools.idea.editors.gfxtrace.gapi.GapiPaths;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import java.awt.Window;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GfxTraceUtil {
    public static void trackEvent(@NotNull String eventAction, @Nullable String eventLabel, @Nullable Integer eventValue) {
        if (eventAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventAction", "com/android/tools/idea/editors/gfxtrace/GfxTraceUtil", "trackEvent"));
        }
        UsageTracker.getInstance().trackEvent("gfxTrace", eventAction, eventLabel, eventValue);
    }

    public static boolean checkAndTryInstallGapidSdkComponent(Project project) {
        if (!GapiPaths.isValid()) {
            Window window = WindowManager.getInstance().suggestParentWindow(project);
            int result = JOptionPane.showConfirmDialog(window, "GPU Tools are not installed, install now?", "GPU Tools Missing", 2);
            if (result != 0) {
                return false;
            }
            Collection<String> missingComponents = GapiPaths.getMissingSdkComponents();
            if (missingComponents.isEmpty()) {
                Logger.getInstance(GfxTraceCaptureAction.class).warn("no valid package to install found");
                return false;
            }
            ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, missingComponents);
            if (dialog == null) {
                Logger.getInstance(GfxTraceCaptureAction.class).warn("this is strange, we got no dialog back from createDialogForPaths");
                return false;
            }
            dialog.setTitle("Install Missing Components");
            if (!dialog.showAndGet()) {
                return false;
            }
        }
        return true;
    }
}

