/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.models;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.UiErrorCallback;
import com.android.tools.idea.editors.gfxtrace.service.ContextID;
import com.android.tools.idea.editors.gfxtrace.service.ContextList;
import com.android.tools.idea.editors.gfxtrace.service.Hierarchy;
import com.android.tools.idea.editors.gfxtrace.service.HierarchyList;
import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomGroup;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomList;
import com.android.tools.idea.editors.gfxtrace.service.atom.Range;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomsPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public class AtomStream
implements PathListener {
    private static final Logger LOG = Logger.getInstance(AtomStream.class);
    private final GfxTraceEditor myEditor;
    private final PathStore<AtomsPath> myAtomsPath = new PathStore();
    private final PathStore<AtomRangePath> myAtomPath = new PathStore();
    private final Listeners myListeners = new Listeners();
    private AtomList myAtomList;
    private HierarchyList myHierarchies;
    private ContextList myContexts;

    public AtomStream(GfxTraceEditor editor) {
        this.myEditor = editor;
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
        if (this.myAtomsPath.updateIfNotNull(CapturePath.atoms(event.findCapturePath()))) {
            this.myListeners.onAtomLoadingStart(this);
            CapturePath capturePath = this.myAtomsPath.getPath().getCapture();
            ListenableFuture<AtomList> atomF = this.myEditor.getClient().get(this.myAtomsPath.getPath());
            ListenableFuture allF = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{atomF, this.loadContexts(capturePath), this.loadHierarchies(capturePath)});
            Rpc.listen((ListenableFuture)allF, (Logger)LOG, (Rpc.Callback)new UiErrorCallback<List<BinaryObject>, LoadData, Void>(){

                @Override
                protected UiErrorCallback.ResultOrError<LoadData, Void> onRpcThread(Rpc.Result<List<BinaryObject>> result) {
                    try {
                        List list = (List)result.get();
                        return this.success(new LoadData((AtomList)list.get(0), (ContextList)list.get(1), (HierarchyList)list.get(2)));
                    }
                    catch (RpcException e) {
                        LOG.error((Throwable)e);
                        return this.error(null);
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                        return this.error(null);
                    }
                }

                @Override
                protected void onUiThreadSuccess(LoadData data) {
                    AtomStream.this.update(data.myAtoms, data.myContexts, data.myHierarchies);
                }

                @Override
                protected void onUiThreadError(Void error) {
                    AtomStream.this.update(null, null, null);
                }
            });
        }
        if (this.myAtomPath.updateIfNotNull(event.findAtomPath())) {
            this.myListeners.onAtomsSelected(this.myAtomPath.getPath());
        }
    }

    private ListenableFuture<ContextList> loadContexts(CapturePath capturePath) {
        if (this.myEditor.getFeatures().hasContextsAndHierachies()) {
            return this.myEditor.getClient().get(capturePath.contexts());
        }
        return Futures.immediateFuture((Object)new ContextList());
    }

    private ListenableFuture<HierarchyList> loadHierarchies(CapturePath capturePath) {
        if (this.myEditor.getFeatures().hasContextsAndHierachies()) {
            return this.myEditor.getClient().get(capturePath.hierarchies());
        }
        return Futures.transform(this.myEditor.getClient().get(capturePath.hierarchy()), (Function)new Function<AtomGroup, HierarchyList>(){

            @Nullable
            public HierarchyList apply(@Nullable AtomGroup root) {
                Hierarchy hierarchy = new Hierarchy().setRoot(root).setContext(ContextID.INVALID);
                return new HierarchyList().setHierarchies(new Hierarchy[]{hierarchy});
            }
        });
    }

    private void update(AtomList atomList, ContextList contexts, HierarchyList hierarchies) {
        this.myAtomList = atomList;
        this.myContexts = contexts;
        this.myHierarchies = hierarchies;
        this.myListeners.onAtomLoadingComplete(this);
    }

    public boolean isLoaded() {
        return this.myAtomList != null && this.myHierarchies != null && this.myContexts != null;
    }

    public AtomsPath getPath() {
        return this.myAtomsPath.getPath();
    }

    public int getAtomCount() {
        return this.myAtomList.getAtoms().length;
    }

    public Atom getAtom(long index) {
        return this.myAtomList.get(index);
    }

    public int getStartOfFrame(long index) {
        Atom[] atoms = this.myAtomList.getAtoms();
        for (int i = (int)index; i > 0; --i) {
            if (!atoms[i - 1].isEndOfFrame()) continue;
            return i;
        }
        return 0;
    }

    public int getEndOfFrame(long index) {
        Atom[] atoms = this.myAtomList.getAtoms();
        for (int i = (int)index; i < atoms.length; ++i) {
            if (!atoms[i].isEndOfFrame()) continue;
            return i;
        }
        return atoms.length - 1;
    }

    public AtomList getAtoms() {
        return this.myAtomList;
    }

    public HierarchyList getHierarchies() {
        return this.myHierarchies;
    }

    public ContextList getContexts() {
        return this.myContexts;
    }

    public AtomRangePath getSelectedAtomsPath() {
        return this.myAtomPath.getPath();
    }

    public void selectAtoms(long from, long count, Object source) {
        AtomsPath path = this.myAtomsPath.getPath();
        if (path != null) {
            this.myEditor.activatePath(path.range(from, count), source);
        }
    }

    public void selectAtoms(Range range, Object source) {
        this.selectAtoms(range.getStart(), range.getCount(), source);
    }

    public Atom getFirstSelectedAtom() {
        AtomRangePath path = this.myAtomPath.getPath();
        return path == null || this.myAtomList == null ? null : this.myAtomList.get(path.getFirst());
    }

    public Atom getLastSelectedAtom() {
        AtomRangePath path = this.myAtomPath.getPath();
        return path == null || this.myAtomList == null ? null : this.myAtomList.get(path.getLast());
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    private static class Listeners
    extends ArrayList<Listener>
    implements Listener {
        @Override
        public void onAtomLoadingStart(AtomStream atoms) {
            for (Listener listener : this.toArray(new Listener[this.size()])) {
                listener.onAtomLoadingStart(atoms);
            }
        }

        @Override
        public void onAtomLoadingComplete(AtomStream atoms) {
            for (Listener listener : this.toArray(new Listener[this.size()])) {
                listener.onAtomLoadingComplete(atoms);
            }
        }

        @Override
        public void onAtomsSelected(AtomRangePath path) {
            for (Listener listener : this.toArray(new Listener[this.size()])) {
                listener.onAtomsSelected(path);
            }
        }

        @Override
        public synchronized <T> T[] toArray(T[] a) {
            return super.toArray(a);
        }

        @Override
        public synchronized boolean add(Listener listener) {
            return super.add(listener);
        }

        @Override
        public synchronized boolean remove(Object o) {
            return super.remove(o);
        }
    }

    public static interface Listener {
        public void onAtomLoadingStart(AtomStream var1);

        public void onAtomLoadingComplete(AtomStream var1);

        public void onAtomsSelected(AtomRangePath var1);
    }

    private class LoadData {
        public final AtomList myAtoms;
        public final ContextList myContexts;
        public final HierarchyList myHierarchies;

        public LoadData(AtomList atoms, ContextList contexts, HierarchyList hierarchies) {
            this.myAtoms = atoms;
            this.myContexts = contexts;
            this.myHierarchies = hierarchies;
        }
    }
}

