/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.atom;

import com.android.tools.idea.editors.gfxtrace.controllers.AtomController;
import com.android.tools.idea.editors.gfxtrace.service.Context;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomList;
import com.android.tools.idea.editors.gfxtrace.service.atom.Range;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Slice;
import com.android.tools.rpclib.schema.Struct;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public final class AtomGroup
implements BinaryObject {
    private String myName;
    private Range myRange;
    private AtomGroup[] mySubGroups;
    private static final Entity ENTITY = new Entity("atom", "Group", "", "");

    public boolean isValid() {
        return this.myRange.isValid();
    }

    public void addChildren(@NotNull DefaultMutableTreeNode parent, @NotNull AtomList atoms, @NotNull Context context) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomGroup", "addChildren"));
        }
        if (atoms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atoms", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomGroup", "addChildren"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomGroup", "addChildren"));
        }
        long next = this.myRange.getStart();
        for (AtomGroup subGroup : this.mySubGroups) {
            atoms.addAtoms(parent, next, subGroup.getRange().getStart(), context);
            DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(new AtomController.Group(subGroup, atoms.get(subGroup.getRange().getLast()), subGroup.getRange().getLast()), true);
            subGroup.addChildren(subNode, atoms, context);
            if (subNode.getChildCount() != 0) {
                parent.add(subNode);
            }
            next = subGroup.getRange().getEnd();
        }
        atoms.addAtoms(parent, next, this.myRange.getEnd(), context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomGroup atomGroup = (AtomGroup)o;
        if (this.myName != null ? !this.myName.equals(atomGroup.myName) : atomGroup.myName != null) {
            return false;
        }
        if (this.myRange != null ? !this.myRange.equals(atomGroup.myRange) : atomGroup.myRange != null) {
            return false;
        }
        return Arrays.equals(this.mySubGroups, atomGroup.mySubGroups);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myRange != null ? this.myRange.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.mySubGroups);
        return result;
    }

    public String toString() {
        return "AtomGroup{name='" + this.myName + '\'' + ", range=" + this.myRange + ", subGroups=" + Arrays.toString(this.mySubGroups) + '}';
    }

    public String getName() {
        return this.myName;
    }

    public AtomGroup setName(String v) {
        this.myName = v;
        return this;
    }

    public Range getRange() {
        return this.myRange;
    }

    public AtomGroup setRange(Range v) {
        this.myRange = v;
        return this;
    }

    public AtomGroup[] getSubGroups() {
        return this.mySubGroups;
    }

    public AtomGroup setSubGroups(AtomGroup[] v) {
        this.mySubGroups = v;
        return this;
    }

    @NotNull
    public BinaryClass klass() {
        Klass klass = Klass.INSTANCE;
        if (klass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomGroup", "klass"));
        }
        return klass;
    }

    public static void register() {
    }

    static /* synthetic */ AtomGroup[] access$302(AtomGroup x0, AtomGroup[] x1) {
        x0.mySubGroups = x1;
        return x1;
    }

    static {
        ENTITY.setFields(new Field[]{new Field("Name", (Type)new Primitive("string", Method.String)), new Field("Range", (Type)new Struct(Range.Klass.INSTANCE.entity())), new Field("SubGroups", (Type)new Slice("GroupList", (Type)new Struct(Klass.INSTANCE.entity())))});
        Namespace.register((BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @NotNull
        public Entity entity() {
            Entity entity = ENTITY;
            if (entity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomGroup$Klass", "entity"));
            }
            return entity;
        }

        @NotNull
        public BinaryObject create() {
            AtomGroup atomGroup = new AtomGroup();
            if (atomGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomGroup$Klass", "create"));
            }
            return atomGroup;
        }

        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomGroup$Klass", "encode"));
            }
            AtomGroup o = (AtomGroup)obj;
            e.string(o.myName);
            e.value((BinaryObject)o.myRange);
            e.uint32((long)o.mySubGroups.length);
            for (int i = 0; i < o.mySubGroups.length; ++i) {
                e.value((BinaryObject)o.mySubGroups[i]);
            }
        }

        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            if (d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/editors/gfxtrace/service/atom/AtomGroup$Klass", "decode"));
            }
            AtomGroup o = (AtomGroup)obj;
            o.myName = d.string();
            o.myRange = new Range();
            d.value((BinaryObject)o.myRange);
            AtomGroup.access$302(o, new AtomGroup[d.uint32()]);
            for (int i = 0; i < o.mySubGroups.length; ++i) {
                ((AtomGroup)o).mySubGroups[i] = new AtomGroup();
                d.value((BinaryObject)o.mySubGroups[i]);
            }
        }
    }
}

