/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.fd.client.InstantRunClient;
import com.android.tools.fd.client.InstantRunPushFailedException;
import com.android.tools.fd.client.UpdateMode;
import com.android.tools.idea.fd.FileChangeListener;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.LogWrapper;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableSet;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.xdebugger.XDebugSession;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstantRunManager
implements ProjectComponent {
    public static final String MINIMUM_GRADLE_PLUGIN_VERSION_STRING = "2.2.2";
    public static final GradleVersion MINIMUM_GRADLE_PLUGIN_VERSION = GradleVersion.parse((String)"2.2.2");
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"InstantRun", (String)ToolWindowId.RUN);
    public static final Logger LOG = Logger.getInstance((String)"#InstantRun");
    public static final ILogger ILOGGER = new LogWrapper(LOG);
    public static final ImmutableSet<String> ALLOWED_MULTI_PROCESSES = ImmutableSet.of((Object)":leakcanary", (Object)":background_crash");
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileChangeListener myFileChangeListener;

    public InstantRunManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunManager", "<init>"));
        }
        this.myProject = project;
        this.myFileChangeListener = new FileChangeListener(project);
        this.myFileChangeListener.setEnabled(InstantRunSettings.isInstantRunEnabled());
    }

    @NotNull
    public static InstantRunManager get(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunManager", "get"));
        }
        InstantRunManager instantRunManager = (InstantRunManager)project.getComponent(InstantRunManager.class);
        if (instantRunManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "get"));
        }
        return instantRunManager;
    }

    @NotNull
    public static AndroidVersion getMinDeviceApiLevel(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/android/tools/idea/fd/InstantRunManager", "getMinDeviceApiLevel"));
        }
        AndroidVersion version = (AndroidVersion)processHandler.getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL);
        AndroidVersion androidVersion = version == null ? AndroidVersion.DEFAULT : version;
        if (androidVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "getMinDeviceApiLevel"));
        }
        return androidVersion;
    }

    public static void transferLocalIdToDeviceId(@NotNull IDevice device, @NotNull InstantRunContext context) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "transferLocalIdToDeviceId"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/fd/InstantRunManager", "transferLocalIdToDeviceId"));
        }
        InstantRunBuildInfo buildInfo = context.getInstantRunBuildInfo();
        assert (buildInfo != null);
        String localTimestamp = buildInfo.getTimeStamp();
        assert (!StringUtil.isEmpty((String)localTimestamp)) : "Unable to detect build timestamp";
        InstantRunClient.transferBuildIdToDevice((IDevice)device, (String)localTimestamp, (String)context.getApplicationId(), (ILogger)ILOGGER);
    }

    public static boolean isInstantRunCapableDeviceVersion(@NotNull AndroidVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/fd/InstantRunManager", "isInstantRunCapableDeviceVersion"));
        }
        return version.getApiLevel() >= 15;
    }

    public static boolean hasLocalCacheOfDeviceData(@NotNull IDevice device, @NotNull InstantRunContext context) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "hasLocalCacheOfDeviceData"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/fd/InstantRunManager", "hasLocalCacheOfDeviceData"));
        }
        InstalledPatchCache cache = context.getInstalledPatchCache();
        return cache.getInstalledManifestResourcesHash(device, context.getApplicationId()) != null;
    }

    @NotNull
    public String getComponentName() {
        if ("InstantRunManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/InstantRunManager", "getComponentName"));
        }
        return "InstantRunManager";
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public FileChangeListener.Changes getChangesAndReset() {
        return this.myFileChangeListener.getChangesAndReset();
    }

    static void updateFileListener(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/InstantRunManager", "updateFileListener"));
        }
        InstantRunManager manager = InstantRunManager.get(project);
        manager.myFileChangeListener.setEnabled(InstantRunSettings.isInstantRunEnabled());
    }

    @Nullable
    public static InstantRunClient getInstantRunClient(@NotNull InstantRunContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/fd/InstantRunManager", "getInstantRunClient"));
        }
        InstantRunBuildInfo buildInfo = context.getInstantRunBuildInfo();
        if (buildInfo == null) {
            return null;
        }
        return new InstantRunClient(context.getApplicationId(), ILOGGER, buildInfo.getSecretToken());
    }

    public UpdateMode pushArtifacts(@NotNull IDevice device, @NotNull InstantRunContext context, @NotNull UpdateMode updateMode) throws InstantRunPushFailedException, IOException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/InstantRunManager", "pushArtifacts"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/fd/InstantRunManager", "pushArtifacts"));
        }
        if (updateMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateMode", "com/android/tools/idea/fd/InstantRunManager", "pushArtifacts"));
        }
        InstantRunClient client = InstantRunManager.getInstantRunClient(context);
        assert (client != null);
        InstantRunBuildInfo instantRunBuildInfo = context.getInstantRunBuildInfo();
        assert (instantRunBuildInfo != null);
        if ((updateMode = client.pushPatches(device, instantRunBuildInfo, updateMode, InstantRunSettings.isRestartActivity(), InstantRunSettings.isShowToastEnabled())) == UpdateMode.HOT_SWAP || updateMode == UpdateMode.WARM_SWAP) {
            this.refreshDebugger(context.getApplicationId());
        }
        return updateMode;
    }

    private void refreshDebugger(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/android/tools/idea/fd/InstantRunManager", "refreshDebugger"));
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                DebuggerManagerEx debugger = DebuggerManagerEx.getInstanceEx((Project)InstantRunManager.this.myProject);
                if (!debugger.getSessions().isEmpty()) {
                    List breakpoints = debugger.getBreakpointManager().getBreakpoints();
                    for (Breakpoint breakpoint : breakpoints) {
                        if (!breakpoint.isEnabled()) continue;
                        breakpoint.setEnabled(false);
                        breakpoint.setEnabled(true);
                    }
                }
            }
        });
        DebuggerManagerEx debugger = DebuggerManagerEx.getInstanceEx((Project)this.myProject);
        for (final DebuggerSession session : debugger.getSessions()) {
            Client client = (Client)session.getProcess().getProcessHandler().getUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT);
            if (client == null || !client.isValid() || !StringUtil.equals((CharSequence)packageName, (CharSequence)client.getClientData().getClientDescription())) continue;
            session.getProcess().getManagerThread().invoke(new DebuggerCommandImpl(){

                protected void action() throws Exception {
                    JavaExecutionStack stack;
                    DebuggerContextImpl context = session.getContextManager().getContext();
                    SuspendContextImpl suspendContext = context.getSuspendContext();
                    if (suspendContext != null && (stack = suspendContext.getActiveExecutionStack()) != null) {
                        stack.initTopFrame();
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            session.refresh(false);
                            XDebugSession xSession = session.getXDebugSession();
                            if (xSession != null) {
                                xSession.resume();
                            }
                        }
                    });
                }
            });
        }
    }
}

