/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.GradleSyncState;
import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    private static final Logger LOG = Logger.getInstance(ProjectSetUpTask.class);
    @NotNull
    private final Project myProject;
    private final boolean myProjectIsNew;
    private final boolean mySelectModulesToImport;
    private final boolean mySyncSkipped;
    @Nullable
    private final GradleSyncListener mySyncListener;

    ProjectSetUpTask(@NotNull Project project, boolean projectIsNew, boolean selectModulesToImport, boolean syncSkipped, @Nullable GradleSyncListener syncListener) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "<init>"));
        }
        this.myProject = project;
        this.myProjectIsNew = projectIsNew;
        this.mySelectModulesToImport = selectModulesToImport;
        this.mySyncSkipped = syncSkipped;
        this.mySyncListener = syncListener;
    }

    public void onSuccess(@Nullable DataNode<ProjectData> projectInfo) {
        assert (projectInfo != null);
        this.populateProject(projectInfo);
        Runnable runnable = () -> {
            boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
            if (!isTest || !GradleProjectImporter.ourSkipSetupFromTest) {
                if (this.myProjectIsNew) {
                    Projects.open(this.myProject);
                }
                if (!isTest) {
                    this.myProject.save();
                }
            }
            if (this.myProjectIsNew) {
                AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(this.myProject);
                projectComponent.configureGradleProject();
            }
            if (this.mySyncListener != null) {
                if (this.mySyncSkipped) {
                    this.mySyncListener.syncSkipped(this.myProject);
                } else {
                    this.mySyncListener.syncSucceeded(this.myProject);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            GuiUtils.invokeLaterIfNeeded((Runnable)runnable, (ModalityState)ModalityState.defaultModalityState());
        }
    }

    private void populateProject(@NotNull DataNode<ProjectData> projectInfo) {
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "populateProject"));
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            if (projectInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "lambda$populateProject$1"));
            }
            Projects.populate(this.myProject, projectInfo, this.mySelectModulesToImport, true);
        });
    }

    public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/ProjectSetUpTask", "onFailure"));
        }
        UIUtil.invokeAndWaitIfNeeded(() -> ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID));
        if (errorDetails != null) {
            LOG.warn(errorDetails);
        }
        String newMessage = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage});
        LOG.info(newMessage);
        GradleProjectSyncData.removeFrom(this.myProject);
        GradleSyncState.getInstance(this.myProject).syncFailed(newMessage);
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, newMessage);
        }
    }
}

