/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.WidgetContainer;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceResolver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintModel;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.TextDirection;
import com.android.tools.sherpa.drawing.decorator.TextWidget;
import com.android.tools.sherpa.drawing.decorator.WidgetDecorator;
import com.android.tools.sherpa.interaction.WidgetInteractionTargets;
import com.android.tools.sherpa.scout.Scout;
import com.android.tools.sherpa.structure.WidgetCompanion;
import com.android.tools.sherpa.structure.WidgetsScene;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintUtilities {
    static final int MINIMUM_SIZE = 48;
    static final int MINIMUM_SIZE_EXPAND = 6;

    @Nullable
    static String getConnectionAttributeMargin(@Nullable ConstraintAnchor anchor) {
        if (anchor != null) {
            switch (anchor.getType()) {
                case LEFT: {
                    return "layout_marginLeft";
                }
                case TOP: {
                    return "layout_marginTop";
                }
                case RIGHT: {
                    return "layout_marginRight";
                }
                case BOTTOM: {
                    return "layout_marginBottom";
                }
            }
        }
        return null;
    }

    @Nullable
    static String getConnectionRtlAttributeMargin(@Nullable ConstraintAnchor anchor) {
        if (anchor != null) {
            switch (anchor.getType()) {
                case LEFT: {
                    return "layout_marginStart";
                }
                case RIGHT: {
                    return "layout_marginEnd";
                }
            }
        }
        return null;
    }

    @Nullable
    static String getConnectionAttribute(@Nullable ConstraintAnchor origin, @Nullable ConstraintAnchor target) {
        String attribute = null;
        if (origin != null && target != null) {
            block0 : switch (origin.getType()) {
                case BASELINE: {
                    if (target.getType() != ConstraintAnchor.Type.BASELINE) break;
                    attribute = "layout_constraintBaseline_toBaselineOf";
                    break;
                }
                case LEFT: {
                    switch (target.getType()) {
                        case LEFT: {
                            attribute = "layout_constraintLeft_toLeftOf";
                            break;
                        }
                        case RIGHT: {
                            attribute = "layout_constraintLeft_toRightOf";
                        }
                    }
                    break;
                }
                case RIGHT: {
                    switch (target.getType()) {
                        case LEFT: {
                            attribute = "layout_constraintRight_toLeftOf";
                            break;
                        }
                        case RIGHT: {
                            attribute = "layout_constraintRight_toRightOf";
                        }
                    }
                    break;
                }
                case TOP: {
                    switch (target.getType()) {
                        case TOP: {
                            attribute = "layout_constraintTop_toTopOf";
                            break;
                        }
                        case BOTTOM: {
                            attribute = "layout_constraintTop_toBottomOf";
                        }
                    }
                    break;
                }
                case BOTTOM: {
                    switch (target.getType()) {
                        case TOP: {
                            attribute = "layout_constraintBottom_toTopOf";
                            break block0;
                        }
                        case BOTTOM: {
                            attribute = "layout_constraintBottom_toBottomOf";
                        }
                    }
                }
            }
        }
        return attribute;
    }

    @Nullable
    static String getConnectionAttributeCreator(@Nullable ConstraintAnchor anchor) {
        if (anchor != null) {
            switch (anchor.getType()) {
                case LEFT: {
                    return "layout_constraintLeft_creator";
                }
                case TOP: {
                    return "layout_constraintTop_creator";
                }
                case RIGHT: {
                    return "layout_constraintRight_creator";
                }
                case BOTTOM: {
                    return "layout_constraintBottom_creator";
                }
                case BASELINE: {
                    return "layout_constraintBaseline_creator";
                }
                case CENTER: {
                    return "layout_constraintCenter_creator";
                }
                case CENTER_X: {
                    return "layout_constraintCenterX_creator";
                }
                case CENTER_Y: {
                    return "layout_constraintCenterY_creator";
                }
            }
        }
        return null;
    }

    public static void resetAnchor(@NotNull AttributesTransaction attributes, @NotNull ConstraintAnchor.Type anchorType) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "resetAnchor"));
        }
        if (anchorType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorType", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "resetAnchor"));
        }
        switch (anchorType) {
            case LEFT: {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf", null);
                attributes.setAttribute("http://schemas.android.com/tools", "layout_constraintLeft_creator", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
                break;
            }
            case TOP: {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf", null);
                attributes.setAttribute("http://schemas.android.com/tools", "layout_constraintTop_creator", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
                break;
            }
            case RIGHT: {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toLeftOf", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf", null);
                attributes.setAttribute("http://schemas.android.com/tools", "layout_constraintRight_creator", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
                break;
            }
            case BOTTOM: {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toTopOf", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf", null);
                attributes.setAttribute("http://schemas.android.com/tools", "layout_constraintBottom_creator", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
                break;
            }
            case BASELINE: {
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
                attributes.setAttribute("http://schemas.android.com/tools", "layout_constraintBaseline_creator", null);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
            }
        }
    }

    public static void setEditorPosition(@Nullable ConstraintWidget widget, @NotNull AttributesTransaction attributes, int x, int y) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setEditorPosition"));
        }
        String attributeX = "layout_editor_absoluteX";
        String attributeY = "layout_editor_absoluteY";
        if (widget != null && ConstraintUtilities.hasHorizontalConstraints(widget)) {
            attributes.setAttribute("http://schemas.android.com/tools", attributeX, null);
        } else {
            String sX = String.format("%ddp", x);
            attributes.setAttribute("http://schemas.android.com/tools", attributeX, sX);
        }
        if (widget != null && ConstraintUtilities.hasVerticalConstraints(widget)) {
            attributes.setAttribute("http://schemas.android.com/tools", attributeY, null);
        } else {
            String sY = String.format("%ddp", y);
            attributes.setAttribute("http://schemas.android.com/tools", attributeY, sY);
        }
    }

    public static void clearEditorPosition(@NotNull AttributesTransaction attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "clearEditorPosition"));
        }
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
    }

    private static boolean hasHorizontalConstraints(@NotNull ConstraintWidget widget) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "hasHorizontalConstraints"));
        }
        ConstraintAnchor left = widget.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor right = widget.getAnchor(ConstraintAnchor.Type.RIGHT);
        return left != null && left.isConnected() || right != null && right.isConnected();
    }

    private static boolean hasVerticalConstraints(@NotNull ConstraintWidget widget) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "hasVerticalConstraints"));
        }
        ConstraintAnchor top = widget.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottom = widget.getAnchor(ConstraintAnchor.Type.BOTTOM);
        ConstraintAnchor baseline = widget.getAnchor(ConstraintAnchor.Type.BASELINE);
        return top != null && top.isConnected() || bottom != null && bottom.isConnected() || baseline != null && baseline.isConnected();
    }

    private static boolean versionGreaterThan(GradleVersion v, int major, int minor, int micro, int beta, int alpha) {
        if (v == null) {
            return true;
        }
        if (v.getMajor() != major) {
            return v.getMajor() > major;
        }
        if (v.getMinor() != minor) {
            return v.getMinor() > minor;
        }
        if (v.getMicro() != micro) {
            return v.getMicro() > micro;
        }
        if (alpha > 0) {
            if ("alpha".equals(v.getPreviewType())) {
                return v.getPreview() > alpha;
            }
            return true;
        }
        if (beta > 0) {
            if ("beta".equals(v.getPreviewType())) {
                return v.getPreview() > beta;
            }
            return true;
        }
        return false;
    }

    private static boolean useParentReference(NlModel model) {
        String constraint_artifact = "com.android.support.constraint:constraint-layout";
        GradleVersion v = model.getModuleDependencyVersion(constraint_artifact);
        return ConstraintUtilities.versionGreaterThan(v, 1, 0, 0, 0, 4);
    }

    private static boolean useGuidelineFloat(NlModel model) {
        String constraint_artifact = "com.android.support.constraint:constraint-layout";
        GradleVersion v = model.getModuleDependencyVersion(constraint_artifact);
        return ConstraintUtilities.versionGreaterThan(v, 1, 0, 0, 0, 5);
    }

    static void setConnection(@NotNull AttributesTransaction attributes, @NotNull ConstraintAnchor anchor) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setConnection"));
        }
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setConnection"));
        }
        ConstraintUtilities.resetAnchor(attributes, anchor.getType());
        String attribute = ConstraintUtilities.getConnectionAttribute(anchor, anchor.getTarget());
        String marginAttribute = ConstraintUtilities.getConnectionAttributeMargin(anchor);
        String marginAttributeRtl = ConstraintUtilities.getConnectionRtlAttributeMargin(anchor);
        if (anchor.isConnected() && attribute != null) {
            NlModel model;
            ConstraintWidget owner = anchor.getOwner();
            WidgetCompanion ownerCompanion = (WidgetCompanion)owner.getCompanionWidget();
            ConstraintWidget target = anchor.getTarget().getOwner();
            WidgetCompanion companion = (WidgetCompanion)target.getCompanionWidget();
            NlComponent targetComponent = (NlComponent)companion.getWidgetModel();
            boolean use_parent_ref = ConstraintUtilities.useParentReference(targetComponent.getModel());
            String targetId = owner.getParent() == target && use_parent_ref ? "parent" : "@+id/" + targetComponent.ensureId();
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", attribute, targetId);
            String margin = ownerCompanion.getWidgetProperties().getMarginValue(anchor);
            String marginRtl = ownerCompanion.getWidgetProperties().getMarginRtlValue(anchor);
            String marginValue = null;
            if (anchor.getMargin() > 0) {
                marginValue = String.format("%ddp", anchor.getMargin());
            }
            if (margin != null && !ownerCompanion.getWidgetProperties().isMarginReference(anchor)) {
                margin = marginValue;
            }
            if (marginRtl != null && !ownerCompanion.getWidgetProperties().isMarginRtlReference(anchor)) {
                marginRtl = marginValue;
            }
            if (ConstraintUtilities.supportsStartEnd(anchor, model = targetComponent.getModel())) {
                if (marginRtl == null) {
                    marginRtl = margin != null ? margin : marginValue;
                }
                if (ConstraintUtilities.requiresRightLeft(model) && margin == null) {
                    margin = marginRtl;
                }
            } else if (margin == null) {
                margin = marginValue;
            }
            if (marginAttribute != null && margin != null) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", marginAttribute, margin);
            }
            if (marginAttributeRtl != null && marginRtl != null) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", marginAttributeRtl, marginRtl);
            }
            String attributeCreator = ConstraintUtilities.getConnectionAttributeCreator(anchor);
            if (anchor.getConnectionCreator() != 0) {
                attributes.setAttribute("http://schemas.android.com/tools", attributeCreator, String.valueOf(anchor.getConnectionCreator()));
            } else {
                attributes.setAttribute("http://schemas.android.com/tools", attributeCreator, null);
            }
        }
    }

    static boolean isRtlMargin(String attribute) {
        return "layout_marginLeft".equals(attribute) || "layout_marginRight".equals(attribute);
    }

    @NotNull
    static String getRtlMarginAttribute(String attribute, TextDirection direction) {
        if ("layout_marginLeft".equals(attribute)) {
            String string = direction.getAttrMarginLeft();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getRtlMarginAttribute"));
            }
            return string;
        }
        if ("layout_marginRight".equals(attribute)) {
            String string = direction.getAttrMarginRight();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getRtlMarginAttribute"));
            }
            return string;
        }
        String string = direction.getAttrMarginLeft();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getRtlMarginAttribute"));
        }
        return string;
    }

    public static void setDimension(@NotNull AttributesTransaction attributes, @NotNull ConstraintWidget widget) {
        String height;
        String width;
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setDimension"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setDimension"));
        }
        switch (widget.getHorizontalDimensionBehaviour()) {
            case ANY: {
                width = "0dp";
                break;
            }
            case WRAP_CONTENT: {
                width = "wrap_content";
                break;
            }
            default: {
                width = String.format("%ddp", widget.getWidth());
            }
        }
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", width);
        switch (widget.getVerticalDimensionBehaviour()) {
            case ANY: {
                height = "0dp";
                break;
            }
            case WRAP_CONTENT: {
                height = "wrap_content";
                break;
            }
            default: {
                height = String.format("%ddp", widget.getHeight());
            }
        }
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", height);
    }

    static void setHorizontalBias(@NotNull AttributesTransaction attributes, @NotNull ConstraintWidget widget) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setHorizontalBias"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setHorizontalBias"));
        }
        float bias = widget.getHorizontalBiasPercent();
        if (bias != 0.5f) {
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", String.valueOf(bias));
        }
    }

    static void setVerticalBias(@NotNull AttributesTransaction component, @NotNull ConstraintWidget widget) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setVerticalBias"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setVerticalBias"));
        }
        float bias = widget.getVerticalBiasPercent();
        if (bias != 0.5f) {
            component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", String.valueOf(bias));
        }
    }

    static void commitGuideline(NlModel model, @NotNull AttributesTransaction component, @NotNull Guideline guideline) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "commitGuideline"));
        }
        if (guideline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guideline", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "commitGuideline"));
        }
        int behaviour = guideline.getRelativeBehaviour();
        WidgetCompanion companion = (WidgetCompanion)guideline.getCompanionWidget();
        component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", null);
        component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", null);
        component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", null);
        component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_Percent", null);
        String previousValue = companion.getWidgetProperties().getGuidelineAttribute();
        if (previousValue != null && !previousValue.startsWith("@")) {
            previousValue = null;
        }
        String value = previousValue;
        if (behaviour == 0) {
            boolean useFloat = ConstraintUtilities.useGuidelineFloat(model);
            if (value == null) {
                float percent = guideline.getRelativePercent();
                value = useFloat ? String.valueOf(percent) : String.valueOf((int)(percent * 100.0f));
            }
            String percentAttribute = useFloat ? "layout_constraintGuide_percent" : "layout_constraintGuide_Percent";
            component.setAttribute("http://schemas.android.com/apk/res-auto", percentAttribute, value);
        } else if (behaviour == 1) {
            if (value == null) {
                value = String.format("%ddp", guideline.getRelativeBegin());
            }
            component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", value);
        } else if (behaviour == 2) {
            if (value == null) {
                value = String.format("%ddp", guideline.getRelativeEnd());
            }
            component.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", value);
        }
    }

    static void setBias(@NotNull String attribute, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setBias"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setBias"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setBias"));
        }
        AttributesTransaction attributes = component.startAttributeTransaction();
        String biasString = attributes.getAttribute("http://schemas.android.com/apk/res-auto", attribute);
        float bias = 0.5f;
        if (biasString != null && biasString.length() > 0) {
            try {
                bias = Float.parseFloat(biasString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (attribute.equalsIgnoreCase("layout_constraintHorizontal_bias")) {
            widget.setHorizontalBiasPercent(bias);
        } else {
            widget.setVerticalBiasPercent(bias);
        }
    }

    static void setDimensionRatio(@NotNull String attribute, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setDimensionRatio"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setDimensionRatio"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setDimensionRatio"));
        }
        AttributesTransaction attributes = component.startAttributeTransaction();
        String dimensionRatioString = attributes.getAttribute("http://schemas.android.com/apk/res-auto", attribute);
        float dimensionRatio = 0.0f;
        if (dimensionRatioString == null || dimensionRatioString.length() == 0) {
            widget.setDimensionRatio(dimensionRatio);
            return;
        }
        int colonIndex = dimensionRatioString.indexOf(58);
        if (colonIndex >= 0 && colonIndex < dimensionRatioString.length() - 1) {
            String nominator = dimensionRatioString.substring(0, colonIndex);
            String denominator = dimensionRatioString.substring(colonIndex + 1);
            if (nominator.length() > 0 && denominator.length() > 0) {
                try {
                    float nominatorValue = Float.parseFloat(nominator);
                    float denominatorValue = Float.parseFloat(denominator);
                    if (denominatorValue > 0.0f) {
                        dimensionRatio = nominatorValue / denominatorValue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        widget.setDimensionRatio(dimensionRatio);
    }

    static void setStartMargin(@Nullable String left, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setStartMargin"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setStartMargin"));
        }
        if (left != null) {
            int margin = ConstraintUtilities.getMargin(component, "layout_marginStart");
            widget.getAnchor(ConstraintAnchor.Type.LEFT).setMargin(margin);
        }
    }

    static void setEndMargin(@Nullable String right, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setEndMargin"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setEndMargin"));
        }
        if (right != null) {
            int margin = ConstraintUtilities.getMargin(component, "layout_marginEnd");
            widget.getAnchor(ConstraintAnchor.Type.RIGHT).setMargin(margin);
        }
    }

    static void setTopMargin(@Nullable String top, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setTopMargin"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setTopMargin"));
        }
        if (top != null) {
            int margin = ConstraintUtilities.getMargin(component, "layout_marginTop");
            widget.getAnchor(ConstraintAnchor.Type.TOP).setMargin(margin);
        }
    }

    static void setBottomMargin(@Nullable String bottom, @NotNull NlComponent component, @NotNull ConstraintWidget widget) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setBottomMargin"));
        }
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setBottomMargin"));
        }
        if (bottom != null) {
            int margin = ConstraintUtilities.getMargin(component, "layout_marginBottom");
            widget.getAnchor(ConstraintAnchor.Type.BOTTOM).setMargin(margin);
        }
    }

    static int getMargin(@NotNull NlComponent component, @NotNull String attr) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getMargin"));
        }
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getMargin"));
        }
        AttributesTransaction attributes = component.startAttributeTransaction();
        String margin = attributes.getAttribute("http://schemas.android.com/apk/res/android", attr);
        if (margin == null) {
            if (attr == "layout_marginStart") {
                margin = attributes.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
            } else if (attr == "layout_marginEnd") {
                margin = attributes.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
            }
        }
        if (margin != null) {
            return ConstraintUtilities.getDpValue(component, margin);
        }
        return 0;
    }

    private static int getDpValue(@NotNull NlComponent component, String value) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getDpValue"));
        }
        if (value != null && (resourceResolver = (configuration = component.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer px = ResourceHelper.resolveDimensionPixelSize((RenderResources)resourceResolver, value, configuration);
            return px == null ? 0 : (int)(0.5f + (float)px.intValue() / ((float)configuration.getDensity().getDpiValue() / 160.0f));
        }
        return 0;
    }

    private static int getLayoutDimensionDpValue(@NotNull NlComponent component, String value) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getLayoutDimensionDpValue"));
        }
        if ("wrap_content".equalsIgnoreCase(value)) {
            return -2;
        }
        if ("match_parent".equalsIgnoreCase(value)) {
            return -1;
        }
        return ConstraintUtilities.getDpValue(component, value);
    }

    static void setTarget(@NotNull NlModel model, @NotNull WidgetsScene widgetsScene, @Nullable String targetID, @Nullable ConstraintWidget widgetSrc, @NotNull ConstraintAnchor.Type constraintA, @NotNull ConstraintAnchor.Type constraintB) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setTarget"));
        }
        if (widgetsScene == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widgetsScene", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setTarget"));
        }
        if (constraintA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintA", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setTarget"));
        }
        if (constraintB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintB", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setTarget"));
        }
        if (targetID == null) {
            return;
        }
        NlComponent componentFound = null;
        ConstraintWidget parent = widgetSrc.getParent();
        if (ConstraintUtilities.useParentReference(model) && targetID.equalsIgnoreCase("parent") && parent != null) {
            WidgetCompanion companion = (WidgetCompanion)parent.getCompanionWidget();
            componentFound = (NlComponent)companion.getWidgetModel();
        } else {
            String id = NlComponent.extractId(targetID);
            if (id == null) {
                return;
            }
            for (NlComponent component : model.getComponents()) {
                NlComponent found = ConstraintUtilities.getComponentFromId(component, id);
                if (found == null) continue;
                componentFound = found;
                break;
            }
        }
        if (componentFound != null) {
            ConstraintWidget widget = widgetsScene.getWidget((Object)componentFound);
            if (widgetSrc != null && widget != null) {
                int connectionCreator = 0;
                WidgetCompanion companion = (WidgetCompanion)widgetSrc.getCompanionWidget();
                NlComponent component = (NlComponent)companion.getWidgetModel();
                String creatorAttribute = ConstraintUtilities.getConnectionAttributeCreator(widgetSrc.getAnchor(constraintA));
                String creatorValue = component.startAttributeTransaction().getAttribute("http://schemas.android.com/tools", creatorAttribute);
                if (creatorValue != null) {
                    try {
                        connectionCreator = Integer.parseInt(creatorValue);
                    }
                    catch (NumberFormatException e) {
                        connectionCreator = 0;
                    }
                }
                if (constraintA == constraintB && constraintA == ConstraintAnchor.Type.BASELINE) {
                    widgetSrc.getAnchor(constraintA).connect(widget.getAnchor(constraintB), 0, ConstraintAnchor.Strength.STRONG, connectionCreator, true);
                } else {
                    widgetSrc.connect(constraintA, widget, constraintB, 0, ConstraintAnchor.Strength.STRONG, connectionCreator);
                }
            }
        }
    }

    @Nullable
    static NlComponent getComponentFromId(@NotNull NlComponent component, @NotNull String id) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getComponentFromId"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getComponentFromId"));
        }
        if (ConstraintUtilities.useParentReference(component.getModel()) && id.equalsIgnoreCase("parent")) {
            return component.getParent();
        }
        if (component.getId() != null && component.getId().equalsIgnoreCase(id)) {
            return component;
        }
        for (NlComponent child : component.getChildren()) {
            NlComponent found = ConstraintUtilities.getComponentFromId(child, id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private static void setMargin(@NotNull ConstraintWidget widget, int margin, @NotNull ConstraintAnchor.Type type) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setMargin"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "setMargin"));
        }
        if (widget.getAnchor(type).isConnected()) {
            widget.getAnchor(type).setMargin(margin);
        }
    }

    static boolean updateWidget(@NotNull ConstraintModel constraintModel, @Nullable ConstraintWidget widget, @Nullable NlComponent component) {
        WidgetDecorator decorator;
        String absoluteY;
        String absoluteX;
        WidgetContainer parentContainer;
        ConstraintWidget parentWidget;
        String absoluteHeight;
        if (constraintModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintModel", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "updateWidget"));
        }
        if (component == null || widget == null) {
            return false;
        }
        AttributesTransaction attributes = component.startAttributeTransaction();
        if (!(widget instanceof Guideline)) {
            widget.setVisibility(component.getAndroidViewVisibility());
        }
        widget.setDebugName(component.getId());
        WidgetsScene scene = constraintModel.getScene();
        Insets padding = component.getPadding(true);
        if (widget instanceof ConstraintWidgetContainer) {
            ((ConstraintWidgetContainer)widget).setPadding(constraintModel.pxToDp(padding.left), constraintModel.pxToDp(padding.top), constraintModel.pxToDp(padding.right), constraintModel.pxToDp(padding.bottom));
        } else {
            widget.setDimension(constraintModel.pxToDp(component.w), constraintModel.pxToDp(component.h));
        }
        String absoluteWidth = attributes.getAttribute("http://schemas.android.com/tools", "layout_conversion_absoluteWidth");
        if (absoluteWidth != null) {
            Configuration configuration = component.getModel().getConfiguration();
            ResourceResolver resourceResolver = configuration.getResourceResolver();
            int size = ResourceHelper.resolveDimensionPixelSize((RenderResources)resourceResolver, absoluteWidth, configuration);
            size = constraintModel.pxToDp(size);
            widget.setWidth(size);
        }
        if ((absoluteHeight = attributes.getAttribute("http://schemas.android.com/tools", "layout_conversion_absoluteHeight")) != null) {
            Configuration configuration = component.getModel().getConfiguration();
            ResourceResolver resourceResolver = configuration.getResourceResolver();
            int size = ResourceHelper.resolveDimensionPixelSize((RenderResources)resourceResolver, absoluteHeight, configuration);
            size = constraintModel.pxToDp(size);
            widget.setHeight(size);
        }
        widget.setMinWidth(constraintModel.pxToDp(component.getMinimumWidth()));
        widget.setMinHeight(constraintModel.pxToDp(component.getMinimumHeight()));
        NlComponent parent = component.getParent();
        NlModel model = component.getModel();
        if (parent != null && (parentWidget = scene.getWidget((Object)parent)) instanceof WidgetContainer) {
            WidgetContainer parentContainerWidget = (WidgetContainer)parentWidget;
            if (widget.getParent() != parentContainerWidget) {
                parentContainerWidget.add(widget);
            }
        }
        int x = constraintModel.pxToDp(component.x);
        int y = constraintModel.pxToDp(component.y);
        if (widget instanceof ConstraintWidgetContainer) {
            x += constraintModel.pxToDp(padding.left);
            y += constraintModel.pxToDp(padding.top);
        }
        if ((parentContainer = (WidgetContainer)widget.getParent()) != null) {
            if (!(parentContainer instanceof ConstraintWidgetContainer)) {
                x = constraintModel.pxToDp(component.x - component.getParent().x);
                y = constraintModel.pxToDp(component.y - component.getParent().y);
            } else {
                x -= parentContainer.getDrawX();
                y -= parentContainer.getDrawY();
            }
        }
        if ((absoluteX = attributes.getAttribute("http://schemas.android.com/tools", "layout_conversion_absoluteX")) != null) {
            Configuration configuration = component.getModel().getConfiguration();
            ResourceResolver resourceResolver = configuration.getResourceResolver();
            int position = ResourceHelper.resolveDimensionPixelSize((RenderResources)resourceResolver, absoluteX, configuration);
            x = constraintModel.pxToDp(position);
        }
        if ((absoluteY = attributes.getAttribute("http://schemas.android.com/tools", "layout_conversion_absoluteY")) != null) {
            Configuration configuration = component.getModel().getConfiguration();
            ResourceResolver resourceResolver = configuration.getResourceResolver();
            int position = ResourceHelper.resolveDimensionPixelSize((RenderResources)resourceResolver, absoluteY, configuration);
            y = constraintModel.pxToDp(position);
        }
        if (widget.getX() != x || widget.getY() != y) {
            widget.setOrigin(x, y);
            widget.forceUpdateDrawPosition();
        }
        boolean overrideDimension = false;
        String layout_width = attributes.getAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        if (component.w == 0 || ConstraintUtilities.getLayoutDimensionDpValue(component, layout_width) == 0) {
            widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.ANY);
        } else if (layout_width != null && layout_width.equalsIgnoreCase("wrap_content")) {
            if (widget.getWidth() < 48 && widget instanceof WidgetContainer && ((WidgetContainer)widget).getChildren().size() == 0) {
                widget.setWidth(48);
                widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                overrideDimension = true;
            } else {
                widget.setWrapWidth(widget.getWidth());
                widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
            }
        } else if (layout_width != null && layout_width.equalsIgnoreCase("match_parent")) {
            if (ConstraintUtilities.isWidgetInsideConstraintLayout(widget)) {
                if (widget.getAnchor(ConstraintAnchor.Type.LEFT).isConnected() && widget.getAnchor(ConstraintAnchor.Type.RIGHT).isConnected()) {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.ANY);
                } else {
                    widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    widget.setWidth(6);
                    int height = widget.getHeight();
                    ConstraintWidget.DimensionBehaviour verticalBehaviour = widget.getVerticalDimensionBehaviour();
                    if (height <= 1 && widget instanceof WidgetContainer) {
                        widget.setHeight(6);
                    }
                    ArrayList<ConstraintWidget> widgets = new ArrayList<ConstraintWidget>();
                    widgets.add(widget);
                    Scout.arrangeWidgets((Scout.Arrange)Scout.Arrange.ExpandHorizontally, widgets, (boolean)true);
                    widget.setHeight(height);
                    widget.setVerticalDimensionBehaviour(verticalBehaviour);
                    overrideDimension = true;
                }
            }
        } else {
            widget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
        }
        String layout_height = attributes.getAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        if (component.h == 0 || ConstraintUtilities.getLayoutDimensionDpValue(component, layout_height) == 0) {
            widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.ANY);
        } else if (layout_height != null && layout_height.equalsIgnoreCase("wrap_content")) {
            if (widget.getHeight() < 48 && widget instanceof WidgetContainer && ((WidgetContainer)widget).getChildren().size() == 0) {
                widget.setHeight(48);
                widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                overrideDimension = true;
            } else {
                widget.setWrapHeight(widget.getHeight());
                widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
            }
        } else if (layout_height != null && layout_height.equalsIgnoreCase("match_parent")) {
            if (ConstraintUtilities.isWidgetInsideConstraintLayout(widget)) {
                if (widget.getAnchor(ConstraintAnchor.Type.TOP).isConnected() && widget.getAnchor(ConstraintAnchor.Type.BOTTOM).isConnected()) {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.ANY);
                } else {
                    widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                    widget.setHeight(6);
                    int width = widget.getWidth();
                    ConstraintWidget.DimensionBehaviour horizontalBehaviour = widget.getHorizontalDimensionBehaviour();
                    if (width <= 1 && widget instanceof WidgetContainer) {
                        widget.setWidth(6);
                    }
                    ArrayList<ConstraintWidget> widgets = new ArrayList<ConstraintWidget>();
                    widgets.add(widget);
                    Scout.arrangeWidgets((Scout.Arrange)Scout.Arrange.ExpandVertically, widgets, (boolean)true);
                    widget.setWidth(width);
                    widget.setHorizontalDimensionBehaviour(horizontalBehaviour);
                    overrideDimension = true;
                }
            }
        } else {
            widget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
        }
        widget.setBaselineDistance(constraintModel.pxToDp(component.getBaseline()));
        widget.resetAnchors();
        String left1 = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf");
        String left2 = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf");
        String right1 = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toLeftOf");
        String right2 = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf");
        String top1 = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf");
        String top2 = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf");
        String bottom1 = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toTopOf");
        String bottom2 = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf");
        String baseline = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf");
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        companion.getWidgetProperties().clear();
        ConstraintUtilities.setMarginType(ConstraintAnchor.Type.LEFT, component, widget);
        ConstraintUtilities.setMarginType(ConstraintAnchor.Type.RIGHT, component, widget);
        ConstraintUtilities.setMarginType(ConstraintAnchor.Type.TOP, component, widget);
        ConstraintUtilities.setMarginType(ConstraintAnchor.Type.BOTTOM, component, widget);
        ConstraintUtilities.setTarget(model, scene, left1, widget, ConstraintAnchor.Type.LEFT, ConstraintAnchor.Type.LEFT);
        ConstraintUtilities.setStartMargin(left1, component, widget);
        ConstraintUtilities.setTarget(model, scene, left2, widget, ConstraintAnchor.Type.LEFT, ConstraintAnchor.Type.RIGHT);
        ConstraintUtilities.setStartMargin(left2, component, widget);
        ConstraintUtilities.setTarget(model, scene, right1, widget, ConstraintAnchor.Type.RIGHT, ConstraintAnchor.Type.LEFT);
        ConstraintUtilities.setEndMargin(right1, component, widget);
        ConstraintUtilities.setTarget(model, scene, right2, widget, ConstraintAnchor.Type.RIGHT, ConstraintAnchor.Type.RIGHT);
        ConstraintUtilities.setEndMargin(right2, component, widget);
        ConstraintUtilities.setTarget(model, scene, top1, widget, ConstraintAnchor.Type.TOP, ConstraintAnchor.Type.TOP);
        ConstraintUtilities.setTopMargin(top1, component, widget);
        ConstraintUtilities.setTarget(model, scene, top2, widget, ConstraintAnchor.Type.TOP, ConstraintAnchor.Type.BOTTOM);
        ConstraintUtilities.setTopMargin(top2, component, widget);
        ConstraintUtilities.setTarget(model, scene, bottom1, widget, ConstraintAnchor.Type.BOTTOM, ConstraintAnchor.Type.TOP);
        ConstraintUtilities.setBottomMargin(bottom1, component, widget);
        ConstraintUtilities.setTarget(model, scene, bottom2, widget, ConstraintAnchor.Type.BOTTOM, ConstraintAnchor.Type.BOTTOM);
        ConstraintUtilities.setBottomMargin(bottom2, component, widget);
        ConstraintUtilities.setTarget(model, scene, baseline, widget, ConstraintAnchor.Type.BASELINE, ConstraintAnchor.Type.BASELINE);
        ConstraintUtilities.setBias("layout_constraintHorizontal_bias", component, widget);
        ConstraintUtilities.setBias("layout_constraintVertical_bias", component, widget);
        ConstraintUtilities.setDimensionRatio("layout_constraintDimensionRatio", component, widget);
        if (widget instanceof Guideline) {
            Guideline guideline = (Guideline)widget;
            ConstraintUtilities.setGuideline(component, guideline);
        }
        if ((decorator = companion.getWidgetDecorator(0)) != null && decorator instanceof TextWidget) {
            String textSize;
            TextWidget textWidget = (TextWidget)decorator;
            textWidget.setText(ConstraintUtilities.getResolvedText(component));
            Configuration configuration = component.getModel().getConfiguration();
            ResourceResolver resourceResolver = configuration.getResourceResolver();
            Integer size = null;
            if (resourceResolver != null && (textSize = attributes.getAttribute("http://schemas.android.com/apk/res/android", "textSize")) != null) {
                size = ResourceHelper.resolveDimensionPixelSize((RenderResources)resourceResolver, textSize, configuration);
            }
            if (size == null) {
                size = ResourceHelper.resolveDimensionPixelSize((RenderResources)resourceResolver, "15sp", configuration);
            }
            textWidget.setTextSize((float)constraintModel.pxToDp(size));
        }
        return overrideDimension;
    }

    private static void setMarginType(ConstraintAnchor.Type type, NlComponent component, ConstraintWidget widget) {
        String margin = null;
        String marginRtl = null;
        switch (type) {
            case LEFT: {
                margin = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
                marginRtl = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart");
                break;
            }
            case RIGHT: {
                margin = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
                marginRtl = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
                break;
            }
            case TOP: {
                margin = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop");
                break;
            }
            case BOTTOM: {
                margin = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom");
            }
        }
        if (margin == null && marginRtl == null) {
            return;
        }
        ConstraintAnchor anchor = widget.getAnchor(type);
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        if (margin != null) {
            companion.getWidgetProperties().setMarginReference(anchor, margin);
        }
        if (marginRtl != null) {
            companion.getWidgetProperties().setMarginRtlReference(anchor, marginRtl);
        }
    }

    private static void setGuideline(NlComponent component, Guideline guideline) {
        AttributesTransaction attributes = component.startAttributeTransaction();
        String relativeBegin = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String relativeEnd = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        boolean useFloat = ConstraintUtilities.useGuidelineFloat(component.getModel());
        String percentAttribute = useFloat ? "layout_constraintGuide_percent" : "layout_constraintGuide_Percent";
        String relativePercent = attributes.getAttribute("http://schemas.android.com/apk/res-auto", percentAttribute);
        String oldRelativePercent = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_Percent");
        WidgetCompanion companion = (WidgetCompanion)guideline.getCompanionWidget();
        if (useFloat && oldRelativePercent != null) {
            companion.getWidgetProperties().setGuidelineAttribute(relativePercent);
            float value = 0.0f;
            try {
                value = (float)Integer.parseInt(oldRelativePercent) / 100.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            guideline.setGuidePercent(value);
        } else if (relativePercent != null && relativePercent.length() > 0) {
            companion.getWidgetProperties().setGuidelineAttribute(relativePercent);
            float value = 0.0f;
            try {
                value = useFloat ? Float.parseFloat(relativePercent) : (float)Integer.parseInt(relativePercent) / 100.0f;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            guideline.setGuidePercent(value);
        } else if (relativeBegin != null && relativeBegin.length() > 0) {
            companion.getWidgetProperties().setGuidelineAttribute(relativeBegin);
            try {
                int value = ConstraintUtilities.getDpValue(component, relativeBegin);
                guideline.setGuideBegin(value);
            }
            catch (NumberFormatException value) {}
        } else if (relativeEnd != null && relativeEnd.length() > 0) {
            companion.getWidgetProperties().setGuidelineAttribute(relativeEnd);
            try {
                int value = ConstraintUtilities.getDpValue(component, relativeEnd);
                guideline.setGuideEnd(value);
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
        }
        String orientation = attributes.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
        if (orientation != null) {
            int newOrientation = 0;
            if ("vertical".equalsIgnoreCase(orientation)) {
                newOrientation = 1;
            }
            if (newOrientation != guideline.getOrientation()) {
                guideline.setOrientation(newOrientation);
                WidgetInteractionTargets interactionTargets = companion.getWidgetInteractionTargets();
                interactionTargets.resetConstraintHandles();
            }
        }
    }

    @NotNull
    static String resolveStringResource(@NotNull NlComponent component, @NotNull String text) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "resolveStringResource"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "resolveStringResource"));
        }
        Configuration configuration = component.getModel().getConfiguration();
        ResourceResolver resourceResolver = configuration.getResourceResolver();
        if (resourceResolver != null) {
            String string = ResourceHelper.resolveStringValue((RenderResources)resourceResolver, text);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "resolveStringResource"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "resolveStringResource"));
        }
        return "";
    }

    @NotNull
    static String getResolvedText(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getResolvedText"));
        }
        String text = component.startAttributeTransaction().getAttribute("http://schemas.android.com/apk/res/android", "text");
        if (text != null) {
            if (text.startsWith("@")) {
                String string = ConstraintUtilities.resolveStringResource(component, text);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getResolvedText"));
                }
                return string;
            }
            String string = text;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getResolvedText"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getResolvedText"));
        }
        return "";
    }

    private static void saveXmlWidgets(@NotNull ConstraintModel model, boolean commit) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "saveXmlWidgets"));
        }
        Collection widgets = model.getScene().getWidgets();
        for (ConstraintWidget widget : widgets) {
            if (commit) {
                assert (ApplicationManager.getApplication().isWriteAccessAllowed());
                ConstraintUtilities.commitElement(model, widget);
                continue;
            }
            ConstraintUtilities.updateElement(model, widget);
        }
    }

    static void saveModelToXML(@NotNull NlModel nlModel, final boolean commit) {
        if (nlModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nlModel", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "saveModelToXML"));
        }
        final ConstraintModel model = ConstraintModel.getConstraintModel(nlModel);
        if (commit) {
            Project project = nlModel.getProject();
            XmlFile file = nlModel.getFile();
            String label = "Constraint";
            WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities$1", "run"));
                    }
                    ConstraintUtilities.saveXmlWidgets(model, commit);
                }
            };
            action.execute();
        } else {
            ConstraintUtilities.saveXmlWidgets(model, commit);
        }
    }

    public static void rollbackXMLChanges(@NotNull NlModel nlModel) {
        if (nlModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nlModel", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "rollbackXMLChanges"));
        }
        nlModel.getComponents().forEach(component -> component.startAttributeTransaction().rollback());
    }

    static AttributesTransaction updateElement(ConstraintModel model, @NotNull ConstraintWidget widget) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "updateElement"));
        }
        WidgetCompanion companion = (WidgetCompanion)widget.getCompanionWidget();
        NlComponent component = (NlComponent)companion.getWidgetModel();
        boolean isDroppedWidget = model.getDragDropWidget() == widget;
        boolean isInsideConstraintLayout = ConstraintUtilities.isWidgetInsideConstraintLayout(widget);
        if (!isDroppedWidget && (widget.isRoot() || widget.isRootContainer() || !isInsideConstraintLayout)) {
            return null;
        }
        AttributesTransaction attributes = component.startAttributeTransaction();
        if (isInsideConstraintLayout || isDroppedWidget) {
            ConstraintUtilities.setEditorPosition(widget, attributes, widget.getX(), widget.getY());
        } else {
            ConstraintUtilities.clearEditorPosition(attributes);
        }
        ConstraintUtilities.setDimension(attributes, widget);
        for (ConstraintAnchor anchor : widget.getAnchors()) {
            ConstraintUtilities.setConnection(attributes, anchor);
        }
        ConstraintUtilities.setHorizontalBias(attributes, widget);
        ConstraintUtilities.setVerticalBias(attributes, widget);
        if (widget instanceof Guideline) {
            ConstraintUtilities.commitGuideline(component.getModel(), attributes, (Guideline)widget);
        }
        return attributes;
    }

    private static boolean isWidgetInsideConstraintLayout(@NotNull ConstraintWidget widget) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "isWidgetInsideConstraintLayout"));
        }
        ConstraintWidget parent = widget.getParent();
        if (parent == null) {
            return false;
        }
        return parent instanceof ConstraintWidgetContainer;
    }

    static void commitElement(ConstraintModel model, @NotNull ConstraintWidget widget) {
        if (widget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "widget", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "commitElement"));
        }
        AttributesTransaction transaction = ConstraintUtilities.updateElement(model, widget);
        if (transaction != null) {
            transaction.commit();
        }
    }

    static void renderModel(@NotNull ConstraintModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "renderModel"));
        }
        model.getNlModel().requestRender();
    }

    static AndroidVersion getCompileSdkVersion(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getCompileSdkVersion"));
        }
        return AndroidModuleInfo.get(model.getFacet()).getBuildSdkVersion();
    }

    static AndroidVersion getMinSdkVersion(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getMinSdkVersion"));
        }
        return AndroidModuleInfo.get(model.getFacet()).getMinSdkVersion();
    }

    static AndroidVersion getTargetSdkVersion(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "getTargetSdkVersion"));
        }
        return AndroidModuleInfo.get(model.getFacet()).getTargetSdkVersion();
    }

    static boolean supportsStartEnd(ConstraintAnchor anchor, @NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "supportsStartEnd"));
        }
        if (anchor.getType() != ConstraintAnchor.Type.LEFT && anchor.getType() != ConstraintAnchor.Type.RIGHT) {
            return false;
        }
        AndroidVersion compileSdkVersion = ConstraintUtilities.getCompileSdkVersion(model);
        return compileSdkVersion == null || compileSdkVersion.isGreaterOrEqualThan(17) && ConstraintUtilities.getTargetSdkVersion(model).isGreaterOrEqualThan(17);
    }

    static boolean requiresRightLeft(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintUtilities", "requiresRightLeft"));
        }
        return ConstraintUtilities.getMinSdkVersion(model).getApiLevel() < 17;
    }
}

