/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.dom.AndroidAnyAttributeDescriptor;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.resourceManagers.SystemResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlProperties {
    private static NlProperties ourInstance = null;
    private final AndroidDomElementDescriptorProvider myDescriptorProvider = new AndroidDomElementDescriptorProvider();

    public static synchronized NlProperties getInstance() {
        if (ourInstance == null) {
            ourInstance = new NlProperties();
        }
        return ourInstance;
    }

    @NotNull
    public Table<String, String, NlPropertyItem> getProperties(@NotNull List<NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "getProperties"));
        }
        Table table = (Table)ApplicationManager.getApplication().runReadAction(() -> {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "lambda$getProperties$0"));
            }
            return this.getPropertiesWithReadLock(components);
        });
        if (table == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getProperties"));
        }
        return table;
    }

    @NotNull
    private Table<String, String, NlPropertyItem> getPropertiesWithReadLock(@NotNull List<NlComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
        }
        assert (!components.isEmpty());
        NlComponent first = components.get(0);
        XmlTag firstTag = first.getTag();
        if (!firstTag.isValid()) {
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
            }
            return immutableTable;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)firstTag);
        if (facet == null) {
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
            }
            return immutableTable;
        }
        LocalResourceManager localResourceManager = facet.getLocalResourceManager();
        SystemResourceManager systemResourceManager = facet.getSystemResourceManager();
        if (systemResourceManager == null) {
            Logger.getInstance(NlProperties.class).error("No system resource manager for module: " + facet.getModule().getName());
            ImmutableTable immutableTable = ImmutableTable.of();
            if (immutableTable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
            }
            return immutableTable;
        }
        AttributeDefinitions localAttrDefs = ((ResourceManager)localResourceManager).getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = ((ResourceManager)systemResourceManager).getAttributeDefinitions();
        Table<String, String, NlPropertyItem> combinedProperties = null;
        for (NlComponent component : components) {
            XmlTag tag = component.getTag();
            if (!tag.isValid()) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
                }
                return immutableTable;
            }
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                ImmutableTable immutableTable = ImmutableTable.of();
                if (immutableTable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
                }
                return immutableTable;
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor desc : descriptors) {
                String namespace = NlProperties.getNamespace(desc, tag);
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android".equals(namespace) ? systemAttrDefs : localAttrDefs;
                AttributeDefinition attrDef = attrDefs == null ? null : attrDefs.getAttrDefByName(desc.getName());
                NlPropertyItem property = NlPropertyItem.create(components, desc, namespace, attrDef);
                properties.put((Object)StringUtil.notNullize((String)namespace), (Object)property.getName(), (Object)property);
            }
            switch (tag.getName()) {
                case "AutoCompleteTextView": {
                    properties.put((Object)"http://schemas.android.com/apk/res/android", (Object)"popupBackground", (Object)NlPropertyItem.create(components, new AndroidAnyAttributeDescriptor("popupBackground"), "http://schemas.android.com/apk/res/android", systemAttrDefs != null ? systemAttrDefs.getAttrDefByName("popupBackground") : null));
                }
            }
            combinedProperties = NlProperties.combine((Table<String, String, NlPropertyItem>)properties, combinedProperties);
        }
        assert (combinedProperties != null);
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingStart");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"paddingEnd");
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res-auto", (Object)"theme");
        NlProperties.setUpDesignProperties(combinedProperties);
        NlProperties.setUpSrcCompat(combinedProperties, facet, components);
        Table<String, String, NlPropertyItem> table = combinedProperties;
        if (table == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlProperties", "getPropertiesWithReadLock"));
        }
        return table;
    }

    @Nullable
    private static String getNamespace(@NotNull XmlAttributeDescriptor descriptor, @NotNull XmlTag context) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/android/tools/idea/uibuilder/property/NlProperties", "getNamespace"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/uibuilder/property/NlProperties", "getNamespace"));
        }
        if (descriptor instanceof NamespaceAwareXmlAttributeDescriptor) {
            return ((NamespaceAwareXmlAttributeDescriptor)descriptor).getNamespace(context);
        }
        return null;
    }

    private static Table<String, String, NlPropertyItem> combine(@NotNull Table<String, String, NlPropertyItem> properties, @Nullable Table<String, String, NlPropertyItem> combinedProperties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlProperties", "combine"));
        }
        if (combinedProperties == null) {
            return properties;
        }
        ArrayList namespaces = new ArrayList(combinedProperties.rowKeySet());
        ArrayList propertiesToRemove = new ArrayList();
        for (String namespace : namespaces) {
            propertiesToRemove.clear();
            for (Map.Entry entry : combinedProperties.row((Object)namespace).entrySet()) {
                NlPropertyItem other = (NlPropertyItem)properties.get((Object)namespace, entry.getKey());
                if (((NlPropertyItem)entry.getValue()).sameDefinition(other)) continue;
                propertiesToRemove.add(entry.getKey());
            }
            for (String propertyName : propertiesToRemove) {
                combinedProperties.remove((Object)namespace, (Object)propertyName);
            }
        }
        combinedProperties.remove((Object)"http://schemas.android.com/apk/res/android", (Object)"id");
        return combinedProperties;
    }

    private static void setUpDesignProperties(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlProperties", "setUpDesignProperties"));
        }
        ArrayList designProperties = new ArrayList(properties.row((Object)"http://schemas.android.com/tools").keySet());
        for (String propertyName : designProperties) {
            NlPropertyItem item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res-auto", (Object)propertyName);
            if (item == null) {
                item = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)propertyName);
            }
            if (item == null) continue;
            NlPropertyItem designItem = item.getDesignTimeProperty();
            properties.put((Object)"http://schemas.android.com/tools", (Object)propertyName, (Object)designItem);
        }
    }

    private static void setUpSrcCompat(@NotNull Table<String, String, NlPropertyItem> properties, @NotNull AndroidFacet facet, @NotNull List<NlComponent> components) {
        AndroidGradleModel gradleModel;
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlProperties", "setUpSrcCompat"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/property/NlProperties", "setUpSrcCompat"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "setUpSrcCompat"));
        }
        NlPropertyItem srcProperty = (NlPropertyItem)properties.get((Object)"http://schemas.android.com/apk/res/android", (Object)"src");
        if (srcProperty != null && (gradleModel = AndroidGradleModel.get(facet)) != null && GradleUtil.dependsOn(gradleModel, "com.android.support:appcompat-v7") && NlProperties.allTagsSupportSrcCompat(facet, components)) {
            AttributeDefinition srcDefinition = srcProperty.getDefinition();
            assert (srcDefinition != null);
            AttributeDefinition srcCompatDefinition = new AttributeDefinition("srcCompat", null, srcDefinition.getFormats());
            srcCompatDefinition.getParentStyleables().addAll(srcDefinition.getParentStyleables());
            NlPropertyItem srcCompatProperty = new NlPropertyItem(components, "http://schemas.android.com/apk/res-auto", srcCompatDefinition);
            properties.put((Object)"http://schemas.android.com/apk/res-auto", (Object)"srcCompat", (Object)srcCompatProperty);
        }
    }

    private static boolean allTagsSupportSrcCompat(@NotNull AndroidFacet facet, @NotNull List<NlComponent> components) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/uibuilder/property/NlProperties", "allTagsSupportSrcCompat"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlProperties", "allTagsSupportSrcCompat"));
        }
        ViewHandlerManager manager = ViewHandlerManager.get(facet);
        for (NlComponent component : components) {
            ViewHandler handler = manager.getHandler(component.getTagName());
            if (handler instanceof ImageViewHandler) continue;
            return false;
        }
        return true;
    }
}

