/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.rendering.RefreshRenderAction;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.model.Coordinates;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.SelectionHandle;
import com.android.tools.idea.uibuilder.model.SelectionModel;
import com.android.tools.idea.uibuilder.surface.CanvasResizeInteraction;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.Interaction;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.MarqueeInteraction;
import com.android.tools.idea.uibuilder.surface.ResizeInteraction;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.tools.idea.uibuilder.surface.ScrollInteraction;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.util.PsiNavigateUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InteractionManager {
    private static final int HOVER_DELAY_MS = Registry.intValue((String)"ide.tooltip.initialDelay");
    private static final int SCROLL_END_TIME_MS = 500;
    @NotNull
    private final DesignSurface mySurface;
    @Nullable
    private Interaction myCurrentInteraction;
    @Nullable
    private List<Layer> myLayers;
    protected int myLastMouseX;
    protected int myLastMouseY;
    @JdkConstants.InputEventMask
    protected static int ourLastStateMask;
    private final Timer myHoverTimer;
    private final Timer myScrollEndTimer;
    private final ActionListener myScrollEndListener;
    private Listener myListener;
    private DropTarget myDropTarget;

    public InteractionManager(@NotNull DesignSurface surface) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/surface/InteractionManager", "<init>"));
        }
        this.mySurface = surface;
        this.myHoverTimer = new Timer(HOVER_DELAY_MS, null);
        this.myHoverTimer.setRepeats(false);
        this.myScrollEndTimer = new Timer(500, null);
        this.myScrollEndTimer.setRepeats(false);
        this.myScrollEndListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractionManager.this.myScrollEndTimer.removeActionListener(this);
                InteractionManager.this.finishInteraction(0, 0, 0, false);
            }
        };
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/surface/InteractionManager", "getSurface"));
        }
        return designSurface;
    }

    @Nullable
    public Interaction getCurrentInteraction() {
        return this.myCurrentInteraction;
    }

    public void registerListeners() {
        assert (this.myListener == null);
        this.myListener = new Listener();
        JComponent layeredPane = this.mySurface.getLayeredPane();
        layeredPane.addMouseMotionListener(this.myListener);
        layeredPane.addMouseWheelListener(this.myListener);
        layeredPane.addMouseListener(this.myListener);
        layeredPane.addKeyListener(this.myListener);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myDropTarget = new DropTarget(this.mySurface.getLayeredPane(), 3, this.myListener, true, null);
        }
        this.myHoverTimer.addActionListener(this.myListener);
    }

    public void unregisterListeners() {
        this.myDropTarget.removeDropTargetListener(this.myListener);
        this.myHoverTimer.removeActionListener(this.myListener);
    }

    private void startInteraction(int x, int y, @Nullable Interaction interaction, int modifiers) {
        if (this.myCurrentInteraction != null) {
            this.finishInteraction(x, y, modifiers, true);
            assert (this.myCurrentInteraction == null);
        }
        if (interaction != null) {
            this.myCurrentInteraction = interaction;
            this.myCurrentInteraction.begin(x, y, modifiers);
            this.myLayers = interaction.createOverlays();
        }
    }

    @Nullable
    public List<Layer> getLayers() {
        return this.myLayers;
    }

    @JdkConstants.InputEventMask
    public static int getLastModifiers() {
        return ourLastStateMask;
    }

    private void updateMouse(int x, int y) {
        if (this.myCurrentInteraction != null) {
            this.myCurrentInteraction.update(x, y, ourLastStateMask);
            this.mySurface.repaint();
        }
    }

    private void finishInteraction(int x, int y, int modifiers, boolean canceled) {
        if (this.myCurrentInteraction != null) {
            this.myCurrentInteraction.end(x, y, modifiers, canceled);
            if (this.myLayers != null) {
                for (Layer layer : this.myLayers) {
                    layer.dispose();
                }
                this.myLayers = null;
            }
            this.myCurrentInteraction = null;
            ourLastStateMask = 0;
            this.updateCursor(x, y);
            this.mySurface.repaint();
        }
    }

    void updateCursor(int x, int y) {
        ScreenView screenView = this.mySurface.getScreenView(x, y);
        if (screenView == null) {
            this.mySurface.setCursor(null);
            return;
        }
        SelectionModel selectionModel = screenView.getSelectionModel();
        if (!selectionModel.isEmpty()) {
            int mx = Coordinates.getAndroidX(screenView, x);
            int my = Coordinates.getAndroidY(screenView, y);
            if (!selectionModel.isEmpty()) {
                ViewGroupHandler handler;
                NlComponent parent;
                NlComponent primary = selectionModel.getPrimary();
                NlComponent nlComponent = parent = primary != null ? primary.getParent() : null;
                if (parent != null && (handler = parent.getViewGroupHandler()) != null && handler.updateCursor(screenView, mx, my)) {
                    return;
                }
            }
            for (NlComponent component : selectionModel.getSelection()) {
                ViewGroupHandler viewGroupHandler = component.getViewGroupHandler();
                if (viewGroupHandler == null || !viewGroupHandler.updateCursor(screenView, mx, my)) continue;
                return;
            }
            int max = Coordinates.getAndroidDimension(screenView, 10);
            SelectionHandle handle = selectionModel.findHandle(mx, my, max);
            if (handle != null) {
                Cursor cursor = handle.getCursor();
                if (cursor != this.mySurface.getCursor()) {
                    this.mySurface.setCursor(cursor);
                }
                return;
            }
            NlComponent component = selectionModel.findComponent(mx, my);
            if (component == null || component.isRoot()) {
                component = screenView.getModel().findLeafAt(mx, my, false);
            }
            if (component != null && !component.isRoot()) {
                Cursor cursor = Cursor.getPredefinedCursor(12);
                if (cursor != this.mySurface.getCursor()) {
                    this.mySurface.setCursor(cursor);
                }
                return;
            }
        } else {
            int my;
            int mx;
            ViewGroupHandler viewGroupHandler;
            NlComponent component = Coordinates.findComponent(screenView, x, y);
            if (component != null && (viewGroupHandler = component.getViewGroupHandler()) != null && viewGroupHandler.updateCursor(screenView, mx = Coordinates.getAndroidX(screenView, x), my = Coordinates.getAndroidY(screenView, y))) {
                this.mySurface.repaint();
            }
            if (this.mySurface.getScreenMode() != DesignSurface.ScreenMode.BOTH || screenView.getScreenViewType() == ScreenView.ScreenViewType.NORMAL) {
                Dimension size = screenView.getSize();
                Rectangle resizeZone = new Rectangle(screenView.getX() + size.width, screenView.getY() + size.height, 48, 48);
                if (resizeZone.contains(x, y)) {
                    this.mySurface.setCursor(Cursor.getPredefinedCursor(5));
                    return;
                }
            }
        }
        this.mySurface.setCursor(null);
    }

    public void cancelInteraction() {
        this.finishInteraction(this.myLastMouseX, this.myLastMouseY, ourLastStateMask, true);
    }

    public Object getListener() {
        return this.myListener;
    }

    private class Listener
    implements MouseMotionListener,
    MouseListener,
    KeyListener,
    DropTargetListener,
    ActionListener,
    MouseWheelListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/surface/InteractionManager$Listener", "mouseClicked"));
            }
            if (event.getClickCount() == 2 && event.getButton() == 1) {
                NlComponent component = this.getComponentAt(event.getX(), event.getY());
                if (component != null) {
                    if (InteractionManager.this.mySurface.isPreviewSurface()) {
                        PsiNavigateUtil.navigate((PsiElement)component.getTag());
                    } else {
                        InteractionManager.this.mySurface.notifyActivateComponent(component);
                    }
                }
            } else if (event.isPopupTrigger()) {
                this.selectComponentAt(event.getX(), event.getY(), false, true);
                InteractionManager.this.mySurface.getActionManager().showPopup(event);
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            ViewGroupHandler viewGroupHandler;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/surface/InteractionManager$Listener", "mousePressed"));
            }
            if (event.getID() == 501) {
                InteractionManager.this.mySurface.getLayeredPane().requestFocusInWindow();
            }
            InteractionManager.this.myLastMouseX = event.getX();
            InteractionManager.this.myLastMouseY = event.getY();
            ourLastStateMask = event.getModifiers();
            if (event.isPopupTrigger()) {
                this.selectComponentAt(event.getX(), event.getY(), false, true);
                InteractionManager.this.mySurface.getActionManager().showPopup(event);
                return;
            }
            ScreenView screenView = InteractionManager.this.mySurface.getScreenView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
            if (screenView == null) {
                return;
            }
            if (InteractionManager.this.mySurface.getScreenMode() != DesignSurface.ScreenMode.BOTH || screenView.getScreenViewType() == ScreenView.ScreenViewType.NORMAL) {
                Dimension size = screenView.getSize();
                Rectangle resizeZone = new Rectangle(screenView.getX() + size.width, screenView.getY() + size.height, 48, 48);
                if (resizeZone.contains(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY)) {
                    InteractionManager.this.startInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, new CanvasResizeInteraction(InteractionManager.this.mySurface), ourLastStateMask);
                    return;
                }
            }
            SelectionModel selectionModel = screenView.getSelectionModel();
            NlComponent component = Coordinates.findComponent(screenView, InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
            if (component == null) {
                if (!selectionModel.isEmpty()) {
                    component = selectionModel.getPrimary();
                } else {
                    return;
                }
            }
            ViewGroupHandler viewGroupHandler2 = viewGroupHandler = component != null ? component.getViewGroupHandler() : null;
            if (viewGroupHandler == null) {
                return;
            }
            Interaction interaction = null;
            if (interaction == null && !selectionModel.isEmpty()) {
                NlComponent parent;
                NlComponent primary = screenView.getSelectionModel().getPrimary();
                NlComponent nlComponent = parent = primary != null ? primary.getParent() : null;
                if (parent != null) {
                    ViewGroupHandler handler;
                    int ax = Coordinates.getAndroidX(screenView, InteractionManager.this.myLastMouseX);
                    int ay = Coordinates.getAndroidY(screenView, InteractionManager.this.myLastMouseY);
                    if (primary.containsX(ax) && primary.containsY(ay) && (handler = parent.getViewGroupHandler()) != null) {
                        interaction = handler.createInteraction(screenView, primary);
                    }
                }
            }
            if (interaction == null) {
                interaction = viewGroupHandler.createInteraction(screenView, component);
            }
            if (interaction != null) {
                InteractionManager.this.startInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, interaction, ourLastStateMask);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/surface/InteractionManager$Listener", "mouseReleased"));
            }
            if (event.isPopupTrigger()) {
                this.selectComponentAt(event.getX(), event.getY(), false, true);
                InteractionManager.this.mySurface.repaint();
                InteractionManager.this.mySurface.getActionManager().showPopup(event);
                return;
            }
            if (event.getButton() > 1 || SystemInfo.isMac && event.isControlDown()) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            int modifiers = event.getModifiers();
            if (InteractionManager.this.myCurrentInteraction == null) {
                boolean allowToggle = (modifiers & 5) != 0;
                this.selectComponentAt(x, y, allowToggle, false);
                InteractionManager.this.mySurface.repaint();
            }
            if (InteractionManager.this.myCurrentInteraction == null) {
                InteractionManager.this.updateCursor(x, y);
            } else {
                InteractionManager.this.finishInteraction(x, y, modifiers, false);
            }
            InteractionManager.this.mySurface.repaint();
        }

        private void selectComponentAt(int x, int y, boolean allowToggle, boolean ignoreIfAlreadySelected) {
            int max;
            int my;
            int mx;
            SelectionHandle handle;
            ScreenView screenView = InteractionManager.this.mySurface.getScreenView(x, y);
            if (screenView == null) {
                return;
            }
            SelectionModel selectionModel = screenView.getSelectionModel();
            NlComponent component = Coordinates.findComponent(screenView, x, y);
            if (component == null && (handle = selectionModel.findHandle(mx = Coordinates.getAndroidX(screenView, x), my = Coordinates.getAndroidY(screenView, y), max = Coordinates.getAndroidDimension(screenView, 10))) != null) {
                component = handle.component;
            }
            if (ignoreIfAlreadySelected && component != null && selectionModel.isSelected(component)) {
                return;
            }
            if (component == null) {
                selectionModel.clear();
            } else if (allowToggle) {
                selectionModel.toggle(component);
            } else {
                selectionModel.setSelection(Collections.singletonList(component));
            }
        }

        @Nullable
        private NlComponent getComponentAt(int x, int y) {
            ScreenView screenView = InteractionManager.this.mySurface.getScreenView(x, y);
            if (screenView == null) {
                return null;
            }
            return Coordinates.findComponent(screenView, x, y);
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/surface/InteractionManager$Listener", "mouseEntered"));
            }
            InteractionManager.this.myHoverTimer.restart();
            InteractionManager.this.mySurface.resetHover();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/surface/InteractionManager$Listener", "mouseExited"));
            }
            InteractionManager.this.myHoverTimer.stop();
            InteractionManager.this.mySurface.resetHover();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            if (InteractionManager.this.myCurrentInteraction != null) {
                InteractionManager.this.myLastMouseX = x;
                InteractionManager.this.myLastMouseY = y;
                ourLastStateMask = event.getModifiers();
                InteractionManager.this.myCurrentInteraction.update(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, ourLastStateMask);
                InteractionManager.this.mySurface.repaint();
            } else {
                Interaction interaction;
                int max;
                int ay;
                int ax;
                int modifiers;
                x = InteractionManager.this.myLastMouseX;
                y = InteractionManager.this.myLastMouseY;
                ourLastStateMask = modifiers = event.getModifiers();
                boolean toggle = (modifiers & 3) != 0;
                ScreenView screenView = InteractionManager.this.mySurface.getScreenView(x, y);
                if (screenView == null) {
                    return;
                }
                SelectionModel selectionModel = screenView.getSelectionModel();
                SelectionHandle handle = selectionModel.findHandle(ax = Coordinates.getAndroidX(screenView, x), ay = Coordinates.getAndroidY(screenView, y), max = Coordinates.getAndroidDimension(screenView, 10));
                if (handle != null) {
                    interaction = new ResizeInteraction(screenView, handle.component, handle);
                } else {
                    NlComponent primary;
                    NlModel model = screenView.getModel();
                    NlComponent component = null;
                    if (selectionModel.isEmpty() && !model.getComponents().isEmpty()) {
                        selectionModel.setSelection(Collections.singleton(model.getComponents().get(0).getRoot()));
                    }
                    if ((primary = selectionModel.getPrimary()) != null && !primary.isRoot() && primary.containsX(ax) && primary.containsY(ay)) {
                        component = primary;
                    } else if (primary != null) {
                        component = primary.findImmediateLeafAt(ax, ay);
                    }
                    if (component == null) {
                        component = model.findLeafAt(ax, ay, false);
                    }
                    if (component == null || component.isRoot()) {
                        interaction = new MarqueeInteraction(screenView, toggle);
                    } else {
                        List<Object> dragged;
                        if (selectionModel.isSelected(component)) {
                            dragged = Lists.newArrayList();
                            if (primary != null) {
                                if (primary.isRoot()) {
                                    primary = null;
                                } else {
                                    dragged.add(primary);
                                }
                            }
                            for (NlComponent selected : selectionModel.getSelection()) {
                                if (selected.isRoot() || selected == primary) continue;
                                dragged.add(selected);
                            }
                        } else {
                            dragged = Collections.singletonList(component);
                        }
                        interaction = new DragDropInteraction(InteractionManager.this.mySurface, dragged);
                    }
                }
                InteractionManager.this.startInteraction(x, y, interaction, modifiers);
            }
            InteractionManager.this.myHoverTimer.restart();
            InteractionManager.this.mySurface.resetHover();
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            int x = event.getX();
            int y = event.getY();
            InteractionManager.this.myLastMouseX = x;
            InteractionManager.this.myLastMouseY = y;
            ourLastStateMask = event.getModifiers();
            InteractionManager.this.mySurface.hover(x, y);
            if ((ourLastStateMask & 0x400) != 0) {
                if (InteractionManager.this.myCurrentInteraction != null) {
                    InteractionManager.this.updateMouse(x, y);
                    InteractionManager.this.mySurface.repaint();
                }
            } else {
                InteractionManager.this.updateCursor(x, y);
            }
            InteractionManager.this.myHoverTimer.restart();
            InteractionManager.this.mySurface.resetHover();
        }

        @Override
        public void keyTyped(KeyEvent event) {
            ourLastStateMask = event.getModifiers();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            SelectionModel model;
            ScreenView screenView;
            int modifiers = event.getModifiers();
            int keyCode = event.getKeyCode();
            char keyChar = event.getKeyChar();
            ourLastStateMask = modifiers;
            if (InteractionManager.this.myCurrentInteraction != null) {
                if (keyCode == 27) {
                    InteractionManager.this.finishInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, ourLastStateMask, true);
                    return;
                }
                if (InteractionManager.this.myCurrentInteraction.keyPressed(event)) {
                    return;
                }
            }
            if (keyChar == '+') {
                InteractionManager.this.mySurface.zoomIn();
            } else if (keyChar == '-') {
                InteractionManager.this.mySurface.zoomOut();
            }
            if (event.isAltDown() || event.isMetaDown() || event.isShiftDown() || event.isControlDown()) {
                return;
            }
            if (keyChar == '1') {
                InteractionManager.this.mySurface.zoomActual();
            } else if (keyChar == 'r') {
                RefreshRenderAction.clearCache(InteractionManager.this.mySurface);
            } else if (keyChar == 'b') {
                DesignSurface.ScreenMode nextMode = InteractionManager.this.mySurface.getScreenMode().next();
                InteractionManager.this.mySurface.setScreenMode(nextMode, true);
            } else if (keyChar == '0') {
                InteractionManager.this.mySurface.zoomToFit();
            } else if (keyChar == 'd') {
                ScreenView screenView2 = InteractionManager.this.mySurface.getScreenView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
                if (screenView2 != null) {
                    screenView2.switchDevice();
                }
            } else if (keyChar == 'o') {
                ScreenView screenView3 = InteractionManager.this.mySurface.getScreenView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
                if (screenView3 != null) {
                    screenView3.toggleOrientation();
                }
            } else if (keyChar == 'f') {
                InteractionManager.this.mySurface.toggleDeviceFrames();
            } else if (!(keyCode != 127 && keyCode != 8 || (screenView = InteractionManager.this.mySurface.getScreenView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY)) == null || (model = screenView.getSelectionModel()).isEmpty())) {
                List<NlComponent> selection = model.getSelection();
                screenView.getModel().delete(selection);
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            ourLastStateMask = event.getModifiers();
            if (InteractionManager.this.myCurrentInteraction != null) {
                InteractionManager.this.myCurrentInteraction.keyReleased(event);
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dragEvent) {
            if (InteractionManager.this.myCurrentInteraction == null) {
                NlDropEvent event = new NlDropEvent(dragEvent);
                Point location = event.getLocation();
                InteractionManager.this.myLastMouseX = location.x;
                InteractionManager.this.myLastMouseY = location.y;
                ScreenView screenView = InteractionManager.this.mySurface.getScreenView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
                if (screenView == null) {
                    event.reject();
                    return;
                }
                NlModel model = screenView.getModel();
                DnDTransferItem item = NlModel.getTransferItem(event.getTransferable(), true);
                if (item == null) {
                    event.reject();
                    return;
                }
                DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
                InsertType insertType = model.determineInsertType(dragType, item, true);
                List dragged = (List)ApplicationManager.getApplication().runWriteAction(() -> model.createComponents(screenView, item, insertType));
                if (dragged == null) {
                    event.reject();
                    return;
                }
                int yOffset = 0;
                for (NlComponent component : dragged) {
                    component.x = Coordinates.getAndroidX(screenView, InteractionManager.this.myLastMouseX) - component.w / 2;
                    component.y = Coordinates.getAndroidY(screenView, InteractionManager.this.myLastMouseY) - component.h / 2 + yOffset;
                    yOffset += component.h;
                }
                DragDropInteraction interaction = new DragDropInteraction(InteractionManager.this.mySurface, dragged);
                interaction.setType(dragType);
                interaction.setTransferItem(item);
                InteractionManager.this.startInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, interaction, 0);
                event.accept(insertType.isCreate() ? 1 : event.getDropAction());
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dragEvent) {
            NlDropEvent event = new NlDropEvent(dragEvent);
            Point location = event.getLocation();
            InteractionManager.this.myLastMouseX = location.x;
            InteractionManager.this.myLastMouseY = location.y;
            ScreenView screenView = InteractionManager.this.mySurface.getScreenView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
            if (screenView != null && InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction) {
                DragDropInteraction interaction = (DragDropInteraction)InteractionManager.this.myCurrentInteraction;
                interaction.update(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, ourLastStateMask);
                DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
                interaction.setType(dragType);
                NlModel model = screenView.getModel();
                InsertType insertType = model.determineInsertType(dragType, interaction.getTransferItem(), true);
                event.accept(insertType.isCreate() ? 1 : event.getDropAction());
            } else {
                event.reject();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            if (InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction) {
                InteractionManager.this.finishInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, ourLastStateMask, true);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropEvent) {
            NlDropEvent event = new NlDropEvent(dropEvent);
            Point location = event.getLocation();
            InteractionManager.this.myLastMouseX = location.x;
            InteractionManager.this.myLastMouseY = location.y;
            InsertType insertType = this.performDrop(event.getDropAction(), event.getTransferable());
            if (insertType != null) {
                event.accept(insertType == InsertType.COPY ? event.getDropAction() : 1);
                event.complete();
            } else {
                event.reject();
            }
        }

        @Nullable
        private InsertType performDrop(int dropAction, @Nullable Transferable transferable) {
            if (!(InteractionManager.this.myCurrentInteraction instanceof DragDropInteraction)) {
                return null;
            }
            InsertType insertType = this.updateDropInteraction(dropAction, transferable);
            InteractionManager.this.finishInteraction(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY, ourLastStateMask, insertType == null);
            return insertType;
        }

        @Nullable
        private InsertType updateDropInteraction(int dropAction, @Nullable Transferable transferable) {
            List components;
            if (transferable == null) {
                return null;
            }
            DnDTransferItem item = NlModel.getTransferItem(transferable, false);
            if (item == null) {
                return null;
            }
            ScreenView screenView = InteractionManager.this.mySurface.getScreenView(InteractionManager.this.myLastMouseX, InteractionManager.this.myLastMouseY);
            if (screenView == null) {
                return null;
            }
            NlModel model = screenView.getModel();
            DragType dragType = dropAction == 1 ? DragType.COPY : DragType.MOVE;
            InsertType insertType = model.determineInsertType(dragType, item, false);
            DragDropInteraction interaction = (DragDropInteraction)InteractionManager.this.myCurrentInteraction;
            assert (interaction != null);
            interaction.setType(dragType);
            interaction.setTransferItem(item);
            List<NlComponent> dragged = interaction.getDraggedComponents();
            if (insertType.isMove()) {
                components = model.getSelectionModel().getSelection();
            } else {
                components = (List)ApplicationManager.getApplication().runWriteAction(() -> model.createComponents(screenView, item, insertType));
                if (components == null) {
                    return null;
                }
            }
            if (dragged.size() != components.size()) {
                throw new AssertionError((Object)String.format("Problem with drop: dragged.size(%1$d) != components.size(%2$d)", dragged.size(), components.size()));
            }
            for (int index = 0; index < dragged.size(); ++index) {
                ((NlComponent)components.get((int)index)).x = dragged.get((int)index).x;
                ((NlComponent)components.get((int)index)).y = dragged.get((int)index).y;
            }
            dragged.clear();
            dragged.addAll(components);
            return insertType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != InteractionManager.this.myHoverTimer) {
                return;
            }
            int x = InteractionManager.this.myLastMouseX;
            int y = InteractionManager.this.myLastMouseY;
            InteractionManager.this.mySurface.hover(x, y);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            boolean isScrollInteraction;
            int scrollAmount;
            int x = e.getX();
            int y = e.getY();
            ScreenView screenView = InteractionManager.this.mySurface.getScreenView(x, y);
            if (screenView == null) {
                return;
            }
            NlComponent component = Coordinates.findComponent(screenView, x, y);
            if (component == null) {
                return;
            }
            if (e.getScrollType() == 0) {
                scrollAmount = e.getUnitsToScroll();
            } else {
                int n = scrollAmount = e.getWheelRotation() < 0 ? -1 : 1;
            }
            if (InteractionManager.this.myCurrentInteraction == null) {
                ScrollInteraction scrollInteraction = ScrollInteraction.createScrollInteraction(screenView, component);
                if (scrollInteraction == null) {
                    e.getComponent().getParent().dispatchEvent(e);
                    return;
                }
                JScrollPane scrollPane = InteractionManager.this.mySurface.getScrollPane();
                JViewport viewport = scrollPane.getViewport();
                Dimension extentSize = viewport.getExtentSize();
                Dimension viewSize = viewport.getViewSize();
                if (viewSize.width > extentSize.width || viewSize.height > extentSize.height) {
                    e.getComponent().getParent().dispatchEvent(e);
                    return;
                }
                InteractionManager.this.startInteraction(x, y, scrollInteraction, 0);
                isScrollInteraction = true;
                InteractionManager.this.myScrollEndTimer.addActionListener(InteractionManager.this.myScrollEndListener);
            } else {
                isScrollInteraction = InteractionManager.this.myCurrentInteraction instanceof ScrollInteraction;
            }
            InteractionManager.this.myCurrentInteraction.scroll(e.getX(), e.getY(), scrollAmount);
            if (isScrollInteraction) {
                InteractionManager.this.myScrollEndTimer.restart();
            }
        }
    }
}

