/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public class TerminalColor {
    public static final TerminalColor BLACK = TerminalColor.index(0);
    public static final TerminalColor WHITE = TerminalColor.index(15);
    private int myColorIndex;
    private Color myColor;

    public TerminalColor(int index) {
        this.myColorIndex = index;
        this.myColor = null;
    }

    public TerminalColor(int r, int g, int b) {
        this.myColorIndex = -1;
        this.myColor = new Color(r, g, b);
    }

    public static TerminalColor index(int index) {
        return new TerminalColor(index);
    }

    public static TerminalColor rgb(int r, int g, int b) {
        return new TerminalColor(r, g, b);
    }

    public boolean isIndexed() {
        return this.myColorIndex != -1;
    }

    public Color toAwtColor() {
        if (this.isIndexed()) {
            throw new IllegalArgumentException("Color is indexed color so a palette is needed");
        }
        return this.myColor;
    }

    public int getIndex() {
        return this.myColorIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TerminalColor that = (TerminalColor)o;
        if (this.isIndexed()) {
            if (!that.isIndexed()) {
                return false;
            }
            return this.myColorIndex == that.myColorIndex;
        }
        if (that.isIndexed()) {
            return false;
        }
        return this.myColor.equals(that.myColor);
    }

    public int hashCode() {
        return this.myColor != null ? this.myColor.hashCode() : this.myColorIndex;
    }

    @Nullable
    public static TerminalColor awt(@Nullable Color color) {
        if (color == null) {
            return null;
        }
        return TerminalColor.rgb(color.getRed(), color.getGreen(), color.getBlue());
    }
}

