/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class ConcurrencyAnnotationsManager {
    private static final String[] FRAMEWORKS = new String[]{"net.jcip.annotations", "javax.annotation.concurrent", "org.apache.http.annotation", "com.android.annotations.concurrency"};
    private static final String IMMUTABLE = "Immutable";
    private static final String GUARDED_BY = "GuardedBy";
    private static final String THREAD_SAFE = "ThreadSafe";
    private static final String NOT_THREAD_SAFE = "NotThreadSafe";
    private final List<String> myImmutableList = new ArrayList<String>();
    private final List<String> myGuardedByList = new ArrayList<String>();
    private final List<String> myThreadSafeList = new ArrayList<String>();
    private final List<String> myNotThreadSafeList = new ArrayList<String>();

    public ConcurrencyAnnotationsManager() {
        ConcurrencyAnnotationsManager.fillDefaults(this.myImmutableList, IMMUTABLE);
        ConcurrencyAnnotationsManager.fillDefaults(this.myGuardedByList, GUARDED_BY);
        ConcurrencyAnnotationsManager.fillDefaults(this.myThreadSafeList, THREAD_SAFE);
        ConcurrencyAnnotationsManager.fillDefaults(this.myNotThreadSafeList, NOT_THREAD_SAFE);
    }

    private static void fillDefaults(List<String> list, final String annoName) {
        list.addAll(ContainerUtil.map((Object[])FRAMEWORKS, (Function)new Function<String, String>(){

            public String fun(String framework) {
                return framework + "." + annoName;
            }
        }));
    }

    public static ConcurrencyAnnotationsManager getInstance(Project project) {
        return ServiceManager.getService(project, ConcurrencyAnnotationsManager.class);
    }

    public List<String> getImmutableAnnotations() {
        return this.myImmutableList;
    }

    public List<String> getGuardedByAnnotations() {
        return this.myGuardedByList;
    }

    public List<String> getThreadSafeList() {
        return this.myThreadSafeList;
    }

    public List<String> getNotThreadSafeList() {
        return this.myNotThreadSafeList;
    }
}

