/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

abstract class MnemonicWrapper<T extends Component>
implements Runnable,
PropertyChangeListener {
    final T myComponent;
    private final String myTextProperty;
    private final String myCodeProperty;
    private final String myIndexProperty;
    private int myCode;
    private int myIndex;
    private boolean myFocusable;
    private boolean myEvent;
    private boolean myTextChanged;
    private Runnable myRunnable;

    public static MnemonicWrapper getWrapper(Component component) {
        if (component == null || component.getClass().getName().equals("com.intellij.openapi.wm.impl.StripeButton")) {
            return null;
        }
        for (PropertyChangeListener listener : component.getPropertyChangeListeners()) {
            if (!(listener instanceof MnemonicWrapper)) continue;
            MnemonicWrapper wrapper = (MnemonicWrapper)listener;
            wrapper.run();
            return wrapper;
        }
        if (component instanceof JMenuItem) {
            return null;
        }
        if (component instanceof AbstractButton) {
            return new ButtonWrapper((AbstractButton)component);
        }
        if (component instanceof JLabel) {
            return new LabelWrapper((JLabel)component);
        }
        return null;
    }

    private MnemonicWrapper(T component, String text, String code, String index) {
        this.myComponent = component;
        this.myTextProperty = text;
        this.myCodeProperty = code;
        this.myIndexProperty = index;
        if (!this.updateText()) {
            this.myCode = this.getMnemonicCode();
            this.myIndex = this.getMnemonicIndex();
        }
        this.myFocusable = this.isFocusable();
        ((Component)this.myComponent).addPropertyChangeListener(this);
        this.run();
    }

    @Override
    public final void run() {
        boolean disabled = this.isDisabled();
        try {
            this.myEvent = true;
            if (this.myTextChanged) {
                this.updateText();
            }
            this.setMnemonicCode(disabled ? 0 : this.myCode);
            this.setMnemonicIndex(disabled ? -1 : this.myIndex);
            Component component = this.getFocusableComponent();
            if (component != null) {
                component.setFocusable(disabled || this.myFocusable);
            }
        }
        finally {
            this.myEvent = false;
            this.myTextChanged = false;
            this.myRunnable = null;
        }
    }

    @Override
    public final void propertyChange(PropertyChangeEvent event) {
        if (!this.myEvent) {
            String property = event.getPropertyName();
            if (this.myTextProperty.equals(property)) {
                this.myTextChanged = true;
                this.updateRequest();
            } else if (this.myCodeProperty.equals(property)) {
                this.myCode = this.getMnemonicCode();
                this.updateRequest();
            } else if (this.myIndexProperty.equals(property)) {
                this.myIndex = this.getMnemonicIndex();
                this.updateRequest();
            } else if ("focusable".equals(property) || "labelFor".equals(property)) {
                this.myFocusable = this.isFocusable();
                this.updateRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateText() {
        String text = this.getText();
        if (text != null) {
            int code = 0;
            int index = -1;
            int length = text.length();
            StringBuilder sb = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                char ch = text.charAt(i);
                if (ch != '\u001b') {
                    sb.append(ch);
                    continue;
                }
                if (i + 1 >= length) continue;
                code = KeyEvent.getExtendedKeyCodeForChar(text.charAt(i + 1));
                index = sb.length();
            }
            if (code != 0) {
                try {
                    this.myEvent = true;
                    this.setText(sb.toString());
                }
                finally {
                    this.myEvent = false;
                }
                this.myCode = code;
                this.myIndex = index;
                return true;
            }
        }
        return false;
    }

    private void updateRequest() {
        if (this.myRunnable == null) {
            this.myRunnable = this;
            SwingUtilities.invokeLater(this);
        }
    }

    private boolean isFocusable() {
        Component component = this.getFocusableComponent();
        return component == null || component.isFocusable();
    }

    Component getFocusableComponent() {
        return this.myComponent;
    }

    boolean isDisabled() {
        return UISettings.getShadowInstance().DISABLE_MNEMONICS_IN_CONTROLS;
    }

    abstract String getText();

    abstract void setText(String var1);

    abstract int getMnemonicCode();

    abstract void setMnemonicCode(int var1);

    abstract int getMnemonicIndex();

    abstract void setMnemonicIndex(int var1);

    static KeyStroke fixMacKeyStroke(KeyStroke stroke, InputMap map, int code, boolean onKeyRelease, String action) {
        if (stroke != null && code != stroke.getKeyCode()) {
            map.remove(stroke);
            stroke = null;
        }
        if (stroke == null && code != 0) {
            stroke = KeyStroke.getKeyStroke(code, 520, onKeyRelease);
            map.put(stroke, action);
        }
        return stroke;
    }

    /* synthetic */ MnemonicWrapper(Component x0, String x1, String x2, String x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    private static class LabelWrapper
    extends MnemonicWrapper<JLabel> {
        private KeyStroke myStrokeRelease;

        private LabelWrapper(JLabel component) {
            super(component, "text", "displayedMnemonic", "displayedMnemonicIndex", null);
        }

        @Override
        String getText() {
            return ((JLabel)this.myComponent).getText();
        }

        @Override
        void setText(String text) {
            ((JLabel)this.myComponent).setText(text);
        }

        @Override
        int getMnemonicCode() {
            return ((JLabel)this.myComponent).getDisplayedMnemonic();
        }

        @Override
        void setMnemonicCode(int code) {
            InputMap map;
            ((JLabel)this.myComponent).setDisplayedMnemonic(code);
            if (SystemInfo.isMac && Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl") && (map = ((JLabel)this.myComponent).getInputMap(2)) != null) {
                this.myStrokeRelease = LabelWrapper.fixMacKeyStroke(this.myStrokeRelease, map, code, true, "release");
            }
        }

        @Override
        int getMnemonicIndex() {
            return ((JLabel)this.myComponent).getDisplayedMnemonicIndex();
        }

        @Override
        void setMnemonicIndex(int index) {
            ((JLabel)this.myComponent).setDisplayedMnemonicIndex(index);
        }

        @Override
        Component getFocusableComponent() {
            return ((JLabel)this.myComponent).getLabelFor();
        }
    }

    private static class ButtonWrapper
    extends MnemonicWrapper<AbstractButton> {
        private KeyStroke myStrokePressed;
        private KeyStroke myStrokeReleased;

        private ButtonWrapper(AbstractButton component) {
            super(component, "text", "mnemonic", "displayedMnemonicIndex", null);
        }

        @Override
        String getText() {
            return ((AbstractButton)this.myComponent).getText();
        }

        @Override
        void setText(String text) {
            ((AbstractButton)this.myComponent).setText(text);
        }

        @Override
        int getMnemonicCode() {
            return ((AbstractButton)this.myComponent).getMnemonic();
        }

        @Override
        void setMnemonicCode(int code) {
            InputMap map;
            if (this.getMnemonicCode() != code) {
                ((AbstractButton)this.myComponent).setMnemonic(code);
            }
            if (SystemInfo.isMac && Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl") && (map = ((AbstractButton)this.myComponent).getInputMap(2)) != null) {
                this.myStrokePressed = ButtonWrapper.fixMacKeyStroke(this.myStrokePressed, map, code, false, "pressed");
                this.myStrokeReleased = ButtonWrapper.fixMacKeyStroke(this.myStrokeReleased, map, code, true, "released");
            }
        }

        @Override
        int getMnemonicIndex() {
            return ((AbstractButton)this.myComponent).getDisplayedMnemonicIndex();
        }

        @Override
        void setMnemonicIndex(int index) {
            if (this.getMnemonicIndex() != index) {
                ((AbstractButton)this.myComponent).setDisplayedMnemonicIndex(index);
            }
        }
    }

    private static class MenuWrapper
    extends ButtonWrapper {
        private MenuWrapper(AbstractButton component) {
            super(component);
        }

        @Override
        boolean isDisabled() {
            return UISettings.getShadowInstance().DISABLE_MNEMONICS;
        }
    }
}

