/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnAction
implements PossiblyDumbAware {
    private static final Logger LOG = Logger.getInstance(AnAction.class);
    public static final Key<List<AnAction>> ACTIONS_KEY = Key.create((String)"AnAction.shortcutSet");
    public static final AnAction[] EMPTY_ARRAY = new AnAction[0];
    private Presentation myTemplatePresentation;
    private ShortcutSet myShortcutSet = CustomShortcutSet.EMPTY;
    private boolean myEnabledInModalContext = false;
    private boolean myIsDefaultIcon = true;
    private boolean myWorksInInjected;
    private boolean myIsGlobal;

    public AnAction() {
        this(null, null, null);
    }

    public AnAction(Icon icon) {
        this(null, null, icon);
    }

    public AnAction(@Nullable String text) {
        this(text, null, null);
    }

    public AnAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(text);
        presentation.setDescription(description);
        presentation.setIcon(icon);
    }

    public final ShortcutSet getShortcutSet() {
        return this.myShortcutSet;
    }

    public final void registerCustomShortcutSet(@NotNull ShortcutSet shortcutSet, @Nullable JComponent component) {
        if (shortcutSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutSet", "com/intellij/openapi/actionSystem/AnAction", "registerCustomShortcutSet"));
        }
        this.registerCustomShortcutSet(shortcutSet, component, null);
    }

    public final void registerCustomShortcutSet(int keyCode, @JdkConstants.InputEventMask int modifiers, @Nullable JComponent component) {
        this.registerCustomShortcutSet(new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, modifiers)), component);
    }

    public final void registerCustomShortcutSet(@NotNull ShortcutSet shortcutSet, @Nullable JComponent component, @Nullable Disposable parentDisposable) {
        if (shortcutSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcutSet", "com/intellij/openapi/actionSystem/AnAction", "registerCustomShortcutSet"));
        }
        this.setShortcutSet(shortcutSet);
        this.registerCustomShortcutSet(component, parentDisposable);
    }

    public final void registerCustomShortcutSet(final @Nullable JComponent component, @Nullable Disposable parentDisposable) {
        if (component == null) {
            return;
        }
        List actionList = (List)UIUtil.getClientProperty((Object)component, ACTIONS_KEY);
        if (actionList == null) {
            actionList = new SmartList();
            UIUtil.putClientProperty((JComponent)component, ACTIONS_KEY, (Object)actionList);
        }
        if (!actionList.contains(this)) {
            actionList.add(this);
        }
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    AnAction.this.unregisterCustomShortcutSet(component);
                }
            });
        }
    }

    public final void unregisterCustomShortcutSet(@Nullable JComponent component) {
        List actionList = (List)UIUtil.getClientProperty((Object)component, ACTIONS_KEY);
        if (actionList != null) {
            actionList.remove(this);
        }
    }

    public final void copyFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceAction", "com/intellij/openapi/actionSystem/AnAction", "copyFrom"));
        }
        Presentation sourcePresentation = sourceAction.getTemplatePresentation();
        Presentation presentation = this.getTemplatePresentation();
        presentation.copyFrom(sourcePresentation);
        this.copyShortcutFrom(sourceAction);
    }

    public final void copyShortcutFrom(@NotNull AnAction sourceAction) {
        if (sourceAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceAction", "com/intellij/openapi/actionSystem/AnAction", "copyShortcutFrom"));
        }
        this.setShortcutSet(sourceAction.getShortcutSet());
    }

    public final boolean isEnabledInModalContext() {
        return this.myEnabledInModalContext;
    }

    protected final void setEnabledInModalContext(boolean enabledInModalContext) {
        this.myEnabledInModalContext = enabledInModalContext;
    }

    public boolean displayTextInToolbar() {
        return false;
    }

    public void update(AnActionEvent e) {
    }

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/AnAction", "beforeActionPerformedUpdate"));
        }
        boolean worksInInjected = this.isInInjectedContext();
        e.setInjectedContext(worksInInjected);
        this.update(e);
        if (!e.getPresentation().isEnabled() && worksInInjected) {
            e.setInjectedContext(false);
            this.update(e);
        }
    }

    @NotNull
    public final Presentation getTemplatePresentation() {
        Presentation presentation = this.myTemplatePresentation;
        if (presentation == null) {
            this.myTemplatePresentation = presentation = new Presentation();
        }
        Presentation presentation2 = presentation;
        if (presentation2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/AnAction", "getTemplatePresentation"));
        }
        return presentation2;
    }

    public abstract void actionPerformed(AnActionEvent var1);

    protected void setShortcutSet(ShortcutSet shortcutSet) {
        if (this.myIsGlobal && this.myShortcutSet != shortcutSet) {
            LOG.warn("ShortcutSet of global AnActions should not be changed outside of KeymapManager.\nThis is likely not what you wanted to do. Consider setting shortcut in keymap defaults, inheriting from other action using `use-shortcut-of` or wrapping with EmptyAction.wrap().", new Throwable());
        }
        this.myShortcutSet = shortcutSet;
    }

    public void setDefaultIcon(boolean isDefaultIconSet) {
        this.myIsDefaultIcon = isDefaultIconSet;
    }

    public boolean isDefaultIcon() {
        return this.myIsDefaultIcon;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }

    public boolean isTransparentUpdate() {
        return this instanceof TransparentUpdate;
    }

    @Override
    public boolean isDumbAware() {
        return this instanceof DumbAware;
    }

    public boolean startInTransaction() {
        return false;
    }

    @Nullable
    public static Project getEventProject(AnActionEvent e) {
        return e == null ? null : e.getData(CommonDataKeys.PROJECT);
    }

    public String toString() {
        return this.getTemplatePresentation().toString();
    }

    void markAsGlobal() {
        this.myIsGlobal = true;
    }

    public static interface TransparentUpdate {
    }
}

