/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CachedValuesManager {
    private static final NotNullLazyKey<CachedValuesManager, Project> INSTANCE_KEY = ServiceManager.createLazyKey(CachedValuesManager.class);
    private final ConcurrentMap<String, Key<CachedValue>> keyForProvider = ContainerUtil.newConcurrentMap();
    private static final ConcurrentMap<String, Key<CachedValue>> globalKeyForProvider = ContainerUtil.newConcurrentMap();

    public static CachedValuesManager getManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/util/CachedValuesManager", "getManager"));
        }
        return (CachedValuesManager)INSTANCE_KEY.getValue((UserDataHolder)project);
    }

    @NotNull
    public abstract <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> var1, boolean var2);

    @NotNull
    public abstract <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> var1, boolean var2);

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/util/CachedValuesManager", "createCachedValue"));
        }
        CachedValue<T> cachedValue = this.createCachedValue(provider, true);
        if (cachedValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/CachedValuesManager", "createCachedValue"));
        }
        return cachedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, D extends UserDataHolder, P> T getParameterizedCachedValue(@NotNull D dataHolder, @NotNull Key<ParameterizedCachedValue<T, P>> key, @NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue, P parameter) {
        ParameterizedCachedValue value;
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/psi/util/CachedValuesManager", "getParameterizedCachedValue"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/util/CachedValuesManager", "getParameterizedCachedValue"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/util/CachedValuesManager", "getParameterizedCachedValue"));
        }
        if (dataHolder instanceof UserDataHolderEx) {
            UserDataHolderEx dh = (UserDataHolderEx)dataHolder;
            value = (ParameterizedCachedValue)dh.getUserData(key);
            if (value == null) {
                value = this.createParameterizedCachedValue(provider, trackValue);
                value = (ParameterizedCachedValue)dh.putUserDataIfAbsent(key, value);
            }
        } else {
            D d = dataHolder;
            synchronized (d) {
                value = (ParameterizedCachedValue)dataHolder.getUserData(key);
                if (value == null) {
                    value = this.createParameterizedCachedValue(provider, trackValue);
                    dataHolder.putUserData(key, (Object)value);
                }
            }
        }
        return value.getValue(parameter);
    }

    public abstract <T, D extends UserDataHolder> T getCachedValue(@NotNull D var1, @NotNull Key<CachedValue<T>> var2, @NotNull CachedValueProvider<T> var3, boolean var4);

    public <T, D extends UserDataHolder> T getCachedValue(@NotNull D dataHolder, @NotNull CachedValueProvider<T> provider) {
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        return this.getCachedValue(dataHolder, this.getKeyForClass(provider.getClass()), provider, false);
    }

    public static <T> T getCachedValue(@NotNull PsiElement psi, @NotNull CachedValueProvider<T> provider) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/util/CachedValuesManager", "getCachedValue"));
        }
        Key<CachedValue<T>> key = CachedValuesManager.getKeyForClass(provider.getClass(), globalKeyForProvider);
        CachedValue value = (CachedValue)psi.getUserData(key);
        return value == null ? CachedValuesManager.computeAndGet(psi, key, provider) : value.getValue();
    }

    public static <T> T computeAndGet(final @NotNull PsiElement psi, @NotNull Key<CachedValue<T>> key, final @NotNull CachedValueProvider<T> provider) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/psi/util/CachedValuesManager", "computeAndGet"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/util/CachedValuesManager", "computeAndGet"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/util/CachedValuesManager", "computeAndGet"));
        }
        return CachedValuesManager.getManager(psi.getProject()).getCachedValue(psi, key, new CachedValueProvider<T>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<T> compute() {
                PsiFile file;
                CachedValueProvider.Result result = provider.compute();
                if (result != null && !psi.isPhysical() && (file = psi.getContainingFile()) != null) {
                    return CachedValueProvider.Result.create(result.getValue(), ArrayUtil.append((Object[])result.getDependencyItems(), (Object)file, (ArrayFactory)ArrayUtil.OBJECT_ARRAY_FACTORY));
                }
                return result;
            }
        }, false);
    }

    @NotNull
    public <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass) {
        if (providerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerClass", "com/intellij/psi/util/CachedValuesManager", "getKeyForClass"));
        }
        Key<CachedValue<T>> key = CachedValuesManager.getKeyForClass(providerClass, this.keyForProvider);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/CachedValuesManager", "getKeyForClass"));
        }
        return key;
    }

    @NotNull
    private static <T> Key<CachedValue<T>> getKeyForClass(@NotNull Class<?> providerClass, ConcurrentMap<String, Key<CachedValue>> keyForProvider) {
        if (providerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerClass", "com/intellij/psi/util/CachedValuesManager", "getKeyForClass"));
        }
        String name = providerClass.getName();
        assert (name != null) : providerClass + " doesn't have a name; can't be used for cache value provider";
        Key key = (Key)keyForProvider.get(name);
        if (key == null) {
            key = (Key)ConcurrencyUtil.cacheOrGet(keyForProvider, (Object)name, (Object)Key.create((String)name));
        }
        Key key2 = key;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/CachedValuesManager", "getKeyForClass"));
        }
        return key2;
    }
}

