/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.impl.JBEditorTabsPainter;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class DefaultEditorTabsPainter
extends JBEditorTabsPainter {
    @Override
    public void doPaintInactive(Graphics2D g2d, Rectangle effectiveBounds, int x, int y, int w, int h, Color tabColor, int row, int column, boolean vertical) {
        g2d.setColor(tabColor != null ? tabColor : this.getDefaultTabColor());
        g2d.fillRect(x, y, w, h);
        if (Registry.is((String)"ide.new.editor.tabs.selection")) {
            return;
        }
        g2d.setColor(this.getInactiveMaskColor());
        g2d.fillRect(x, y, w, h);
    }

    @Override
    public void doPaintBackground(Graphics2D g, Rectangle clip, boolean vertical, Rectangle rectangle) {
        g.setColor((Color)(Registry.is((String)"ide.new.editor.tabs.selection") ? new JBColor((Color)Gray._255, (Color)Gray._60) : this.getBackgroundColor()));
        g.fill(clip);
    }

    @Override
    public void fillSelectionAndBorder(Graphics2D g, JBTabsImpl.ShapeInfo selectedShape, Color tabColor, int x, int y, int height) {
        g.setColor(tabColor != null ? tabColor : this.getDefaultTabColor());
        g.fill(selectedShape.fillPath.getShape());
    }

    @Override
    public Color getBackgroundColor() {
        return Registry.is((String)"ide.new.editor.tabs.selection") ? new JBColor((Color)Gray._255, (Color)Gray._60) : UIUtil.CONTRAST_BORDER_COLOR;
    }

    protected Color getDefaultTabColor() {
        if (this.myDefaultTabColor != null) {
            return this.myDefaultTabColor;
        }
        return Color.WHITE;
    }

    protected Color getInactiveMaskColor() {
        return ColorUtil.withAlpha((Color)new Color(0x262626), (double)0.2);
    }
}

