/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.util.ValueConv;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class Buffers {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    protected Buffers() {
    }

    public static ByteBuffer newDirectByteBuffer(int n) {
        return Buffers.nativeOrder(ByteBuffer.allocateDirect(n));
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n, int n2) {
        return (ByteBuffer)Buffers.newDirectByteBuffer(n2).put(byArray, n, n2).rewind();
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n) {
        return Buffers.newDirectByteBuffer(byArray, n, byArray.length - n);
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray) {
        return Buffers.newDirectByteBuffer(byArray, 0);
    }

    public static DoubleBuffer newDirectDoubleBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 8).asDoubleBuffer();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n, int n2) {
        return (DoubleBuffer)Buffers.newDirectDoubleBuffer(n2).put(dArray, n, n2).rewind();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n) {
        return Buffers.newDirectDoubleBuffer(dArray, n, dArray.length - n);
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray) {
        return Buffers.newDirectDoubleBuffer(dArray, 0);
    }

    public static FloatBuffer newDirectFloatBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 4).asFloatBuffer();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n, int n2) {
        return (FloatBuffer)Buffers.newDirectFloatBuffer(n2).put(fArray, n, n2).rewind();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n) {
        return Buffers.newDirectFloatBuffer(fArray, n, fArray.length - n);
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray) {
        return Buffers.newDirectFloatBuffer(fArray, 0);
    }

    public static IntBuffer newDirectIntBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 4).asIntBuffer();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n, int n2) {
        return (IntBuffer)Buffers.newDirectIntBuffer(n2).put(nArray, n, n2).rewind();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n) {
        return Buffers.newDirectIntBuffer(nArray, n, nArray.length - n);
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray) {
        return Buffers.newDirectIntBuffer(nArray, 0);
    }

    public static LongBuffer newDirectLongBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 8).asLongBuffer();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n, int n2) {
        return (LongBuffer)Buffers.newDirectLongBuffer(n2).put(lArray, n, n2).rewind();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n) {
        return Buffers.newDirectLongBuffer(lArray, n, lArray.length - n);
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray) {
        return Buffers.newDirectLongBuffer(lArray, 0);
    }

    public static ShortBuffer newDirectShortBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 2).asShortBuffer();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n, int n2) {
        return (ShortBuffer)Buffers.newDirectShortBuffer(n2).put(sArray, n, n2).rewind();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n) {
        return Buffers.newDirectShortBuffer(sArray, n, sArray.length - n);
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray) {
        return Buffers.newDirectShortBuffer(sArray, 0);
    }

    public static CharBuffer newDirectCharBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 2).asCharBuffer();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n, int n2) {
        return (CharBuffer)Buffers.newDirectCharBuffer(n2).put(cArray, n, n2).rewind();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n) {
        return Buffers.newDirectCharBuffer(cArray, n, cArray.length - n);
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray) {
        return Buffers.newDirectCharBuffer(cArray, 0);
    }

    public static <B extends Buffer> B slice(B b) {
        if (b instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)b;
            return (B)byteBuffer.slice().order(byteBuffer.order());
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).slice();
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).slice();
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).slice();
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).slice();
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).slice();
        }
        if (b instanceof CharBuffer) {
            return (B)((CharBuffer)b).slice();
        }
        String string = String.valueOf(b.getClass());
        throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length()).append("unexpected buffer type: ").append(string).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B extends Buffer> B slice(B b, int n, int n2) {
        int n3 = b.position();
        int n4 = b.limit();
        B b2 = null;
        try {
            b.position(n).limit(n + n2);
            b2 = Buffers.slice(b);
        }
        finally {
            b.position(n3).limit(n4);
        }
        return b2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final FloatBuffer slice2Float(Buffer buffer, int n, int n2) {
        FloatBuffer floatBuffer;
        block8: {
            int n3;
            int n4;
            if (null != buffer) {
                n4 = buffer.position();
                n3 = buffer.limit();
            } else {
                n4 = 0;
                n3 = 0;
            }
            try {
                if (buffer instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)buffer;
                    byteBuffer.position(n * 4);
                    byteBuffer.limit((n + n2) * 4);
                    floatBuffer = byteBuffer.slice().order(byteBuffer.order()).asFloatBuffer();
                    break block8;
                }
                if (buffer instanceof FloatBuffer) {
                    FloatBuffer floatBuffer2 = (FloatBuffer)buffer;
                    floatBuffer2.position(n);
                    floatBuffer2.limit(n + n2);
                    floatBuffer = floatBuffer2.slice();
                    break block8;
                }
                throw new InternalError("Buffer not ByteBuffer, nor FloarBuffer, nor backing array given");
            }
            finally {
                if (null != buffer) {
                    buffer.position(n4).limit(n3);
                }
            }
        }
        floatBuffer.mark();
        return floatBuffer;
    }

    public static final FloatBuffer slice2Float(float[] fArray, int n, int n2) {
        return (FloatBuffer)FloatBuffer.wrap(fArray, n, n2).mark();
    }

    public static ByteBuffer nativeOrder(ByteBuffer byteBuffer) {
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    public static int sizeOfBufferElem(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof ByteBuffer) {
            return 1;
        }
        if (object instanceof IntBuffer) {
            return 4;
        }
        if (object instanceof ShortBuffer) {
            return 2;
        }
        if (object instanceof FloatBuffer) {
            return 4;
        }
        if (object instanceof DoubleBuffer) {
            return 8;
        }
        if (object instanceof LongBuffer) {
            return 8;
        }
        if (object instanceof CharBuffer) {
            return 2;
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).elementSize();
        }
        String string = String.valueOf(object.getClass().getName());
        throw new RuntimeException(string.length() != 0 ? "Unexpected buffer type ".concat(string) : new String("Unexpected buffer type "));
    }

    public static int remainingElem(Object object) throws IllegalArgumentException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).remaining();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).remaining();
        }
        String string = String.valueOf(object.getClass().getCanonicalName());
        throw new IllegalArgumentException(string.length() != 0 ? "Unsupported anonymous buffer type: ".concat(string) : new String("Unsupported anonymous buffer type: "));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int remainingBytes(Object object) throws IllegalArgumentException {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).remaining();
            if (object instanceof ByteBuffer) {
                return n;
            }
            if (object instanceof FloatBuffer) {
                return n * 4;
            }
            if (object instanceof IntBuffer) {
                return n * 4;
            }
            if (object instanceof ShortBuffer) {
                return n * 2;
            }
            if (object instanceof DoubleBuffer) {
                return n * 8;
            }
            if (object instanceof LongBuffer) {
                return n * 8;
            }
            if (object instanceof CharBuffer) {
                return n * 2;
            }
            String string = String.valueOf(object.getClass().getCanonicalName());
            throw new InternalError(string.length() != 0 ? "Unsupported Buffer type: ".concat(string) : new String("Unsupported Buffer type: "));
        }
        if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.remaining() * nativeBuffer.elementSize();
        }
        String string = String.valueOf(object.getClass().getCanonicalName());
        throw new IllegalArgumentException(string.length() != 0 ? "Unsupported anonymous buffer type: ".concat(string) : new String("Unsupported anonymous buffer type: "));
    }

    public static boolean isDirect(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).isDirect();
        }
        if (object instanceof PointerBuffer) {
            return ((PointerBuffer)object).isDirect();
        }
        String string = String.valueOf(object.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "Unexpected buffer type ".concat(string) : new String("Unexpected buffer type "));
    }

    public static int getDirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return n;
            }
            if (object instanceof FloatBuffer) {
                return n * 4;
            }
            if (object instanceof IntBuffer) {
                return n * 4;
            }
            if (object instanceof ShortBuffer) {
                return n * 2;
            }
            if (object instanceof DoubleBuffer) {
                return n * 8;
            }
            if (object instanceof LongBuffer) {
                return n * 8;
            }
            if (object instanceof CharBuffer) {
                return n * 2;
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.position() * nativeBuffer.elementSize();
        }
        String string = String.valueOf(object.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "Disallowed array backing store type in buffer ".concat(string) : new String("Disallowed array backing store type in buffer "));
    }

    public static Object getArray(Object object) throws UnsupportedOperationException, IllegalArgumentException {
        if (object == null) {
            return null;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).array();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).array();
        }
        String string = String.valueOf(object.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "Disallowed array backing store type in buffer ".concat(string) : new String("Disallowed array backing store type in buffer "));
    }

    public static int getIndirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return ((ByteBuffer)object).arrayOffset() + n;
            }
            if (object instanceof FloatBuffer) {
                return 4 * (((FloatBuffer)object).arrayOffset() + n);
            }
            if (object instanceof IntBuffer) {
                return 4 * (((IntBuffer)object).arrayOffset() + n);
            }
            if (object instanceof ShortBuffer) {
                return 2 * (((ShortBuffer)object).arrayOffset() + n);
            }
            if (object instanceof DoubleBuffer) {
                return 8 * (((DoubleBuffer)object).arrayOffset() + n);
            }
            if (object instanceof LongBuffer) {
                return 8 * (((LongBuffer)object).arrayOffset() + n);
            }
            if (object instanceof CharBuffer) {
                return 2 * (((CharBuffer)object).arrayOffset() + n);
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.elementSize() * (nativeBuffer.arrayOffset() + nativeBuffer.position());
        }
        String string = String.valueOf(object.getClass().getName());
        throw new IllegalArgumentException(string.length() != 0 ? "Unknown buffer type ".concat(string) : new String("Unknown buffer type "));
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.rewind();
        byteBuffer.position(n);
        return byteBuffer2;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        return Buffers.copyFloatBufferAsByteBuffer(floatBuffer).asFloatBuffer();
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        return Buffers.copyIntBufferAsByteBuffer(intBuffer).asIntBuffer();
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer shortBuffer) {
        return Buffers.copyShortBufferAsByteBuffer(shortBuffer).asShortBuffer();
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer floatBuffer) {
        int n = floatBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(floatBuffer.remaining() * 4);
        byteBuffer.asFloatBuffer().put(floatBuffer);
        byteBuffer.rewind();
        floatBuffer.position(n);
        return byteBuffer;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer intBuffer) {
        int n = intBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(intBuffer.remaining() * 4);
        byteBuffer.asIntBuffer().put(intBuffer);
        byteBuffer.rewind();
        intBuffer.position(n);
        return byteBuffer;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer shortBuffer) {
        int n = shortBuffer.position();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(shortBuffer.remaining() * 2);
        byteBuffer.asShortBuffer().put(shortBuffer);
        byteBuffer.rewind();
        shortBuffer.position(n);
        return byteBuffer;
    }

    public static float[] getFloatArray(double[] dArray, int n, float[] fArray, int n2, int n3) {
        if (0 > n3) {
            n3 = dArray.length - n;
        }
        if (n3 > dArray.length - n) {
            int n4 = n3;
            int n5 = dArray.length;
            throw new IllegalArgumentException(new StringBuilder(95).append("payload (").append(n4).append(") greater than remaining source bytes [len ").append(n5).append(", offset ").append(n).append("]").toString());
        }
        if (null == fArray) {
            fArray = new float[n3];
            n2 = 0;
        }
        if (n3 > fArray.length - n2) {
            int n6 = n3;
            int n7 = fArray.length;
            int n8 = n2;
            throw new IllegalArgumentException(new StringBuilder(93).append("payload (").append(n6).append(") greater than remaining dest bytes [len ").append(n7).append(", offset ").append(n8).append("]").toString());
        }
        for (int i = 0; i < n3; ++i) {
            fArray[n2 + i] = (float)dArray[n + i];
        }
        return fArray;
    }

    public static FloatBuffer getFloatBuffer(DoubleBuffer doubleBuffer, FloatBuffer floatBuffer) {
        if (null == floatBuffer) {
            floatBuffer = Buffers.newDirectFloatBuffer(doubleBuffer.remaining());
        }
        if (floatBuffer.remaining() < doubleBuffer.remaining()) {
            int n = doubleBuffer.remaining();
            int n2 = floatBuffer.remaining();
            throw new IllegalArgumentException(new StringBuilder(71).append("payload (").append(n).append(") is greater than remaining dest bytes: ").append(n2).toString());
        }
        while (doubleBuffer.hasRemaining()) {
            floatBuffer.put((float)doubleBuffer.get());
        }
        return floatBuffer;
    }

    public static double[] getDoubleArray(float[] fArray, int n, double[] dArray, int n2, int n3) {
        if (0 > n3) {
            n3 = fArray.length - n;
        }
        if (n3 > fArray.length - n) {
            int n4 = n3;
            int n5 = fArray.length;
            throw new IllegalArgumentException(new StringBuilder(95).append("payload (").append(n4).append(") greater than remaining source bytes [len ").append(n5).append(", offset ").append(n).append("]").toString());
        }
        if (null == dArray) {
            dArray = new double[n3];
            n2 = 0;
        }
        if (n3 > dArray.length - n2) {
            int n6 = n3;
            int n7 = dArray.length;
            int n8 = n2;
            throw new IllegalArgumentException(new StringBuilder(93).append("payload (").append(n6).append(") greater than remaining dest bytes [len ").append(n7).append(", offset ").append(n8).append("]").toString());
        }
        for (int i = 0; i < n3; ++i) {
            dArray[n2 + i] = fArray[n + i];
        }
        return dArray;
    }

    public static DoubleBuffer getDoubleBuffer(FloatBuffer floatBuffer, DoubleBuffer doubleBuffer) {
        if (null == doubleBuffer) {
            doubleBuffer = Buffers.newDirectDoubleBuffer(floatBuffer.remaining());
        }
        if (doubleBuffer.remaining() < floatBuffer.remaining()) {
            int n = floatBuffer.remaining();
            int n2 = doubleBuffer.remaining();
            throw new IllegalArgumentException(new StringBuilder(71).append("payload (").append(n).append(") is greater than remaining dest bytes: ").append(n2).toString());
        }
        while (floatBuffer.hasRemaining()) {
            doubleBuffer.put(floatBuffer.get());
        }
        return doubleBuffer;
    }

    public static <B extends Buffer> B put(B b, Buffer buffer) {
        if (b instanceof ByteBuffer && buffer instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put((ByteBuffer)buffer);
        }
        if (b instanceof ShortBuffer && buffer instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put((ShortBuffer)buffer);
        }
        if (b instanceof IntBuffer && buffer instanceof IntBuffer) {
            return (B)((IntBuffer)b).put((IntBuffer)buffer);
        }
        if (b instanceof FloatBuffer && buffer instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put((FloatBuffer)buffer);
        }
        if (b instanceof LongBuffer && buffer instanceof LongBuffer) {
            return (B)((LongBuffer)b).put((LongBuffer)buffer);
        }
        if (b instanceof DoubleBuffer && buffer instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put((DoubleBuffer)buffer);
        }
        if (b instanceof CharBuffer && buffer instanceof CharBuffer) {
            return (B)((CharBuffer)b).put((CharBuffer)buffer);
        }
        String string = String.valueOf(b.getClass().getName());
        String string2 = String.valueOf(buffer.getClass().getName());
        throw new IllegalArgumentException(new StringBuilder(44 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Incompatible Buffer classes: dest = ").append(string).append(", src = ").append(string2).toString());
    }

    public static <B extends Buffer> B putb(B b, byte by) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(by);
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(by);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(by);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(by);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(by);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(by);
        }
        if (b instanceof CharBuffer) {
            return (B)((CharBuffer)b).put((char)by);
        }
        String string = String.valueOf(b);
        throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length()).append("Byte doesn't match Buffer Class: ").append(string).toString());
    }

    public static <B extends Buffer> B puts(B b, short s) {
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(s);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(s);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(s);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(s);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(s);
        }
        String string = String.valueOf(b);
        throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(string).length()).append("Short doesn't match Buffer Class: ").append(string).toString());
    }

    public static <B extends Buffer> B puti(B b, int n) {
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(n);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(n);
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).put(n);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(n);
        }
        String string = String.valueOf(b);
        throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(string).length()).append("Integer doesn't match Buffer Class: ").append(string).toString());
    }

    public static <B extends Buffer> B putf(B b, float f) {
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(f);
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put(f);
        }
        String string = String.valueOf(b);
        throw new IllegalArgumentException(new StringBuilder(34 + String.valueOf(string).length()).append("Float doesn't match Buffer Class: ").append(string).toString());
    }

    public static <B extends Buffer> B putd(B b, double d) {
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put((float)d);
        }
        String string = String.valueOf(b);
        throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(string).length()).append("Double doesn't match Buffer Class: ").append(string).toString());
    }

    public static <B extends Buffer> B putNb(B b, boolean bl, byte by, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(by);
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.byte_to_short(by, bl2, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.byte_to_int(by, bl2, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.byte_to_float(by, bl2));
        }
        String string = String.valueOf(b);
        throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length()).append("Byte doesn't match Buffer Class: ").append(string).toString());
    }

    public static <B extends Buffer> B putNs(B b, boolean bl, short s, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.short_to_byte(s, bl2, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(s);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.short_to_int(s, bl2, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.short_to_float(s, bl2));
        }
        String string = String.valueOf(b);
        throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length()).append("Byte doesn't match Buffer Class: ").append(string).toString());
    }

    public static <B extends Buffer> B putNi(B b, boolean bl, int n, boolean bl2) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.int_to_byte(n, bl2, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.int_to_short(n, bl2, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(n);
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(ValueConv.int_to_float(n, bl2));
        }
        String string = String.valueOf(b);
        throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length()).append("Byte doesn't match Buffer Class: ").append(string).toString());
    }

    public static <B extends Buffer> B putNf(B b, boolean bl, float f) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(ValueConv.float_to_byte(f, bl));
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(ValueConv.float_to_short(f, bl));
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(ValueConv.float_to_int(f, bl));
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(f);
        }
        String string = String.valueOf(b);
        throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length()).append("Byte doesn't match Buffer Class: ").append(string).toString());
    }

    public static void rangeCheck(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return;
        }
        if (byArray.length < n + n2) {
            int n3 = byArray.length - n;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(60).append("Required ").append(n2).append(" elements in array, only had ").append(n3).toString());
        }
    }

    public static void rangeCheck(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return;
        }
        if (cArray.length < n + n2) {
            int n3 = cArray.length - n;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(60).append("Required ").append(n2).append(" elements in array, only had ").append(n3).toString());
        }
    }

    public static void rangeCheck(short[] sArray, int n, int n2) {
        if (sArray == null) {
            return;
        }
        if (sArray.length < n + n2) {
            int n3 = sArray.length - n;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(60).append("Required ").append(n2).append(" elements in array, only had ").append(n3).toString());
        }
    }

    public static void rangeCheck(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return;
        }
        if (nArray.length < n + n2) {
            int n3 = nArray.length - n;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(60).append("Required ").append(n2).append(" elements in array, only had ").append(n3).toString());
        }
    }

    public static void rangeCheck(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return;
        }
        if (lArray.length < n + n2) {
            int n3 = lArray.length - n;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(60).append("Required ").append(n2).append(" elements in array, only had ").append(n3).toString());
        }
    }

    public static void rangeCheck(float[] fArray, int n, int n2) {
        if (fArray == null) {
            return;
        }
        if (fArray.length < n + n2) {
            int n3 = fArray.length - n;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(60).append("Required ").append(n2).append(" elements in array, only had ").append(n3).toString());
        }
    }

    public static void rangeCheck(double[] dArray, int n, int n2) {
        if (dArray == null) {
            return;
        }
        if (dArray.length < n + n2) {
            int n3 = dArray.length - n;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(60).append("Required ").append(n2).append(" elements in array, only had ").append(n3).toString());
        }
    }

    public static void rangeCheck(Buffer buffer, int n) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < n) {
            int n2 = buffer.remaining();
            throw new IndexOutOfBoundsException(new StringBuilder(71).append("Required ").append(n).append(" remaining elements in buffer, only had ").append(n2).toString());
        }
    }

    public static void rangeCheckBytes(Object object, int n) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (object == null) {
            return;
        }
        int n2 = Buffers.remainingBytes(object);
        if (n2 < n) {
            throw new IndexOutOfBoundsException(new StringBuilder(68).append("Required ").append(n).append(" remaining bytes in buffer, only had ").append(n2).toString());
        }
    }

    public static StringBuilder toString(StringBuilder stringBuilder, String string, Buffer buffer) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(buffer.getClass().getSimpleName());
        stringBuilder.append("[pos ").append(buffer.position()).append(", lim ").append(buffer.limit()).append(", cap ").append(buffer.capacity());
        stringBuilder.append(", remaining ").append(buffer.remaining());
        stringBuilder.append("; array ").append(buffer.hasArray()).append(", direct ").append(buffer.isDirect());
        stringBuilder.append(", r/w ").append(!buffer.isReadOnly()).append(": ");
        if (buffer instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)buffer;
            for (int i = 0; i < byteBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(byteBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, byteBuffer.get(i)));
            }
        } else if (buffer instanceof FloatBuffer) {
            FloatBuffer floatBuffer = (FloatBuffer)buffer;
            for (int i = 0; i < floatBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(floatBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, Float.valueOf(floatBuffer.get(i))));
            }
        } else if (buffer instanceof IntBuffer) {
            IntBuffer intBuffer = (IntBuffer)buffer;
            for (int i = 0; i < intBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(intBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, intBuffer.get(i)));
            }
        } else if (buffer instanceof ShortBuffer) {
            ShortBuffer shortBuffer = (ShortBuffer)buffer;
            for (int i = 0; i < shortBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(shortBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, shortBuffer.get(i)));
            }
        } else if (buffer instanceof DoubleBuffer) {
            DoubleBuffer doubleBuffer = (DoubleBuffer)buffer;
            for (int i = 0; i < doubleBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(doubleBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, doubleBuffer.get(i)));
            }
        } else if (buffer instanceof LongBuffer) {
            LongBuffer longBuffer = (LongBuffer)buffer;
            for (int i = 0; i < longBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(longBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, longBuffer.get(i)));
            }
        } else if (buffer instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)buffer;
            for (int i = 0; i < charBuffer.limit(); ++i) {
                if (0 < i) {
                    stringBuilder.append(", ");
                }
                if (null == string) {
                    stringBuilder.append(charBuffer.get(i));
                    continue;
                }
                stringBuilder.append(String.format(string, Character.valueOf(charBuffer.get(i))));
            }
        }
        stringBuilder.append("]");
        return stringBuilder;
    }
}

