/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.InputPropertiesSerializer;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private static final int MAX_HISTORY_ENTRIES = 3;
    private final TaskArtifactStateCacheAccess cacheAccess;
    private final FileSnapshotRepository snapshotRepository;
    private final PersistentIndexedCache<String, TaskExecutionList> taskHistoryCache;
    private final TaskExecutionListSerializer serializer;
    private final StringInterner stringInterner;

    public CacheBackedTaskHistoryRepository(TaskArtifactStateCacheAccess cacheAccess, FileSnapshotRepository snapshotRepository, StringInterner stringInterner) {
        this.cacheAccess = cacheAccess;
        this.snapshotRepository = snapshotRepository;
        this.stringInterner = stringInterner;
        this.serializer = new TaskExecutionListSerializer(stringInterner);
        this.taskHistoryCache = cacheAccess.createCache("taskArtifacts", String.class, this.serializer);
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal task) {
        final TaskExecutionList previousExecutions = this.loadPreviousExecutions(task);
        final LazyTaskExecution currentExecution = new LazyTaskExecution();
        currentExecution.snapshotRepository = this.snapshotRepository;
        currentExecution.cacheAccess = this.cacheAccess;
        currentExecution.setDeclaredOutputFilePaths(this.getDeclaredOutputFilePaths(task));
        final LazyTaskExecution previousExecution = this.findBestMatchingPreviousExecution(currentExecution, previousExecutions.executions);
        if (previousExecution != null) {
            previousExecution.snapshotRepository = this.snapshotRepository;
            previousExecution.cacheAccess = this.cacheAccess;
        }
        return new TaskHistoryRepository.History(){

            public TaskExecution getPreviousExecution() {
                return previousExecution;
            }

            public TaskExecution getCurrentExecution() {
                return currentExecution;
            }

            public void update() {
                CacheBackedTaskHistoryRepository.this.cacheAccess.useCache("Update task history", new Runnable(){

                    public void run() {
                        ImmutableSortedMap.Builder builder;
                        previousExecutions.executions.addFirst(currentExecution);
                        if (currentExecution.inputFilesSnapshotIds == null && currentExecution.inputFilesSnapshot != null) {
                            builder = ImmutableSortedMap.naturalOrder();
                            for (Map.Entry entry : currentExecution.inputFilesSnapshot.entrySet()) {
                                builder.put(entry.getKey(), (Object)CacheBackedTaskHistoryRepository.this.snapshotRepository.add((FileCollectionSnapshot)entry.getValue()));
                            }
                            currentExecution.inputFilesSnapshotIds = (Map)builder.build();
                        }
                        if (currentExecution.outputFilesSnapshotIds == null && currentExecution.outputFilesSnapshot != null) {
                            builder = ImmutableSortedMap.naturalOrder();
                            for (Map.Entry entry : currentExecution.outputFilesSnapshot.entrySet()) {
                                builder.put(entry.getKey(), (Object)CacheBackedTaskHistoryRepository.this.snapshotRepository.add((FileCollectionSnapshot)entry.getValue()));
                            }
                            currentExecution.outputFilesSnapshotIds = (Map)builder.build();
                        }
                        if (currentExecution.discoveredFilesSnapshotId == null && currentExecution.discoveredFilesSnapshot != null) {
                            currentExecution.discoveredFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(currentExecution.discoveredFilesSnapshot);
                        }
                        while (previousExecutions.executions.size() > 3) {
                            LazyTaskExecution execution = (LazyTaskExecution)previousExecutions.executions.removeLast();
                            if (execution.inputFilesSnapshotIds != null) {
                                for (Long id : execution.inputFilesSnapshotIds.values()) {
                                    CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(id);
                                }
                            }
                            if (execution.outputFilesSnapshotIds != null) {
                                for (Long id : execution.outputFilesSnapshotIds.values()) {
                                    CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(id);
                                }
                            }
                            if (execution.discoveredFilesSnapshotId == null) continue;
                            CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(execution.discoveredFilesSnapshotId);
                        }
                        previousExecutions.beforeSerialized();
                        CacheBackedTaskHistoryRepository.this.taskHistoryCache.put(task.getPath(), previousExecutions);
                    }
                });
            }
        };
    }

    private TaskExecutionList loadPreviousExecutions(final TaskInternal task) {
        return this.cacheAccess.useCache("Load task history", new Factory<TaskExecutionList>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TaskExecutionList create() {
                ClassLoader original = CacheBackedTaskHistoryRepository.this.serializer.getClassLoader();
                ClassLoader projectClassLoader = ((ProjectInternal)Cast.cast(ProjectInternal.class, (Object)task.getProject())).getClassLoaderScope().getLocalClassLoader();
                CacheBackedTaskHistoryRepository.this.serializer.setClassLoader(projectClassLoader);
                try {
                    TaskExecutionList history = (TaskExecutionList)CacheBackedTaskHistoryRepository.this.taskHistoryCache.get(task.getPath());
                    TaskExecutionList taskExecutionList = history == null ? new TaskExecutionList() : history;
                    return taskExecutionList;
                }
                finally {
                    CacheBackedTaskHistoryRepository.this.serializer.setClassLoader(original);
                }
            }
        });
    }

    private Set<String> getDeclaredOutputFilePaths(TaskInternal task) {
        HashSet<String> declaredOutputFilePaths = new HashSet<String>();
        for (File file : task.getOutputs().getFiles()) {
            declaredOutputFilePaths.add(this.stringInterner.intern(file.getAbsolutePath()));
        }
        return declaredOutputFilePaths;
    }

    private LazyTaskExecution findBestMatchingPreviousExecution(TaskExecution currentExecution, Collection<LazyTaskExecution> previousExecutions) {
        Set<String> declaredOutputFilePaths = currentExecution.getDeclaredOutputFilePaths();
        LazyTaskExecution bestMatch = null;
        int bestMatchOverlap = 0;
        for (LazyTaskExecution previousExecution : previousExecutions) {
            Set<String> previousDeclaredOutputFilePaths = previousExecution.getDeclaredOutputFilePaths();
            if (declaredOutputFilePaths.isEmpty() && previousDeclaredOutputFilePaths.isEmpty()) {
                bestMatch = previousExecution;
                break;
            }
            Sets.SetView intersection = Sets.intersection(declaredOutputFilePaths, previousDeclaredOutputFilePaths);
            int overlap = intersection.size();
            if (overlap > bestMatchOverlap) {
                bestMatch = previousExecution;
                bestMatchOverlap = overlap;
            }
            if (bestMatchOverlap != declaredOutputFilePaths.size()) continue;
            break;
        }
        return bestMatch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyTaskExecution
    extends TaskExecution {
        private Map<String, Long> inputFilesSnapshotIds;
        private Map<String, Long> outputFilesSnapshotIds;
        private Long discoveredFilesSnapshotId;
        private transient FileSnapshotRepository snapshotRepository;
        private transient Map<String, FileCollectionSnapshot> inputFilesSnapshot;
        private transient Map<String, FileCollectionSnapshot> outputFilesSnapshot;
        private transient FileCollectionSnapshot discoveredFilesSnapshot;
        private transient TaskArtifactStateCacheAccess cacheAccess;

        private LazyTaskExecution() {
        }

        @Override
        public Map<String, FileCollectionSnapshot> getInputFilesSnapshot() {
            if (this.inputFilesSnapshot == null) {
                this.inputFilesSnapshot = this.cacheAccess.useCache("fetch input files", new Factory<Map<String, FileCollectionSnapshot>>(){

                    public Map<String, FileCollectionSnapshot> create() {
                        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                        for (Map.Entry entry : LazyTaskExecution.this.inputFilesSnapshotIds.entrySet()) {
                            builder.put(entry.getKey(), (Object)LazyTaskExecution.this.snapshotRepository.get((Long)entry.getValue()));
                        }
                        return builder.build();
                    }
                });
            }
            return this.inputFilesSnapshot;
        }

        @Override
        public void setInputFilesSnapshot(Map<String, FileCollectionSnapshot> inputFilesSnapshot) {
            this.inputFilesSnapshot = inputFilesSnapshot;
            this.inputFilesSnapshotIds = null;
        }

        @Override
        public FileCollectionSnapshot getDiscoveredInputFilesSnapshot() {
            if (this.discoveredFilesSnapshot == null) {
                this.discoveredFilesSnapshot = this.cacheAccess.useCache("fetch discovered input files", new Factory<FileCollectionSnapshot>(){

                    public FileCollectionSnapshot create() {
                        return LazyTaskExecution.this.snapshotRepository.get(LazyTaskExecution.this.discoveredFilesSnapshotId);
                    }
                });
            }
            return this.discoveredFilesSnapshot;
        }

        @Override
        public void setDiscoveredInputFilesSnapshot(FileCollectionSnapshot discoveredFilesSnapshot) {
            this.discoveredFilesSnapshot = discoveredFilesSnapshot;
            this.discoveredFilesSnapshotId = null;
        }

        @Override
        public Map<String, FileCollectionSnapshot> getOutputFilesSnapshot() {
            if (this.outputFilesSnapshot == null) {
                this.outputFilesSnapshot = this.cacheAccess.useCache("fetch output files", new Factory<Map<String, FileCollectionSnapshot>>(){

                    public Map<String, FileCollectionSnapshot> create() {
                        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                        for (Map.Entry entry : LazyTaskExecution.this.outputFilesSnapshotIds.entrySet()) {
                            String propertyName = (String)entry.getKey();
                            builder.put((Object)propertyName, (Object)LazyTaskExecution.this.snapshotRepository.get((Long)entry.getValue()));
                        }
                        return builder.build();
                    }
                });
            }
            return this.outputFilesSnapshot;
        }

        @Override
        public void setOutputFilesSnapshot(Map<String, FileCollectionSnapshot> outputFilesSnapshot) {
            this.outputFilesSnapshot = outputFilesSnapshot;
            this.outputFilesSnapshotIds = null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class LazyTaskExecutionSerializer
        implements Serializer<LazyTaskExecution> {
            private final InputPropertiesSerializer inputPropertiesSerializer;
            private final StringInterner stringInterner;

            public LazyTaskExecutionSerializer(ClassLoader classLoader, StringInterner stringInterner) {
                this.inputPropertiesSerializer = new InputPropertiesSerializer(classLoader);
                this.stringInterner = stringInterner;
            }

            public LazyTaskExecution read(Decoder decoder) throws Exception {
                LazyTaskExecution execution = new LazyTaskExecution();
                execution.inputFilesSnapshotIds = LazyTaskExecutionSerializer.readSnapshotIds(decoder);
                execution.outputFilesSnapshotIds = LazyTaskExecutionSerializer.readSnapshotIds(decoder);
                execution.discoveredFilesSnapshotId = decoder.readLong();
                execution.setTaskClass(decoder.readString());
                if (decoder.readBoolean()) {
                    execution.setTaskClassLoaderHash(HashCode.fromBytes((byte[])decoder.readBinary()));
                }
                if (decoder.readBoolean()) {
                    execution.setTaskActionsClassLoaderHash(HashCode.fromBytes((byte[])decoder.readBinary()));
                }
                int outputFiles = decoder.readInt();
                HashSet<String> files = new HashSet<String>();
                for (int j = 0; j < outputFiles; ++j) {
                    files.add(this.stringInterner.intern(decoder.readString()));
                }
                execution.setDeclaredOutputFilePaths(files);
                boolean inputProperties = decoder.readBoolean();
                if (inputProperties) {
                    Object map = this.inputPropertiesSerializer.read(decoder);
                    execution.setInputProperties((Map<String, Object>)map);
                } else {
                    execution.setInputProperties(new HashMap<String, Object>());
                }
                return execution;
            }

            public void write(Encoder encoder, LazyTaskExecution execution) throws Exception {
                LazyTaskExecutionSerializer.writeSnapshotIds(encoder, execution.inputFilesSnapshotIds);
                LazyTaskExecutionSerializer.writeSnapshotIds(encoder, execution.outputFilesSnapshotIds);
                encoder.writeLong(execution.discoveredFilesSnapshotId.longValue());
                encoder.writeString((CharSequence)execution.getTaskClass());
                HashCode classLoaderHash = execution.getTaskClassLoaderHash();
                if (classLoaderHash == null) {
                    encoder.writeBoolean(false);
                } else {
                    encoder.writeBoolean(true);
                    encoder.writeBinary(classLoaderHash.asBytes());
                }
                HashCode actionsClassLoaderHash = execution.getTaskActionsClassLoaderHash();
                if (actionsClassLoaderHash == null) {
                    encoder.writeBoolean(false);
                } else {
                    encoder.writeBoolean(true);
                    encoder.writeBinary(actionsClassLoaderHash.asBytes());
                }
                encoder.writeInt(execution.getDeclaredOutputFilePaths().size());
                for (String outputFile : execution.getDeclaredOutputFilePaths()) {
                    encoder.writeString((CharSequence)outputFile);
                }
                if (execution.getInputProperties() == null || execution.getInputProperties().isEmpty()) {
                    encoder.writeBoolean(false);
                } else {
                    encoder.writeBoolean(true);
                    this.inputPropertiesSerializer.write(encoder, execution.getInputProperties());
                }
            }

            private static Map<String, Long> readSnapshotIds(Decoder decoder) throws IOException {
                int count = decoder.readInt();
                ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
                for (int snapshotIdx = 0; snapshotIdx < count; ++snapshotIdx) {
                    String property = decoder.readString();
                    long id = decoder.readLong();
                    builder.put((Object)property, (Object)id);
                }
                return builder.build();
            }

            private static void writeSnapshotIds(Encoder encoder, Map<String, Long> ids) throws IOException {
                encoder.writeInt(ids.size());
                for (Map.Entry<String, Long> entry : ids.entrySet()) {
                    encoder.writeString((CharSequence)entry.getKey());
                    encoder.writeLong(entry.getValue().longValue());
                }
            }
        }
    }

    private static class TaskExecutionList {
        private final Deque<LazyTaskExecution> executions = new ArrayDeque<LazyTaskExecution>();

        private TaskExecutionList() {
        }

        public String toString() {
            return super.toString() + "[" + this.executions.size() + "]";
        }

        public void beforeSerialized() {
            for (LazyTaskExecution execution : this.executions) {
                execution.snapshotRepository = null;
                execution.cacheAccess = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskExecutionListSerializer
    implements Serializer<TaskExecutionList> {
        private ClassLoader classLoader;
        private final StringInterner stringInterner;

        public TaskExecutionListSerializer(StringInterner stringInterner) {
            this.stringInterner = stringInterner;
        }

        public TaskExecutionList read(Decoder decoder) throws Exception {
            int executions = decoder.readByte();
            TaskExecutionList history = new TaskExecutionList();
            LazyTaskExecution.LazyTaskExecutionSerializer executionSerializer = new LazyTaskExecution.LazyTaskExecutionSerializer(this.classLoader, this.stringInterner);
            for (int i = 0; i < executions; ++i) {
                LazyTaskExecution exec = executionSerializer.read(decoder);
                history.executions.add(exec);
            }
            return history;
        }

        public void write(Encoder encoder, TaskExecutionList value) throws Exception {
            int size = value.executions.size();
            encoder.writeByte((byte)size);
            LazyTaskExecution.LazyTaskExecutionSerializer executionSerializer = new LazyTaskExecution.LazyTaskExecutionSerializer(this.classLoader, this.stringInterner);
            for (LazyTaskExecution execution : value.executions) {
                executionSerializer.write(encoder, execution);
            }
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }
}

