/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.AbstractFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FileSnapshotter;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.cache.CacheAccess;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.Stat;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.serialize.SerializerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalFileSetSnapshotter
extends AbstractFileCollectionSnapshotter {
    private final FileSystem fileSystem;

    public MinimalFileSetSnapshotter(FileSnapshotter snapshotter, CacheAccess cacheAccess, StringInterner stringInterner, FileResolver fileResolver, FileSystem fileSystem) {
        super(snapshotter, cacheAccess, stringInterner, fileResolver);
        this.fileSystem = fileSystem;
    }

    @Override
    protected void visitFiles(FileCollection input, List<FileTreeElement> fileTreeElements, List<FileTreeElement> missingFiles) {
        for (File file : input.getFiles()) {
            if (file.exists()) {
                fileTreeElements.add(new DefaultFileVisitDetails(file, (Chmod)this.fileSystem, (Stat)this.fileSystem));
                continue;
            }
            missingFiles.add(new MissingFileVisitDetails(file));
        }
    }

    @Override
    public void registerSerializers(SerializerRegistry registry) {
    }

    private static class MissingFileVisitDetails
    implements FileVisitDetails {
        private final File file;
        private final RelativePath relativePath;

        public MissingFileVisitDetails(File file) {
            this.file = file;
            this.relativePath = new RelativePath(true, file.getName());
        }

        public File getFile() {
            return this.file;
        }

        public boolean isDirectory() {
            return false;
        }

        public String getName() {
            return this.file.getName();
        }

        public String getPath() {
            return this.file.getName();
        }

        public RelativePath getRelativePath() {
            return this.relativePath;
        }

        public int getMode() {
            return 0;
        }

        public long getLastModified() {
            return 0L;
        }

        public long getSize() {
            return 0L;
        }

        public InputStream open() {
            throw new UncheckedIOException((Throwable)new FileNotFoundException(this.file.getAbsolutePath()));
        }

        public void copyTo(OutputStream output) {
            throw new UncheckedIOException((Throwable)new FileNotFoundException(this.file.getAbsolutePath()));
        }

        public boolean copyTo(File target) {
            throw new UncheckedIOException((Throwable)new FileNotFoundException(this.file.getAbsolutePath()));
        }

        public void stopVisiting() {
        }
    }
}

